/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.NotificationMgr;
import com.zipow.videobox.view.mm.MMSystemNotificationListView;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.videomeetings.R;

public class ContactRequestsFragment
extends ZMDialogFragment
implements View.OnClickListener {
    private MMSystemNotificationListView mBuddyInviteListView;
    private ZoomMessengerUI.IZoomMessengerUIListener mZoomMessengerUIListener;

    public static void showAsActivity(ZMActivity activity, int requestCode) {
        Bundle args = new Bundle();
        SimpleActivity.show(activity, ContactRequestsFragment.class.getName(), args, requestCode, true, 1);
    }

    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_contact_requests, container, false);
        view.findViewById(R.id.btnCancel).setOnClickListener((View.OnClickListener)this);
        this.mBuddyInviteListView = (MMSystemNotificationListView)view.findViewById(R.id.systemNotificationListView);
        this.mBuddyInviteListView.setEmptyView(view.findViewById(R.id.panelNoItemMsg));
        this.mBuddyInviteListView.setParentFragment(this);
        return view;
    }

    public void onClick(View v) {
        if (v.getId() == R.id.btnCancel) {
            this.dismiss();
        }
    }

    public void onPause() {
        super.onPause();
        ZoomMessengerUI.getInstance().removeListener(this.mZoomMessengerUIListener);
    }

    public void onResume() {
        super.onResume();
        if (this.mZoomMessengerUIListener == null) {
            this.mZoomMessengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

                @Override
                public boolean onNotifySubscribeRequest(String jid, String msg) {
                    ContactRequestsFragment.this.onZoomMessengerNotifySubscribeRequest();
                    return true;
                }

                @Override
                public void onIndicateInfoUpdatedWithJID(String jid) {
                    ContactRequestsFragment.this.onIndicateInfoUpdatedWithJID(jid);
                }

                @Override
                public boolean onNotifySubscriptionAccepted(String jid) {
                    ContactRequestsFragment.this.onZoomMessengerNotifySubscribeRequest();
                    return true;
                }

                @Override
                public void onIndicateBuddyListUpdated() {
                    ContactRequestsFragment.this.onIndicateBuddyListUpdated();
                }

                @Override
                public boolean onNotifySubscriptionDenied(String jid) {
                    ContactRequestsFragment.this.onZoomMessengerNotifySubscribeRequest();
                    return true;
                }

                @Override
                public void onNotifySubscribeRequestUpdated(String jid) {
                    ContactRequestsFragment.this.onNotifySubscribeRequestUpdated(jid);
                }
            };
        }
        ZoomMessengerUI.getInstance().addListener(this.mZoomMessengerUIListener);
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (messenger.getUnreadRequestCount() > 0) {
            NotificationMgr.removeMessageNotificationMM((Context)this.getActivity(), "######SYSTEM_NOTIFICATION_SESSION");
        }
        this.mBuddyInviteListView.reloadAllItems();
    }

    private void onIndicateBuddyListUpdated() {
        this.mBuddyInviteListView.onIndicateBuddyListUpdated();
    }

    private void onIndicateInfoUpdatedWithJID(String jid) {
        this.mBuddyInviteListView.onIndicateInfoUpdatedWithJID(jid);
    }

    private void onZoomMessengerNotifySubscribeRequest() {
        this.mBuddyInviteListView.onZoomMessengerNotifySubscribeRequest();
    }

    private void onNotifySubscribeRequestUpdated(String jid) {
        this.mBuddyInviteListView.onNotifySubscribeRequestUpdated(jid);
    }

    public void dismiss() {
        this.finishFragment(true);
    }
}

