/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.style.ForegroundColorSpan;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.AbsListView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import android.widget.Toast;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.SimpleInMeetingActivity;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.CmmUserList;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.confapp.qa.ZoomQABuddy;
import com.zipow.videobox.confapp.qa.ZoomQAComponent;
import com.zipow.videobox.fragment.ConfChatBuddyChooseFragment;
import com.zipow.videobox.fragment.ConfChatFragmentOld;
import com.zipow.videobox.util.ZMConfUtil;
import com.zipow.videobox.view.ConfChatAttendeeItem;
import com.zipow.videobox.view.ConfChatItem;
import com.zipow.videobox.view.ConfChatListView;
import java.io.Serializable;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.AccessibilityUtil;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.IZMMenuItem;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMMenuAdapter;
import us.zoom.androidlib.widget.ZMSimpleMenuItem;
import us.zoom.videomeetings.R;

public class ConfChatFragment
extends ZMDialogFragment
implements View.OnClickListener,
SimpleActivity.ExtListener,
AbsListView.OnScrollListener,
ConfChatListView.OnClickMessageListener,
TextView.OnEditorActionListener {
    private static final int REQUEST_CHAT_BUDDY = 10;
    private ConfChatListView mChatListView;
    private ConfChatAttendeeItem mCurrentItem;
    private TextView mTxtDisabledAlert;
    private View mChatBuddyPanel;
    private TextView mTxtCurrentItem;
    private EditText mEdtMessage;
    private LinearLayout mInputLayout;
    private Button mBtnSend;
    private static final String EXTRA_CHAT_ITEM = "EXTRA_CHAT_ITEM";
    private boolean mIsAttendee;
    public static final int DEFALUT_ROLE = -1;
    private boolean mIsWebinar;
    private ConfUI.SimpleConfUIListener mConfUIListener = new ConfUI.SimpleConfUIListener(){

        @Override
        public boolean onUserEvent(final int eventType, final long userId, final int flag) {
            ConfChatFragment.this.getNonNullEventTaskManagerOrThrowException().push(new EventAction(){

                public void run(IUIElement ui) {
                    ConfChatFragment f = (ConfChatFragment)ui;
                    if (f != null) {
                        f.handleOnUserEvent(eventType, userId, flag);
                    }
                }
            });
            return ConfChatFragment.this.mChatListView.onUserEvent(eventType, userId, flag);
        }

        @Override
        public boolean onChatMessageReceived(String msgID, long sender, String senderDisplayName, long receiver, String receiverDisplayName, String content, long time) {
            boolean res = ConfChatFragment.this.mChatListView.onChatMessageReceived(msgID, sender, senderDisplayName, receiver, receiverDisplayName, content, time);
            if (ConfChatFragment.this.getActivity() instanceof ConfActivity) {
                ((ConfActivity)ConfChatFragment.this.getActivity()).refreshUnreadChatCount();
            }
            return res;
        }

        @Override
        public boolean onConfStatusChanged2(int cmd, long ret) {
            return ConfChatFragment.this.onConfStatusChanged2(cmd, ret);
        }

        @Override
        public boolean onUserStatusChanged(int cmd, long userId, int userAction) {
            return ConfChatFragment.this.onUserStatusChanged(cmd, userId);
        }
    };

    public static void showAsActivity(ZMActivity activity, int requestCode, long userId) {
        if (activity == null) {
            return;
        }
        Bundle args = new Bundle();
        if (userId != 0L) {
            CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
            if (confContext != null && confContext.isWebinar()) {
                ZoomQABuddy buddy = ZMConfUtil.getZoomQABuddyByNodeId(userId);
                if (buddy == null) {
                    CmmUser user = ConfMgr.getInstance().getUserById(userId);
                    if (user == null) {
                        return;
                    }
                    args.putSerializable(EXTRA_CHAT_ITEM, (Serializable)new ConfChatAttendeeItem(user));
                } else {
                    args.putSerializable(EXTRA_CHAT_ITEM, (Serializable)new ConfChatAttendeeItem(buddy));
                }
            } else {
                CmmUser user = ConfMgr.getInstance().getUserById(userId);
                if (user == null) {
                    return;
                }
                args.putSerializable(EXTRA_CHAT_ITEM, (Serializable)new ConfChatAttendeeItem(user));
            }
        }
        SimpleInMeetingActivity.show(activity, ConfChatFragment.class.getName(), args, requestCode, false);
    }

    public static void showAsFragment(FragmentManager fm, long userId) {
        if (ConfChatFragment.getConfChatFragment(fm) != null) {
            return;
        }
        ConfChatFragmentOld f = new ConfChatFragmentOld();
        Bundle args = new Bundle();
        if (userId != 0L) {
            CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
            if (confContext != null && confContext.isWebinar()) {
                ZoomQABuddy buddy = ZMConfUtil.getZoomQABuddyByNodeId(userId);
                if (buddy == null) {
                    return;
                }
                args.putSerializable(EXTRA_CHAT_ITEM, (Serializable)new ConfChatAttendeeItem(buddy));
            } else {
                CmmUser user = ConfMgr.getInstance().getUserById(userId);
                if (user == null) {
                    return;
                }
                args.putSerializable(EXTRA_CHAT_ITEM, (Serializable)new ConfChatAttendeeItem(user));
            }
        }
        args.putLong("userId", userId);
        f.setArguments(args);
        f.show(fm, ConfChatFragmentOld.class.getName());
    }

    public static void showAsActivity(ZMActivity activity, int requestCode, ConfChatAttendeeItem chatItem) {
        if (activity == null) {
            return;
        }
        Bundle args = new Bundle();
        if (chatItem != null) {
            args.putSerializable(EXTRA_CHAT_ITEM, (Serializable)chatItem);
        }
        SimpleInMeetingActivity.show(activity, ConfChatFragment.class.getName(), args, requestCode, false);
    }

    public static void showAsFragment(FragmentManager fm, long userId, ConfChatAttendeeItem chatItem) {
        if (ConfChatFragment.getConfChatFragment(fm) != null) {
            return;
        }
        ConfChatFragmentOld f = new ConfChatFragmentOld();
        Bundle args = new Bundle();
        if (chatItem != null) {
            args.putSerializable(EXTRA_CHAT_ITEM, (Serializable)chatItem);
        }
        args.putLong("userId", userId);
        f.setArguments(args);
        f.show(fm, ConfChatFragmentOld.class.getName());
    }

    public static ConfChatFragment getConfChatFragment(FragmentManager fm) {
        return (ConfChatFragment)fm.findFragmentByTag(ConfChatFragment.class.getName());
    }

    public long getUserId() {
        if (this.mCurrentItem == null) {
            return 0L;
        }
        return this.mCurrentItem.nodeID;
    }

    @SuppressLint(value={"NewApi"})
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Bundle args;
        CmmConfContext context;
        View content = inflater.inflate(R.layout.zm_webinar_chat, container, false);
        this.mChatListView = (ConfChatListView)content.findViewById(R.id.chatListView);
        this.mTxtDisabledAlert = (TextView)content.findViewById(R.id.txtDisabledAlert);
        this.mChatBuddyPanel = content.findViewById(R.id.chatBuddyPanel);
        this.mTxtCurrentItem = (TextView)content.findViewById(R.id.txtCurrentItem);
        this.mEdtMessage = (EditText)content.findViewById(R.id.edtMessage);
        this.mInputLayout = (LinearLayout)content.findViewById(R.id.inputLayout);
        this.mBtnSend = (Button)content.findViewById(R.id.btnSend);
        this.mTxtCurrentItem.setTextColor(this.getResources().getColorStateList(R.drawable.zm_button_text_no_disable));
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        boolean bl = this.mIsWebinar = confContext != null && confContext.isWebinar();
        if (this.mIsWebinar) {
            ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
            this.mIsAttendee = qacomponent == null || qacomponent.isWebinarAttendee();
        } else {
            CmmUser myself = ConfMgr.getInstance().getMyself();
            if (myself != null) {
                boolean bl2 = this.mIsAttendee = !myself.isHost() && !myself.isCoHost();
            }
        }
        if (savedInstanceState != null) {
            this.mCurrentItem = (ConfChatAttendeeItem)savedInstanceState.getSerializable(EXTRA_CHAT_ITEM);
        }
        if ((context = ConfMgr.getInstance().getConfContext()) == null) {
            return null;
        }
        if (!this.mIsAttendee && this.mCurrentItem == null && !context.isPrivateChatOFF() && (args = this.getArguments()) != null) {
            this.mCurrentItem = (ConfChatAttendeeItem)args.getSerializable(EXTRA_CHAT_ITEM);
        }
        if (this.mIsAttendee) {
            if (context.isPrivateChatOFF()) {
                this.mChatBuddyPanel.setEnabled(false);
                this.mTxtCurrentItem.setEnabled(false);
                this.mTxtCurrentItem.setCompoundDrawables(null, null, null, null);
            } else {
                args = this.getArguments();
                if (args != null) {
                    this.mCurrentItem = (ConfChatAttendeeItem)args.getSerializable(EXTRA_CHAT_ITEM);
                }
            }
            this.judgeChatEnable();
        } else {
            this.mEdtMessage.setHint(R.string.zm_webinar_txt_panelist_send_hint);
        }
        ConfUI.getInstance().addListener(this.mConfUIListener);
        this.refreshTxtCurrentItem();
        this.mBtnSend.setOnClickListener((View.OnClickListener)this);
        content.findViewById(R.id.btnBack).setOnClickListener((View.OnClickListener)this);
        this.mTxtCurrentItem.setOnClickListener((View.OnClickListener)this);
        this.mChatBuddyPanel.setOnClickListener((View.OnClickListener)this);
        this.mChatListView.setOnScrollListener(this);
        this.mChatListView.setOnClickMessageListener(this);
        if (Build.VERSION.SDK_INT >= 11) {
            this.mChatBuddyPanel.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

                public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    ConfChatFragment.this.refreshTxtCurrentItem();
                }
            });
        }
        this.mEdtMessage.addTextChangedListener(new TextWatcher(){

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void afterTextChanged(Editable s) {
                ConfChatFragment.this.mBtnSend.setEnabled(ConfChatFragment.this.mEdtMessage.getEditableText().length() != 0);
            }
        });
        this.mEdtMessage.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        return content;
    }

    public void onResume() {
        super.onResume();
        this.mChatListView.updateUI();
        if (this.getActivity() instanceof ConfActivity) {
            ((ConfActivity)this.getActivity()).refreshUnreadChatCount();
        }
    }

    public void onPause() {
        this.mChatListView.onParentFragmentPause();
        super.onPause();
    }

    private void handleOnUserEvent(int eventType, long userId, int flag) {
        switch (eventType) {
            case 0: {
                if (!this.mIsWebinar || this.mCurrentItem.nodeID == 0L || this.mCurrentItem.nodeID == 1L) break;
                ZoomQABuddy buddy = ZMConfUtil.getZoomQABuddyByNodeId(this.mCurrentItem.nodeID);
                if (buddy == null && (buddy = ZMConfUtil.getZoomQABuddyByJid(this.mCurrentItem.jid)) != null) {
                    this.mCurrentItem = new ConfChatAttendeeItem(buddy);
                    this.refreshTxtCurrentItem();
                }
                if (buddy == null || buddy.isOfflineUser()) break;
                this.mTxtDisabledAlert.setVisibility(8);
                return;
            }
            case 1: {
                this.judgeChatEnable();
            }
        }
    }

    private void judgeChatEnable() {
        if (this.mIsAttendee) {
            ConfMgr mgr = ConfMgr.getInstance();
            if (!mgr.isAllowAttendeeChat()) {
                this.mTxtDisabledAlert.setVisibility(0);
                this.mTxtDisabledAlert.setText(R.string.zm_webinar_txt_chat_disabled);
                this.mInputLayout.setVisibility(8);
                this.mChatBuddyPanel.setVisibility(8);
            } else {
                this.mTxtDisabledAlert.setVisibility(8);
                this.mInputLayout.setVisibility(0);
                this.mChatBuddyPanel.setVisibility(0);
                CmmConfStatus cmmConfStatus = mgr.getConfStatusObj();
                if (cmmConfStatus == null) {
                    return;
                }
                int privildge = cmmConfStatus.getAttendeeChatPriviledge();
                CmmUserList userList = ConfMgr.getInstance().getUserList();
                if (userList == null) {
                    return;
                }
                CmmUser cmmUser = userList.getHostUser();
                if (cmmUser == null) {
                    return;
                }
                if (privildge == 3) {
                    if (this.mCurrentItem == null || this.mCurrentItem.nodeID == 0L || this.mCurrentItem.nodeID == 1L) {
                        this.mCurrentItem = new ConfChatAttendeeItem(cmmUser.getScreenName(), null, cmmUser.getNodeId(), -1);
                    }
                } else if (privildge == 2) {
                    if (this.mCurrentItem == null) {
                        this.mCurrentItem = new ConfChatAttendeeItem(this.getString(R.string.zm_webinar_txt_all_panelists), null, 1L, -1);
                    } else if (this.mCurrentItem.nodeID == 0L) {
                        this.mCurrentItem.name = this.getString(R.string.zm_webinar_txt_all_panelists);
                        this.mCurrentItem.nodeID = 1L;
                        this.mCurrentItem.role = -1;
                    }
                }
            }
            this.refreshTxtCurrentItem();
        }
    }

    public boolean onConfStatusChanged2(int cmd, long ret) {
        switch (cmd) {
            case 28: {
                this.judgeChatEnable();
                break;
            }
        }
        return false;
    }

    private boolean onUserStatusChanged(int cmd, long userId) {
        switch (cmd) {
            case 1: 
            case 43: 
            case 44: {
                this.processOnHostOrCoHostChanged();
            }
        }
        return true;
    }

    private void processOnHostOrCoHostChanged() {
        CmmConfContext context;
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (!this.mIsWebinar && myself != null) {
            boolean bl = this.mIsAttendee = !myself.isHost() && !myself.isCoHost();
        }
        if ((context = ConfMgr.getInstance().getConfContext()) == null) {
            return;
        }
        if (this.mIsAttendee) {
            if (context.isPrivateChatOFF()) {
                this.mChatBuddyPanel.setEnabled(false);
                this.mTxtCurrentItem.setEnabled(false);
                this.mTxtCurrentItem.setCompoundDrawables(null, null, null, null);
            }
            this.judgeChatEnable();
        } else {
            this.mTxtDisabledAlert.setVisibility(8);
            this.mInputLayout.setVisibility(0);
            this.mChatBuddyPanel.setVisibility(0);
            this.mEdtMessage.setHint(R.string.zm_webinar_txt_panelist_send_hint);
        }
    }

    public void onDestroy() {
        ConfUI.getInstance().removeListener(this.mConfUIListener);
        super.onDestroy();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (outState != null) {
            outState.putSerializable(EXTRA_CHAT_ITEM, (Serializable)this.mCurrentItem);
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 10: {
                if (resultCode != -1 || data == null) break;
                ConfChatAttendeeItem item = (ConfChatAttendeeItem)data.getSerializableExtra("EXTRA_WEBINAR_BUDDY");
                if (item != null) {
                    this.mCurrentItem = item;
                    this.mTxtDisabledAlert.setVisibility(8);
                }
                this.refreshTxtCurrentItem();
                break;
            }
        }
    }

    private void refreshTxtCurrentItem() {
        int priviledge;
        CmmConfStatus cmmConfStatus;
        this.mTxtCurrentItem.setEnabled(true);
        this.mChatBuddyPanel.setEnabled(true);
        this.mTxtCurrentItem.setCompoundDrawablesWithIntrinsicBounds(null, null, this.getResources().getDrawable(R.drawable.zm_dropdown), null);
        if (this.mCurrentItem == null) {
            if (this.mIsWebinar) {
                this.mCurrentItem = new ConfChatAttendeeItem(this.getString(R.string.zm_webinar_txt_all_panelists), null, 1L, -1);
            } else if (this.mIsAttendee) {
                CmmConfStatus cmmConfStatus2 = ConfMgr.getInstance().getConfStatusObj();
                if (cmmConfStatus2 == null) {
                    return;
                }
                int privildge = cmmConfStatus2.getAttendeeChatPriviledge();
                if (privildge == 3) {
                    CmmUserList userList = ConfMgr.getInstance().getUserList();
                    if (userList == null) {
                        return;
                    }
                    CmmUser cmmUser = userList.getHostUser();
                    if (cmmUser == null) {
                        return;
                    }
                    this.mCurrentItem = new ConfChatAttendeeItem(cmmUser.getScreenName(), null, cmmUser.getNodeId(), -1);
                } else {
                    this.mCurrentItem = new ConfChatAttendeeItem(this.getString(R.string.zm_webinar_txt_everyone), null, 0L, -1);
                }
            } else {
                this.mCurrentItem = new ConfChatAttendeeItem(this.getString(R.string.zm_webinar_txt_everyone), null, 0L, -1);
            }
        }
        ViewParent parent = this.mTxtCurrentItem.getParent();
        if (this.mCurrentItem.role == 0 && parent != null && parent instanceof ViewGroup && !TextUtils.isEmpty((CharSequence)this.mCurrentItem.name)) {
            if (((ViewGroup)parent).getMeasuredWidth() > 0) {
                String keyWords = this.getString(R.string.zm_webinar_txt_label_ccPanelist, new Object[]{"", this.getString(R.string.zm_webinar_txt_all_panelists)});
                TextPaint paint = this.mTxtCurrentItem.getPaint();
                if (paint == null) {
                    this.mTxtCurrentItem.setText((CharSequence)this.mCurrentItem.name);
                    this.mChatBuddyPanel.setContentDescription((CharSequence)(this.getString(R.string.zm_webinar_txt_send_to) + this.mTxtCurrentItem.getText()));
                    return;
                }
                float keyWordsLength = paint.measureText(keyWords);
                ViewGroup group = (ViewGroup)parent;
                int groupWidth = group.getMeasuredWidth();
                int selfPadding = this.mTxtCurrentItem.getCompoundPaddingLeft() + this.mTxtCurrentItem.getCompoundPaddingRight();
                int startPosition = this.mTxtCurrentItem.getLeft();
                CharSequence lableName = TextUtils.ellipsize((CharSequence)this.mCurrentItem.name, (TextPaint)paint, (float)((float)((groupWidth -= group.getPaddingRight()) - selfPadding - startPosition) - keyWordsLength), (TextUtils.TruncateAt)TextUtils.TruncateAt.END);
                this.mTxtCurrentItem.setText((CharSequence)this.getString(R.string.zm_webinar_txt_label_ccPanelist, new Object[]{lableName, this.getString(R.string.zm_webinar_txt_all_panelists)}));
            } else {
                this.mTxtCurrentItem.setText((CharSequence)this.getString(R.string.zm_webinar_txt_label_ccPanelist, new Object[]{this.mCurrentItem.name, this.getString(R.string.zm_webinar_txt_all_panelists)}));
            }
            this.mChatBuddyPanel.setContentDescription((CharSequence)(this.getString(R.string.zm_webinar_txt_send_to) + this.mTxtCurrentItem.getText()));
        } else {
            if (this.mCurrentItem.role == 2 || this.mCurrentItem.role == 1) {
                SpannableStringBuilder builder = new SpannableStringBuilder((CharSequence)this.getString(R.string.zm_webinar_txt_private_label));
                ForegroundColorSpan span = new ForegroundColorSpan(this.getResources().getColor(R.color.zm_txt_warn));
                builder.setSpan((Object)span, 0, builder.length(), 33);
                builder.append((CharSequence)this.mCurrentItem.name);
                this.mTxtCurrentItem.setText((CharSequence)builder);
            } else {
                if (this.mIsAttendee) {
                    if (this.mCurrentItem.nodeID == 0L) {
                        this.mEdtMessage.setHint(R.string.zm_webinar_txt_attendee_send_hint_everyone);
                    } else if (this.mCurrentItem.nodeID == 1L) {
                        this.mEdtMessage.setHint(R.string.zm_webinar_txt_attendee_send_hint_panelist);
                    } else {
                        CmmConfStatus cmmConfStatus3;
                        this.mEdtMessage.setHint(R.string.zm_webinar_txt_attendee_send_hint_11380);
                        CmmUser cmmUser = ConfMgr.getInstance().getUserById(this.mCurrentItem.nodeID);
                        if (cmmUser != null && cmmUser.isHost() && (cmmConfStatus3 = ConfMgr.getInstance().getConfStatusObj()) != null) {
                            int priviledge2 = cmmConfStatus3.getAttendeeChatPriviledge();
                            CmmUserList cmmUserList = ConfMgr.getInstance().getUserList();
                            if (this.mIsAttendee && cmmUserList != null && priviledge2 == 3 && !cmmUserList.hasCoHostUserInMeeting()) {
                                this.mTxtCurrentItem.setEnabled(false);
                                this.mChatBuddyPanel.setEnabled(false);
                                this.mTxtCurrentItem.setCompoundDrawablesWithIntrinsicBounds(null, null, null, null);
                            }
                        }
                    }
                }
                this.mTxtCurrentItem.setText((CharSequence)this.mCurrentItem.name);
            }
            this.mChatBuddyPanel.setContentDescription((CharSequence)(this.getString(R.string.zm_webinar_txt_send_to) + this.mTxtCurrentItem.getText()));
        }
        if (this.mIsAttendee && this.mIsWebinar && (cmmConfStatus = ConfMgr.getInstance().getConfStatusObj()) != null && (priviledge = cmmConfStatus.getAttendeeChatPriviledge()) == 2) {
            this.mTxtCurrentItem.setEnabled(false);
            this.mChatBuddyPanel.setEnabled(false);
            this.mTxtCurrentItem.setCompoundDrawablesWithIntrinsicBounds(null, null, null, null);
        }
        if (this.mCurrentItem != null) {
            this.mBtnSend.setContentDescription((CharSequence)this.mCurrentItem.getSendContentDescription((Context)this.getActivity()));
        }
        if (parent instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)parent;
            viewGroup.requestLayout();
            viewGroup.invalidate();
        }
    }

    public void onClick(View v) {
        if (v == null) {
            return;
        }
        int id2 = v.getId();
        if (id2 == R.id.btnSend) {
            this.doSend();
        } else if (id2 == R.id.btnBack) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtMessage);
            this.dismiss();
        } else if (id2 == R.id.chatBuddyPanel || id2 == R.id.txtCurrentItem) {
            ConfChatBuddyChooseFragment.showAsActivity((Fragment)this, 10);
        }
    }

    private void doSend() {
        String msg = this.mEdtMessage.getText().toString();
        if (TextUtils.isEmpty((CharSequence)msg.trim())) {
            return;
        }
        if (this.mCurrentItem != null && this.mCurrentItem.nodeID != 0L && this.mCurrentItem.nodeID != 1L && this.mCurrentItem.nodeID != -1L) {
            if (!this.mIsWebinar) {
                CmmUser user = ConfMgr.getInstance().getUserById(this.mCurrentItem.nodeID);
                if (user == null) {
                    this.mTxtDisabledAlert.setVisibility(0);
                    this.mTxtDisabledAlert.setText((CharSequence)this.getString(R.string.zm_webinar_txt_chat_attendee_not_session_11380, new Object[]{this.mCurrentItem.name}));
                    return;
                }
            } else {
                ZoomQABuddy buddy = ZMConfUtil.getZoomQABuddyByNodeId(this.mCurrentItem.nodeID);
                if (buddy == null && (buddy = ZMConfUtil.getZoomQABuddyByJid(this.mCurrentItem.jid)) != null) {
                    this.mCurrentItem = new ConfChatAttendeeItem(buddy);
                    this.refreshTxtCurrentItem();
                }
                if (buddy == null || buddy.isOfflineUser()) {
                    this.mTxtDisabledAlert.setVisibility(0);
                    this.mTxtDisabledAlert.setText((CharSequence)this.getString(R.string.zm_webinar_txt_chat_attendee_not_session_11380, new Object[]{this.mCurrentItem.name}));
                    return;
                }
            }
        }
        boolean result = false;
        if (this.mIsAttendee) {
            if (this.mCurrentItem == null || this.mCurrentItem.nodeID == 0L) {
                result = ConfMgr.getInstance().sendChatMessageTo(0L, msg, false, false, 0L);
            } else if (this.mCurrentItem.nodeID == 1L) {
                result = ConfMgr.getInstance().sendXmppChatToAllPanelists(msg);
            } else {
                CmmUser user;
                CmmConfStatus cmmConfStatus;
                if (!(this.mIsWebinar || (cmmConfStatus = ConfMgr.getInstance().getConfStatusObj()) == null || cmmConfStatus.getAttendeeChatPriviledge() != 3 || (user = ConfMgr.getInstance().getUserById(this.mCurrentItem.nodeID)) == null || user.isHost() || user.isCoHost())) {
                    Toast toast = Toast.makeText((Context)this.getActivity(), (CharSequence)this.getString(R.string.zm_webinar_msg_no_permisson_11380, new Object[]{this.mCurrentItem.name}), (int)1);
                    toast.setGravity(17, 0, 0);
                    toast.show();
                    return;
                }
                result = ConfMgr.getInstance().sendChatMessageTo(this.mCurrentItem.nodeID, msg, false, false, 0L);
            }
        } else {
            if (this.mCurrentItem == null) {
                return;
            }
            if (this.mCurrentItem.nodeID == 0L) {
                result = ConfMgr.getInstance().sendChatMessageTo(0L, msg, false, false, 0L);
            } else if (this.mCurrentItem.nodeID == 1L) {
                result = ConfMgr.getInstance().sendChatMessageTo(0L, msg, true, false, 0L);
            } else if (this.mCurrentItem.nodeID != -1L) {
                if (this.mIsWebinar) {
                    ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
                    if (qacomponent == null) {
                        return;
                    }
                    ZoomQABuddy buddy = ZMConfUtil.getZoomQABuddyByNodeId(this.mCurrentItem.nodeID);
                    if (buddy == null || buddy.isOfflineUser()) {
                        this.mTxtDisabledAlert.setVisibility(0);
                        this.mTxtDisabledAlert.setText((CharSequence)this.getString(R.string.zm_webinar_txt_chat_attendee_not_session_11380, new Object[]{this.mCurrentItem.name}));
                        return;
                    }
                    if (buddy.getRole() == 0) {
                        result = ConfMgr.getInstance().sendXmppChatToIndividual(msg, this.mCurrentItem.jid, true);
                        if (result) {
                            result = ConfMgr.getInstance().sendChatMessageTo(0L, msg, true, true, this.mCurrentItem.nodeID);
                        }
                    } else {
                        result = ConfMgr.getInstance().sendChatMessageTo(this.mCurrentItem.nodeID, msg, false, false, 0L);
                    }
                } else {
                    CmmUser user = ConfMgr.getInstance().getUserById(this.mCurrentItem.nodeID);
                    if (user != null) {
                        result = ConfMgr.getInstance().sendChatMessageTo(this.mCurrentItem.nodeID, msg, false, false, 0L);
                    }
                }
            }
        }
        if (result) {
            if (AccessibilityUtil.isSpokenFeedbackEnabled((Context)this.getActivity())) {
                AccessibilityUtil.announceForAccessibilityCompat((View)this.mBtnSend, (int)R.string.zm_accessibility_sent_19147);
            }
            this.mTxtDisabledAlert.setVisibility(8);
            this.mEdtMessage.setText((CharSequence)"");
        } else {
            ZoomQAComponent qaComponent = ConfMgr.getInstance().getQAComponent();
            if (qaComponent == null) {
                return;
            }
            if (!qaComponent.isConnected()) {
                Toast toast = Toast.makeText((Context)this.getActivity(), (int)R.string.zm_description_mm_msg_failed, (int)1);
                toast.setGravity(17, 0, 0);
                toast.show();
            }
            if (this.mIsAttendee && !this.mIsWebinar) {
                CmmConfStatus cmmConfStatus = ConfMgr.getInstance().getConfStatusObj();
                if (cmmConfStatus == null) {
                    return;
                }
                int priviledge = cmmConfStatus.getAttendeeChatPriviledge();
                if (priviledge == 3) {
                    CmmUserList userList = ConfMgr.getInstance().getUserList();
                    if (userList == null) {
                        return;
                    }
                    CmmUser cmmUser = userList.getHostUser();
                    if (cmmUser == null) {
                        return;
                    }
                    if (this.mCurrentItem == null) {
                        this.mCurrentItem = new ConfChatAttendeeItem(cmmUser.getScreenName(), null, cmmUser.getNodeId(), -1);
                    } else {
                        this.mCurrentItem.name = cmmUser.getScreenName();
                        this.mCurrentItem.nodeID = cmmUser.getNodeId();
                        this.mCurrentItem.role = -1;
                    }
                    this.refreshTxtCurrentItem();
                }
            }
        }
    }

    public void dismiss() {
        this.finishFragment(true);
    }

    @Override
    public void onKeyboardOpen() {
    }

    private ConfChatAttendeeItem createAttendeeInstance(ConfChatItem src) {
        if (src != null) {
            ConfChatAttendeeItem item = null;
            String name = null;
            long nodeId = 0L;
            String jid = null;
            if (src.isSelfSend) {
                name = src.receiverName;
                nodeId = src.receiver;
                jid = src.receiverJid;
                switch (src.msgType) {
                    case 0: {
                        name = this.getString(R.string.zm_webinar_txt_everyone);
                        nodeId = 0L;
                        break;
                    }
                    case 1: {
                        name = this.getString(R.string.zm_webinar_txt_all_panelists);
                        nodeId = 1L;
                        break;
                    }
                }
            } else {
                name = src.senderName;
                nodeId = src.sender;
                jid = src.senderJid;
            }
            if (nodeId != 0L && nodeId != 1L) {
                CmmConfContext context = ConfMgr.getInstance().getConfContext();
                if (context != null && context.isPrivateChatOFF()) {
                    return null;
                }
                if (this.mIsWebinar) {
                    ZoomQABuddy buddy = ZMConfUtil.getZoomQABuddyByNodeIdOrJid(nodeId, jid);
                    if (buddy == null || buddy.isOfflineUser()) {
                        return null;
                    }
                    item = buddy.getRole() == 0 ? new ConfChatAttendeeItem(name, buddy.getJID(), nodeId, 0) : new ConfChatAttendeeItem(name, buddy.getJID(), nodeId, 1);
                } else {
                    CmmUser user = ConfMgr.getInstance().getUserById(nodeId);
                    if (user != null) {
                        item = new ConfChatAttendeeItem(name, null, nodeId, 1);
                    }
                }
            } else {
                item = new ConfChatAttendeeItem(name, null, nodeId, -1);
            }
            return item;
        }
        return null;
    }

    @Override
    public boolean onSearchRequested() {
        return false;
    }

    @Override
    public boolean onTipLayerTouched() {
        return false;
    }

    @Override
    public void onKeyboardClosed() {
    }

    @Override
    public boolean onBackPressed() {
        return false;
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        if (scrollState == 1) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtMessage);
        }
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
    }

    @Override
    public void onClickMessage(ConfChatItem chatItem) {
        ConfChatAttendeeItem select;
        if (this.mIsAttendee) {
            return;
        }
        if (chatItem != null && (select = this.createAttendeeInstance(chatItem)) != null) {
            this.mCurrentItem = select;
            this.refreshTxtCurrentItem();
            UIUtil.openSoftKeyboard((Context)this.getActivity(), (View)this.mEdtMessage);
        }
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        this.doSend();
        return true;
    }

    @Override
    public void onLongClickMessage(ConfChatItem message) {
        this.showMessageContextMenu(message);
    }

    public void showMessageContextMenu(ConfChatItem chatItem) {
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        final ZMMenuAdapter menuAdapter = new ZMMenuAdapter((Context)activity, false);
        menuAdapter.addItem((IZMMenuItem)new MessageContextMenuItem(activity.getString(R.string.zm_mm_lbl_copy_message), 0, chatItem));
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)activity).setAdapter((ListAdapter)menuAdapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                MessageContextMenuItem item = (MessageContextMenuItem)((Object)menuAdapter.getItem(which));
                ConfChatFragment.this.onSelectContextMenuItem(item);
            }
        }).create();
        dialog.setCanceledOnTouchOutside(true);
        dialog.show();
    }

    private void onSelectContextMenuItem(MessageContextMenuItem item) {
        switch (item.getAction()) {
            case 0: {
                String message = item.getChatMessage();
                if (StringUtil.isEmptyOrNull((String)message)) break;
                AndroidAppUtil.copyText((Context)this.getActivity(), (CharSequence)message);
            }
        }
    }

    static class MessageContextMenuItem
    extends ZMSimpleMenuItem {
        public static final int ACTION_COPY = 0;
        private ConfChatItem mChatItem;

        public MessageContextMenuItem(String label, int action, ConfChatItem item) {
            super(action, label);
            this.mChatItem = item;
        }

        public String getChatMessage() {
            if (this.mChatItem == null) {
                return "";
            }
            return this.mChatItem.content;
        }
    }
}

