/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import com.zipow.videobox.SimpleInMeetingActivity;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.confapp.qa.ZoomQAUI;
import com.zipow.videobox.view.ConfChatAttendeeItem;
import com.zipow.videobox.view.ConfChatBuddyListView;
import java.io.Serializable;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.videomeetings.R;

public class ConfChatBuddyChooseFragment
extends ZMDialogFragment
implements AdapterView.OnItemClickListener,
View.OnClickListener {
    public static final String EXTRA_WEBINAR_BUDDY = "EXTRA_WEBINAR_BUDDY";
    private ConfChatBuddyListView mWebinarChatBuddyListView;
    private ZoomQAUI.IZoomQAUIListener mQAUIListener;
    private ConfUI.IConfUIListener mConfUIListener;

    public static void showAsActivity(ZMActivity activity, int requestCode) {
        Bundle args = new Bundle();
        SimpleInMeetingActivity.show(activity, ConfChatBuddyChooseFragment.class.getName(), args, requestCode, true, 2);
    }

    public static void showAsActivity(Fragment fragment, int requestCode) {
        Bundle args = new Bundle();
        SimpleInMeetingActivity.show(fragment, ConfChatBuddyChooseFragment.class.getName(), args, requestCode, true, 2);
    }

    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View content = inflater.inflate(R.layout.zm_webinar_chat_buddychoose, container, false);
        this.mWebinarChatBuddyListView = (ConfChatBuddyListView)content.findViewById(R.id.webinarChatBuddyListView);
        content.findViewById(R.id.btnBack).setOnClickListener((View.OnClickListener)this);
        this.mWebinarChatBuddyListView.setOnItemClickListener(this);
        return content;
    }

    public void onResume() {
        super.onResume();
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null && confContext.isWebinar()) {
            if (this.mQAUIListener == null) {
                this.mQAUIListener = new ZoomQAUI.SimpleZoomQAUIListener(){

                    @Override
                    public void onUserAdded(String jid) {
                        ConfChatBuddyChooseFragment.this.onUserAdded(jid);
                    }

                    @Override
                    public void onUserRemoved(String jid) {
                        ConfChatBuddyChooseFragment.this.onUserRemoved(jid);
                    }

                    @Override
                    public void onChattedAttendeeUpdated(long nodeId) {
                        ConfChatBuddyChooseFragment.this.onChattedAttendeeUpdated(nodeId);
                    }

                    @Override
                    public void onWebinarAttendeeGuestStatusChanged(long nodeID, boolean isGuest) {
                        ConfChatBuddyChooseFragment.this.onChattedAttendeeUpdated(nodeID);
                    }
                };
            }
            ZoomQAUI.getInstance().addListener(this.mQAUIListener);
        } else {
            if (this.mConfUIListener == null) {
                this.mConfUIListener = new ConfUI.SimpleConfUIListener(){

                    @Override
                    public boolean onUserStatusChanged(int cmd, long userId, int userAction) {
                        switch (cmd) {
                            case 1: 
                            case 43: 
                            case 44: {
                                ConfChatBuddyChooseFragment.this.processOnHostOrCoHostChanged();
                                break;
                            }
                            case 45: {
                                ConfChatBuddyChooseFragment.this.userGuestStatusChanged();
                            }
                        }
                        return true;
                    }

                    @Override
                    public boolean onConfStatusChanged2(int cmd, long ret) {
                        switch (cmd) {
                            case 28: {
                                ConfChatBuddyChooseFragment.this.attendeeChatStatusChange();
                                break;
                            }
                        }
                        return false;
                    }

                    @Override
                    public boolean onUserEvent(int eventType, long userId, int flag) {
                        return ConfChatBuddyChooseFragment.this.onUserEvent(eventType, userId, flag);
                    }
                };
            }
            ConfUI.getInstance().addListener(this.mConfUIListener);
        }
        this.mWebinarChatBuddyListView.loadAllItems();
    }

    public void onPause() {
        if (this.mQAUIListener != null) {
            ZoomQAUI.getInstance().removeListener(this.mQAUIListener);
        }
        if (this.mConfUIListener != null) {
            ConfUI.getInstance().removeListener(this.mConfUIListener);
        }
        super.onPause();
    }

    public boolean onUserEvent(int eventType, long userId, int flag) {
        return this.mWebinarChatBuddyListView.onUserEvent(eventType, userId, flag);
    }

    public void onUserAdded(String jid) {
        this.mWebinarChatBuddyListView.onUserAdded(jid);
    }

    public void onUserRemoved(String jid) {
        this.mWebinarChatBuddyListView.onUserRemoved(jid);
    }

    public void onChattedAttendeeUpdated(long nodeId) {
        this.mWebinarChatBuddyListView.onChattedAttendeeUpdated(nodeId);
    }

    public void onDestroy() {
        super.onDestroy();
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        Object item = this.mWebinarChatBuddyListView.getItemAtPosition(position);
        if (item == null || !(item instanceof ConfChatAttendeeItem)) {
            return;
        }
        ConfChatAttendeeItem attendee = (ConfChatAttendeeItem)item;
        if (attendee.nodeID == -1L) {
            return;
        }
        Intent data = new Intent();
        data.putExtra(EXTRA_WEBINAR_BUDDY, (Serializable)attendee);
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            activity.setResult(-1, data);
            this.dismiss();
        }
    }

    public void dismiss() {
        this.finishFragment(true);
    }

    public void onClick(View v) {
        if (v == null) {
            return;
        }
        int id2 = v.getId();
        if (id2 == R.id.btnBack) {
            this.dismiss();
        }
    }

    private void attendeeChatStatusChange() {
        this.mWebinarChatBuddyListView.onAttendeeStatusChange();
    }

    private void processOnHostOrCoHostChanged() {
        this.mWebinarChatBuddyListView.onHostOrCoHostChanged();
    }

    private void userGuestStatusChanged() {
        this.mWebinarChatBuddyListView.onUserGuestStatusChanged();
    }
}

