/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import com.zipow.videobox.ptapp.IMHelper;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.view.BuddyInviteListView;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class BuddyInviteFragment
extends ZMDialogFragment
implements View.OnClickListener,
PTUI.IIMListener {
    public static final String ARG_EMAILS = "emails";
    private Button mBtnSend;
    private Button mBtnBack;
    private EditText mEdtEmail;
    private BuddyInviteListView mBuddyInviteListView;

    public static void show(ZMActivity activity, String emails) {
        BuddyInviteFragment f = new BuddyInviteFragment();
        Bundle args = new Bundle();
        if (emails != null) {
            args.putString(ARG_EMAILS, emails);
        }
        f.setArguments(args);
        activity.getSupportFragmentManager().beginTransaction().add(0x1020002, (Fragment)f, BuddyInviteFragment.class.getName()).commit();
    }

    public static void showDialog(FragmentManager fm, String emails) {
        if (BuddyInviteFragment.getBuddyInviteFragment(fm) != null) {
            return;
        }
        BuddyInviteFragment f = new BuddyInviteFragment();
        Bundle args = new Bundle();
        if (emails != null) {
            args.putString(ARG_EMAILS, emails);
        }
        f.setArguments(args);
        f.show(fm, BuddyInviteFragment.class.getName());
    }

    public static BuddyInviteFragment getBuddyInviteFragment(FragmentManager fm) {
        return (BuddyInviteFragment)fm.findFragmentByTag(BuddyInviteFragment.class.getName());
    }

    public static BuddyInviteFragment getBuddyInviteFragment(ZMActivity activity) {
        BuddyInviteFragment f = (BuddyInviteFragment)activity.getSupportFragmentManager().findFragmentByTag(BuddyInviteFragment.class.getName());
        return f;
    }

    public BuddyInviteFragment() {
        this.setStyle(1, R.style.ZMDialog_HideSoftKeyboard);
    }

    public void onStart() {
        super.onStart();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        String emails;
        View view = inflater.inflate(R.layout.zm_buddy_invite, container, false);
        this.mBtnBack = (Button)view.findViewById(R.id.btnBack);
        this.mBtnSend = (Button)view.findViewById(R.id.btnSend);
        this.mEdtEmail = (EditText)view.findViewById(R.id.edtEmail);
        this.mBuddyInviteListView = (BuddyInviteListView)view.findViewById(R.id.buddyInviteListView);
        Bundle args = this.getArguments();
        if (args != null && (emails = args.getString(ARG_EMAILS)) != null) {
            this.mEdtEmail.setText((CharSequence)emails);
        }
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        this.mBtnSend.setOnClickListener((View.OnClickListener)this);
        this.mEdtEmail.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                BuddyInviteFragment.this.mBtnSend.setEnabled(BuddyInviteFragment.this.checkInputEmails());
            }
        });
        return view;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
    }

    public void onPause() {
        super.onPause();
        PTUI.getInstance().removeIMListener(this);
    }

    public void onResume() {
        super.onResume();
        PTUI.getInstance().addIMListener(this);
        this.mBuddyInviteListView.reloadAllItems();
        this.mBtnSend.setEnabled(this.checkInputEmails());
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        } else if (id2 == R.id.btnSend) {
            this.onClickBtnSend();
        }
    }

    private void onClickBtnBack() {
        this.dismiss();
    }

    private boolean checkInputEmails() {
        String[] emailArray;
        String emails = this.mEdtEmail.getText().toString();
        int count = 0;
        for (String email : emailArray = emails.split(",")) {
            String checkEmail = email = email.trim();
            if (StringUtil.isValidEmailAddress((String)checkEmail)) {
                ++count;
                continue;
            }
            return false;
        }
        return count > 0;
    }

    private void onClickBtnSend() {
        String[] emailArray;
        IMHelper imHelper = PTApp.getInstance().getIMHelper();
        if (imHelper == null) {
            return;
        }
        boolean hasFailure = false;
        boolean hasSucceed = false;
        String emails = this.mEdtEmail.getText().toString();
        for (String email : emailArray = emails.split(",")) {
            String checkEmail = email = email.trim();
            if (!StringUtil.isValidEmailAddress((String)checkEmail)) continue;
            if (imHelper.subscribeBuddy(email)) {
                hasSucceed = true;
                continue;
            }
            hasFailure = true;
        }
        if (hasSucceed && !hasFailure) {
            SentDoneAlertDialog dialog = new SentDoneAlertDialog();
            dialog.show(this.getFragmentManager(), SentDoneAlertDialog.class.getName());
        }
    }

    public void dismiss() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        this.finishFragment(true);
    }

    @Override
    public void onIMLocalStatusChanged(int status) {
    }

    @Override
    public void onIMReceived(PTAppProtos.IMMessage message) {
    }

    @Override
    public void onIMBuddyPresence(PTAppProtos.BuddyItem item) {
    }

    @Override
    public void onIMBuddyPic(PTAppProtos.BuddyItem item) {
    }

    @Override
    public void onIMBuddySort() {
    }

    @Override
    public void onSubscriptionRequest() {
        this.mBuddyInviteListView.reloadAllItems();
    }

    @Override
    public void onSubscriptionUpdate() {
        this.mBuddyInviteListView.reloadAllItems();
    }

    @Override
    public void onQuerySSOVanityURL(String reqId, int result, String url) {
    }

    @Override
    public void onQueryIPLocation(int result, PTAppProtos.IPLocationInfo ipInfo) {
    }

    public static class SentDoneAlertDialog
    extends ZMDialogFragment {
        public SentDoneAlertDialog() {
            this.setCancelable(false);
        }

        public void onStart() {
            super.onStart();
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            return new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.zm_msg_buddy_invite_done).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    SentDoneAlertDialog.this.onClickBtnOK();
                }
            }).create();
        }

        public void onClickBtnOK() {
            FragmentManager fm = this.getFragmentManager();
            BuddyInviteFragment inviteFragment = (BuddyInviteFragment)fm.findFragmentByTag(BuddyInviteFragment.class.getName());
            if (inviteFragment != null) {
                inviteFragment.dismiss();
            }
        }
    }
}

