/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.helper.ItemTouchHelper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.zipow.videobox.AudioOptionActivity;
import com.zipow.videobox.confapp.meeting.AudioOptionParcelItem;
import com.zipow.videobox.view.adapter.ZmAudioOptionAdapter;
import java.util.ArrayList;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.recyclerviewhelper.RVHItemTouchHelperCallback;
import us.zoom.androidlib.widget.recyclerviewhelper.RVHViewHolder;
import us.zoom.videomeetings.R;

public class AudioOptionFragment
extends ZMDialogFragment
implements View.OnClickListener {
    public static final int REQUEST_SELECT_DIAL_IN_COUNTRIES = 1;
    private AudioOptionParcelItem mAudioOptionParcelItem = new AudioOptionParcelItem();
    private ZmAudioOptionAdapter mAudioOptionAdapter;

    public static void showInActivity(ZMActivity activity, AudioOptionParcelItem audioOptionParcelItem) {
        AudioOptionFragment f = new AudioOptionFragment();
        Bundle args = new Bundle();
        args.putParcelable("ARG_SELECT_AUDIO_OPTION_ITEM", (Parcelable)audioOptionParcelItem);
        f.setArguments(args);
        activity.getSupportFragmentManager().beginTransaction().add(0x1020002, (Fragment)f, AudioOptionFragment.class.getName()).commit();
    }

    public static AudioOptionFragment getAudioOptionFragment(ZMActivity activity) {
        return (AudioOptionFragment)activity.getSupportFragmentManager().findFragmentByTag(AudioOptionFragment.class.getName());
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.zm_audio_option, null);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        Bundle args = this.getArguments();
        if (args != null) {
            this.mAudioOptionParcelItem = (AudioOptionParcelItem)args.getParcelable("ARG_SELECT_AUDIO_OPTION_ITEM");
            if (this.mAudioOptionParcelItem == null) {
                this.mAudioOptionParcelItem = new AudioOptionParcelItem();
            }
        }
        RecyclerView recyclerView = (RecyclerView)view.findViewById(R.id.recyclerView);
        view.findViewById(R.id.btnBack).setOnClickListener((View.OnClickListener)this);
        view.findViewById(R.id.btnOK).setOnClickListener((View.OnClickListener)this);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mAudioOptionAdapter = new ZmAudioOptionAdapter((ZMActivity)this.getActivity(), this.mAudioOptionParcelItem);
        recyclerView.setAdapter((RecyclerView.Adapter)this.mAudioOptionAdapter);
        RVHItemTouchHelperCallback callback = new RVHItemTouchHelperCallback(this.mAudioOptionAdapter, true, false, true){

            public void clearView(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
                super.clearView(recyclerView, viewHolder);
                if (viewHolder instanceof RVHViewHolder) {
                    RVHViewHolder itemViewHolder = (RVHViewHolder)viewHolder;
                    itemViewHolder.onItemClear();
                    AudioOptionFragment.this.mAudioOptionParcelItem.setmSelectedDialInCountries(AudioOptionFragment.this.mAudioOptionAdapter.getSelectedCountries());
                }
            }
        };
        ItemTouchHelper helper = new ItemTouchHelper((ItemTouchHelper.Callback)callback);
        helper.attachToRecyclerView(recyclerView);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 1: {
                if (resultCode != -1 || data == null) break;
                ArrayList addedCountries = data.getStringArrayListExtra("RESULT_ARG_ADD_DIALIN_COUNTRIES");
                ArrayList minusCountries = data.getStringArrayListExtra("RESULT_ARG_MINUS_DIALIN_COUNTRIES");
                this.mAudioOptionAdapter.refresh(addedCountries, minusCountries);
            }
        }
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        } else if (id2 == R.id.btnOK) {
            this.onClickOk();
        }
    }

    private void onClickBtnBack() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        this.finishFragment(0);
    }

    private void onClickOk() {
        AudioOptionActivity audioOptionActivity = (AudioOptionActivity)this.getActivity();
        if (audioOptionActivity != null) {
            audioOptionActivity.onOkDone(this.mAudioOptionParcelItem);
        }
    }
}

