/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.telephony.TelephonyManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.google.protobuf.InvalidProtocolBufferException;
import com.zipow.videobox.AddrBookVerifyNumberActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.fragment.SelectCountryCodeFragment;
import com.zipow.videobox.fragment.SimpleMessageDialog;
import com.zipow.videobox.ptapp.ABContactsHelper;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.SystemInfoHelper;
import java.io.Serializable;
import java.util.Locale;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.CountryCodeUtil;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.PhoneNumberUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.WaitingDialog;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class AddrBookSetNumberFragment
extends ZMDialogFragment
implements View.OnClickListener,
PTUI.IPhoneABListener {
    private final String TAG = AddrBookSetNumberFragment.class.getSimpleName();
    private static final int REQUEST_SELECT_COUTRY_CODE = 100;
    private Button mBtnNext = null;
    private Button mBtnBack = null;
    private EditText mEdtNumber = null;
    private View mBtnSelectCountryCode = null;
    private TextView mTxtCountryCode;
    private String mIsoCountryCode = null;
    private SelectCountryCodeFragment.CountryCodeItem mSelectedCountryCode;

    public static void showInActivity(ZMActivity activity) {
        AddrBookSetNumberFragment f = new AddrBookSetNumberFragment();
        Bundle args = new Bundle();
        f.setArguments(args);
        activity.getSupportFragmentManager().beginTransaction().add(0x1020002, (Fragment)f, AddrBookSetNumberFragment.class.getName()).commit();
    }

    public void onStart() {
        super.onStart();
        PTUI.getInstance().addPhoneABListener(this);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_addrbook_set_number, container, false);
        this.mBtnNext = (Button)view.findViewById(R.id.btnNext);
        this.mBtnBack = (Button)view.findViewById(R.id.btnBack);
        this.mEdtNumber = (EditText)view.findViewById(R.id.edtNumber);
        this.mBtnSelectCountryCode = view.findViewById(R.id.btnSelectCountryCode);
        this.mTxtCountryCode = (TextView)view.findViewById(R.id.txtCountryCode);
        this.mBtnNext.setOnClickListener((View.OnClickListener)this);
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        this.mBtnSelectCountryCode.setOnClickListener((View.OnClickListener)this);
        this.installNumberChangeListener();
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            this.mIsoCountryCode = CountryCodeUtil.getIsoCountryCode((Context)activity);
        }
        if (Build.VERSION.SDK_INT < 23 || this.checkSelfPermission("android.permission.READ_PHONE_STATE") == 0) {
            this.loadDefaultNumber();
        }
        if (savedInstanceState == null) {
            this.selectCountryCode(this.mIsoCountryCode);
        } else {
            this.mSelectedCountryCode = (SelectCountryCodeFragment.CountryCodeItem)savedInstanceState.get("mSelectedCountryCode");
            this.updateSelectedCountry();
        }
        this.updateNextButton();
        return view;
    }

    public void onRequestPermissionsResult(final int requestCode, final String[] permissions, final int[] grantResults) {
        this.getNonNullEventTaskManagerOrThrowException().pushLater("ABSetNumberRequestPermission", new EventAction("ABSetNumberRequestPermission"){

            public void run(IUIElement ui) {
                ((AddrBookSetNumberFragment)ui).handleRequestPermissionResult(requestCode, permissions, grantResults);
            }
        });
    }

    public void handleRequestPermissionResult(int requestCode, String[] permissions, int[] grantResults) {
        if (permissions == null || grantResults == null) {
            return;
        }
        for (int i = 0; i < permissions.length; ++i) {
            if (!"android.permission.READ_PHONE_STATE".equals(permissions[i]) || grantResults[i] != 0) continue;
            this.loadDefaultNumber();
            this.updateNextButton();
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putSerializable("mSelectedCountryCode", (Serializable)this.mSelectedCountryCode);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        SelectCountryCodeFragment.CountryCodeItem item;
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 100 && resultCode == -1 && data != null && (item = (SelectCountryCodeFragment.CountryCodeItem)data.getSerializableExtra("countryCode")) != null) {
            this.mSelectedCountryCode = item;
            this.updateSelectedCountry();
        }
    }

    private void selectCountryCode(String isoCountryCode) {
        if (isoCountryCode == null) {
            return;
        }
        String phoneCountryCode = CountryCodeUtil.isoCountryCode2PhoneCountryCode((String)isoCountryCode);
        Locale locale = new Locale("", isoCountryCode.toLowerCase(Locale.US));
        String countryName = locale.getDisplayCountry();
        this.mSelectedCountryCode = new SelectCountryCodeFragment.CountryCodeItem(phoneCountryCode, isoCountryCode, countryName);
        this.updateSelectedCountry();
    }

    private void updateSelectedCountry() {
        if (this.mSelectedCountryCode == null) {
            return;
        }
        this.mTxtCountryCode.setText((CharSequence)(this.mSelectedCountryCode.countryName + "(+" + this.mSelectedCountryCode.countryCode + ")"));
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        PTUI.getInstance().addPhoneABListener(this);
    }

    public void onDestroy() {
        super.onDestroy();
        FragmentActivity activity = this.getActivity();
        if (activity != null && activity.isFinishing() || this.isRemoving()) {
            PTUI.getInstance().removePhoneABListener(this);
        }
    }

    private void updateNextButton() {
        String countryCode = this.getSelectedCountryCode();
        String number = this.getPhoneNumber();
        boolean enabled = !StringUtil.isEmptyOrNull((String)countryCode) && !StringUtil.isEmptyOrNull((String)number) && number.length() > 4;
        this.mBtnNext.setEnabled(enabled);
    }

    private void installNumberChangeListener() {
        this.mEdtNumber.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                AddrBookSetNumberFragment.this.updateNextButton();
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
    }

    private void loadDefaultNumber() {
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        TelephonyManager telMgr = (TelephonyManager)activity.getSystemService("phone");
        if (telMgr != null) {
            String number = null;
            try {
                number = telMgr.getLine1Number();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.mIsoCountryCode = CountryCodeUtil.getIsoCountryCode((Context)activity);
            String phoneCountryCode = CountryCodeUtil.isoCountryCode2PhoneCountryCode((String)this.mIsoCountryCode);
            if (number != null) {
                this.mEdtNumber.setText((CharSequence)this.truncateCountryCode(number, phoneCountryCode));
            }
        }
    }

    private String truncateCountryCode(String phoneNumber, String countryCode) {
        int idx;
        if (StringUtil.isEmptyOrNull((String)phoneNumber) || StringUtil.isEmptyOrNull((String)countryCode)) {
            return phoneNumber;
        }
        String savedPhoneNumber = phoneNumber = PhoneNumberUtil.formatNumber((String)phoneNumber, (String)countryCode);
        int idxPlus = phoneNumber.indexOf(43);
        if (idxPlus >= 0) {
            phoneNumber = phoneNumber.substring(idxPlus + 1);
        }
        if ((idx = phoneNumber.indexOf(countryCode)) != 0) {
            return savedPhoneNumber;
        }
        return phoneNumber.substring(countryCode.length());
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnNext) {
            this.onClickBtnNext();
        } else if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        } else if (id2 == R.id.btnSelectCountryCode) {
            this.onClickBtnSelectCountryCode();
        }
    }

    private void onClickBtnSelectCountryCode() {
        SelectCountryCodeFragment.showAsActivity((Fragment)this, 100);
    }

    private void onClickBtnNext() {
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        }
        if (!NetworkUtil.hasDataNetwork((Context)VideoBoxApplication.getInstance())) {
            SimpleMessageDialog dialog = SimpleMessageDialog.newInstance(R.string.zm_alert_network_disconnected);
            dialog.show(this.getFragmentManager(), SimpleMessageDialog.class.getName());
            return;
        }
        ABContactsHelper contactsHelper = PTApp.getInstance().getABContactsHelper();
        if (contactsHelper != null) {
            String phoneNumber = this.getPhoneNumber();
            String countryCode = this.getSelectedCountryCode();
            if (StringUtil.isEmptyOrNull((String)phoneNumber) || StringUtil.isEmptyOrNull((String)countryCode)) {
                return;
            }
            String formatedNumber = "";
            if (phoneNumber.startsWith("+")) {
                formatedNumber = PhoneNumberUtil.formatNumber((String)phoneNumber, (String)countryCode);
                String tmp = PhoneNumberUtil.getCountryCodeFromFormatedPhoneNumber((String)formatedNumber);
                if (StringUtil.isEmptyOrNull((String)tmp)) {
                    this.mEdtNumber.setText((CharSequence)phoneNumber.substring(1));
                    return;
                }
                countryCode = tmp;
                phoneNumber = formatedNumber.substring(countryCode.length() + 1);
            } else if (phoneNumber.startsWith("0")) {
                phoneNumber = phoneNumber.substring(1);
                formatedNumber = "+" + countryCode + phoneNumber;
            } else {
                formatedNumber = "+" + countryCode + phoneNumber;
            }
            this.selectCountryCode(CountryCodeUtil.phoneCountryCodeToIsoCountryCode((String)countryCode));
            this.mEdtNumber.setText((CharSequence)phoneNumber);
            this.showConfirmationDialog(formatedNumber, countryCode);
        }
    }

    private void showConfirmationDialog(String formatedPhoneNumber, String countryCode) {
        RegisterConfirmDialog.showRegisterConfirmDialog(this, formatedPhoneNumber, countryCode);
    }

    private void onConfirmRegister(String formatedPhoneNumber, String countryCode) {
        ABContactsHelper contactsHelper = PTApp.getInstance().getABContactsHelper();
        if (contactsHelper == null) {
            return;
        }
        int seconds = ABContactsHelper.getRemainSMSTimeInSecond(formatedPhoneNumber, countryCode);
        if (seconds > 0) {
            AddrBookVerifyNumberActivity.show((ZMActivity)this.getActivity(), countryCode, this.getPhoneNumber(), 100);
            return;
        }
        int ret = contactsHelper.registerPhoneNumber(formatedPhoneNumber, countryCode, SystemInfoHelper.getDeviceId());
        if (0 == ret) {
            WaitingDialog dialog = new WaitingDialog(R.string.zm_msg_waiting);
            dialog.show(this.getFragmentManager(), WaitingDialog.class.getName());
        } else {
            this.showErrorDialog(ret);
        }
    }

    private String getSelectedCountryCode() {
        if (this.mSelectedCountryCode == null) {
            return null;
        }
        return this.mSelectedCountryCode.countryCode;
    }

    private String getPhoneNumber() {
        String phoneNumber = this.mEdtNumber.getText().toString();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < phoneNumber.length(); ++i) {
            char c = phoneNumber.charAt(i);
            if (c >= '0' && c <= '9') {
                builder.append(c);
                continue;
            }
            if (c == '+' && builder.length() == 0) {
                builder.append(c);
                continue;
            }
            if (c == ',' || c == ';') break;
        }
        return builder.toString();
    }

    private void onClickBtnBack() {
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        }
        if (this.getShowsDialog()) {
            this.dismiss();
        } else if (activity != null) {
            activity.setResult(0);
            activity.finish();
        }
    }

    @Override
    public void onPhoneABEvent(final int event, final long result, final Object content) {
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("handlePhoneABEvent"){

            public void run(IUIElement ui) {
                ((AddrBookSetNumberFragment)ui).handlePhoneABEvent(event, result, content);
            }
        });
    }

    private void handlePhoneABEvent(int event, long result, Object content) {
        switch (event) {
            case 0: {
                this.onPhoneRegisterComplete(result, content);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
        }
    }

    private void onPhoneRegisterComplete(long result, Object content) {
        WaitingDialog dialog = (WaitingDialog)this.getFragmentManager().findFragmentByTag(WaitingDialog.class.getName());
        if (dialog != null) {
            dialog.dismiss();
        }
        switch ((int)result) {
            case 0: {
                byte[] protoData = (byte[])content;
                PTAppProtos.PhoneRegisterResponse response = null;
                if (protoData != null) {
                    try {
                        response = PTAppProtos.PhoneRegisterResponse.parseFrom(protoData);
                    }
                    catch (InvalidProtocolBufferException e) {
                        return;
                    }
                }
                if (response == null) {
                    this.showErrorDialog((int)result);
                    break;
                }
                if (response.getNeedVerifySMS()) {
                    this.startToVerifyPhoneNumber();
                    break;
                }
                this.onRegisterOK();
                break;
            }
            default: {
                this.showErrorDialog((int)result);
            }
        }
    }

    private void startToVerifyPhoneNumber() {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        String countryCode = this.getSelectedCountryCode();
        String number = this.getPhoneNumber();
        AddrBookVerifyNumberActivity.show(activity, countryCode, number, 100);
        PTUI.getInstance().removePhoneABListener(this);
    }

    private void showErrorDialog(int errorCode) {
        SimpleMessageDialog dialog = SimpleMessageDialog.newInstance(R.string.zm_msg_register_phone_number_failed);
        dialog.show(this.getFragmentManager(), SimpleMessageDialog.class.getName());
    }

    private void onRegisterOK() {
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            UIUtil.closeSoftKeyboard((Context)activity, (View)this.getView());
        }
        if (this.getShowsDialog()) {
            this.dismiss();
        } else if (activity != null) {
            String countryCode = this.getSelectedCountryCode();
            String number = this.getPhoneNumber();
            Intent intent = new Intent();
            intent.putExtra("countryCode", countryCode);
            intent.putExtra("number", number);
            activity.setResult(-1, intent);
            activity.finish();
        }
    }

    public static class RegisterConfirmDialog
    extends ZMDialogFragment {
        private static final String ARG_NUMBER = "number";
        private static final String ARG_COUNTRY_CODE = "countryCode";
        private String mNumber;
        private String mCountryCode;

        public static void showRegisterConfirmDialog(AddrBookSetNumberFragment parentFragment, String formatedPhoneNumber, String countryCode) {
            RegisterConfirmDialog dlg = new RegisterConfirmDialog();
            Bundle args = new Bundle();
            args.putString(ARG_NUMBER, formatedPhoneNumber);
            args.putString(ARG_COUNTRY_CODE, countryCode);
            dlg.setArguments(args);
            FragmentManager fm = parentFragment.getChildFragmentManager();
            if (fm != null) {
                dlg.show(fm, RegisterConfirmDialog.class.getName());
            }
        }

        public static RegisterConfirmDialog getRegisterConfirmDialog(AddrBookSetNumberFragment parentFragment) {
            FragmentManager fm = parentFragment.getChildFragmentManager();
            if (fm == null) {
                return null;
            }
            RegisterConfirmDialog f = (RegisterConfirmDialog)fm.findFragmentByTag(RegisterConfirmDialog.class.getName());
            return f;
        }

        public RegisterConfirmDialog() {
            this.setCancelable(true);
        }

        public void onStart() {
            super.onStart();
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            Bundle args = this.getArguments();
            if (args == null) {
                return new ZMAlertDialog.Builder((Context)this.getActivity()).create();
            }
            this.mNumber = args.getString(ARG_NUMBER);
            this.mCountryCode = args.getString(ARG_COUNTRY_CODE);
            if (StringUtil.isEmptyOrNull((String)this.mNumber) || StringUtil.isEmptyOrNull((String)this.mCountryCode)) {
                return new ZMAlertDialog.Builder((Context)this.getActivity()).create();
            }
            String displayNumber = this.formatDisplayNumber(this.mNumber, this.mCountryCode);
            String message = this.getActivity().getString(R.string.zm_msg_send_verification_sms_confirm, new Object[]{displayNumber});
            return new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(message).setCancelable(true).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            }).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    RegisterConfirmDialog.this.onOK();
                }
            }).create();
        }

        private String formatDisplayNumber(String formatedNumber, String countryCode) {
            if (formatedNumber.length() <= countryCode.length()) {
                return formatedNumber;
            }
            String number = formatedNumber.substring(countryCode.length() + 1);
            return "+" + countryCode + " " + number;
        }

        public void onResume() {
            super.onResume();
            if (StringUtil.isEmptyOrNull((String)this.mNumber) || StringUtil.isEmptyOrNull((String)this.mCountryCode)) {
                this.dismissAllowingStateLoss();
            }
        }

        private void onOK() {
            Fragment f = this.getParentFragment();
            if (f instanceof AddrBookSetNumberFragment) {
                ((AddrBookSetNumberFragment)f).onConfirmRegister(this.mNumber, this.mCountryCode);
            }
        }
    }
}

