/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.fragment;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.TextView;
import android.widget.Toast;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.LoginActivity;
import com.zipow.videobox.MMChatActivity;
import com.zipow.videobox.fragment.AvatarPreviewFragment;
import com.zipow.videobox.fragment.InviteFragment;
import com.zipow.videobox.fragment.SimpleMessageDialog;
import com.zipow.videobox.ptapp.ABContactsCache;
import com.zipow.videobox.ptapp.ABContactsHelper;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.delegate.PTAppDelegation;
import com.zipow.videobox.ptapp.mm.ZMBuddySyncInstance;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomBuddySearchData;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.sip.server.SipCallManager;
import com.zipow.videobox.util.ImageUtil;
import com.zipow.videobox.util.ZMBitmapFactory;
import com.zipow.videobox.view.AvatarView;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.IMView;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.app.ZMSendMessageFragment;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.PhoneNumberUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.IZMMenuItem;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMMenuAdapter;
import us.zoom.androidlib.widget.ZMSimpleMenuItem;
import us.zoom.videomeetings.R;

public class AddrBookItemDetailsFragment
extends ZMDialogFragment
implements View.OnClickListener,
PTUI.IPTUIListener,
ABContactsCache.IABContactsCacheListener,
PTUI.IPhoneABListener,
View.OnLongClickListener {
    private final String TAG = AddrBookItemDetailsFragment.class.getSimpleName();
    private static final String ARG_CONTACT = "contact";
    private static final String ARG_IS_FROM_ONE_TO_ONE_CHAT = "isFromOneToOneChat";
    private static final String WAITING_DIALOG_TAG = "search_key_waiting_dialog";
    public static final String RESULT_EXTRA_BACK_TO_CHAT = "backToChat";
    private Button mBtnBack = null;
    private View mBtnMoreOpts = null;
    private View mBtnVideoCall = null;
    private View mBtnAudioCall = null;
    private View mBtnMMChat = null;
    private ImageView mImgVideoCall = null;
    private ImageView mImgAudioCall = null;
    private ImageView mImgMMChat = null;
    private TextView mTxtScreenName = null;
    private TextView mTxtSubName = null;
    private AvatarView mAvatarView = null;
    private IMAddrBookItem mContact = null;
    private boolean mbCheckingContactForChat = false;
    private View mPanelPMI;
    private View mPanelPersonalUrl;
    private View mPanelPhoneNumber;
    private TextView mTxtPMI;
    private TextView mTxtPersonalUrl;
    private TextView mTxtProfilePhone;
    private View mPanelTitleBar;
    private View mPanelUserInfo;
    private TextView mTxtCustomStatus;
    private View mPanelSIP;
    private TextView mTxtSIP;
    private ZoomMessengerUI.IZoomMessengerUIListener mZoomMessengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

        @Override
        public void onIndicateInfoUpdatedWithJID(String jid) {
            AddrBookItemDetailsFragment.this.onIndicateInfoUpdatedWithJID(jid);
        }

        @Override
        public void onIndicate_BuddyBigPictureDownloaded(String jid, int result) {
            AddrBookItemDetailsFragment.this.onIndicateBuddyBigPicUpdated(jid);
        }

        @Override
        public void onNotifyBuddyJIDUpgrade(String phoneNo, String oldJid, String newJid) {
            AddrBookItemDetailsFragment.this.onNotifyBuddyJIDUpgrade(phoneNo, oldJid, newJid);
        }

        @Override
        public void onRemoveBuddy(String jid, int result) {
            AddrBookItemDetailsFragment.this.onRemoveBuddy(jid, result);
        }

        @Override
        public void Indicate_BlockedUsersUpdated() {
            AddrBookItemDetailsFragment.this.Indicate_BlockedUsersUpdated();
        }

        @Override
        public void Indicate_BlockedUsersAdded(List<String> users) {
            AddrBookItemDetailsFragment.this.Indicate_BlockedUsersAdded(users);
        }

        @Override
        public void Indicate_BlockedUsersRemoved(List<String> users) {
            AddrBookItemDetailsFragment.this.Indicate_BlockedUsersRemoved(users);
        }

        @Override
        public void Indicate_FetchUserProfileResult(PTAppProtos.UserProfileResult result) {
            AddrBookItemDetailsFragment.this.Indicate_FetchUserProfileResult(result);
        }

        @Override
        public void onSearchBuddyByKey(String key, int result) {
            AddrBookItemDetailsFragment.this.onSearchBuddyByKey(key, result);
        }
    };

    public static void showInActivity(ZMActivity activity, IMAddrBookItem contact) {
        AddrBookItemDetailsFragment.showInActivity(activity, contact, false);
    }

    public static void showInActivity(ZMActivity activity, IMAddrBookItem contact, boolean isFromOneToOneChat) {
        AddrBookItemDetailsFragment f = new AddrBookItemDetailsFragment();
        Bundle args = new Bundle();
        args.putSerializable(ARG_CONTACT, (Serializable)contact);
        args.putBoolean(ARG_IS_FROM_ONE_TO_ONE_CHAT, isFromOneToOneChat);
        f.setArguments(args);
        activity.getSupportFragmentManager().beginTransaction().add(0x1020002, (Fragment)f, AddrBookItemDetailsFragment.class.getName()).commit();
    }

    public static AddrBookItemDetailsFragment findAddrBookItemDetailsFragment(ZMActivity activity) {
        if (activity == null) {
            return null;
        }
        FragmentManager fm = activity.getSupportFragmentManager();
        if (fm == null) {
            return null;
        }
        AddrBookItemDetailsFragment f = (AddrBookItemDetailsFragment)fm.findFragmentByTag(AddrBookItemDetailsFragment.class.getName());
        return f;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_addrbook_item_details, container, false);
        this.mBtnBack = (Button)view.findViewById(R.id.btnBack);
        this.mBtnMoreOpts = view.findViewById(R.id.btnMoreOpts);
        this.mBtnVideoCall = view.findViewById(R.id.btnVideoCall);
        this.mBtnAudioCall = view.findViewById(R.id.btnAudioCall);
        this.mBtnMMChat = view.findViewById(R.id.btnMMChat);
        this.mImgAudioCall = (ImageView)view.findViewById(R.id.imgAudioCall);
        this.mImgMMChat = (ImageView)view.findViewById(R.id.imgMMChat);
        this.mImgVideoCall = (ImageView)view.findViewById(R.id.imgVidoCall);
        this.mTxtScreenName = (TextView)view.findViewById(R.id.txtScreenName);
        this.mTxtSubName = (TextView)view.findViewById(R.id.txtScreenSubName);
        this.mAvatarView = (AvatarView)view.findViewById(R.id.avatarView);
        this.mPanelPhoneNumber = view.findViewById(R.id.panelPhoneNumber);
        this.mTxtProfilePhone = (TextView)view.findViewById(R.id.txtProfilePhone);
        this.mPanelTitleBar = view.findViewById(R.id.panelTitleBar);
        this.mPanelUserInfo = view.findViewById(R.id.panelUserInfo);
        this.mTxtCustomStatus = (TextView)view.findViewById(R.id.txtCustomStatus);
        this.mPanelSIP = view.findViewById(R.id.panelSIP);
        this.mTxtSIP = (TextView)view.findViewById(R.id.txtSIP);
        this.mPanelPMI = view.findViewById(R.id.panelPMI);
        this.mPanelPersonalUrl = view.findViewById(R.id.panelPersonUrl);
        this.mTxtPMI = (TextView)view.findViewById(R.id.txtPMI);
        this.mTxtPersonalUrl = (TextView)view.findViewById(R.id.txtPersonUrl);
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        this.mBtnVideoCall.setOnClickListener((View.OnClickListener)this);
        this.mBtnAudioCall.setOnClickListener((View.OnClickListener)this);
        this.mBtnMMChat.setOnClickListener((View.OnClickListener)this);
        this.mBtnMoreOpts.setOnClickListener((View.OnClickListener)this);
        this.mAvatarView.setOnClickListener(this);
        this.mPanelPhoneNumber.setOnClickListener((View.OnClickListener)this);
        this.mPanelSIP.setOnClickListener((View.OnClickListener)this);
        this.mPanelPMI.setOnLongClickListener((View.OnLongClickListener)this);
        this.mPanelPersonalUrl.setOnLongClickListener((View.OnLongClickListener)this);
        this.mPanelPhoneNumber.setOnLongClickListener((View.OnLongClickListener)this);
        this.updateButtons();
        PTUI.getInstance().addPhoneABListener(this);
        ZoomMessengerUI.getInstance().addListener(this.mZoomMessengerUIListener);
        this.fetchUserProfile();
        return view;
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (savedInstanceState == null && this.mContact != null) {
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            String jid = this.mContact.getJid();
            if (!StringUtil.isEmptyOrNull((String)jid)) {
                messenger.refreshBuddyVCard(jid, true);
                messenger.refreshBuddyBigPicture(jid);
            }
        }
    }

    public void onDestroy() {
        super.onDestroy();
        PTUI.getInstance().removePhoneABListener(this);
    }

    public void onDestroyView() {
        ZoomMessengerUI.getInstance().removeListener(this.mZoomMessengerUIListener);
        super.onDestroyView();
    }

    private boolean canAccessMoreDetails() {
        if (this.mContact == null) {
            return false;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return false;
        }
        return messenger.isMyContact(this.mContact.getJid()) || messenger.isCompanyContact(this.mContact.getJid());
    }

    private void fetchUserProfile() {
        if (!this.canAccessMoreDetails() || this.mContact == null) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null) {
            messenger.fetchUserProfileByJid(this.mContact.getJid());
        }
    }

    private void updateUserInfo() {
        ZoomBuddy buddy;
        if (this.mContact == null) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null && (buddy = messenger.getBuddyWithJID(this.mContact.getJid())) != null) {
            IMAddrBookItem oldContact = this.mContact;
            this.mContact = IMAddrBookItem.fromZoomBuddy(buddy);
            if (oldContact.isFromWebSearch()) {
                this.mContact.setIsFromWebSearch(true);
            }
        }
        this.mTxtScreenName.setText((CharSequence)this.mContact.getScreenName());
        String email = this.mContact.getAccountEmail();
        if (!StringUtil.isEmptyOrNull((String)email)) {
            this.mTxtSubName.setVisibility(0);
            this.mTxtSubName.setText((CharSequence)email);
        } else {
            this.mTxtSubName.setVisibility(8);
        }
        FragmentActivity context = this.getActivity();
        if (context == null) {
            this.mAvatarView.setAvatar((String)null);
            return;
        }
        String text = this.mContact.getSignature();
        if (StringUtil.isEmptyOrNull((String)text)) {
            this.mTxtCustomStatus.setVisibility(8);
        } else {
            this.mTxtCustomStatus.setVisibility(0);
            this.mTxtCustomStatus.setText((CharSequence)text);
        }
        Bitmap bitmap = this.getAvatarBitmap();
        this.mAvatarView.setAvatar(bitmap);
        this.mAvatarView.setBgColorSeedString(this.mContact.getJid());
        this.mAvatarView.setName(this.mContact.getScreenName());
        if (messenger == null || messenger.imChatGetOption() == 2) {
            this.mBtnMMChat.setEnabled(false);
        }
        if (this.canAccessMoreDetails()) {
            if (this.mContact.getPmi() != 0L) {
                this.mTxtPMI.setText((CharSequence)StringUtil.formatConfNumber((long)this.mContact.getPmi()));
                this.mPanelPMI.setVisibility(0);
            } else {
                this.mPanelPMI.setVisibility(8);
            }
            if (!StringUtil.isEmptyOrNull((String)this.mContact.getPersonLink())) {
                this.mTxtPersonalUrl.setText((CharSequence)this.formatPersonUrl(this.mContact.getPersonLink()));
                this.mPanelPersonalUrl.setVisibility(0);
            } else {
                this.mPanelPersonalUrl.setVisibility(8);
            }
            if (!StringUtil.isEmptyOrNull((String)this.mContact.getProfilePhoneNumber())) {
                this.mTxtProfilePhone.setText((CharSequence)PhoneNumberUtil.formatDisplayPhoneNumber((String)this.mContact.getProfileCountryCode(), (String)this.mContact.getProfilePhoneNumber()));
                this.mPanelPhoneNumber.setVisibility(0);
            } else {
                this.mPanelPhoneNumber.setVisibility(8);
            }
            if (StringUtil.isEmptyOrNull((String)this.mContact.getSipPhoneNumber())) {
                this.mPanelSIP.setVisibility(8);
            } else {
                this.mTxtSIP.setText((CharSequence)this.mContact.getSipPhoneNumber());
                this.mPanelSIP.setVisibility(0);
            }
        } else {
            this.mPanelPMI.setVisibility(8);
            this.mPanelPersonalUrl.setVisibility(8);
            this.mPanelPhoneNumber.setVisibility(8);
            this.mPanelSIP.setVisibility(8);
        }
    }

    private String formatPersonUrl(String url) {
        if (StringUtil.isEmptyOrNull((String)url)) {
            return null;
        }
        if (url.startsWith("https://")) {
            return url.substring(8);
        }
        if (url.startsWith("http://")) {
            return url.substring(7);
        }
        return url;
    }

    private Bitmap getAvatarBitmap() {
        FragmentActivity context;
        if (this.mContact == null) {
            return null;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null) {
            Bitmap bitmap;
            File file;
            String avatar = null;
            String jid = this.mContact.getJid();
            ZoomBuddy buddy = messenger.getBuddyWithJID(jid);
            if (buddy != null) {
                avatar = buddy.getLocalBigPicturePath();
            }
            if (ImageUtil.isValidImageFile(avatar)) {
                Bitmap bitmap2 = ZMBitmapFactory.decodeFile(avatar);
                return bitmap2;
            }
            if (!StringUtil.isEmptyOrNull((String)avatar) && (file = new File(avatar)).exists()) {
                file.delete();
            }
            if (buddy != null && ImageUtil.isValidImageFile(avatar = buddy.getLocalPicturePath()) && (bitmap = ZMBitmapFactory.decodeFile(avatar)) != null) {
                return bitmap;
            }
        }
        if ((context = this.getActivity()) != null) {
            Bitmap bitmap = this.mContact.getAvatarBitmap((Context)context);
            return bitmap;
        }
        return null;
    }

    public void onResume() {
        super.onResume();
        PTUI.getInstance().addPTUIListener(this);
        ABContactsCache abCache = ABContactsCache.getInstance();
        abCache.addListener(this);
        this.updateBtnMoreOpts();
        if (abCache.needReloadAll()) {
            abCache.reloadAllContacts();
        }
        this.updateUserInfo();
        this.updateButtons();
    }

    private void onIndicateInfoUpdatedWithJID(String jid) {
        if (this.mContact != null && StringUtil.isSameString((String)this.mContact.getJid(), (String)jid)) {
            this.updateUserInfo();
            this.updateBtnMoreOpts();
        }
    }

    private void onNotifyBuddyJIDUpgrade(String phoneNo, String oldJid, String newJid) {
        if (this.mContact != null && StringUtil.isSameString((String)this.mContact.getJid(), (String)oldJid)) {
            this.close();
        }
    }

    private void onIndicateBuddyBigPicUpdated(String jid) {
        if (this.mContact != null && StringUtil.isSameString((String)this.mContact.getJid(), (String)jid)) {
            this.updateUserInfo();
        }
    }

    private void onRemoveBuddy(String jid, int result) {
        if (this.mContact != null && StringUtil.isSameString((String)this.mContact.getJid(), (String)jid)) {
            this.close();
        }
    }

    private void Indicate_BlockedUsersUpdated() {
        this.updateButtons();
    }

    private void Indicate_BlockedUsersAdded(List<String> users) {
        this.updateButtons();
    }

    private void Indicate_BlockedUsersRemoved(List<String> users) {
        this.updateButtons();
    }

    private void Indicate_FetchUserProfileResult(PTAppProtos.UserProfileResult result) {
        if (result == null || this.mContact == null || !StringUtil.isSameString((String)result.getPeerJid(), (String)this.mContact.getJid())) {
            return;
        }
        this.updateUserInfo();
    }

    public void onSearchBuddyByKey(String key, int result) {
        if (this.mContact == null) {
            return;
        }
        if (!StringUtil.isSameString((String)key, (String)this.mContact.getAccountEmail())) {
            return;
        }
        UIUtil.dismissWaitingDialog((FragmentManager)this.getFragmentManager(), (String)WAITING_DIALOG_TAG);
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddySearchData data = messenger.getBuddySearchData();
        if (data != null && data.getBuddyCount() > 0) {
            this.addSameDomainBuddy();
        } else {
            this.addBuddyByJid();
        }
    }

    public void onPause() {
        super.onPause();
        PTUI.getInstance().removePTUIListener(this);
        ABContactsCache.getInstance().removeListener(this);
    }

    @Override
    public void onPhoneABEvent(int event, final long result, Object content) {
        if (event != 3) {
            return;
        }
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction(){

            public void run(IUIElement ui) {
                ((AddrBookItemDetailsFragment)ui).onPhoneNumbersMatchUpdated(result);
            }
        });
    }

    private void onPhoneNumbersMatchUpdated(long result) {
        if (!this.mbCheckingContactForChat) {
            return;
        }
        this.mbCheckingContactForChat = false;
        switch ((int)result) {
            case 0: {
                this.startChat(false);
                break;
            }
            case 1104: {
                this.onPhoneBindByOther();
                break;
            }
            case 2: 
            case 5003: {
                this.showConnectionError();
                break;
            }
            default: {
                this.showUnnableChatError(result);
            }
        }
    }

    private void onPhoneBindByOther() {
        this.onClickBtnBack();
    }

    private void showUnnableChatError(long result) {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        String msg = context.getString(R.string.zm_mm_msg_start_chat_failed, new Object[]{result});
        Toast.makeText((Context)context, (CharSequence)msg, (int)1).show();
    }

    private void showConnectionError() {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        Toast.makeText((Context)context, (int)R.string.zm_msg_disconnected_try_again, (int)1).show();
    }

    @Override
    public void onContactsCacheUpdated() {
        if (this.mContact.getPhoneNumberCount() == 1) {
            ABContactsCache.Contact contact = ABContactsCache.getInstance().getFirstContactByPhoneNumber(this.mContact.getPhoneNumber(0));
            if (contact != null) {
                this.mContact.setContactId(contact.contactId);
                this.mContact.setScreenName(contact.displayName);
            } else {
                this.mContact.setContactId(-1);
            }
            this.updateUserInfo();
            this.updateBtnMoreOpts();
        }
    }

    private void updateBtnMoreOpts() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        int actionCount = 0;
        if (this.mContact.getIsRobot()) {
            actionCount = 1;
        } else if (!this.mContact.isZoomRoomContact()) {
            boolean isBuddy;
            if (this.mContact.getContactId() < 0) {
                String phoneNumber = this.mContact.getPhoneNumberCount() > 0 ? this.mContact.getPhoneNumber(0) : null;
                String email = this.mContact.getAccountEmail();
                if (!StringUtil.isEmptyOrNull((String)phoneNumber)) {
                    ++actionCount;
                }
                if (!StringUtil.isEmptyOrNull((String)email)) {
                    ++actionCount;
                }
            }
            if (!(isBuddy = messenger.isMyContact(this.mContact.getJid()))) {
                ++actionCount;
            } else if (messenger.canRemoveBuddy(this.mContact.getJid())) {
                ++actionCount;
            }
        }
        if (actionCount > 0) {
            this.mBtnMoreOpts.setVisibility(0);
        } else {
            this.mBtnMoreOpts.setVisibility(8);
        }
    }

    private boolean is2_5Buddy() {
        String phoneNumber;
        if (this.mContact == null) {
            return false;
        }
        String jid = this.mContact.getJid();
        String string2 = phoneNumber = this.mContact.getPhoneNumberCount() > 0 ? this.mContact.getPhoneNumber(0) : null;
        return jid != null && phoneNumber != null && jid.startsWith(phoneNumber);
    }

    public void onStart() {
        super.onStart();
    }

    private void updateButtons() {
        Bundle args = this.getArguments();
        if (args == null) {
            return;
        }
        this.mContact = (IMAddrBookItem)args.getSerializable(ARG_CONTACT);
        if (this.mContact == null) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        boolean imDisable = false;
        if (messenger == null || messenger.imChatGetOption() == 2) {
            imDisable = true;
        }
        boolean isBlocked = false;
        if (messenger == null || messenger.blockUserIsBlocked(this.mContact.getJid())) {
            isBlocked = true;
        }
        if (this.mContact.getIsRobot()) {
            this.mBtnVideoCall.setEnabled(false);
            this.mBtnAudioCall.setEnabled(false);
            this.mBtnMMChat.setEnabled(!isBlocked && !imDisable);
        } else if (this.mContact.getIsZoomUser()) {
            long callStatus = PTApp.getInstance().getCallStatus();
            switch ((int)callStatus) {
                case 1: {
                    this.mBtnAudioCall.setEnabled(false);
                    this.mBtnVideoCall.setEnabled(false);
                    break;
                }
                case 2: {
                    this.mBtnAudioCall.setEnabled(false);
                    this.mBtnVideoCall.setEnabled(false);
                    break;
                }
                default: {
                    this.mBtnAudioCall.setEnabled(!isBlocked);
                    this.mBtnVideoCall.setEnabled(!isBlocked);
                }
            }
            this.mBtnMMChat.setEnabled(!imDisable && !this.mContact.isZoomRoomContact() && (this.mContact.getPhoneNumberCount() > 0 || !StringUtil.isEmptyOrNull((String)this.mContact.getJid())));
        } else {
            this.mBtnAudioCall.setEnabled(false);
            this.mBtnVideoCall.setEnabled(false);
            this.mBtnMMChat.setEnabled(false);
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        } else if (id2 == R.id.btnVideoCall) {
            this.onClickBtnVideoCall();
        } else if (id2 == R.id.btnAudioCall) {
            this.onClickBtnAudioCall();
        } else if (id2 == R.id.btnMMChat) {
            this.onClickBtnMMChat();
        } else if (id2 == R.id.btnMoreOpts) {
            this.onClicKBtnMoreOpts();
        } else if (id2 == R.id.avatarView) {
            this.onClickAvatarView();
        } else if (id2 == R.id.panelPhoneNumber) {
            this.onClickTxtProfilePhone();
        } else if (id2 == R.id.panelSIP) {
            this.onClickPanelSIIP();
        }
    }

    private void onClickPanelSIIP() {
        if (!StringUtil.isEmptyOrNull((String)this.mContact.getSipPhoneNumber())) {
            if (!SipCallManager.getInstance().isSipAvailable()) {
                new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.zm_mm_msg_sip_unavailable_14480).setPositiveButton(R.string.zm_btn_ok, null).show();
                return;
            }
            SipCallManager.getInstance().callPeer(this.mContact.getSipPhoneNumber());
        }
    }

    private void onClickTxtProfilePhone() {
        if (this.mContact == null || StringUtil.isEmptyOrNull((String)this.mContact.getProfilePhoneNumber())) {
            return;
        }
        FragmentActivity context = this.getActivity();
        final ZMMenuAdapter adapter = new ZMMenuAdapter((Context)this.getActivity(), false);
        String phone = PhoneNumberUtil.formatNumber((String)this.mContact.getProfilePhoneNumber(), (String)this.mContact.getProfileCountryCode());
        adapter.addItem((IZMMenuItem)new ClickContextMenu(1, context.getString(R.string.zm_msg_call_phonenum, new Object[]{phone}), phone));
        adapter.addItem((IZMMenuItem)new ClickContextMenu(2, context.getString(R.string.zm_msg_sms_phonenum, new Object[]{phone}), phone));
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)context).setAdapter((ListAdapter)adapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ClickContextMenu item = (ClickContextMenu)((Object)adapter.getItem(which));
                switch (item.getAction()) {
                    case 1: {
                        AndroidAppUtil.sendDial((Context)AddrBookItemDetailsFragment.this.getActivity(), (String)item.getValue());
                        break;
                    }
                    case 2: {
                        ZMSendMessageFragment.show((Context)AddrBookItemDetailsFragment.this.getActivity(), (FragmentManager)AddrBookItemDetailsFragment.this.getFragmentManager(), null, (String[])new String[]{item.getValue()}, null, null, null, null, null, (int)2);
                        break;
                    }
                }
            }
        }).create();
        dialog.setCanceledOnTouchOutside(true);
        dialog.show();
    }

    private void onClickBtnInviteToConf() {
        int callStatus = PTApp.getInstance().getCallStatus();
        if (callStatus == 1 || callStatus == 2) {
            this.inviteABContact();
        }
    }

    private void onClickBtnVideoCall() {
        int callStatus = PTApp.getInstance().getCallStatus();
        if (callStatus == 0) {
            this.callABContact(3);
        }
    }

    private void callABContact(int abCallType) {
        Bundle args = this.getArguments();
        if (args == null) {
            return;
        }
        IMAddrBookItem contact = (IMAddrBookItem)args.getSerializable(ARG_CONTACT);
        if (contact == null) {
            return;
        }
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        int ret = ConfActivity.inviteToVideoCall((Context)activity, contact.getJid(), abCallType);
        if (ret != 0) {
            IMView.StartHangoutFailedDialog.show(((ZMActivity)activity).getSupportFragmentManager(), IMView.StartHangoutFailedDialog.class.getName(), ret);
        }
    }

    private void inviteABContact() {
        Bundle args = this.getArguments();
        if (args == null) {
            return;
        }
        IMAddrBookItem contact = (IMAddrBookItem)args.getSerializable(ARG_CONTACT);
        if (contact == null) {
            return;
        }
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        String jid = contact.getJid();
        if (StringUtil.isEmptyOrNull((String)jid)) {
            return;
        }
        String[] buddyJids = new String[]{contact.getJid()};
        String confId = PTApp.getInstance().getActiveCallId();
        long meetingNum = PTApp.getInstance().getActiveMeetingNo();
        int ret = PTAppDelegation.getInstance().inviteBuddiesToConf(buddyJids, null, confId, meetingNum, this.getString(R.string.zm_msg_invitation_message_template));
        if (ret != 0) {
            this.onSentInvitationFailed();
        } else {
            this.onSentInvitationDone((Activity)activity);
        }
    }

    private void onSentInvitationFailed() {
        new InviteFragment.InviteFailedDialog().show(this.getFragmentManager(), InviteFragment.InviteFailedDialog.class.getName());
    }

    private void onSentInvitationDone(Activity activity) {
        ConfActivity.returnToConf((Context)activity);
        activity.finish();
    }

    private void onClickBtnAudioCall() {
        int callStatus = PTApp.getInstance().getCallStatus();
        if (callStatus == 0) {
            this.callABContact(4);
        }
    }

    private void onClickBtnBack() {
        this.close();
    }

    public void close() {
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        }
        if (this.getShowsDialog()) {
            super.dismiss();
        } else if (activity != null) {
            activity.finish();
        }
    }

    private void onClickBtnInviteToGetZoom() {
        Bundle args = this.getArguments();
        if (args == null) {
            return;
        }
        IMAddrBookItem contact = (IMAddrBookItem)args.getSerializable(ARG_CONTACT);
        if (contact == null) {
            return;
        }
        this.showNonZoomUserActions(contact);
    }

    private void onClickBtnMMChat() {
        this.startChat(true);
    }

    private void startChat(boolean matchPhoneNumbersIfCannotChat) {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        Bundle args = this.getArguments();
        if (args == null) {
            return;
        }
        IMAddrBookItem contact = (IMAddrBookItem)args.getSerializable(ARG_CONTACT);
        boolean isFromOneToOneChat = args.getBoolean(ARG_IS_FROM_ONE_TO_ONE_CHAT);
        if (contact == null) {
            return;
        }
        FragmentManager fm = this.getFragmentManager();
        if (fm == null) {
            return;
        }
        if (isFromOneToOneChat) {
            Intent data = new Intent();
            data.putExtra(RESULT_EXTRA_BACK_TO_CHAT, true);
            activity.setResult(-1, data);
            activity.finish();
        } else if (!StringUtil.isEmptyOrNull((String)contact.getJid())) {
            String phoneNumber = null;
            if (contact.getPhoneNumberCount() > 0) {
                phoneNumber = contact.getPhoneNumber(0);
            }
            AddrBookItemDetailsFragment.startChat(activity, contact, phoneNumber);
        } else if (matchPhoneNumbersIfCannotChat) {
            this.checkContactForChat(contact);
        } else {
            this.showCannotChatMessage();
        }
    }

    private void showCannotChatMessage() {
        SimpleMessageDialog dialog = SimpleMessageDialog.newInstance(R.string.zm_mm_msg_cannot_chat_with_old_version);
        dialog.show(this.getFragmentManager(), "CannotChatMessageDialog");
    }

    private void checkContactForChat(IMAddrBookItem contact) {
        ABContactsHelper contactsHelper = PTApp.getInstance().getABContactsHelper();
        if (contactsHelper == null) {
            return;
        }
        int cnt = contact.getPhoneNumberCount();
        ArrayList<String> numbers = new ArrayList<String>();
        for (int i = 0; i < cnt; ++i) {
            String number = contact.getNormalizedPhoneNumber(i);
            if (number == null) continue;
            numbers.add(number);
        }
        this.mbCheckingContactForChat = false;
        int ret = contactsHelper.matchPhoneNumbers(numbers, false);
        if (ret == 0) {
            this.mbCheckingContactForChat = true;
        } else {
            this.showUnnableChatError(-1L);
        }
    }

    private void onClicKBtnMoreOpts() {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        final ZMMenuAdapter adapter = new ZMMenuAdapter((Context)context, false);
        boolean isBuddy = false;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        String jid = this.mContact.getJid();
        isBuddy = messenger.isMyContact(jid);
        if (!this.mContact.getIsRobot()) {
            if (!isBuddy) {
                adapter.addItem((IZMMenuItem)new MoreOptsMenuItem(2, this.getString(R.string.zm_mi_add_zoom_contact)));
            } else if (messenger.canRemoveBuddy(jid)) {
                adapter.addItem((IZMMenuItem)new MoreOptsMenuItem(3, this.getString(R.string.zm_mi_remove_zoom_contact)));
            }
        }
        if (this.mContact.getContactId() < 0) {
            String phoneNumber = this.mContact.getPhoneNumberCount() > 0 ? this.mContact.getPhoneNumber(0) : null;
            String email = this.mContact.getAccountEmail();
            if (!StringUtil.isEmptyOrNull((String)phoneNumber) || !StringUtil.isEmptyOrNull((String)email)) {
                adapter.addItem((IZMMenuItem)new MoreOptsMenuItem(0, this.getString(R.string.zm_mi_create_new_contact)));
                adapter.addItem((IZMMenuItem)new MoreOptsMenuItem(1, this.getString(R.string.zm_mi_add_to_existing_contact)));
            }
        }
        boolean isBlocked = messenger.blockUserIsBlocked(jid);
        PTApp ptApp = PTApp.getInstance();
        if (isBuddy && ptApp.isAutoReponseON() && !isBlocked && !this.mContact.getIsRobot()) {
            adapter.addItem((IZMMenuItem)new MoreOptsMenuItem(4, this.getString(messenger.isAutoAcceptBuddy(jid) ? R.string.zm_mi_disable_auto_answer : R.string.zm_mi_enable_auto_answer)));
        }
        if (isBlocked) {
            adapter.addItem((IZMMenuItem)new MoreOptsMenuItem(5, this.getString(R.string.zm_mi_unblock_user)));
        } else {
            adapter.addItem((IZMMenuItem)new MoreOptsMenuItem(5, this.getString(R.string.zm_mi_block_user)));
        }
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)context).setTitle(R.string.zm_title_contact_option).setAdapter((ListAdapter)adapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                MoreOptsMenuItem item = (MoreOptsMenuItem)((Object)adapter.getItem(which));
                AddrBookItemDetailsFragment.this.onSelectMoreOptsMenuItem(item);
            }
        }).create();
        dialog.setCanceledOnTouchOutside(true);
        dialog.show();
    }

    private void onClickAvatarView() {
        if (this.mContact == null) {
            return;
        }
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        Bitmap bitmap = this.getAvatarBitmap();
        if (bitmap == null) {
            return;
        }
        AvatarPreviewFragment.showContactAvatar((Fragment)this, this.mContact);
    }

    private void onSelectMoreOptsMenuItem(MoreOptsMenuItem item) {
        String email;
        String phoneNumber;
        if (this.mContact == null) {
            return;
        }
        Intent intent = new Intent();
        intent.putExtra("name", this.mContact.getScreenName());
        String string2 = phoneNumber = this.mContact.getPhoneNumberCount() > 0 ? this.mContact.getPhoneNumber(0) : null;
        if (!StringUtil.isEmptyOrNull((String)phoneNumber)) {
            intent.putExtra("phone", phoneNumber);
            intent.putExtra("phone_type", 2);
        }
        if (!StringUtil.isEmptyOrNull((String)(email = this.mContact.getAccountEmail()))) {
            intent.putExtra("email", email);
            intent.putExtra("email_type", 2);
        }
        if (item.getAction() == 1) {
            intent.setAction("android.intent.action.INSERT_OR_EDIT");
            intent.setType("vnd.android.cursor.item/contact");
        } else if (item.getAction() == 0) {
            intent.setAction("android.intent.action.INSERT");
            intent.setType("vnd.android.cursor.dir/raw_contact");
        } else {
            if (item.getAction() == 4) {
                String jid;
                ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                if (messenger == null) {
                    return;
                }
                messenger.updateAutoAnswerGroupBuddy(jid, !messenger.isAutoAcceptBuddy(jid = this.mContact.getJid()));
                return;
            }
            if (item.getAction() == 2) {
                FragmentActivity context = this.getActivity();
                if (context == null) {
                    return;
                }
                ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                if (messenger == null || !messenger.isConnectionGood()) {
                    this.showCannotAddZoomContactForDisconnected();
                    return;
                }
                if (this.is2_5Buddy()) {
                    Toast.makeText((Context)context, (int)R.string.zm_mm_msg_cannot_add_contact_of_older_version, (int)1).show();
                } else if (messenger.searchBuddyByKey(this.mContact.getAccountEmail())) {
                    UIUtil.showWaitingDialog((FragmentManager)this.getFragmentManager(), (int)R.string.zm_msg_waiting, (String)WAITING_DIALOG_TAG);
                } else {
                    this.addBuddyByJid();
                }
                return;
            }
            if (item.getAction() == 3) {
                FragmentActivity context = this.getActivity();
                if (context == null) {
                    return;
                }
                ZMAlertDialog dlg = new ZMAlertDialog.Builder((Context)context).setTitle(context.getString(R.string.zm_title_remove_contact, new Object[]{this.mContact.getScreenName()})).setCancelable(true).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                    }
                }).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        AddrBookItemDetailsFragment.this.removeZoomContact();
                    }
                }).create();
                dlg.show();
                return;
            }
            if (item.getAction() == 5) {
                ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                if (messenger == null) {
                    return;
                }
                FragmentActivity context = this.getActivity();
                if (context == null) {
                    return;
                }
                boolean isConnectionGood = messenger.isConnectionGood();
                String jid = this.mContact.getJid();
                if (messenger.blockUserIsBlocked(jid)) {
                    if (!isConnectionGood) {
                        Toast.makeText((Context)context, (int)R.string.zm_mm_msg_cannot_unblock_buddy_no_connection, (int)1).show();
                        return;
                    }
                    ArrayList<String> users = new ArrayList<String>();
                    users.add(jid);
                    messenger.blockUserUnBlockUsers(users);
                } else {
                    BlockFragment.show(this.getFragmentManager(), this.mContact);
                }
                return;
            }
            return;
        }
        try {
            this.startActivity(intent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addBuddyByJid() {
        if (this.mContact == null) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null || !messenger.isConnectionGood()) {
            this.showCannotAddZoomContactForDisconnected();
            return;
        }
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return;
        }
        String jid = this.mContact.getJid();
        boolean succ = messenger.addBuddyByJID(jid, myself.getScreenName(), null, this.mContact.getScreenName(), this.mContact.getAccountEmail());
        if (succ) {
            ZMBuddySyncInstance.getInsatance().onAddBuddyByJid(jid);
            Toast.makeText((Context)this.getActivity(), (int)R.string.zm_mm_msg_add_contact_request_sent, (int)1).show();
        } else {
            Toast.makeText((Context)this.getActivity(), (int)R.string.zm_mm_msg_add_contact_failed, (int)1).show();
        }
    }

    private void addSameDomainBuddy() {
        if (this.mContact == null) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null || !messenger.isConnectionGood()) {
            this.showCannotAddZoomContactForDisconnected();
            return;
        }
        String jid = this.mContact.getJid();
        if (messenger.isMyContact(jid) || messenger.addSameOrgBuddyByJID(jid)) {
            Toast.makeText((Context)this.getActivity(), (int)R.string.zm_mm_msg_add_contact_request_sent, (int)1).show();
        } else {
            Toast.makeText((Context)this.getActivity(), (int)R.string.zm_mm_msg_add_contact_failed, (int)1).show();
        }
    }

    private void removeZoomContact() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (!messenger.isConnectionGood()) {
            this.showCannotRemoveZoomContactForDisconnected();
            return;
        }
        String jid = this.mContact.getJid();
        if (messenger.canRemoveBuddy(jid)) {
            messenger.updateAutoAnswerGroupBuddy(jid, false);
            messenger.removeBuddy(jid, null);
        }
    }

    private void showCannotAddZoomContactForDisconnected() {
        FragmentActivity context = this.getActivity();
        if (context != null) {
            Toast.makeText((Context)context, (int)R.string.zm_mm_msg_cannot_add_buddy_no_connection, (int)1).show();
        }
    }

    private void showCannotRemoveZoomContactForDisconnected() {
        FragmentActivity context = this.getActivity();
        if (context != null) {
            Toast.makeText((Context)context, (int)R.string.zm_mm_msg_cannot_remove_buddy_no_connection, (int)1).show();
        }
    }

    private void showNonZoomUserActions(IMAddrBookItem item) {
        if (item == null) {
            return;
        }
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        FragmentManager fm = activity.getSupportFragmentManager();
        if (fm == null) {
            return;
        }
        int countNumbers = item.getPhoneNumberCount();
        int countEmails = item.getEmailCount();
        if (countNumbers == 1 && countEmails == 0) {
            AddrBookItemDetailsFragment.inviteBySMS((Context)activity, fm, item.getPhoneNumber(0));
        } else if (countNumbers == 0 && countEmails == 1) {
            AddrBookItemDetailsFragment.inviteByEmail((Context)activity, fm, item.getEmail(0));
        } else {
            ContextMenuFragment.show(fm, item);
        }
    }

    private static void inviteByEmail(Context context, FragmentManager fm, String email) {
        String topic = PTApp.getInstance().getZoomInvitationEmailSubject();
        String content = PTApp.getInstance().getZoomInvitationEmailBody();
        ZMSendMessageFragment.show((Context)context, (FragmentManager)fm, (String[])new String[]{email}, null, (String)topic, (String)content, (String)content, null, null, (int)1);
    }

    private static void inviteBySMS(Context context, FragmentManager fm, String phoneNumber) {
        String topic = PTApp.getInstance().getZoomInvitationEmailSubject();
        String content = context.getString(R.string.zm_msg_sms_invitation_content);
        ZMSendMessageFragment.show((Context)context, (FragmentManager)fm, null, (String[])new String[]{phoneNumber}, (String)topic, (String)content, (String)content, null, null, (int)2);
    }

    private static void startChat(ZMActivity activity, IMAddrBookItem contact, String phoneNumber) {
        MMChatActivity.showAsOneToOneChatWithPhoneNumber(activity, contact, phoneNumber, true);
    }

    @Override
    public void onPTAppEvent(int event, long result) {
        switch (event) {
            case 22: {
                this.updateButtons();
            }
        }
    }

    @Override
    public void onDataNetworkStatusChanged(boolean connected) {
    }

    private void loginToUse() {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        PTApp.getInstance().logout(1);
        LoginActivity.show((Context)activity, false);
        this.close();
    }

    public boolean onLongClick(View v) {
        if (v == null) {
            return false;
        }
        int id2 = v.getId();
        if (id2 == R.id.panelPMI) {
            if (this.mContact != null && this.mContact.getPmi() != 0L) {
                this.showCopyContextMenu(this.mContact.getPmi() + "");
                return true;
            }
        } else if (id2 == R.id.panelPersonUrl) {
            if (this.mContact != null && !StringUtil.isEmptyOrNull((String)this.mContact.getPersonLink())) {
                this.showCopyContextMenu(this.formatPersonUrl(this.mContact.getPersonLink()));
                return true;
            }
        } else if (id2 == R.id.panelPhoneNumber && this.mContact != null && !StringUtil.isEmptyOrNull((String)this.mContact.getProfilePhoneNumber())) {
            String phone = PhoneNumberUtil.formatNumber((String)this.mContact.getProfilePhoneNumber(), (String)this.mContact.getProfileCountryCode());
            this.showCopyContextMenu(phone);
            return true;
        }
        return false;
    }

    private void showCopyContextMenu(String value) {
        FragmentActivity context = this.getActivity();
        final ZMMenuAdapter adapter = new ZMMenuAdapter((Context)this.getActivity(), false);
        adapter.addItem((IZMMenuItem)new LongClickMenuItem(0, this.getString(R.string.zm_btn_copy), value));
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)context).setAdapter((ListAdapter)adapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                LongClickMenuItem item = (LongClickMenuItem)((Object)adapter.getItem(which));
                AndroidAppUtil.copyText((Context)AddrBookItemDetailsFragment.this.getActivity(), (CharSequence)item.getValue());
            }
        }).create();
        dialog.setCanceledOnTouchOutside(true);
        dialog.show();
    }

    public static class ClickContextMenu
    extends ZMSimpleMenuItem {
        public static final int ACTION_PHONE_CALL = 1;
        public static final int ACTION_PHONE_MSG = 2;
        private String mValue;

        public ClickContextMenu(int action, String label, String value) {
            super(action, label);
            this.mValue = value;
        }

        public String getValue() {
            return this.mValue;
        }
    }

    static class LongClickMenuItem
    extends ZMSimpleMenuItem {
        public static final int ACTION_COPY = 0;
        private String mValue;

        public LongClickMenuItem(int action, String label, String value) {
            super(action, label);
            this.mValue = value;
        }

        public String getValue() {
            return this.mValue;
        }
    }

    static class MoreOptsMenuItem
    extends ZMSimpleMenuItem {
        public static final int ACTION_CREATE_NEW_CONTACT = 0;
        public static final int ACTION_ADD_TO_EXISTING_CONTACT = 1;
        public static final int ACTION_ADD_ZOOM_CONTACT = 2;
        public static final int ACTION_REMOVE_ZOOM_CONTACT = 3;
        public static final int ACTION_AUTO_ANSWER = 4;
        public static final int ACTION_BLOCK_USER = 5;

        public MoreOptsMenuItem(int action, String label) {
            super(action, label);
        }
    }

    static class ContextMenuItem
    extends ZMSimpleMenuItem {
        private String mLabel;
        private String mPhoneNumber;
        private String mEmail;

        public ContextMenuItem(String label, String phoneNumber, String email) {
            this.mLabel = label;
            this.mPhoneNumber = phoneNumber;
            this.mEmail = email;
        }

        public String toString() {
            return this.mLabel;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public String getPhoneNumber() {
            return this.mPhoneNumber;
        }

        public String getEmail() {
            return this.mEmail;
        }

        public boolean isPhoneNumberItem() {
            return !StringUtil.isEmptyOrNull((String)this.mPhoneNumber);
        }

        public boolean isEmailItem() {
            return !StringUtil.isEmptyOrNull((String)this.mEmail);
        }

        public Drawable getIcon() {
            return null;
        }
    }

    public static class ContextMenuFragment
    extends ZMDialogFragment {
        private static final String ARG_ADDRBOOKITEM = "addrBookItem";
        private ZMMenuAdapter<ContextMenuItem> mAdapter;

        public static void show(@NonNull FragmentManager fm, @NonNull IMAddrBookItem item) {
            Bundle args = new Bundle();
            args.putSerializable(ARG_ADDRBOOKITEM, (Serializable)item);
            ContextMenuFragment f = new ContextMenuFragment();
            f.setArguments(args);
            f.show(fm, ContextMenuFragment.class.getName());
        }

        public ContextMenuFragment() {
            this.setCancelable(true);
        }

        public void onStart() {
            super.onStart();
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            IMAddrBookItem item = (IMAddrBookItem)this.getArguments().getSerializable(ARG_ADDRBOOKITEM);
            this.mAdapter = this.createUpdateAdapter();
            FragmentActivity activity = this.getActivity();
            String title = item.getScreenName();
            title = StringUtil.isEmptyOrNull((String)title) ? activity.getString(R.string.zm_title_invite) : activity.getString(R.string.zm_title_invite_xxx, new Object[]{title});
            ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)activity).setTitle(title).setAdapter(this.mAdapter, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ContextMenuFragment.this.onSelectItem(which);
                }
            }).create();
            dialog.setCanceledOnTouchOutside(true);
            return dialog;
        }

        private ZMMenuAdapter<ContextMenuItem> createUpdateAdapter() {
            IMAddrBookItem item = (IMAddrBookItem)this.getArguments().getSerializable(ARG_ADDRBOOKITEM);
            ArrayList<ContextMenuItem> items = new ArrayList<ContextMenuItem>();
            if (item != null) {
                int i;
                for (i = 0; i < item.getPhoneNumberCount(); ++i) {
                    String number = item.getPhoneNumber(i);
                    items.add(new ContextMenuItem(number, number, null));
                }
                for (i = 0; i < item.getEmailCount(); ++i) {
                    String email = item.getEmail(i);
                    items.add(new ContextMenuItem(email, null, email));
                }
            }
            if (this.mAdapter == null) {
                this.mAdapter = new ZMMenuAdapter((Context)this.getActivity(), false);
            } else {
                this.mAdapter.clear();
            }
            this.mAdapter.addAll(items);
            return this.mAdapter;
        }

        public void refresh() {
            this.createUpdateAdapter().notifyDataSetChanged();
        }

        private void onSelectItem(int which) {
            ContextMenuItem menuItem = (ContextMenuItem)((Object)this.mAdapter.getItem(which));
            if (menuItem == null) {
                return;
            }
            ZMActivity activity = (ZMActivity)this.getActivity();
            if (activity == null) {
                return;
            }
            FragmentManager fm = activity.getSupportFragmentManager();
            if (fm == null) {
                return;
            }
            if (menuItem.isPhoneNumberItem()) {
                AddrBookItemDetailsFragment.inviteBySMS((Context)activity, fm, menuItem.getPhoneNumber());
            } else {
                AddrBookItemDetailsFragment.inviteByEmail((Context)activity, fm, menuItem.getEmail());
            }
        }
    }

    public static class BlockFragment
    extends ZMDialogFragment {
        private static final String ARG_ADDRBOOKITEM = "addrBookItem";

        public static void show(FragmentManager fm, IMAddrBookItem item) {
            if (item == null || fm == null) {
                return;
            }
            Bundle args = new Bundle();
            args.putSerializable(ARG_ADDRBOOKITEM, (Serializable)item);
            BlockFragment f = new BlockFragment();
            f.setArguments(args);
            f.show(fm, BlockFragment.class.getName());
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            IMAddrBookItem item = (IMAddrBookItem)this.getArguments().getSerializable(ARG_ADDRBOOKITEM);
            ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.zm_alert_block_confirm_title).setMessage(this.getString(R.string.zm_alert_block_confirm_msg, new Object[]{item.getScreenName()})).setNegativeButton(R.string.zm_btn_cancel, null).setPositiveButton(R.string.zm_btn_block, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    FragmentActivity activity = BlockFragment.this.getActivity();
                    if (activity == null) {
                        return;
                    }
                    ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                    if (messenger == null) {
                        return;
                    }
                    IMAddrBookItem item = (IMAddrBookItem)BlockFragment.this.getArguments().getSerializable(BlockFragment.ARG_ADDRBOOKITEM);
                    if (item == null) {
                        return;
                    }
                    boolean isConnectionGood = messenger.isConnectionGood();
                    String jid = item.getJid();
                    if (!messenger.blockUserIsBlocked(jid)) {
                        if (!isConnectionGood) {
                            Toast.makeText((Context)BlockFragment.this.getActivity(), (int)R.string.zm_mm_msg_cannot_block_buddy_no_connection, (int)1).show();
                            return;
                        }
                        ArrayList<String> users = new ArrayList<String>();
                        users.add(jid);
                        messenger.blockUserBlockUsers(users);
                    }
                }
            }).create();
            dialog.setCanceledOnTouchOutside(true);
            return dialog;
        }
    }
}

