/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.dropbox;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.net.Uri;
import com.dropbox.core.android.Auth;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.dropbox.ZMAppKeyPair;
import com.zipow.videobox.dropbox.ZMDropboxClient;
import com.zipow.videobox.util.ZMAuthUtil;
import java.util.List;
import us.zoom.androidlib.util.StringUtil;

public class ZMDropbox {
    private static ZMDropbox INSTANCE = null;
    private ZMDropboxClient mDropboxClient;
    private static final String DROPBOX_PREFS_NAME = "dropbox_prefs";
    private static final String PREF_KEY_APP_KEY = "APP_KEY";
    private static final String PREF_KEY_APP_SECRET = "APP_SECRET";
    private static final String PREF_KEY_TOKEN = "ACCESS-TOKEN";
    private static ZMAppKeyPair sZoomAppKeyPair = new ZMAppKeyPair(ZMAuthUtil.getDropboxKey(), ZMAuthUtil.getDropboxSecret());
    private static ZMAppKeyPair sAppKeyPair;
    private static final String ACTION_AUTHENTICATE_V2 = "com.dropbox.android.AUTHENTICATE_V2";
    private static final String[] DROPBOX_APP_SIGNATURES;

    public static synchronized ZMDropbox getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ZMDropbox();
        }
        return INSTANCE;
    }

    public static synchronized void release() {
        if (INSTANCE != null) {
            INSTANCE.logout();
            INSTANCE = null;
        }
    }

    public void login(Context context) {
        if (context == null) {
            return;
        }
        ZMAppKeyPair appKey = ZMDropbox.getAppKeyPair(context);
        Auth.startOAuth2Authentication((Context)context, (String)appKey.key);
    }

    public void logout() {
        this.mDropboxClient = null;
        VideoBoxApplication context = VideoBoxApplication.getInstance();
        if (context != null) {
            SharedPreferences prefs = context.getSharedPreferences(DROPBOX_PREFS_NAME, 0);
            SharedPreferences.Editor editor = prefs.edit();
            editor.putString(PREF_KEY_TOKEN, null);
            editor.commit();
        }
    }

    public boolean onResume(Context context) {
        SharedPreferences prefs = context.getSharedPreferences(DROPBOX_PREFS_NAME, 0);
        String oldToken = prefs.getString(PREF_KEY_TOKEN, null);
        String accessToken = Auth.getOAuth2Token();
        SharedPreferences.Editor editor = prefs.edit();
        if (StringUtil.isEmptyOrNull((String)oldToken) && StringUtil.isEmptyOrNull((String)accessToken)) {
            this.initClient(null);
            return false;
        }
        if (!(StringUtil.isEmptyOrNull((String)accessToken) || !StringUtil.isEmptyOrNull((String)oldToken) && accessToken.equals(oldToken))) {
            editor.putString(PREF_KEY_TOKEN, accessToken);
            editor.commit();
            this.initClient(accessToken);
        } else {
            this.initClient(oldToken);
        }
        return true;
    }

    private void initClient(String accessToken) {
        if (StringUtil.isEmptyOrNull((String)accessToken)) {
            this.logout();
            return;
        }
        if (this.mDropboxClient == null || !accessToken.equals(this.mDropboxClient.getToken())) {
            this.mDropboxClient = new ZMDropboxClient(accessToken);
        }
    }

    public boolean hasLogin() {
        return this.mDropboxClient != null && !StringUtil.isEmptyOrNull((String)this.mDropboxClient.getToken());
    }

    public ZMDropboxClient getClient() {
        return this.mDropboxClient;
    }

    public void setListener(ZMDropboxClient.DropboxListener l) {
        if (this.mDropboxClient != null) {
            this.mDropboxClient.setListener(l);
        }
    }

    public static boolean setAppKeyPair(Context context, String appKey, String appSecret) {
        if (context == null) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)appKey) || StringUtil.isEmptyOrNull((String)appSecret)) {
            SharedPreferences prefs = context.getSharedPreferences(DROPBOX_PREFS_NAME, 0);
            SharedPreferences.Editor editor = prefs.edit();
            editor.clear();
            editor.commit();
            return false;
        }
        SharedPreferences prefs = context.getSharedPreferences(DROPBOX_PREFS_NAME, 0);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString(PREF_KEY_APP_KEY, appKey);
        editor.putString(PREF_KEY_APP_SECRET, appSecret);
        editor.commit();
        return true;
    }

    public static ZMAppKeyPair getAppKeyPair(Context context) {
        if (context == null) {
            return null;
        }
        if ("us.zoom.videomeetings".equals(context.getPackageName())) {
            return sZoomAppKeyPair;
        }
        if (sAppKeyPair == null) {
            SharedPreferences prefs = context.getSharedPreferences(DROPBOX_PREFS_NAME, 0);
            String appKey = prefs.getString(PREF_KEY_APP_KEY, null);
            String appSecret = prefs.getString(PREF_KEY_APP_SECRET, null);
            if (!StringUtil.isEmptyOrNull((String)appKey) && !StringUtil.isEmptyOrNull((String)appSecret)) {
                sAppKeyPair = new ZMAppKeyPair(appKey, appSecret);
            }
        }
        return sAppKeyPair;
    }

    public static boolean isDropboxLoginSupported(Context context) {
        return ZMDropbox.canAuthViaBrowser(context) || ZMDropbox.hasDropboxApp(context);
    }

    private static boolean canAuthViaBrowser(Context context) {
        PackageManager pm = context.getPackageManager();
        if (pm == null) {
            return false;
        }
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"https://www.dropbox.com:443"));
        List list = pm.queryIntentActivities(intent, 65536);
        return list != null && list.size() > 0;
    }

    private static boolean hasDropboxApp(Context context) {
        PackageInfo packageInfo;
        PackageManager manager = context.getPackageManager();
        Intent intent = new Intent();
        intent.setPackage("com.dropbox.android");
        intent.setAction(ACTION_AUTHENTICATE_V2);
        List infos = manager.queryIntentActivities(intent, 0);
        if (null == infos || 1 != infos.size()) {
            return false;
        }
        ResolveInfo resolveInfo = manager.resolveActivity(intent, 0);
        if (resolveInfo == null) {
            return false;
        }
        try {
            packageInfo = manager.getPackageInfo(resolveInfo.activityInfo.packageName, 64);
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        for (Signature signature : packageInfo.signatures) {
            for (String dbSignature : DROPBOX_APP_SIGNATURES) {
                if (!dbSignature.equals(signature.toCharsString())) continue;
                return true;
            }
        }
        return false;
    }

    static {
        DROPBOX_APP_SIGNATURES = new String[]{"308202223082018b02044bd207bd300d06092a864886f70d01010405003058310b3009060355040613025553310b3009060355040813024341311630140603550407130d53616e204672616e636973636f3110300e060355040a130744726f70626f783112301006035504031309546f6d204d65796572301e170d3130303432333230343930315a170d3430303431353230343930315a3058310b3009060355040613025553310b3009060355040813024341311630140603550407130d53616e204672616e636973636f3110300e060355040a130744726f70626f783112301006035504031309546f6d204d6579657230819f300d06092a864886f70d010101050003818d0030818902818100ac1595d0ab278a9577f0ca5a14144f96eccde75f5616f36172c562fab0e98c48ad7d64f1091c6cc11ce084a4313d522f899378d312e112a748827545146a779defa7c31d8c00c2ed73135802f6952f59798579859e0214d4e9c0554b53b26032a4d2dfc2f62540d776df2ea70e2a6152945fb53fef5bac5344251595b729d4810203010001300d06092a864886f70d01010405000381810055c425d94d036153203dc0bbeb3516f94563b102fff39c3d4ed91278db24fc4424a244c2e59f03bbfea59404512b8bf74662f2a32e37eafa2ac904c31f99cfc21c9ff375c977c432d3b6ec22776f28767d0f292144884538c3d5669b568e4254e4ed75d9054f75229ac9d4ccd0b7c3c74a34f07b7657083b2aa76225c0c56ffc", "308201e53082014ea00302010202044e17e115300d06092a864886f70d01010505003037310b30090603550406130255533110300e060355040a1307416e64726f6964311630140603550403130d416e64726f6964204465627567301e170d3131303730393035303331375a170d3431303730313035303331375a3037310b30090603550406130255533110300e060355040a1307416e64726f6964311630140603550403130d416e64726f696420446562756730819f300d06092a864886f70d010101050003818d003081890281810096759fe5abea6a0757039b92adc68d672efa84732c3f959408e12efa264545c61f23141026a6d01eceeeaa13ec7087087e5894a3363da8bf5c69ed93657a6890738a80998e4ca22dc94848f30e2d0e1890000ae2cddf543b20c0c3828deca6c7944b5ecd21a9d18c988b2b3e54517dafbc34b48e801bb1321e0fa49e4d575d7f0203010001300d06092a864886f70d0101050500038181002b6d4b65bcfa6ec7bac97ae6d878064d47b3f9f8da654995b8ef4c385bc4fbfbb7a987f60783ef0348760c0708acd4b7e63f0235c35a4fbcd5ec41b3b4cb295feaa7d5c27fa562a02562b7e1f4776b85147be3e295714986c4a9a07183f48ea09ae4d3ea31b88d0016c65b93526b9c45f2967c3d28dee1aff5a5b29b9c2c8639"};
    }
}

