/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.dialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentManager;
import android.text.Html;
import android.text.method.LinkMovementMethod;
import android.view.ContextThemeWrapper;
import android.view.KeyEvent;
import android.view.View;
import android.widget.TextView;
import com.zipow.videobox.dialog.DialogActionCallBack;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class ZMGDPRConfirmDialog
extends ZMDialogFragment {
    private static String TAG = ZMGDPRConfirmDialog.class.getName();
    public static final int TYPE_SIGN_IN = 1;
    public static final int TYPE_JOIN_MEETING = 2;
    public static final int TYPE_CANNOT_JOIN_MEETING = 3;
    public static final String ARGS_TERMS_URL = "args_terms_url";
    public static final String ARGS_PRIVACY_URL = "args_privacy_url";
    private static final String ARGS_REQUEST_CODE = "args_request_code";
    private static final String ARGS_TYPE = "args_type";
    private DialogActionCallBack mDialogActionCallBack;
    private int mRequestCode;
    private int mType;
    private String mTosUrl;
    private String mPrivacyUrl;

    public static void checkShowDialog(@NonNull ZMActivity activity, int requestCode, int type, @NonNull String tosUrl, @NonNull String privacyUrl) {
        ZMGDPRConfirmDialog.dismiss(activity.getSupportFragmentManager());
        ZMGDPRConfirmDialog.showDialog(activity, requestCode, type, tosUrl, privacyUrl);
    }

    public static void showDialog(@NonNull ZMActivity activity, int requestCode, int type, @NonNull String tosUrl, @NonNull String privacyUrl) {
        Bundle args = new Bundle();
        args.putInt(ARGS_REQUEST_CODE, requestCode);
        args.putInt(ARGS_TYPE, type);
        args.putString(ARGS_TERMS_URL, tosUrl);
        args.putString(ARGS_PRIVACY_URL, privacyUrl);
        ZMGDPRConfirmDialog dialog = new ZMGDPRConfirmDialog();
        dialog.setArguments(args);
        dialog.show(activity.getSupportFragmentManager(), ZMGDPRConfirmDialog.class.getName());
    }

    public static ZMGDPRConfirmDialog findFragment(FragmentManager fm) {
        if (fm == null) {
            return null;
        }
        ZMGDPRConfirmDialog f = (ZMGDPRConfirmDialog)fm.findFragmentByTag(ZMGDPRConfirmDialog.class.getName());
        return f;
    }

    public static boolean dismiss(FragmentManager fm) {
        if (fm == null) {
            return false;
        }
        ZMGDPRConfirmDialog f = ZMGDPRConfirmDialog.findFragment(fm);
        if (f != null) {
            f.dismiss();
            return true;
        }
        return false;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (context != null && context instanceof DialogActionCallBack) {
            this.mDialogActionCallBack = (DialogActionCallBack)context;
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(ARGS_REQUEST_CODE, this.mRequestCode);
        outState.putInt(ARGS_TYPE, this.mType);
        outState.putString(ARGS_TERMS_URL, this.mTosUrl);
        outState.putString(ARGS_PRIVACY_URL, this.mPrivacyUrl);
    }

    public void onViewStateRestored(@Nullable Bundle savedInstanceState) {
        super.onViewStateRestored(savedInstanceState);
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Bundle args = this.getArguments();
        if (args != null) {
            this.mRequestCode = args.getInt(ARGS_REQUEST_CODE);
            this.mType = args.getInt(ARGS_TYPE);
            this.mTosUrl = args.getString(ARGS_TERMS_URL);
            this.mPrivacyUrl = args.getString(ARGS_PRIVACY_URL);
        } else if (savedInstanceState != null) {
            this.mRequestCode = savedInstanceState.getInt(ARGS_REQUEST_CODE);
            this.mType = savedInstanceState.getInt(ARGS_TYPE);
            this.mTosUrl = savedInstanceState.getString(ARGS_TERMS_URL);
            this.mPrivacyUrl = savedInstanceState.getString(ARGS_PRIVACY_URL);
        }
        ZMAlertDialog.Builder builder = new ZMAlertDialog.Builder((Context)this.getActivity()).setView(this.createContent());
        if (this.mType == 1) {
            builder.setCancelable(true);
            builder.setTitle(R.string.zm_title_gdpr_sing_in_41396);
            builder.setPositiveButton(R.string.zm_btn_continue, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ZMGDPRConfirmDialog.this.onClickPositiveBtn();
                    if (dialog != null) {
                        dialog.cancel();
                    }
                }
            });
        } else if (this.mType == 2) {
            builder.setCancelable(false);
            builder.setTitle(R.string.zm_msg_gdrp_new_user_join_meeting_41396);
            builder.setPositiveButton(R.string.zm_btn_agree_41396, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ZMGDPRConfirmDialog.this.onClickPositiveBtn();
                    if (dialog != null) {
                        dialog.cancel();
                    }
                }
            });
            builder.setNegativeButton(R.string.zm_btn_disagree_41396, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ZMGDPRConfirmDialog.this.onClickNegativeBtn();
                }
            });
        } else if (this.mType == 3) {
            builder.setCancelable(false);
            builder.setTitle(R.string.zm_msg_cannot_join_meeting_41396);
            builder.setPositiveButton(R.string.zm_btn_agree_41396, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ZMGDPRConfirmDialog.this.onClickPositiveBtn();
                    if (dialog != null) {
                        dialog.cancel();
                    }
                }
            });
            builder.setNegativeButton(R.string.zm_btn_leave_conference, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ZMGDPRConfirmDialog.this.onClickNegativeBtn();
                }
            });
        }
        ZMAlertDialog dialog = builder.create();
        dialog.setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                if (keyCode == 4) {
                    ZMGDPRConfirmDialog.this.onClickBackPressed();
                    return true;
                }
                return false;
            }
        });
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
        return dialog;
    }

    private View createContent() {
        ContextThemeWrapper contextThemeWrapper = new ContextThemeWrapper((Context)this.getActivity(), R.style.ZMDialog_Material);
        View view = View.inflate((Context)contextThemeWrapper, (int)R.layout.zm_gdpr_layout, null);
        TextView messageView = (TextView)view.findViewById(R.id.txtMessage);
        TextView tosView = (TextView)view.findViewById(R.id.txtTerms);
        TextView privacyView = (TextView)view.findViewById(R.id.txtPrivacy);
        tosView.setMovementMethod(LinkMovementMethod.getInstance());
        privacyView.setMovementMethod(LinkMovementMethod.getInstance());
        if (this.mType == 1) {
            messageView.setText(R.string.zm_msg_gdpr_sing_in_41396);
        } else {
            messageView.setVisibility(8);
        }
        String tosHtml = this.getString(R.string.zm_msg_terms_of_services_41396, new Object[]{this.mTosUrl});
        tosView.setText((CharSequence)Html.fromHtml((String)tosHtml));
        String privacyHtml = this.getString(R.string.zm_msg_privacy_policy_41396, new Object[]{this.mPrivacyUrl});
        privacyView.setText((CharSequence)Html.fromHtml((String)privacyHtml));
        return view;
    }

    private void onClickPositiveBtn() {
        if (this.mDialogActionCallBack != null) {
            this.mDialogActionCallBack.performDialogAction(this.mRequestCode, -1, null);
        }
    }

    private void onClickNegativeBtn() {
        if (this.mDialogActionCallBack != null) {
            Bundle args = new Bundle();
            args.putString(ARGS_TERMS_URL, this.mTosUrl);
            args.putString(ARGS_PRIVACY_URL, this.mPrivacyUrl);
            this.mDialogActionCallBack.performDialogAction(this.mRequestCode, -2, args);
        }
    }

    public void onClickBackPressed() {
        if (this.mDialogActionCallBack != null) {
            this.mDialogActionCallBack.performDialogAction(this.mRequestCode, 1, null);
        }
    }

    public void dismiss() {
        this.finishFragment(false);
    }
}

