/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.dialog;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.FragmentManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.confapp.AudioSessionMgr;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.util.ConfLocalHelper;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.HeadsetUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.recyclerviewhelper.RVHItemClickListener;
import us.zoom.videomeetings.R;

public class SwitchOutputAudioDialog
extends ZMDialogFragment
implements HeadsetUtil.IHeadsetConnectionListener {
    private ConfActivity mConfActivity;
    private MyAdapter myAdapter;
    private boolean isStartingSco;
    private boolean isStoppingSco;
    private Handler mHandler = new Handler();
    private Runnable mCheckCurrentStates = new Runnable(){

        @Override
        public void run() {
            SwitchOutputAudioDialog.this.refreshAdapter();
            SwitchOutputAudioDialog.this.isStartingSco = HeadsetUtil.getInstance().ismIsStartingSco();
            SwitchOutputAudioDialog.this.isStoppingSco = HeadsetUtil.getInstance().ismIsStoppingSco();
            if (!SwitchOutputAudioDialog.this.isStartingSco && !SwitchOutputAudioDialog.this.isStoppingSco) {
                SwitchOutputAudioDialog.this.dismiss();
            }
        }
    };

    public static void showDialog(FragmentManager fm) {
        if (fm == null) {
            return;
        }
        SwitchOutputAudioDialog dlg = new SwitchOutputAudioDialog();
        dlg.show(fm, SwitchOutputAudioDialog.class.getName());
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        ConfActivity confActivity = this.getConfActivity();
        if (confActivity == null) {
            return this.createEmptyDialog();
        }
        View view = this.createContent();
        if (view == null) {
            return this.createEmptyDialog();
        }
        ZMAlertDialog dlg = new ZMAlertDialog.Builder((Context)confActivity).setTheme(R.style.ZMDialog_Material_RoundRect).setView(view).create();
        dlg.setCanceledOnTouchOutside(true);
        return dlg;
    }

    private View createContent() {
        ContextThemeWrapper context = new ContextThemeWrapper((Context)this.getActivity(), R.style.ZMDialog_Material);
        View view = View.inflate((Context)context, (int)R.layout.zm_recyclerview_dialog_switch_audio, null);
        RecyclerView recyclerView = (RecyclerView)view.findViewById(R.id.recyclerView);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)context));
        ArrayList<AudioOutputItem> audioOutputItems = this.buildMenuItems();
        if (CollectionsUtil.isCollectionEmpty(audioOutputItems)) {
            return null;
        }
        this.myAdapter = new MyAdapter(audioOutputItems);
        recyclerView.setAdapter((RecyclerView.Adapter)this.myAdapter);
        recyclerView.addOnItemTouchListener((RecyclerView.OnItemTouchListener)new RVHItemClickListener((Context)context, new RVHItemClickListener.OnItemClickListener(){

            public void onItemClick(View view, int position) {
                AudioOutputItem audioOutputItem = SwitchOutputAudioDialog.this.myAdapter.getItem(position);
                if (audioOutputItem != null) {
                    ConfActivity confActivity;
                    int curAudioSourceType = ConfUI.getInstance().getCurrentAudioSourceType();
                    if (audioOutputItem.getAction() != curAudioSourceType && (confActivity = SwitchOutputAudioDialog.this.getConfActivity()) != null) {
                        ConfLocalHelper.switchAudioSource((Context)confActivity, confActivity.getMyAudioType(), audioOutputItem.getAction());
                        SwitchOutputAudioDialog.this.mHandler.postDelayed(SwitchOutputAudioDialog.this.mCheckCurrentStates, 200L);
                    }
                }
            }
        }));
        return view;
    }

    private ArrayList<AudioOutputItem> buildMenuItems() {
        ArrayList<AudioOutputItem> items = new ArrayList<AudioOutputItem>();
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return null;
        }
        AudioSessionMgr audioMgr = ConfMgr.getInstance().getAudioObj();
        if (audioMgr == null) {
            return null;
        }
        HeadsetUtil headsetUtil = HeadsetUtil.getInstance();
        int curAudioSourceType = ConfUI.getInstance().getCurrentAudioSourceType();
        if (headsetUtil.isBTAndWiredHeadsetsOn()) {
            String btName = headsetUtil.getConnectedBTName();
            AudioOutputItem item = new AudioOutputItem(3, btName == null ? this.getString(R.string.zm_mi_bluetooth) : btName + "(" + this.getString(R.string.zm_mi_bluetooth) + ")", curAudioSourceType == 3);
            items.add(item);
            item = new AudioOutputItem(2, this.getString(R.string.zm_mi_wired_headset), curAudioSourceType == 2);
            items.add(item);
            item = new AudioOutputItem(0, this.getString(R.string.zm_lbl_speaker), curAudioSourceType == 0);
            items.add(item);
        }
        return items;
    }

    private ConfActivity getConfActivity() {
        if (this.mConfActivity == null) {
            this.mConfActivity = (ConfActivity)this.getActivity();
        }
        return this.mConfActivity;
    }

    public void onResume() {
        super.onResume();
        HeadsetUtil.getInstance().addListener((HeadsetUtil.IHeadsetConnectionListener)this);
        ConfActivity confActivity = this.getConfActivity();
        if (confActivity == null) {
            return;
        }
        if (!confActivity.canSwitchAudioSource()) {
            this.dismiss();
            return;
        }
        this.refreshAdapter();
    }

    public void onStop() {
        super.onStop();
        this.mHandler.removeCallbacks(this.mCheckCurrentStates);
    }

    private void refreshAdapter() {
        if (this.myAdapter != null) {
            ArrayList<AudioOutputItem> items = this.buildMenuItems();
            if (!CollectionsUtil.isCollectionEmpty(items)) {
                this.myAdapter.refresh(items);
            } else {
                this.dismiss();
                return;
            }
        }
    }

    public void onPause() {
        super.onPause();
        HeadsetUtil.getInstance().removeListener((HeadsetUtil.IHeadsetConnectionListener)this);
    }

    public void onHeadsetStatusChanged(boolean wiredHeadsetConnected, boolean bluetoothHeadsetConnected) {
        this.refreshAdapter();
    }

    public void onBluetoothScoAudioStatus(boolean on) {
        this.refreshAdapter();
        if (this.isStartingSco && on || this.isStoppingSco && !on) {
            this.dismiss();
        }
    }

    static class MyAdapter
    extends RecyclerView.Adapter<MyViewHolder> {
        private final List<AudioOutputItem> mAudioOutputItems;

        MyAdapter(List<AudioOutputItem> audioOutputItems) {
            this.mAudioOutputItems = audioOutputItems;
        }

        public AudioOutputItem getItem(int pos) {
            if (pos < this.getItemCount()) {
                return this.mAudioOutputItems.get(pos);
            }
            return null;
        }

        public void refresh(List<AudioOutputItem> audioOutputItems) {
            this.mAudioOutputItems.clear();
            this.mAudioOutputItems.addAll(audioOutputItems);
            this.notifyDataSetChanged();
        }

        public MyViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            return new MyViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.zm_item_dialog_audio_output, parent, false));
        }

        public void onBindViewHolder(MyViewHolder holder, int position) {
            holder.bind(this.mAudioOutputItems.get(position));
        }

        public int getItemCount() {
            return CollectionsUtil.isCollectionEmpty(this.mAudioOutputItems) ? 0 : this.mAudioOutputItems.size();
        }

        static class MyViewHolder
        extends RecyclerView.ViewHolder {
            final TextView txtLabel;
            final View leftView;
            final ImageView ivSelected;
            final ProgressBar progressBar;

            public MyViewHolder(View itemView) {
                super(itemView);
                this.leftView = itemView.findViewById(R.id.fr_left);
                this.txtLabel = (TextView)itemView.findViewById(R.id.txtLabel);
                this.ivSelected = (ImageView)itemView.findViewById(R.id.imgIcon);
                this.progressBar = (ProgressBar)itemView.findViewById(R.id.progressBar);
            }

            private boolean isStartingSco() {
                AudioSessionMgr audioSessionMgr = ConfMgr.getInstance().getAudioObj();
                return audioSessionMgr != null && !audioSessionMgr.ismIsUseA2dpMode() && HeadsetUtil.getInstance().ismIsStartingSco();
            }

            private boolean isStoppingSco() {
                AudioSessionMgr audioSessionMgr = ConfMgr.getInstance().getAudioObj();
                return audioSessionMgr != null && !audioSessionMgr.ismIsUseA2dpMode() && HeadsetUtil.getInstance().ismIsStoppingSco();
            }

            public void bind(AudioOutputItem audioOutputItem) {
                this.txtLabel.setText((CharSequence)audioOutputItem.getLabel());
                if (audioOutputItem.isSelected) {
                    this.leftView.setVisibility(0);
                    if (audioOutputItem.getAction() == 3 && this.isStartingSco() || audioOutputItem.getAction() != 3 && this.isStoppingSco()) {
                        this.progressBar.setVisibility(0);
                        this.ivSelected.setVisibility(8);
                    } else {
                        this.progressBar.setVisibility(8);
                        this.ivSelected.setVisibility(0);
                    }
                } else {
                    this.leftView.setVisibility(4);
                    this.progressBar.setVisibility(8);
                }
            }
        }
    }

    static class AudioOutputItem {
        private int action;
        private String label;
        private boolean isSelected;

        public AudioOutputItem(int action, String label, boolean isSelected) {
            this.action = action;
            this.label = label;
            this.isSelected = isSelected;
        }

        public int getAction() {
            return this.action;
        }

        public void setAction(int action) {
            this.action = action;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setSelected(boolean selected) {
            this.isSelected = selected;
        }
    }
}

