/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.dialog;

import android.app.Dialog;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.TipMessageType;
import com.zipow.videobox.util.ConfLocalHelper;
import com.zipow.videobox.view.NormalMessageTip;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.recyclerviewhelper.RVHItemClickListener;
import us.zoom.androidlib.widget.recyclerviewhelper.RVHItemDividerDecoration;
import us.zoom.videomeetings.R;

public class LiveStreamDialog
extends ZMDialogFragment {
    MyAdapter myAdapter;

    public LiveStreamDialog() {
        this.setCancelable(true);
    }

    public static void show(ConfActivity confActivity) {
        if (confActivity != null && confActivity.isActive()) {
            new LiveStreamDialog().show(confActivity.getSupportFragmentManager(), LiveStreamDialog.class.getName());
        }
    }

    public static void refresh(ConfActivity confActivity) {
        LiveStreamDialog liveStreamDialog;
        if (confActivity != null && confActivity.isActive() && (liveStreamDialog = (LiveStreamDialog)confActivity.getSupportFragmentManager().findFragmentByTag(LiveStreamDialog.class.getName())) != null) {
            liveStreamDialog.update(confActivity);
        }
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        ZMAlertDialog.Builder builder = new ZMAlertDialog.Builder((Context)this.getActivity()).setCancelable(true).setTheme(R.style.ZMDialog_Material).setView(this.createContent(), true).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        });
        ZMAlertDialog dialog = builder.create();
        dialog.setCanceledOnTouchOutside(true);
        return dialog;
    }

    private void update(ConfActivity confActivity) {
        List<LiveStreamItem> liveStreamItems = this.getLiveStreamItems(confActivity);
        if (!CollectionsUtil.isCollectionEmpty(liveStreamItems) && this.myAdapter != null) {
            this.myAdapter.refresh(liveStreamItems);
        }
    }

    private View createContent() {
        ConfActivity confActivity = (ConfActivity)this.getActivity();
        if (confActivity == null) {
            return null;
        }
        ContextThemeWrapper context = new ContextThemeWrapper((Context)this.getActivity(), R.style.ZMDialog_Material);
        View view = View.inflate((Context)context, (int)R.layout.zm_recyclerview_dialog, null);
        RecyclerView recyclerView = (RecyclerView)view.findViewById(R.id.recyclerView);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)context));
        List<LiveStreamItem> liveStreamItems = this.getLiveStreamItems(confActivity);
        if (CollectionsUtil.isCollectionEmpty(liveStreamItems)) {
            return null;
        }
        this.myAdapter = new MyAdapter(liveStreamItems);
        recyclerView.setAdapter((RecyclerView.Adapter)this.myAdapter);
        recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new RVHItemDividerDecoration((Context)context, 1, R.drawable.zm_list_divider));
        recyclerView.addOnItemTouchListener((RecyclerView.OnItemTouchListener)new RVHItemClickListener((Context)context, new RVHItemClickListener.OnItemClickListener(){

            public void onItemClick(View view, int position) {
                LiveStreamItem liveStreamItem = LiveStreamDialog.this.myAdapter.getItem(position);
                if (liveStreamItem != null) {
                    if (liveStreamItem.liveStreamItemType == LiveStreamItemType.StopLiveStream) {
                        LiveStreamDialog.this.showLiveStreamStopDialog();
                    } else {
                        LiveStreamDialog.this.copyLink();
                    }
                }
                LiveStreamDialog.this.dismissAllowingStateLoss();
            }
        }));
        return view;
    }

    private List<LiveStreamItem> getLiveStreamItems(ConfActivity confActivity) {
        LiveStreamItem liveStreamItem;
        CmmConfStatus confStatus;
        if (confActivity == null) {
            return null;
        }
        ArrayList<LiveStreamItem> liveStreamItems = new ArrayList<LiveStreamItem>();
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself != null && (myself.isHost() || myself.isCoHost()) && (confStatus = ConfMgr.getInstance().getConfStatusObj()) != null && confStatus.isLiveOn()) {
            liveStreamItem = new LiveStreamItem(LiveStreamItemType.StopLiveStream, R.string.zm_btn_stop_streaming);
            liveStreamItems.add(liveStreamItem);
        }
        liveStreamItem = new LiveStreamItem(LiveStreamItemType.CopyLink, R.string.zm_live_stream_copy_link_30168);
        liveStreamItems.add(liveStreamItem);
        return liveStreamItems;
    }

    private void showLiveStreamStopDialog() {
        ConfActivity confActivity = (ConfActivity)this.getActivity();
        if (confActivity == null) {
            return;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null || !myself.isHost() && !myself.isCoHost()) {
            return;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        boolean isLiveOn = confStatus.isLiveOn();
        if (!isLiveOn) {
            return;
        }
        String title = confActivity.getString(ConfLocalHelper.isWebinar() ? R.string.zm_lbl_meeting_on_live : R.string.zm_lbl_meeting_on_live_26196, new Object[]{ConfLocalHelper.getLiveChannelStreamName()});
        ZMAlertDialog dlg = new ZMAlertDialog.Builder((Context)confActivity).setTitle(title).setPositiveButton(R.string.zm_btn_stop_streaming, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                LiveStreamDialog.this.stopLiveStream();
            }
        }).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).create();
        dlg.show();
    }

    private void stopLiveStream() {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus != null && confStatus.isLiveOn()) {
            confStatus.stopLive();
        }
    }

    private void copyLink() {
        ClipboardManager clipboardManager;
        String viewerUrl;
        ConfActivity confActivity = (ConfActivity)this.getActivity();
        if (confActivity != null && !StringUtil.isEmptyOrNull((String)(viewerUrl = ConfLocalHelper.getLiveChannelStreamUrl())) && (clipboardManager = (ClipboardManager)confActivity.getSystemService("clipboard")) != null) {
            ClipData clipData = ClipData.newPlainText((CharSequence)"label", (CharSequence)viewerUrl);
            clipboardManager.setPrimaryClip(clipData);
            NormalMessageTip.show((Context)confActivity, confActivity.getSupportFragmentManager(), TipMessageType.TIP_COPIED_STREAMING_LINK.name(), -1, R.string.zm_live_stream_copyed_link_30168, 3000L);
        }
    }

    static class MyAdapter
    extends RecyclerView.Adapter<MyViewHolder> {
        private final List<LiveStreamItem> mLiveStreamItems;

        MyAdapter(List<LiveStreamItem> liveStreamItems) {
            this.mLiveStreamItems = liveStreamItems;
        }

        public LiveStreamItem getItem(int pos) {
            if (pos < this.getItemCount()) {
                return this.mLiveStreamItems.get(pos);
            }
            return null;
        }

        public void refresh(List<LiveStreamItem> liveStreamItems) {
            if (liveStreamItems.size() != this.mLiveStreamItems.size()) {
                this.mLiveStreamItems.clear();
                this.mLiveStreamItems.addAll(liveStreamItems);
                this.notifyDataSetChanged();
            }
        }

        public MyViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            return new MyViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.zm_item_dialog_livestream, parent, false));
        }

        public void onBindViewHolder(MyViewHolder holder, int position) {
            holder.bind(this.mLiveStreamItems.get((int)position).stringRes);
        }

        public int getItemCount() {
            return CollectionsUtil.isCollectionEmpty(this.mLiveStreamItems) ? 0 : this.mLiveStreamItems.size();
        }

        class MyViewHolder
        extends RecyclerView.ViewHolder {
            final TextView txtDialogItem;

            public MyViewHolder(View itemView) {
                super(itemView);
                this.txtDialogItem = (TextView)itemView.findViewById(R.id.txtDialogItem);
            }

            public void bind(int textId) {
                this.txtDialogItem.setText(textId);
            }
        }
    }

    static class LiveStreamItem {
        final LiveStreamItemType liveStreamItemType;
        final int stringRes;

        public LiveStreamItem(LiveStreamItemType liveStreamItemType, int stringRes) {
            this.liveStreamItemType = liveStreamItemType;
            this.stringRes = stringRes;
        }
    }

    static enum LiveStreamItemType {
        CopyLink,
        StopLiveStream;

    }
}

