/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.dialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import android.text.util.Linkify;
import android.util.Patterns;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.util.ConfLocalHelper;
import java.util.regex.Pattern;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class JoinFailedDialog
extends ZMDialogFragment {
    private int errorCode = 0;

    public JoinFailedDialog() {
        this.setCancelable(true);
    }

    public static void show(FragmentManager fragmentMgr, String tag, int errorCode) {
        Bundle args = new Bundle();
        args.putInt("errorCode", errorCode);
        JoinFailedDialog dlg = new JoinFailedDialog();
        dlg.setArguments(args);
        dlg.show(fragmentMgr, tag);
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Bundle args = this.getArguments();
        this.errorCode = args.getInt("errorCode");
        View view = LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.zm_dailog_msg_txt_view, null, false);
        TextView msgView = (TextView)view.findViewById(R.id.txtMsg);
        String message = ConfLocalHelper.errorCodeToMessage(this.getActivity().getResources(), this.errorCode);
        msgView.setText((CharSequence)message);
        if (this.errorCode == 24) {
            final String url = this.getString(R.string.zm_firewall_support_url);
            Linkify.addLinks((TextView)msgView, (Pattern)Patterns.WEB_URL, (String)"", (Linkify.MatchFilter)new Linkify.MatchFilter(){

                public boolean acceptMatch(CharSequence s, int start, int end) {
                    String matcher;
                    return s != null && s.length() > 0 && (matcher = s.subSequence(start, end).toString()).equals(url);
                }
            }, null);
        }
        ZMAlertDialog.Builder builder = new ZMAlertDialog.Builder((Context)this.getActivity()).setView(view);
        if (this.errorCode == 10) {
            builder.setPositiveButton(R.string.zm_btn_update, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ConfLocalHelper.leaveAndUpdate((ConfActivity)JoinFailedDialog.this.getActivity());
                }
            }).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ConfLocalHelper.leaveCall((ConfActivity)JoinFailedDialog.this.getActivity());
                }
            });
        } else if (this.errorCode == 23) {
            int positiveBtnStr = PTApp.getInstance().isWebSignedOn() ? R.string.zm_btn_switch_account : R.string.zm_btn_login;
            builder.setTitle(R.string.zm_msg_conffail_internal_only_17745).setMessage(R.string.zm_msg_conffail_signin_join_17745).setPositiveButton(positiveBtnStr, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ConfLocalHelper.leaveAndLogin((ConfActivity)JoinFailedDialog.this.getActivity());
                }
            }).setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ConfActivity confActivity = (ConfActivity)JoinFailedDialog.this.getActivity();
                    if (confActivity != null) {
                        ConfMgr.getInstance().notifyConfLeaveReason(String.valueOf(ConfLocalHelper.errorCodeToLeaveReason(JoinFailedDialog.this.errorCode)), true);
                        ConfLocalHelper.leaveCall(confActivity);
                    }
                }
            });
        } else {
            builder.setNegativeButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ConfActivity confActivity = (ConfActivity)JoinFailedDialog.this.getActivity();
                    if (confActivity != null) {
                        ConfMgr.getInstance().notifyConfLeaveReason(String.valueOf(ConfLocalHelper.errorCodeToLeaveReason(JoinFailedDialog.this.errorCode)), true, JoinFailedDialog.this.errorCode == 1);
                        ConfLocalHelper.leaveCall(confActivity);
                    }
                }
            });
        }
        ZMAlertDialog dlg = builder.create();
        dlg.setCanceledOnTouchOutside(false);
        return dlg;
    }

    public void onCancel(DialogInterface dialog) {
        super.onCancel(dialog);
        ConfActivity confActivity = (ConfActivity)this.getActivity();
        if (confActivity != null) {
            ConfMgr.getInstance().notifyConfLeaveReason(String.valueOf(ConfLocalHelper.errorCodeToLeaveReason(this.errorCode)), true, this.errorCode == 1);
            ConfLocalHelper.leaveCall(confActivity);
        }
    }
}

