/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.dialog;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.text.Html;
import android.text.method.LinkMovementMethod;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.zipow.videobox.dialog.DialogActionCallBack;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.util.ZMWebUtil;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.thirdparty.login.facebook.FbUserProfile;
import us.zoom.videomeetings.R;

public class FbConfirmCreateAccountDialog
extends ZMDialogFragment {
    private static final String TAG = FbConfirmCreateAccountDialog.class.getName();
    private DialogActionCallBack mDialogActionCallBack;
    public static int ACTION_LOGIN_FB_FIRST = 1;

    public FbConfirmCreateAccountDialog() {
        this.setCancelable(true);
    }

    public static void show(ZMActivity activity, @NonNull FbUserProfile fbUserProfile) {
        if (activity == null) {
            return;
        }
        FbConfirmCreateAccountDialog fbConfirmCreateAccountDialog = new FbConfirmCreateAccountDialog();
        Bundle arguments = new Bundle();
        arguments.putParcelable(FbUserProfile.class.getName(), (Parcelable)fbUserProfile);
        fbConfirmCreateAccountDialog.setArguments(arguments);
        fbConfirmCreateAccountDialog.show(activity.getSupportFragmentManager(), TAG);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.mDialogActionCallBack = (DialogActionCallBack)context;
    }

    public void onStart() {
        super.onStart();
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        ZMAlertDialog.Builder builder = new ZMAlertDialog.Builder((Context)this.getActivity()).setCancelable(true).setTheme(R.style.ZMDialog_Material_RoundRect).setView(this.createContent());
        ZMAlertDialog dialog = builder.create();
        dialog.setCanceledOnTouchOutside(true);
        return dialog;
    }

    private View createContent() {
        ContextThemeWrapper contextThemeWrapper = new ContextThemeWrapper((Context)this.getActivity(), R.style.ZMDialog_Material_RoundRect);
        View view = View.inflate((Context)contextThemeWrapper, (int)R.layout.zm_fb_confirm_create_account, null);
        ImageView avatarView = (ImageView)view.findViewById(R.id.avatarView);
        TextView txtHi = (TextView)view.findViewById(R.id.txtHi);
        TextView txtEmail = (TextView)view.findViewById(R.id.txtEmail);
        TextView txtTerms = (TextView)view.findViewById(R.id.txtTerms);
        view.findViewById(R.id.btnCreateAccount).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (FbConfirmCreateAccountDialog.this.mDialogActionCallBack != null) {
                    FbConfirmCreateAccountDialog.this.mDialogActionCallBack.performDialogAction(0, ACTION_LOGIN_FB_FIRST, null);
                }
                FbConfirmCreateAccountDialog.this.dismiss();
            }
        });
        FbUserProfile fbUserProfile = (FbUserProfile)this.getArguments().getParcelable(FbUserProfile.class.getName());
        txtHi.setText((CharSequence)this.getString(R.string.zm_msg_confirm_hi_create_account_31350, new Object[]{StringUtil.safeString((String)fbUserProfile.getName())}));
        txtEmail.setText((CharSequence)fbUserProfile.getEmail());
        txtTerms.setMovementMethod(LinkMovementMethod.getInstance());
        String tosUrl = PTApp.getInstance().getURLByType(10);
        if (!StringUtil.isEmptyOrNull((String)tosUrl)) {
            String html = this.getString(R.string.zm_msg_confirm_terms_create_account_31350, new Object[]{tosUrl, ZMWebUtil.getZmUrlPrivacyPolicy()});
            txtTerms.setText((CharSequence)Html.fromHtml((String)html));
        }
        RequestOptions options = new RequestOptions().circleCrop().placeholder(R.drawable.zm_no_avatar).error(R.drawable.zm_no_avatar);
        Glide.with((Fragment)this).load(fbUserProfile.getAvatarUrl()).apply(options).into(avatarView);
        return view;
    }
}

