/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.config;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.zipow.cmmlib.AppContext;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.util.BuildTarget;
import com.zipow.videobox.util.PreferenceUtil;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.ZMBuildConfig;

public class ConfigReader
extends BroadcastReceiver {
    private static final String TAG = ConfigReader.class.getSimpleName();
    public static final String ACTION_READ_CONFIG = "us.zoom.videomeetings.intent.action.READ_CONFIG";
    public static final String ACTION_ZOOM_CONFIG = "us.zoom.videomeetings.intent.action.ZOOM_CONFIG";
    public static final String KEY_WEBSERVER = "conf.webserver";
    public static final String KEY_WEBSERVER_BEFORE_CN = "conf.webserver.before.cn";
    public static final String KEY_ENABLELOG = "enableLog";
    public static final String KEY_ENABLE_MZM_LOG = "enableMzmLog";
    public static final String KEY_LOG_LEVEL = "logLevel";
    public static final String KEY_DISABLE_UTIL_LOG = "DisableUtilLog";
    public static final String KEY_DISABLE_DEADLOCK_DETECT = "com.zoom.test.disable_deadlock_detect";
    public static final String KEY_CRASH_DUMP_USER_INFO = "Crash.DumpUserInfor";
    public static final String KEY_UI_MODE = "UIMode";
    public static final String KEY_ADDRESS_BOOK_ENABLED = "AddressBookEnabled";
    public static final String KEY_FORCE_DISABLE_GCM = "forceDisableGCM";
    public static final String KEY_AUDIO_API_TYPE = "audioAPIType";
    public static final String KEY_GCM_CAPABLE = "gcmCapable";
    public static final String KEY_GCM_ALWAYS = "gcmAlways";
    public static final String KEY_DB_SDK = "dbSDK";
    public static final String KEY_CONF_SERVER_RINGCENTRAL_API = "conf.server.ringcentralapi";

    public void onReceive(Context context, Intent intent) {
        if (!ACTION_READ_CONFIG.equals(intent.getAction())) {
            return;
        }
        ConfigReader.broadcastConfigInfo(context);
    }

    public static void broadcastConfigInfo(Context context) {
        AppContext appContext;
        String webServer;
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null) {
            return;
        }
        if (!mainboard.isInitialized()) {
            VideoBoxApplication.getInstance().initPTMainboard();
        }
        if (StringUtil.isEmptyOrNull((String)(webServer = (appContext = new AppContext("config")).queryWithKey(KEY_WEBSERVER, AppContext.APP_NAME_CHAT)))) {
            webServer = PTApp.getInstance().getZoomDomain();
        }
        boolean enableLog = "true".equals(appContext.queryWithKey(KEY_ENABLELOG, AppContext.APP_NAME_CHAT));
        boolean enableMZMLog = "true".equals(appContext.queryWithKey(KEY_ENABLE_MZM_LOG, AppContext.APP_NAME_CHAT));
        String logLevel = appContext.queryWithKey(KEY_LOG_LEVEL, AppContext.APP_NAME_CHAT);
        boolean disableUtilLog = "true".equals(appContext.queryWithKey(KEY_DISABLE_UTIL_LOG, AppContext.APP_NAME_CHAT));
        String disableDeadlockDetect = appContext.queryWithKey(KEY_DISABLE_DEADLOCK_DETECT, AppContext.APP_NAME_CHAT);
        String crashDumpUserInfo = appContext.queryWithKey(KEY_CRASH_DUMP_USER_INFO, AppContext.APP_NAME_CHAT);
        String confServerRingcentralAPI = appContext.queryWithKey(KEY_CONF_SERVER_RINGCENTRAL_API, AppContext.APP_NAME_CHAT);
        String uiMode = PreferenceUtil.readStringValue(KEY_UI_MODE, null);
        String addrbookEnabled = PreferenceUtil.readStringValue(KEY_ADDRESS_BOOK_ENABLED, null);
        boolean bForceDisableGCM = PreferenceUtil.readBooleanValue(KEY_FORCE_DISABLE_GCM, false);
        String audioAPIType = PreferenceUtil.readStringValue(KEY_AUDIO_API_TYPE, null);
        boolean bAlwaysGCM = PreferenceUtil.readBooleanValue(KEY_GCM_ALWAYS, false);
        boolean db = PreferenceUtil.readBooleanValue(KEY_DB_SDK, false);
        Intent res = new Intent();
        res.setAction(ACTION_ZOOM_CONFIG);
        res.addCategory("android.intent.category.DEFAULT");
        res.putExtra(KEY_WEBSERVER, webServer);
        res.putExtra(KEY_ENABLELOG, enableLog);
        res.putExtra(KEY_ENABLE_MZM_LOG, enableMZMLog);
        res.putExtra(KEY_LOG_LEVEL, logLevel);
        res.putExtra(KEY_DISABLE_UTIL_LOG, disableUtilLog);
        res.putExtra(KEY_DISABLE_DEADLOCK_DETECT, disableDeadlockDetect);
        res.putExtra(KEY_CRASH_DUMP_USER_INFO, crashDumpUserInfo);
        res.putExtra(KEY_UI_MODE, uiMode);
        res.putExtra(KEY_ADDRESS_BOOK_ENABLED, addrbookEnabled);
        res.putExtra(KEY_FORCE_DISABLE_GCM, bForceDisableGCM);
        res.putExtra(KEY_AUDIO_API_TYPE, audioAPIType);
        res.putExtra(KEY_GCM_CAPABLE, AndroidAppUtil.isC2DMCapable((Context)context));
        res.putExtra(KEY_GCM_ALWAYS, bAlwaysGCM);
        res.putExtra(KEY_DB_SDK, db);
        if (BuildTarget.isRingCentralLogin(ZMBuildConfig.BUILD_TARGET)) {
            res.putExtra(KEY_CONF_SERVER_RINGCENTRAL_API, confServerRingcentralAPI);
        }
        context.sendBroadcast(res, context.getPackageName() + ".permission.READ_CONFIG");
    }
}

