/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.confapp.qa;

import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;

public class ZoomQAUI {
    private static final String TAG = ZoomQAUI.class.getSimpleName();
    private static ZoomQAUI instance = null;
    private ListenerList mListenerList = new ListenerList();
    private long mNativeHandle = 0L;

    public static synchronized ZoomQAUI getInstance() {
        if (instance == null) {
            instance = new ZoomQAUI();
        }
        if (!instance.initialized()) {
            instance.init();
        }
        return instance;
    }

    public ZoomQAUI() {
        this.init();
    }

    private boolean initialized() {
        return this.mNativeHandle != 0L;
    }

    private void init() {
        try {
            this.mNativeHandle = this.nativeInit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public long getNativeHandle() {
        return this.mNativeHandle;
    }

    protected void finalize() throws Throwable {
        if (this.mNativeHandle != 0L) {
            this.nativeUninit(this.mNativeHandle);
        }
        super.finalize();
    }

    public void addListener(IZoomQAUIListener l) {
        if (l == null) {
            return;
        }
        IListener[] listeners = this.mListenerList.getAll();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != l) continue;
            this.removeListener((IZoomQAUIListener)listeners[i]);
        }
        this.mListenerList.add((IListener)l);
    }

    public void removeListener(IZoomQAUIListener l) {
        this.mListenerList.remove((IListener)l);
    }

    protected void notifyConnectStart() {
        try {
            this.notifyConnectStartImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void notifyConnectStartImpl() {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomQAUIListener l = (IZoomQAUIListener)lTmp;
                l.notifyConnectStart();
            }
        }
    }

    protected void notifyConnectResult(boolean bConnectSuccess) {
        try {
            this.notifyConnectResultImpl(bConnectSuccess);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void notifyConnectResultImpl(boolean bConnectSuccess) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomQAUIListener l = (IZoomQAUIListener)lTmp;
                l.notifyConnectResult(bConnectSuccess);
            }
        }
    }

    protected void onRefreshQAUI() {
        try {
            this.onRefreshQAUIImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onRefreshQAUIImpl() {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomQAUIListener l = (IZoomQAUIListener)lTmp;
                l.onRefreshQAUI();
            }
        }
    }

    protected void onAddQuestion(String questionID, boolean bSuccess) {
        try {
            this.onAddQuestionImpl(questionID, bSuccess);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onAddQuestionImpl(String questionID, boolean bSuccess) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomQAUIListener l = (IZoomQAUIListener)lTmp;
                l.onAddQuestion(questionID, bSuccess);
            }
        }
    }

    protected void onAddAnswer(String answerID, boolean bSuccess) {
        try {
            this.onAddAnswerImpl(answerID, bSuccess);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onAddAnswerImpl(String answerID, boolean bSuccess) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomQAUIListener l = (IZoomQAUIListener)lTmp;
                l.onAddAnswer(answerID, bSuccess);
            }
        }
    }

    protected void onReceiveQuestion(String questionID) {
        try {
            this.onReceiveQuestionImpl(questionID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onReceiveQuestionImpl(String questionID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomQAUIListener l = (IZoomQAUIListener)lTmp;
                l.onReceiveQuestion(questionID);
            }
        }
    }

    protected void onReceiveAnswer(String answerID) {
        try {
            this.onReceiveAnswerImpl(answerID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onReceiveAnswerImpl(String answerID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomQAUIListener l = (IZoomQAUIListener)lTmp;
                l.onReceiveAnswer(answerID);
            }
        }
    }

    protected void onQuestionMarkedAsAnswered(String questionID) {
        try {
            this.onQuestionMarkedAsAnsweredImpl(questionID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onQuestionMarkedAsAnsweredImpl(String questionID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomQAUIListener l = (IZoomQAUIListener)lTmp;
                l.onQuestionMarkedAsAnswered(questionID);
            }
        }
    }

    protected void onUserComposing(String questionID) {
        try {
            this.onUserComposingImpl(questionID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onUserComposingImpl(String questionID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomQAUIListener l = (IZoomQAUIListener)lTmp;
                l.onUserComposing(questionID);
            }
        }
    }

    protected void onUserEndComposing(String questionID) {
        try {
            this.onUserEndComposingImpl(questionID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onUserEndComposingImpl(String questionID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomQAUIListener l = (IZoomQAUIListener)lTmp;
                l.onUserEndComposing(questionID);
            }
        }
    }

    protected void onUserLivingReply(String questionID) {
        try {
            this.onUserLivingReplyImpl(questionID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onUserLivingReplyImpl(String questionID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomQAUIListener l = (IZoomQAUIListener)lTmp;
                l.onUserLivingReply(questionID);
            }
        }
    }

    protected void onUserEndLiving(String questionID) {
        try {
            this.onUserEndLivingImpl(questionID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onUserEndLivingImpl(String questionID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomQAUIListener l = (IZoomQAUIListener)lTmp;
                l.onUserEndLiving(questionID);
            }
        }
    }

    protected void onUserListUpdated() {
        try {
            this.onUserListUpdatedImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onUserListUpdatedImpl() {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomQAUIListener l = (IZoomQAUIListener)lTmp;
                l.onUserListUpdated();
            }
        }
    }

    protected void onUserListInitialized() {
        try {
            this.onUserListInitializedImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onUserListInitializedImpl() {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomQAUIListener l = (IZoomQAUIListener)lTmp;
                l.onUserListInitialized();
            }
        }
    }

    protected void onUserAdded(String jid) {
        try {
            this.onUserAddedImpl(jid);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onUserAddedImpl(String jid) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomQAUIListener l = (IZoomQAUIListener)lTmp;
                l.onUserAdded(jid);
            }
        }
    }

    protected void onUserRemoved(String jid) {
        try {
            this.onUserRemovedImpl(jid);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onUserRemovedImpl(String jid) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomQAUIListener l = (IZoomQAUIListener)lTmp;
                l.onUserRemoved(jid);
            }
        }
    }

    protected void onWebinarAttendeeRaisedHand(long nodeID) {
        try {
            this.onWebinarAttendeeRaisedHandImpl(nodeID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onWebinarAttendeeRaisedHandImpl(long nodeID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomQAUIListener l = (IZoomQAUIListener)lTmp;
                l.onWebinarAttendeeRaisedHand(nodeID);
            }
        }
    }

    protected void onWebinarAttendeeLowerHand(long nodeID) {
        try {
            this.onWebinarAttendeeLowerHandImpl(nodeID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onWebinarAttendeeLowerHandImpl(long nodeID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomQAUIListener l = (IZoomQAUIListener)lTmp;
                l.onWebinarAttendeeLowerHand(nodeID);
            }
        }
    }

    protected void onChattedAttendeeUpdated(long nodeID) {
        try {
            this.onChattedAttendeeUpdatedImpl(nodeID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onChattedAttendeeUpdatedImpl(long nodeID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomQAUIListener l = (IZoomQAUIListener)lTmp;
                l.onChattedAttendeeUpdated(nodeID);
            }
        }
    }

    protected void onWebinarAttendeeGuestStatusChanged(long nodeID, boolean isGuest) {
        try {
            this.onWebinarAttendeeGuestStatusChangedImpl(nodeID, isGuest);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onWebinarAttendeeGuestStatusChangedImpl(long nodeID, boolean isGuest) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomQAUIListener l = (IZoomQAUIListener)lTmp;
                l.onWebinarAttendeeGuestStatusChanged(nodeID, isGuest);
            }
        }
    }

    protected void onQuestionMarkedAsDismissed(String question_id) {
        try {
            this.onQuestionMarkedAsDismissedImpl(question_id);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onQuestionMarkedAsDismissedImpl(String question_id) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomQAUIListener l = (IZoomQAUIListener)lTmp;
                l.onQuestionMarkedAsDismissed(question_id);
            }
        }
    }

    protected void onAnswerSenderNameChanged(String sender_jid, String question_id) {
        try {
            this.onAnswerSenderNameChangedImpl(sender_jid, question_id);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onAnswerSenderNameChangedImpl(String sender_jid, String question_id) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomQAUIListener l = (IZoomQAUIListener)lTmp;
                l.onAnswerSenderNameChanged(sender_jid, question_id);
            }
        }
    }

    protected void onReopenQuestion(String question_id) {
        try {
            this.onReopenQuestionImpl(question_id);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onReopenQuestionImpl(String question_id) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomQAUIListener l = (IZoomQAUIListener)lTmp;
                l.onReopenQuestion(question_id);
            }
        }
    }

    protected void onUpvoteQuestion(String question_id, boolean order_changed) {
        try {
            this.onUpvoteQuestionImpl(question_id, order_changed);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onUpvoteQuestionImpl(String question_id, boolean order_changed) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomQAUIListener l = (IZoomQAUIListener)lTmp;
                l.onUpvoteQuestion(question_id, order_changed);
            }
        }
    }

    protected void onRevokeUpvoteQuestion(String question_id, boolean order_changed) {
        try {
            this.onRevokeUpvoteQuestionImpl(question_id, order_changed);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onRevokeUpvoteQuestionImpl(String question_id, boolean order_changed) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IZoomQAUIListener l = (IZoomQAUIListener)lTmp;
                l.onRevokeUpvoteQuestion(question_id, order_changed);
            }
        }
    }

    private native long nativeInit();

    private native void nativeUninit(long var1);

    public static abstract class SimpleZoomQAUIListener
    implements IZoomQAUIListener {
        @Override
        public void notifyConnectStart() {
        }

        @Override
        public void notifyConnectResult(boolean bConnectSuccess) {
        }

        @Override
        public void onRefreshQAUI() {
        }

        @Override
        public void onAddQuestion(String questionID, boolean bSuccess) {
        }

        @Override
        public void onAddAnswer(String answerID, boolean bSuccess) {
        }

        @Override
        public void onReceiveQuestion(String questionID) {
        }

        @Override
        public void onReceiveAnswer(String answerID) {
        }

        @Override
        public void onQuestionMarkedAsAnswered(String questionID) {
        }

        @Override
        public void onUserComposing(String questionID) {
        }

        @Override
        public void onUserEndComposing(String questionID) {
        }

        @Override
        public void onUserLivingReply(String questionID) {
        }

        @Override
        public void onUserEndLiving(String questionID) {
        }

        @Override
        public void onUserListUpdated() {
        }

        @Override
        public void onUserListInitialized() {
        }

        @Override
        public void onUserAdded(String jid) {
        }

        @Override
        public void onUserRemoved(String jid) {
        }

        @Override
        public void onWebinarAttendeeRaisedHand(long nodeID) {
        }

        @Override
        public void onWebinarAttendeeLowerHand(long nodeID) {
        }

        @Override
        public void onChattedAttendeeUpdated(long nodeID) {
        }

        @Override
        public void onWebinarAttendeeGuestStatusChanged(long nodeID, boolean isGuest) {
        }

        @Override
        public void onQuestionMarkedAsDismissed(String question_id) {
        }

        @Override
        public void onAnswerSenderNameChanged(String sender_jid, String question_id) {
        }

        @Override
        public void onReopenQuestion(String question_id) {
        }

        @Override
        public void onUpvoteQuestion(String question_id, boolean order_changed) {
        }

        @Override
        public void onRevokeUpvoteQuestion(String question_id, boolean order_changed) {
        }
    }

    public static interface IZoomQAUIListener
    extends IListener {
        public void notifyConnectStart();

        public void notifyConnectResult(boolean var1);

        public void onRefreshQAUI();

        public void onAddQuestion(String var1, boolean var2);

        public void onAddAnswer(String var1, boolean var2);

        public void onReceiveQuestion(String var1);

        public void onReceiveAnswer(String var1);

        public void onQuestionMarkedAsAnswered(String var1);

        public void onUserComposing(String var1);

        public void onUserEndComposing(String var1);

        public void onUserLivingReply(String var1);

        public void onUserEndLiving(String var1);

        public void onUserListUpdated();

        public void onUserListInitialized();

        public void onUserAdded(String var1);

        public void onUserRemoved(String var1);

        public void onWebinarAttendeeRaisedHand(long var1);

        public void onWebinarAttendeeLowerHand(long var1);

        public void onChattedAttendeeUpdated(long var1);

        public void onWebinarAttendeeGuestStatusChanged(long var1, boolean var3);

        public void onAnswerSenderNameChanged(String var1, String var2);

        public void onQuestionMarkedAsDismissed(String var1);

        public void onReopenQuestion(String var1);

        public void onUpvoteQuestion(String var1, boolean var2);

        public void onRevokeUpvoteQuestion(String var1, boolean var2);
    }
}

