/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.confapp.qa;

import com.zipow.videobox.confapp.qa.ZoomQAAnswer;
import com.zipow.videobox.confapp.qa.ZoomQABuddy;
import com.zipow.videobox.confapp.qa.ZoomQAQuestion;
import com.zipow.videobox.confapp.qa.ZoomQAUI;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.StringUtil;

public class ZoomQAComponent {
    private long mNativeHandle = 0L;

    public ZoomQAComponent(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    public void setZoomQAUI(ZoomQAUI qaUI) {
        if (this.mNativeHandle == 0L) {
            return;
        }
        long uiHandle = 0L;
        if (qaUI != null) {
            uiHandle = qaUI.getNativeHandle();
        }
        this.setZoomQAUIImpl(this.mNativeHandle, uiHandle);
    }

    public String getMyJID() {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getMyJIDImpl(this.mNativeHandle);
    }

    public int getQuestionCount() {
        if (this.mNativeHandle == 0L) {
            return 0;
        }
        return this.getQuestionCountImpl(this.mNativeHandle);
    }

    public ZoomQAQuestion getQuestionAt(int index) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        long handle = this.getQuestionAtImpl(this.mNativeHandle, index);
        if (handle == 0L) {
            return null;
        }
        return new ZoomQAQuestion(handle);
    }

    public int getMyQuestionCount() {
        if (this.mNativeHandle == 0L) {
            return 0;
        }
        return this.getMyQuestionCountImpl(this.mNativeHandle);
    }

    public ZoomQAQuestion getMyQuestionAt(int index) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        long handle = this.getMyQuestionAtImpl(this.mNativeHandle, index);
        if (handle == 0L) {
            return null;
        }
        return new ZoomQAQuestion(handle);
    }

    public ZoomQAQuestion getQuestionByID(String id2) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        if (id2 == null) {
            return null;
        }
        long handle = this.getQuestionByIDImpl(this.mNativeHandle, id2);
        if (handle == 0L) {
            return null;
        }
        return new ZoomQAQuestion(handle);
    }

    public ZoomQAAnswer getAnswerByID(String id2) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        if (id2 == null) {
            return null;
        }
        long handle = this.getAnswerByIDImpl(this.mNativeHandle, id2);
        if (handle == 0L) {
            return null;
        }
        return new ZoomQAAnswer(handle);
    }

    public String addQuestion(String text, String destJID, boolean bAnonymously) {
        String msgId;
        if (this.mNativeHandle == 0L) {
            return null;
        }
        if (text == null) {
            return null;
        }
        if (destJID == null) {
            destJID = "";
        }
        if (StringUtil.isEmptyOrNull((String)(msgId = this.addQuestionImpl(this.mNativeHandle, text, destJID, bAnonymously)))) {
            return null;
        }
        return msgId;
    }

    public String addAnswer(String questionID, String text, String destJID) {
        String msgId;
        if (this.mNativeHandle == 0L) {
            return null;
        }
        if (questionID == null || text == null) {
            return null;
        }
        if (destJID == null) {
            destJID = "";
        }
        if (StringUtil.isEmptyOrNull((String)(msgId = this.addAnswerImpl(this.mNativeHandle, questionID, text, destJID)))) {
            return null;
        }
        return msgId;
    }

    public boolean resendMessage(String msgID) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (msgID == null) {
            return false;
        }
        return this.resendMessageImpl(this.mNativeHandle, msgID);
    }

    public boolean markQuestionAsAnswered(String msgID) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (msgID == null) {
            return false;
        }
        return this.markQuestionAsAnsweredImpl(this.mNativeHandle, msgID);
    }

    public boolean startComposing(String questionId) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (questionId == null) {
            return false;
        }
        return this.startComposingImpl(this.mNativeHandle, questionId);
    }

    public boolean endComposing(String questionId) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (questionId == null) {
            return false;
        }
        return this.endComposingImpl(this.mNativeHandle, questionId);
    }

    public boolean startLiving(String questionId) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (questionId == null) {
            return false;
        }
        return this.startLivingImpl(this.mNativeHandle, questionId);
    }

    public boolean endLiving(String questionId) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (questionId == null) {
            return false;
        }
        return this.endLivingImpl(this.mNativeHandle, questionId);
    }

    public boolean isWebinarAttendee() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.isWebinarAttendeeImpl(this.mNativeHandle);
    }

    public boolean isWebinarPanelist() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.isWebinarPanelistImpl(this.mNativeHandle);
    }

    public boolean isWebinarHost() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.isWebinarHostImpl(this.mNativeHandle);
    }

    public int getOpenQuestionCount() {
        if (this.mNativeHandle == 0L) {
            return 0;
        }
        return this.getOpenQuestionCountImpl(this.mNativeHandle);
    }

    public ZoomQAQuestion getOpenQuestionAt(int index) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        long handle = this.getOpenQuestionAtImpl(this.mNativeHandle, index);
        if (handle == 0L) {
            return null;
        }
        return new ZoomQAQuestion(handle);
    }

    public int getAnsweredQuestionCount() {
        if (this.mNativeHandle == 0L) {
            return 0;
        }
        return this.getAnsweredQuestionCountImpl(this.mNativeHandle);
    }

    public ZoomQAQuestion getAnsweredQuestionAt(int index) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        long handle = this.getAnsweredQuestionAtImpl(this.mNativeHandle, index);
        if (handle == 0L) {
            return null;
        }
        return new ZoomQAQuestion(handle);
    }

    public String getUserNameByJID(String jid) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        if (jid == null) {
            return null;
        }
        return this.getUserNameByJIDImpl(this.mNativeHandle, jid);
    }

    public long getUserNodeIDByJID(String jid) {
        if (this.mNativeHandle == 0L) {
            return 0L;
        }
        if (jid == null) {
            return 0L;
        }
        return this.getUserNodeIDByJIDImpl(this.mNativeHandle, jid);
    }

    public String getUserJIDByNodeID(long nodeId) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        return this.getUserJIDByNodeIDImpl(this.mNativeHandle, nodeId);
    }

    public boolean isJIDMyself(String jid) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (jid == null) {
            return false;
        }
        return this.isJIDMyselfImpl(this.mNativeHandle, jid);
    }

    public boolean isStreamConflict() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.isStreamConflictImpl(this.mNativeHandle);
    }

    public int getBuddyCount() {
        if (this.mNativeHandle == 0L) {
            return 0;
        }
        return this.getBuddyCountImpl(this.mNativeHandle);
    }

    public ZoomQABuddy getBuddyAt(int index) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        long handle = this.getBuddyAtImpl(this.mNativeHandle, index);
        if (handle == 0L) {
            return null;
        }
        return new ZoomQABuddy(handle);
    }

    public ZoomQABuddy getBuddyByID(String jid) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        long handle = this.getBuddyByIDImpl(this.mNativeHandle, jid);
        if (handle == 0L) {
            return null;
        }
        return new ZoomQABuddy(handle);
    }

    public ZoomQABuddy getBuddyByNodeID(long nodeId) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        long handle = this.getBuddyByNodeIDImpl(this.mNativeHandle, nodeId);
        if (handle == 0L) {
            return null;
        }
        return new ZoomQABuddy(handle);
    }

    public boolean isConnected() {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        return this.isConnectedImpl(this.mNativeHandle);
    }

    public List<ZoomQABuddy> getBuddyListByNameFilter(String filter) {
        long[] arrBuddies;
        if (this.mNativeHandle == 0L) {
            return null;
        }
        if (filter == null) {
            filter = "";
        }
        if ((arrBuddies = this.getBuddyListByNameFilterImpl(this.mNativeHandle, filter)) == null) {
            return null;
        }
        int size = arrBuddies.length;
        if (size == 0) {
            return null;
        }
        ArrayList<ZoomQABuddy> buddies = new ArrayList<ZoomQABuddy>();
        for (int i = 0; i < size; ++i) {
            long handle = arrBuddies[i];
            if (handle == 0L) continue;
            ZoomQABuddy buddy = new ZoomQABuddy(handle);
            buddies.add(buddy);
        }
        return buddies;
    }

    public boolean reopenQuestion(String questionId) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)questionId)) {
            return false;
        }
        return this.reopenQuestionImpl(this.mNativeHandle, questionId);
    }

    public boolean upvoteQuestion(String questionId) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)questionId)) {
            return false;
        }
        return this.upvoteQuestionImpl(this.mNativeHandle, questionId);
    }

    public boolean revokeUpvoteQuestion(String questionId) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (StringUtil.isEmptyOrNull((String)questionId)) {
            return false;
        }
        return this.revokeUpvoteQuestionImpl(this.mNativeHandle, questionId);
    }

    public boolean dismissQuestion(String questionId) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (questionId == null) {
            return false;
        }
        return this.dismissQuestionImpl(this.mNativeHandle, questionId);
    }

    public int getDismissedQuestionCount() {
        if (this.mNativeHandle == 0L) {
            return 0;
        }
        return this.getDismissedQuestionCountImpl(this.mNativeHandle);
    }

    public ZoomQAQuestion getDismissedQuestionAt(int index) {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        long handle = this.getDismissedQuestionAtImpl(this.mNativeHandle, index);
        if (handle == 0L) {
            return null;
        }
        return new ZoomQAQuestion(handle);
    }

    private native void setZoomQAUIImpl(long var1, long var3);

    private native String getMyJIDImpl(long var1);

    private native int getQuestionCountImpl(long var1);

    private native long getQuestionAtImpl(long var1, int var3);

    private native long getQuestionByIDImpl(long var1, String var3);

    private native long getAnswerByIDImpl(long var1, String var3);

    private native String addQuestionImpl(long var1, String var3, String var4, boolean var5);

    private native String addAnswerImpl(long var1, String var3, String var4, String var5);

    private native boolean resendMessageImpl(long var1, String var3);

    private native boolean markQuestionAsAnsweredImpl(long var1, String var3);

    private native boolean startComposingImpl(long var1, String var3);

    private native boolean endComposingImpl(long var1, String var3);

    private native boolean startLivingImpl(long var1, String var3);

    private native boolean endLivingImpl(long var1, String var3);

    private native boolean isWebinarAttendeeImpl(long var1);

    private native boolean isWebinarPanelistImpl(long var1);

    private native boolean isWebinarHostImpl(long var1);

    private native int getOpenQuestionCountImpl(long var1);

    private native long getOpenQuestionAtImpl(long var1, int var3);

    private native int getAnsweredQuestionCountImpl(long var1);

    private native long getAnsweredQuestionAtImpl(long var1, int var3);

    private native String getUserNameByJIDImpl(long var1, String var3);

    private native long getUserNodeIDByJIDImpl(long var1, String var3);

    private native boolean isJIDMyselfImpl(long var1, String var3);

    private native boolean isStreamConflictImpl(long var1);

    private native int getBuddyCountImpl(long var1);

    private native long getBuddyAtImpl(long var1, int var3);

    private native long getBuddyByIDImpl(long var1, String var3);

    private native String getUserJIDByNodeIDImpl(long var1, long var3);

    private native long getBuddyByNodeIDImpl(long var1, long var3);

    private native boolean isConnectedImpl(long var1);

    private native long[] getBuddyListByNameFilterImpl(long var1, String var3);

    private native boolean dismissQuestionImpl(long var1, String var3);

    private native boolean reopenQuestionImpl(long var1, String var3);

    private native boolean upvoteQuestionImpl(long var1, String var3);

    private native boolean revokeUpvoteQuestionImpl(long var1, String var3);

    private native int getDismissedQuestionCountImpl(long var1);

    private native long getDismissedQuestionAtImpl(long var1, int var3);

    private native int getMyQuestionCountImpl(long var1);

    private native long getMyQuestionAtImpl(long var1, int var3);
}

