/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.confapp.poll;

import com.zipow.videobox.confapp.poll.PollingDoc;
import com.zipow.videobox.confapp.poll.PollingUI;
import com.zipow.videobox.poll.AbsPollingMgr;
import com.zipow.videobox.poll.IPollingDoc;
import com.zipow.videobox.poll.PollingRole;

public class PollingMgr
extends AbsPollingMgr {
    private long mNativeHandle = 0L;
    private PollingUI.IPollingUIListener mUIListener = new PollingUI.SimplePollingUIListener(){

        @Override
        public void onPollingActionResult(int cmd, String strPID, int ret) {
            PollingMgr.this.processPollingActionResult(cmd, strPID, ret);
        }

        @Override
        public void onPollingStatusChanged(int pollstate, String strPID) {
            PollingMgr.this.processPollingStatusChanged(pollstate, strPID);
        }
    };

    public PollingMgr(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    public void setPollingUI(PollingUI ui) {
        if (this.mNativeHandle == 0L) {
            return;
        }
        if (ui == null) {
            return;
        }
        this.setPollingUIImpl(this.mNativeHandle, ui.getNativeHandle());
        ui.addListener(this.mUIListener);
    }

    @Override
    public int getPollingCount() {
        return this.getPollingCountImpl(this.mNativeHandle);
    }

    @Override
    public IPollingDoc getPollingAtIdx(int index) {
        if (index < 0) {
            return null;
        }
        long handle = this.getPollingAtIdxImpl(this.mNativeHandle, index);
        if (handle == 0L) {
            return null;
        }
        return new PollingDoc(handle);
    }

    @Override
    public IPollingDoc getPollingDocById(String id2) {
        if (id2 == null) {
            return null;
        }
        long handle = this.getPollingDocByIdImpl(this.mNativeHandle, id2);
        if (handle == 0L) {
            return null;
        }
        return new PollingDoc(handle);
    }

    @Override
    public boolean submitPoll(String id2) {
        if (id2 == null) {
            return false;
        }
        return this.submitPollImpl(this.mNativeHandle, id2);
    }

    @Override
    public PollingRole getPollingRole() {
        if (this.isAttendeeofPolling()) {
            return PollingRole.Attendee;
        }
        if (this.isHostofPolling()) {
            return PollingRole.Host;
        }
        return PollingRole.Panelist;
    }

    private void processPollingActionResult(int cmd, String strPID, int ret) {
        if (cmd == 3) {
            this.notifySubmitResult(strPID, ret);
        }
    }

    private void processPollingStatusChanged(int status, String pid) {
        this.notifyPollingStatusChanged(pid, status);
    }

    public boolean isHostofPolling() {
        return this.isHostofPollingImpl(this.mNativeHandle);
    }

    public boolean isPanelistofPolling() {
        return this.isPanelistofPollingImpl(this.mNativeHandle);
    }

    public boolean isAttendeeofPolling() {
        return this.isAttendeeofPollingImpl(this.mNativeHandle);
    }

    private native void setPollingUIImpl(long var1, long var3);

    private native int getPollingCountImpl(long var1);

    private native long getPollingAtIdxImpl(long var1, int var3);

    private native long getPollingDocByIdImpl(long var1, String var3);

    private native boolean submitPollImpl(long var1, String var3);

    private native boolean isHostofPollingImpl(long var1);

    private native boolean isPanelistofPollingImpl(long var1);

    private native boolean isAttendeeofPollingImpl(long var1);
}

