/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.confapp.bo;

import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.confapp.bo.BOMgr;
import com.zipow.videobox.confapp.bo.BOObject;
import com.zipow.videobox.confapp.bo.BOUpdatedUser;
import java.util.List;
import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;

public class BOUI {
    private static final String TAG = BOUI.class.getSimpleName();
    private BOMgr mBoMgr = null;
    private long mNativeHandle = 0L;
    private static BOUI instance = null;
    private ListenerList mListenerList = new ListenerList();

    private BOUI() {
        this.init();
    }

    private boolean initialized() {
        return this.mNativeHandle != 0L;
    }

    private void init() {
        this.mBoMgr = ConfMgr.getInstance().getBOMgr();
        if (this.mBoMgr == null) {
            return;
        }
        try {
            this.mNativeHandle = this.nativeInitImpl(this.mBoMgr.getNativeHandle());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static BOUI getInstance() {
        if (instance == null) {
            instance = new BOUI();
        }
        if (!instance.initialized()) {
            instance.init();
        }
        return instance;
    }

    public static void clearInstance() {
        instance = null;
    }

    protected void finalize() throws Throwable {
        if (this.mNativeHandle != 0L && this.mBoMgr != null) {
            this.nativeUninitImpl(this.mBoMgr.getNativeHandle(), this.mNativeHandle);
        }
        super.finalize();
    }

    public void addListener(IBOUIListener l) {
        if (l == null) {
            return;
        }
        IListener[] listeners = this.mListenerList.getAll();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != l) continue;
            this.removeListener((IBOUIListener)listeners[i]);
        }
        this.mListenerList.add((IListener)l);
    }

    public void removeListener(IBOUIListener l) {
        this.mListenerList.remove((IListener)l);
    }

    protected void onBOUserUpdated(long boObjectHandle, List<BOUpdatedUser> updatedUserList) {
        try {
            this.onBOUserUpdatedImpl(boObjectHandle, updatedUserList);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onBOUserUpdatedImpl(long boObjectHandle, List<BOUpdatedUser> updatedUserList) {
        if (boObjectHandle == 0L) {
            return;
        }
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners == null) {
            return;
        }
        BOObject object = new BOObject(boObjectHandle);
        for (IListener lTmp : listeners) {
            IBOUIListener l = (IBOUIListener)lTmp;
            l.onBOUserUpdated(object, updatedUserList);
        }
    }

    protected void onMasterConfUserListUpdated(List<String> addedUsers, List<String> removedUsers, List<String> modifiedUsers) {
        try {
            this.onMasterConfUserListUpdatedImpl(addedUsers, removedUsers, modifiedUsers);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onMasterConfUserListUpdatedImpl(List<String> addedUsers, List<String> removedUsers, List<String> modifiedUsers) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners == null) {
            return;
        }
        for (IListener lTmp : listeners) {
            IBOUIListener l = (IBOUIListener)lTmp;
            l.onMasterConfUserListUpdated(addedUsers, removedUsers, modifiedUsers);
        }
    }

    protected void onMasterConfHostChanged(String hostGUID, boolean gotHost) {
        try {
            this.onMasterConfHostChangedImpl(hostGUID, gotHost);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onMasterConfHostChangedImpl(String hostGUID, boolean gotHost) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners == null) {
            return;
        }
        for (IListener lTmp : listeners) {
            IBOUIListener l = (IBOUIListener)lTmp;
            l.onMasterConfHostChanged(hostGUID, gotHost);
        }
    }

    protected void onBOControlStatusChanged(int status) {
        try {
            this.onBOControlStatusChangedImpl(status);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onBOControlStatusChangedImpl(int status) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners == null) {
            return;
        }
        for (IListener lTmp : listeners) {
            IBOUIListener l = (IBOUIListener)lTmp;
            l.onBOControlStatusChanged(status);
        }
    }

    protected void onBOTokenReady() {
        try {
            this.onBOTokenReadyImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onBOTokenReadyImpl() {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners == null) {
            return;
        }
        for (IListener lTmp : listeners) {
            IBOUIListener l = (IBOUIListener)lTmp;
            l.onBOTokenReady();
        }
    }

    protected void onBOStoppingTick(int leftSeconds) {
        try {
            this.onBOStoppingTickImpl(leftSeconds);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onBOStoppingTickImpl(int leftSeconds) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners == null) {
            return;
        }
        for (IListener lTmp : listeners) {
            IBOUIListener l = (IBOUIListener)lTmp;
            l.onBOStoppingTick(leftSeconds);
        }
    }

    protected void onHelpRequestReceived(String userGUID) {
        try {
            this.onHelpRequestReceivedImpl(userGUID);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onHelpRequestReceivedImpl(String userGUID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners == null) {
            return;
        }
        for (IListener lTmp : listeners) {
            IBOUIListener l = (IBOUIListener)lTmp;
            l.onHelpRequestReceived(userGUID);
        }
    }

    protected void onBOStartRequestReceived(long boObjectHandle) {
        try {
            this.onBOStartRequestReceivedImpl(boObjectHandle);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onBOStartRequestReceivedImpl(long boObjectHandle) {
        if (ConfUI.getInstance().inSilentMode()) {
            return;
        }
        if (boObjectHandle == 0L) {
            return;
        }
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners == null) {
            return;
        }
        BOObject boObject = new BOObject(boObjectHandle);
        for (IListener lTmp : listeners) {
            IBOUIListener l = (IBOUIListener)lTmp;
            l.onBOStartRequestReceived(boObject);
        }
    }

    protected void onBOStopRequestReceived(int waitSeconds) {
        try {
            this.onBOStopRequestReceivedImpl(waitSeconds);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onBOStopRequestReceivedImpl(int waitSeconds) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners == null) {
            return;
        }
        for (IListener lTmp : listeners) {
            IBOUIListener l = (IBOUIListener)lTmp;
            l.onBOStopRequestReceived(waitSeconds);
        }
    }

    protected void onHelpRequestHandleResultReceived(int result) {
        try {
            this.onHelpRequestHandleResultReceivedImpl(result);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onHelpRequestHandleResultReceivedImpl(int result) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners == null) {
            return;
        }
        for (IListener lTmp : listeners) {
            IBOUIListener l = (IBOUIListener)lTmp;
            l.onHelpRequestHandleResultReceived(result);
        }
    }

    protected void OnBONewBroadcastMessageReceived(String message, long senderId) {
        try {
            this.onBONewBroadcastMessageReceivedImpl(message, senderId);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onBONewBroadcastMessageReceivedImpl(String message, long senderId) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners == null) {
            return;
        }
        for (IListener lTmp : listeners) {
            IBOUIListener l = (IBOUIListener)lTmp;
            l.OnBONewBroadcastMessageReceived(message, senderId);
        }
    }

    protected void onBOSwitchRequestReceived(long boObjectHandle) {
        try {
            this.onBOSwitchRequestReceivedImpl(boObjectHandle);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onBOSwitchRequestReceivedImpl(long boObjectHandle) {
        if (boObjectHandle == 0L) {
            return;
        }
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners == null) {
            return;
        }
        BOObject boObject = new BOObject(boObjectHandle);
        for (IListener lTmp : listeners) {
            IBOUIListener l = (IBOUIListener)lTmp;
            l.onBOSwitchRequestReceived(boObject);
        }
    }

    private native long nativeInitImpl(long var1);

    private native void nativeUninitImpl(long var1, long var3);

    public static abstract class SimpleBOUIListener
    implements IBOUIListener {
        @Override
        public void onBOUserUpdated(BOObject boObject, List<BOUpdatedUser> updatedUserList) {
        }

        @Override
        public void onMasterConfUserListUpdated(List<String> addedUsers, List<String> removedUsers, List<String> modifiedUsers) {
        }

        @Override
        public void onMasterConfHostChanged(String hostGUID, boolean gotHost) {
        }

        @Override
        public void onBOControlStatusChanged(int status) {
        }

        @Override
        public void onBOTokenReady() {
        }

        @Override
        public void onBOStoppingTick(int leftSeconds) {
        }

        @Override
        public void onHelpRequestReceived(String userGUID) {
        }

        @Override
        public void onBOStartRequestReceived(BOObject Object2) {
        }

        @Override
        public void onBOStopRequestReceived(int waitSeconds) {
        }

        @Override
        public void onHelpRequestHandleResultReceived(int result) {
        }

        @Override
        public void OnBONewBroadcastMessageReceived(String message, long senderId) {
        }

        @Override
        public void onBOSwitchRequestReceived(BOObject object) {
        }
    }

    public static interface IBOUIListener
    extends IListener {
        public void onBOUserUpdated(BOObject var1, List<BOUpdatedUser> var2);

        public void onMasterConfUserListUpdated(List<String> var1, List<String> var2, List<String> var3);

        public void onMasterConfHostChanged(String var1, boolean var2);

        public void onBOControlStatusChanged(int var1);

        public void onBOTokenReady();

        public void onBOStoppingTick(int var1);

        public void onHelpRequestReceived(String var1);

        public void onBOStartRequestReceived(BOObject var1);

        public void onBOStopRequestReceived(int var1);

        public void onHelpRequestHandleResultReceived(int var1);

        public void OnBONewBroadcastMessageReceived(String var1, long var2);

        public void onBOSwitchRequestReceived(BOObject var1);
    }
}

