/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.confapp.bo;

import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.provider.Settings;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.TextView;
import com.zipow.videobox.VideoBoxApplication;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.videomeetings.R;

public class BOStatusChangeMgrOnPT {
    private static final String TAG = BOStatusChangeMgrOnPT.class.getSimpleName();
    private final Context mContext;
    private final WindowManager mWindowManager;
    private View mStatusChangeView;
    private ImageView mJoiningIcon;
    private ImageView mLeavingIcon;
    private ImageView mWaitingAnimation;
    private TextView mJoningPrompt;
    private TextView mLeavingPrompt;
    private boolean mbAddedView = false;
    private Handler mHandler;
    private static BOStatusChangeMgrOnPT instance = null;
    private Runnable mForceHideRunnable = new Runnable(){

        @Override
        public void run() {
            BOStatusChangeMgrOnPT.this.hideStatusChangeUI();
        }
    };

    public static BOStatusChangeMgrOnPT getInstance() {
        if (instance == null) {
            instance = new BOStatusChangeMgrOnPT();
        }
        return instance;
    }

    public BOStatusChangeMgrOnPT() {
        this.mHandler = new Handler();
        this.mContext = VideoBoxApplication.getInstance();
        this.mWindowManager = (WindowManager)this.mContext.getSystemService("window");
    }

    private void init() {
        this.mStatusChangeView = View.inflate((Context)this.mContext, (int)R.layout.zm_bo_status_change, null);
        this.mJoiningIcon = (ImageView)this.mStatusChangeView.findViewById(R.id.joiningImage);
        this.mLeavingIcon = (ImageView)this.mStatusChangeView.findViewById(R.id.leavingImage);
        this.mWaitingAnimation = (ImageView)this.mStatusChangeView.findViewById(R.id.waitingAnimation);
        this.mJoningPrompt = (TextView)this.mStatusChangeView.findViewById(R.id.txtJoiningPrompt);
        this.mLeavingPrompt = (TextView)this.mStatusChangeView.findViewById(R.id.txtLeavingPrompt);
        this.mWaitingAnimation.setImageResource(R.anim.zm_bo_connecting);
    }

    private void release() {
        this.mStatusChangeView = null;
        this.mJoiningIcon = null;
        this.mLeavingIcon = null;
        this.mWaitingAnimation = null;
        this.mJoningPrompt = null;
        this.mLeavingPrompt = null;
    }

    private WindowManager.LayoutParams getLayoutParams() {
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
        lp.type = Build.VERSION.SDK_INT >= 25 && Settings.canDrawOverlays((Context)this.mContext) ? CompatUtils.getSystemAlertWindowType((int)2003) : CompatUtils.getSystemAlertWindowType((int)2005);
        lp.flags |= 0x108;
        lp.format = 1;
        lp.height = -1;
        lp.width = -1;
        lp.gravity = 17;
        return lp;
    }

    public void handleStatusChangeStart(boolean join, int joinReason, String boMeetingName) {
        this.showStatusChangeUI(join, joinReason, boMeetingName);
    }

    public void handleStatusChangeCompeleted() {
        this.hideStatusChangeUI();
    }

    private void showStatusChangeUI(boolean join, int joinReason, String boMeetingName) {
        if (this.mWindowManager == null) {
            return;
        }
        if (this.mbAddedView) {
            return;
        }
        this.init();
        try {
            this.mWindowManager.addView(this.mStatusChangeView, (ViewGroup.LayoutParams)this.getLayoutParams());
        }
        catch (Exception e) {
            return;
        }
        this.mbAddedView = true;
        if (join) {
            this.mJoiningIcon.setVisibility(0);
            this.mJoningPrompt.setVisibility(0);
            this.mLeavingIcon.setVisibility(8);
            this.mLeavingPrompt.setVisibility(8);
            if (joinReason == 1) {
                String joinPromt = this.mContext.getString(R.string.zm_bo_lbl_join_by_host_prompt, new Object[]{boMeetingName});
                this.mJoningPrompt.setText((CharSequence)joinPromt);
            } else {
                String joinPromt = this.mContext.getString(R.string.zm_bo_lbl_joining_prompt, new Object[]{boMeetingName});
                this.mJoningPrompt.setText((CharSequence)joinPromt);
            }
        } else {
            this.mJoiningIcon.setVisibility(8);
            this.mJoningPrompt.setVisibility(8);
            this.mLeavingIcon.setVisibility(0);
            this.mLeavingPrompt.setVisibility(0);
        }
        this.mStatusChangeView.setVisibility(0);
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                Drawable drawable2 = BOStatusChangeMgrOnPT.this.mWaitingAnimation.getDrawable();
                if (drawable2 instanceof AnimationDrawable) {
                    ((AnimationDrawable)drawable2).start();
                }
            }
        });
        this.mHandler.postDelayed(this.mForceHideRunnable, 10000L);
    }

    private void hideStatusChangeUI() {
        if (this.mWindowManager == null || this.mStatusChangeView == null) {
            return;
        }
        if (this.mbAddedView) {
            this.mWindowManager.removeView(this.mStatusChangeView);
            this.mbAddedView = false;
        }
        this.mHandler.removeCallbacks(this.mForceHideRunnable);
        this.release();
    }
}

