/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.confapp.bo;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.FragmentManager;
import com.zipow.videobox.ConfActivityNormal;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class BOMeetingEndDialogFragment
extends ZMDialogFragment {
    private ConfActivityNormal mBOActivity;
    private Handler mBoHandler;
    private int mBOWaitSeconds;
    private boolean mAuto;
    private int mEndType;
    public static final int BO_END_TYPE_LEAVE = 0;
    public static final int BO_END_TYPE_CLOSE_IN_MASTER = 1;
    public static final int BO_END_TYPE_CLOSE_IN_BO = 0;
    private static final String BO_MEETING_END_WAIT_SECONDS = "bo_meeting_end_wait_seconds";
    private static final String BO_MEETING_END_AUTO = "bo_meeting_end_auto";
    private static final String BO_MEETING_END_TYPE = "bo_meeting_end_type";
    private Runnable mBOTimeoutRunnable = new Runnable(){

        @Override
        public void run() {
            if (BOMeetingEndDialogFragment.this.mBOWaitSeconds <= 0 || !BOMeetingEndDialogFragment.this.isAdded()) {
                BOMeetingEndDialogFragment.this.closeBO();
                return;
            }
            BOMeetingEndDialogFragment.this.updateLeftSecondsUI();
            if (BOMeetingEndDialogFragment.this.mAuto) {
                BOMeetingEndDialogFragment.this.mBOWaitSeconds--;
                BOMeetingEndDialogFragment.this.mBoHandler.postDelayed(BOMeetingEndDialogFragment.this.mBOTimeoutRunnable, 1000L);
            }
        }
    };

    public static void showDialogFragment(FragmentManager fm, int waitSeconds, boolean auto, int endType, String tag) {
        BOMeetingEndDialogFragment fragment = new BOMeetingEndDialogFragment();
        Bundle args = new Bundle();
        args.putInt(BO_MEETING_END_WAIT_SECONDS, waitSeconds);
        args.putBoolean(BO_MEETING_END_AUTO, auto);
        args.putInt(BO_MEETING_END_TYPE, endType);
        fragment.setArguments(args);
        fragment.show(fm, tag);
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Bundle args = this.getArguments();
        this.mBOWaitSeconds = args.getInt(BO_MEETING_END_WAIT_SECONDS, 30);
        this.mAuto = args.getBoolean(BO_MEETING_END_AUTO, true);
        this.mEndType = args.getInt(BO_MEETING_END_TYPE, 0);
        if (this.mAuto) {
            this.mBoHandler = new Handler();
            this.mBoHandler.postDelayed(this.mBOTimeoutRunnable, 1000L);
        }
        this.mBOActivity = (ConfActivityNormal)this.getActivity();
        ZMAlertDialog.Builder builder = new ZMAlertDialog.Builder((Context)this.getActivity()).setMessage(R.string.zm_bo_msg_close).setTitle(this.getTitleInfo());
        if (this.mEndType == 1) {
            builder.setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            });
        } else {
            builder.setNegativeButton(R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            }).setPositiveButton(R.string.zm_bo_btn_leave_now, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (BOMeetingEndDialogFragment.this.mBOActivity != null) {
                        BOMeetingEndDialogFragment.this.mBOActivity.leaveBO();
                    }
                }
            });
        }
        return builder.create();
    }

    public void onDestroyView() {
        this.mBOWaitSeconds = 0;
        if (this.mBoHandler != null && this.mBOTimeoutRunnable != null) {
            this.mBoHandler.removeCallbacks(this.mBOTimeoutRunnable);
        }
        super.onDestroyView();
    }

    public void updateWaitingSeconds(int leftSeconds) {
        if (leftSeconds <= 0) {
            this.closeBO();
            return;
        }
        this.mBOWaitSeconds = leftSeconds;
        this.updateLeftSecondsUI();
    }

    private void finish() {
        if (!this.isAdded()) {
            return;
        }
        this.dismiss();
    }

    private void closeBO() {
        if (this.mBOActivity != null) {
            this.mBOActivity.leaveBO();
        }
        this.finish();
    }

    private String getTitleInfo() {
        if (this.mBOActivity == null) {
            return "";
        }
        String msg = "";
        msg = this.mEndType == 0 ? this.mBOActivity.getResources().getString(R.string.zm_bo_title_close, new Object[]{this.mBOWaitSeconds}) : this.mBOActivity.getResources().getString(R.string.zm_bo_msg_end_all_bo, new Object[]{this.mBOWaitSeconds});
        return msg;
    }

    private void updateLeftSecondsUI() {
        if (this.mBOActivity == null) {
            return;
        }
        Dialog dialog = this.getDialog();
        if (dialog != null && dialog.isShowing()) {
            dialog.setTitle((CharSequence)this.getTitleInfo());
        }
    }
}

