/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.confapp;

import android.graphics.Bitmap;
import com.zipow.nydus.NydusUtil;
import com.zipow.nydus.VideoCapturer;
import com.zipow.nydus.VideoSize;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.GLButton;
import com.zipow.videobox.confapp.GLImage;
import com.zipow.videobox.confapp.MediaDevice;
import com.zipow.videobox.confapp.RendererUnitInfo;
import com.zipow.videobox.confapp.VideoUnit;
import com.zipow.videobox.sdk.SDKVideoUnit;
import java.util.List;
import us.zoom.androidlib.util.StringUtil;

public class VideoSessionMgr {
    private static final int CAMERA_FIRST = 0;
    private static final int CAMERA_SECOND = 1;
    private static final String TAG = VideoSessionMgr.class.getSimpleName();
    private long mNativeHandle = 0L;
    private boolean mIsPreviewing = false;
    private int mViewWidth = 0;
    private int mViewHeight = 0;
    private int mRotation = 0;
    private int mRotationBeforeVideoPaused = 0;
    private boolean mbHasSetDefaultDevice = false;

    public VideoSessionMgr(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
        VideoCapturer.getInstance().setListener(new VideoCapturer.Listener(){

            @Override
            public void onCaptureResumed() {
                VideoSessionMgr.this.rotateDevice(VideoSessionMgr.this.mRotation, 0L);
            }

            @Override
            public void onCapturePaused() {
            }
        });
    }

    public boolean isPreviewing() {
        return this.mIsPreviewing;
    }

    public boolean isVideoStarted() {
        return this.isSendingVideo();
    }

    public boolean startPreviewDevice(long renderInfo, String cameraID) {
        if (this.mNativeHandle == 0L || renderInfo == 0L) {
            return false;
        }
        if (cameraID == null) {
            return false;
        }
        if (this.mIsPreviewing) {
            return false;
        }
        this.setDefaultDevice(cameraID);
        this.mIsPreviewing = this.startPreviewDeviceImpl(this.mNativeHandle, renderInfo, String.valueOf(cameraID));
        if (this.mIsPreviewing) {
            this.rotateDevice(this.mRotation, renderInfo);
        }
        return this.mIsPreviewing;
    }

    private static boolean isInternalCameraId(String camId) {
        int id2 = -1;
        try {
            id2 = Integer.valueOf(camId);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return id2 > -1;
    }

    public String getDefaultCameraToUse() {
        List<MediaDevice> camList;
        String sCameraId = null;
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        int launchReason = 0;
        if (confContext != null) {
            launchReason = confContext.getLaunchReason();
        }
        if (launchReason == 6 || launchReason == 5 || launchReason == 10 || launchReason == 11) {
            sCameraId = this.getDefaultDevice();
            if (!StringUtil.isEmptyOrNull((String)sCameraId)) {
                // empty if block
            }
        } else {
            String lastId = this.getDefaultDevice();
            if (!VideoSessionMgr.isInternalCameraId(lastId)) {
                sCameraId = lastId;
            }
        }
        if (!StringUtil.isEmptyOrNull((String)sCameraId)) {
            camList = this.getCamList();
            if (camList != null && camList.size() > 0) {
                for (int i = 0; i < camList.size(); ++i) {
                    String id2;
                    MediaDevice device = camList.get(i);
                    if (device == null || !sCameraId.equals(id2 = device.getDeviceId())) continue;
                    return sCameraId;
                }
            }
            sCameraId = null;
        }
        if (NydusUtil.getNumberOfCameras() > 0) {
            int iCameraId = NydusUtil.getFrontCameraId();
            if (iCameraId < 0) {
                iCameraId = 0;
            }
            sCameraId = String.valueOf(iCameraId);
        } else {
            MediaDevice device;
            camList = this.getCamList();
            if (camList != null && camList.size() > 0 && (device = camList.get(0)) != null) {
                sCameraId = device.getDeviceId();
            }
        }
        return sCameraId;
    }

    public boolean stopPreviewDevice(long renderInfo) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (!this.mIsPreviewing) {
            return this.stopShowVideo(renderInfo);
        }
        boolean res = this.stopPreviewDeviceImpl(this.mNativeHandle, renderInfo);
        if (!res) {
            // empty if block
        }
        this.mIsPreviewing = false;
        return res;
    }

    public boolean startMyVideo(long renderInfo) {
        boolean started;
        String deviceId;
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (this.getNumberOfCameras() < 1) {
            return false;
        }
        if (this.isVideoStarted()) {
            return true;
        }
        if (!this.mbHasSetDefaultDevice && !StringUtil.isEmptyOrNull((String)(deviceId = this.getDefaultCameraToUse()))) {
            this.setDefaultDevice(deviceId);
        }
        if (started = this.startMyVideoImpl(this.mNativeHandle, renderInfo)) {
            this.rotateDevice(this.mRotation, 0L);
        }
        return started;
    }

    public boolean stopMyVideo(long renderInfo) {
        if (this.mNativeHandle == 0L) {
            return false;
        }
        if (!this.isVideoStarted()) {
            return false;
        }
        boolean res = this.stopMyVideoImpl(this.mNativeHandle, renderInfo);
        if (!res) {
            // empty if block
        }
        return res;
    }

    public boolean showAttendeeVideo(long renderInfo, long userId, int height, boolean isFloating) {
        if (this.mNativeHandle == 0L || renderInfo == 0L) {
            return false;
        }
        boolean res = this.showAttendeeVideoImpl(this.mNativeHandle, renderInfo, userId, height, isFloating);
        if (!res) {
            // empty if block
        }
        return res;
    }

    public boolean stopShowVideo(long renderInfo) {
        if (this.mNativeHandle == 0L || renderInfo == 0L) {
            return false;
        }
        boolean res = this.stopShowVideoImpl(this.mNativeHandle, renderInfo, false);
        if (!res) {
            // empty if block
        }
        return res;
    }

    public void setGLViewSize(int width, int height) {
        this.mViewWidth = width;
        this.mViewHeight = height;
    }

    public VideoUnit createVideoUnit(boolean isKeyUnit, RendererUnitInfo unitInfo) {
        VideoUnit unit = null;
        long renderInfo = this.createRendererInfo(this.mNativeHandle, isKeyUnit, 0, this.mViewWidth, this.mViewHeight, unitInfo.left, unitInfo.top, unitInfo.width, unitInfo.height);
        if (renderInfo != 0L) {
            boolean ret = this.prepareRenderer(this.mNativeHandle, renderInfo);
            if (ret) {
                unit = new VideoUnit(isKeyUnit, renderInfo, unitInfo);
            } else {
                this.destroyRendererInfo(this.mNativeHandle, renderInfo);
            }
        }
        return unit;
    }

    public void destroyVideoUnit(VideoUnit unit) {
        if (unit == null) {
            return;
        }
        long renderInfo = unit.getRendererInfo();
        this.destroyRenderer(this.mNativeHandle, renderInfo);
        this.destroyRendererInfo(this.mNativeHandle, renderInfo);
    }

    public SDKVideoUnit createVideoUnit(boolean isKeyUnit, int viewWidth, int viewHeight, RendererUnitInfo unitInfo, int groupIndex) {
        SDKVideoUnit unit = null;
        long renderInfo = this.createRendererInfo(this.mNativeHandle, isKeyUnit, groupIndex, viewWidth, viewHeight, unitInfo.left, unitInfo.top, unitInfo.width, unitInfo.height);
        if (renderInfo != 0L) {
            boolean ret = this.prepareRenderer(this.mNativeHandle, renderInfo);
            if (ret) {
                unit = new SDKVideoUnit(isKeyUnit, renderInfo, unitInfo);
            } else {
                this.destroyRendererInfo(this.mNativeHandle, renderInfo);
            }
        }
        return unit;
    }

    public void destroyVideoUnit(SDKVideoUnit unit) {
        if (unit == null) {
            return;
        }
        long renderInfo = unit.getRendererInfo();
        this.destroyRenderer(this.mNativeHandle, renderInfo);
        this.destroyRendererInfo(this.mNativeHandle, renderInfo);
    }

    public GLButton createGLButton(RendererUnitInfo unitInfo) {
        GLButton button = null;
        long renderInfo = this.createRendererInfo(this.mNativeHandle, false, 0, this.mViewWidth, this.mViewHeight, unitInfo.left, unitInfo.top, unitInfo.width, unitInfo.height);
        if (renderInfo != 0L) {
            boolean ret = this.prepareRenderer(this.mNativeHandle, renderInfo);
            if (ret) {
                button = new GLButton(renderInfo, unitInfo);
            } else {
                this.destroyRendererInfo(this.mNativeHandle, renderInfo);
            }
        }
        return button;
    }

    public void destroyGLButton(GLButton button) {
        if (button == null) {
            return;
        }
        long renderInfo = button.getRendererInfo();
        this.destroyRenderer(this.mNativeHandle, renderInfo);
        this.destroyRendererInfo(this.mNativeHandle, renderInfo);
    }

    public GLImage createGLImage(RendererUnitInfo unitInfo) {
        GLImage glImage = null;
        long renderInfo = this.createRendererInfo(this.mNativeHandle, false, 0, this.mViewWidth, this.mViewHeight, unitInfo.left, unitInfo.top, unitInfo.width, unitInfo.height);
        if (renderInfo != 0L) {
            boolean ret = this.prepareRenderer(this.mNativeHandle, renderInfo);
            if (ret) {
                glImage = new GLImage(renderInfo, unitInfo);
            } else {
                this.destroyRendererInfo(this.mNativeHandle, renderInfo);
            }
        }
        return glImage;
    }

    public void destroyGLImage(GLImage button) {
        if (button == null) {
            return;
        }
        long renderInfo = button.getRendererInfo();
        this.destroyRenderer(this.mNativeHandle, renderInfo);
        this.destroyRendererInfo(this.mNativeHandle, renderInfo);
    }

    public void updateUnitLayout(long renderInfo, RendererUnitInfo unit) {
        if (unit == null) {
            return;
        }
        this.updateRendererInfo(this.mNativeHandle, renderInfo, this.mViewWidth, this.mViewHeight, unit.left, unit.top, unit.width, unit.height);
    }

    public void updateUnitLayout(long renderInfo, int width, int height, RendererUnitInfo unit) {
        if (unit == null) {
            return;
        }
        this.updateRendererInfo(this.mNativeHandle, renderInfo, width, height, unit.left, unit.top, unit.width, unit.height);
    }

    public void drawFrame(long keyRenderInfo) {
        this.drawFrameImpl(this.mNativeHandle, keyRenderInfo);
    }

    public boolean enable180p(boolean enabled) {
        return this.enable180pImpl(this.mNativeHandle, enabled);
    }

    public boolean showActiveVideo(long renderInfo, long userId, int height) {
        return this.showActiveVideoImpl(this.mNativeHandle, renderInfo, userId, height);
    }

    public void setDefaultDevice(String cameraId) {
        if (StringUtil.isEmptyOrNull((String)cameraId)) {
            return;
        }
        int iCameraId = -1;
        try {
            iCameraId = Integer.parseInt(cameraId);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (iCameraId >= 0) {
            this.setDefaultDeviceImpl(this.mNativeHandle, cameraId, NydusUtil.isFrontCamera(iCameraId) && !NydusUtil.isCameraMirror(iCameraId));
        } else {
            this.setDefaultDeviceImpl(this.mNativeHandle, cameraId, true);
        }
        this.mbHasSetDefaultDevice = true;
    }

    public String getDefaultDevice() {
        return this.getDefaultDeviceImpl(this.mNativeHandle);
    }

    public boolean switchCamera(String cameraId) {
        if (this.getNumberOfCameras() <= 0) {
            return false;
        }
        if (StringUtil.isSameString((String)cameraId, (String)this.getDefaultDevice()) && this.isVideoStarted()) {
            return true;
        }
        if (this.isVideoStarted() && !this.stopMyVideo(0L)) {
            return false;
        }
        this.setDefaultDevice(cameraId);
        return this.startMyVideo(0L);
    }

    public List<MediaDevice> getCamList() {
        return this.getCamListImpl(this.mNativeHandle);
    }

    public int getNumberOfCameras() {
        return this.getNumberOfCamerasImpl(this.mNativeHandle);
    }

    public int getVideoTypeByID(long userId) {
        return this.getVideoTypeByIDImpl(this.mNativeHandle, userId);
    }

    public long addPic(long renderInfo, int index, Bitmap bmp, int alpha, int mask, int left, int top, int right, int bottom) {
        long startTime = System.currentTimeMillis();
        if (renderInfo == 0L) {
            return 0L;
        }
        if (bmp == null) {
            return 0L;
        }
        if (right < left || bottom < top) {
            return 0L;
        }
        int bmpWidth = bmp.getWidth();
        int bmpHeight = bmp.getHeight();
        int[] pixels = null;
        try {
            pixels = new int[bmpWidth * bmpHeight];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        if (pixels == null) {
            return 0L;
        }
        bmp.getPixels(pixels, 0, bmpWidth, 0, 0, bmpWidth, bmpHeight);
        long ret = this.addPicImpl(this.mNativeHandle, renderInfo, index, pixels, bmpWidth, bmpHeight, alpha, mask, left, top, right, bottom);
        return ret;
    }

    @Deprecated
    public long movePic(long renderInfo, int index, long dataHandle, int bmpWidth, int bmpHeight, int alpha, int mask, int left, int top, int right, int bottom) {
        if (renderInfo == 0L) {
            return 0L;
        }
        if (dataHandle <= 0L) {
            return 0L;
        }
        if (right < left || bottom < top) {
            return 0L;
        }
        return this.movePicImpl(this.mNativeHandle, renderInfo, index, dataHandle, bmpWidth, bmpHeight, alpha, mask, left, top, right, bottom);
    }

    public long movePic2(long renderInfo, int index, int left, int top, int right, int bottom) {
        if (renderInfo == 0L) {
            return 0L;
        }
        if (right < left || bottom < top) {
            return 0L;
        }
        return this.movePic2Impl(this.mNativeHandle, renderInfo, index, left, top, right, bottom);
    }

    public boolean removePic(long renderInfo, int index) {
        if (renderInfo == 0L) {
            return false;
        }
        return this.removePicImpl(this.mNativeHandle, renderInfo, index);
    }

    public void glViewSizeChanged(long renderInfo, int width, int height) {
        if (renderInfo == 0L) {
            return;
        }
        this.glViewSizeChangedImpl(this.mNativeHandle, renderInfo, width, height);
    }

    public void clearRenderer(long renderInfo) {
        if (renderInfo == 0L) {
            return;
        }
        this.clearRendererImpl(this.mNativeHandle, renderInfo);
    }

    public VideoSize getMyVideoSize() {
        VideoSize size = VideoCapturer.getInstance().getVideoSize();
        switch (this.mRotation) {
            case 0: 
            case 2: {
                break;
            }
            case 1: 
            case 3: {
                int tmp = size.width;
                size.width = size.height;
                size.height = tmp;
            }
        }
        return size;
    }

    public void setRendererBackgroudColor(long renderInfo, int color2) {
        this.setRendererBackgroudColorImpl(this.mNativeHandle, renderInfo, color2);
    }

    public boolean querySubStatus(long userId) {
        return this.querySubStatusImpl(this.mNativeHandle, userId);
    }

    public void onMyVideoStarted() {
        this.rotateDevice(this.mRotation, 0L);
    }

    public boolean rotateDevice(int action, long renderInfo) {
        this.mRotation = action;
        if (!VideoCapturer.getInstance().isCapturePaused()) {
            this.mRotationBeforeVideoPaused = action;
            return this.rotateDeviceImpl(this.mNativeHandle, action, renderInfo);
        }
        return this.rotateDeviceImpl(this.mNativeHandle, this.mRotationBeforeVideoPaused, renderInfo);
    }

    public boolean setAspectMode(long renderInfo, int aspectMode) {
        return this.setAspectModeImpl(this.mNativeHandle, renderInfo, aspectMode);
    }

    public boolean isSameVideo(long userId1, long userId2) {
        return this.isSameVideoImpl(this.mNativeHandle, userId1, userId2);
    }

    public boolean isSendingVideo() {
        return this.isSendingVideoImpl(this.mNativeHandle);
    }

    public boolean isLeadShipMode() {
        return this.isLeadShipModeImpl(this.mNativeHandle);
    }

    public boolean isLeaderofLeadMode(long userId) {
        return this.isLeaderofLeadModeImpl(this.mNativeHandle, userId);
    }

    public boolean setLeadShipMode(boolean on, long selectedUserId) {
        return this.setLeadShipModeImpl(this.mNativeHandle, on, selectedUserId);
    }

    public long getActiveUserID() {
        return this.getActiveUserIDImpl(this.mNativeHandle);
    }

    public long getActiveDeckUserID(boolean checkFreeway) {
        return this.getActiveDeckUserIDImpl(this.mNativeHandle, checkFreeway);
    }

    public boolean handleFECCCmd(int cmd, long userId) {
        return this.handleFECCCmd(cmd, userId, 0);
    }

    public boolean handleFECCCmd(int cmd, long userId, int action) {
        return this.handleFECCCmdImpl(this.mNativeHandle, cmd, userId, action);
    }

    public boolean canControlltheCam(long userId) {
        return this.iCanControlltheCamImpl(this.mNativeHandle, userId);
    }

    public boolean isControlMyCam(long userId) {
        return this.isControlMyCamImpl(this.mNativeHandle, userId);
    }

    public boolean isCamInControl(long userId) {
        return this.isCamInControlImpl(this.mNativeHandle, userId);
    }

    public boolean switchToNextCam() {
        MediaDevice device;
        String curCamId = this.getDefaultDevice();
        List<MediaDevice> devices = this.getCamList();
        if (devices == null || devices.size() == 0) {
            return false;
        }
        int i = 0;
        for (i = 0; i < devices.size() && !StringUtil.isSameString((String)(device = devices.get(i)).getDeviceId(), (String)curCamId); ++i) {
        }
        MediaDevice nextDevice = devices.get(i = (i + 1) % devices.size());
        if (nextDevice != null) {
            return this.switchCamera(nextDevice.getDeviceId());
        }
        return false;
    }

    public void turnKubiDeviceOnOFF(boolean on) {
        this.turnKubiDeviceOnOFFImpl(this.mNativeHandle, on);
    }

    public boolean isManualMode() {
        return this.isManualModeImpl(this.mNativeHandle);
    }

    public boolean setManualMode(boolean on, long userId) {
        return this.setManualModeImpl(this.mNativeHandle, on, userId);
    }

    public boolean isSelectedUser(long userId) {
        return this.isSelectedUserImpl(this.mNativeHandle, userId);
    }

    public long getSelectedUser() {
        return this.getSelectedUserImpl(this.mNativeHandle);
    }

    public void setMobileAppActiveStatus(boolean isActive) {
        this.setMobileAppActiveStatusImpl(this.mNativeHandle, isActive);
    }

    private native boolean startPreviewDeviceImpl(long var1, long var3, String var5);

    private native boolean stopPreviewDeviceImpl(long var1, long var3);

    private native boolean startMyVideoImpl(long var1, long var3);

    private native boolean stopMyVideoImpl(long var1, long var3);

    private native boolean enable180pImpl(long var1, boolean var3);

    private native boolean showActiveVideoImpl(long var1, long var3, long var5, int var7);

    private native long createRendererInfo(long var1, boolean var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    private native boolean updateRendererInfo(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10);

    private native boolean destroyRendererInfo(long var1, long var3);

    private native boolean drawFrameImpl(long var1, long var3);

    private native boolean prepareRenderer(long var1, long var3);

    private native boolean destroyRenderer(long var1, long var3);

    private native boolean showAttendeeVideoImpl(long var1, long var3, long var5, int var7, boolean var8);

    private native boolean stopShowVideoImpl(long var1, long var3, boolean var5);

    private native void setDefaultDeviceImpl(long var1, String var3, boolean var4);

    private native String getDefaultDeviceImpl(long var1);

    private native int getVideoTypeByIDImpl(long var1, long var3);

    private native long addPicImpl(long var1, long var3, int var5, int[] var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14);

    private native long movePicImpl(long var1, long var3, int var5, long var6, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15);

    private native long movePic2Impl(long var1, long var3, int var5, int var6, int var7, int var8, int var9);

    private native boolean removePicImpl(long var1, long var3, int var5);

    private native void glViewSizeChangedImpl(long var1, long var3, int var5, int var6);

    private native void clearRendererImpl(long var1, long var3);

    private native void setRendererBackgroudColorImpl(long var1, long var3, int var5);

    private native boolean querySubStatusImpl(long var1, long var3);

    private native boolean rotateDeviceImpl(long var1, int var3, long var4);

    private native boolean setAspectModeImpl(long var1, long var3, int var5);

    private native boolean isSameVideoImpl(long var1, long var3, long var5);

    private native boolean isSendingVideoImpl(long var1);

    private native boolean isLeadShipModeImpl(long var1);

    private native boolean isLeaderofLeadModeImpl(long var1, long var3);

    private native boolean setLeadShipModeImpl(long var1, boolean var3, long var4);

    private native long getActiveUserIDImpl(long var1);

    private native List<MediaDevice> getCamListImpl(long var1);

    private native int getNumberOfCamerasImpl(long var1);

    private native boolean handleFECCCmdImpl(long var1, int var3, long var4, int var6);

    private native boolean iCanControlltheCamImpl(long var1, long var3);

    private native boolean isControlMyCamImpl(long var1, long var3);

    private native boolean isCamInControlImpl(long var1, long var3);

    private native boolean switchToNextCamImpl(long var1);

    private native void turnKubiDeviceOnOFFImpl(long var1, boolean var3);

    private native boolean isManualModeImpl(long var1);

    private native boolean setManualModeImpl(long var1, boolean var3, long var4);

    private native boolean isSelectedUserImpl(long var1, long var3);

    private native long getSelectedUserImpl(long var1);

    private native void setMobileAppActiveStatusImpl(long var1, boolean var3);

    private native long getActiveDeckUserIDImpl(long var1, boolean var3);
}

