/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.confapp;

import android.graphics.Bitmap;
import com.zipow.nydus.VideoSize;
import com.zipow.videobox.confapp.RendererUnitInfo;
import com.zipow.videobox.confapp.ShareUnit;
import com.zipow.videobox.sdk.SDKShareUnit;
import java.nio.ByteBuffer;

public class ShareSessionMgr {
    private static final String TAG = ShareSessionMgr.class.getSimpleName();
    private long mNativeHandle = 0L;
    private int mViewWidth = 0;
    private int mViewHeight = 0;
    private boolean mIsConfCleaned = false;
    public static final Object SHARE_SESSION_LOCK = new Object();

    public ShareSessionMgr(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    public int getShareStatus() {
        return this.getShareStatusImpl(this.mNativeHandle);
    }

    public int getShareSettingType() {
        return this.getShareSettingTypeImpl(this.mNativeHandle);
    }

    public boolean presenterIsSharingAudio() {
        return this.presenterIsSharingAudioImpl(this.mNativeHandle);
    }

    public void setGLViewSize(int width, int height) {
        this.mViewWidth = width;
        this.mViewHeight = height;
    }

    public boolean startShare() {
        return this.startShareImpl(this.mNativeHandle);
    }

    public boolean setCaptureObject() {
        return this.setCaptureObjectImpl(this.mNativeHandle);
    }

    public boolean stopShare() {
        return this.stopShareImpl(this.mNativeHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setCaptureFrame(int width, int height, int stride, ByteBuffer pixels) {
        Object object = SHARE_SESSION_LOCK;
        synchronized (object) {
            if (this.mIsConfCleaned) {
                return false;
            }
            return this.setCaptureRawDataImpl(this.mNativeHandle, width, height, stride, pixels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setCaptureFrame(Bitmap bitmap) {
        Object object = SHARE_SESSION_LOCK;
        synchronized (object) {
            if (this.mIsConfCleaned) {
                return false;
            }
            return this.setCaptureBitmapDataImpl(this.mNativeHandle, bitmap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfCleaned(boolean isConfCleaned) {
        Object object = SHARE_SESSION_LOCK;
        synchronized (object) {
            this.mIsConfCleaned = isConfCleaned;
        }
    }

    public ShareUnit createShareUnit(RendererUnitInfo unitInfo) {
        ShareUnit unit = null;
        long renderInfo = this.createRendererInfo(this.mNativeHandle, false, 0, this.mViewWidth, this.mViewHeight, unitInfo.left, unitInfo.top, unitInfo.width, unitInfo.height);
        if (renderInfo != 0L) {
            boolean ret = this.prepareRenderer(this.mNativeHandle, renderInfo);
            if (ret) {
                unit = new ShareUnit(renderInfo, unitInfo);
            } else {
                this.destroyRendererInfo(this.mNativeHandle, renderInfo);
            }
        }
        return unit;
    }

    public SDKShareUnit createSDKShareUnit(int viewWidth, int viewHeight, RendererUnitInfo unitInfo, int groupIndex) {
        SDKShareUnit unit = null;
        long renderInfo = this.createRendererInfo(this.mNativeHandle, false, groupIndex, viewWidth, viewHeight, unitInfo.left, unitInfo.top, unitInfo.width, unitInfo.height);
        if (renderInfo != 0L) {
            boolean ret = this.prepareRenderer(this.mNativeHandle, renderInfo);
            if (ret) {
                unit = new SDKShareUnit(renderInfo, unitInfo);
            } else {
                this.destroyRendererInfo(this.mNativeHandle, renderInfo);
            }
        }
        return unit;
    }

    public void destroyShareUnit(ShareUnit unit) {
        if (unit == null) {
            return;
        }
        long renderInfo = unit.getRendererInfo();
        this.destroyRenderer(this.mNativeHandle, renderInfo);
        this.destroyRendererInfo(this.mNativeHandle, renderInfo);
    }

    public void destroySDKShareUnit(SDKShareUnit unit) {
        if (unit == null) {
            return;
        }
        long renderInfo = unit.getRendererInfo();
        this.destroyRenderer(this.mNativeHandle, renderInfo);
        this.destroyRendererInfo(this.mNativeHandle, renderInfo);
    }

    public void updateUnitLayout(long renderInfo, RendererUnitInfo unit) {
        if (unit == null) {
            return;
        }
        this.updateRendererInfo(this.mNativeHandle, renderInfo, this.mViewWidth, this.mViewHeight, unit.left, unit.top, unit.width, unit.height);
    }

    public void updateUnitLayout(long renderInfo, RendererUnitInfo unit, int viewWidth, int viewHeight) {
        if (unit == null) {
            return;
        }
        this.updateRendererInfo(this.mNativeHandle, renderInfo, viewWidth, viewHeight, unit.left, unit.top, unit.width, unit.height);
    }

    public long addPic(long renderInfo, int index, Bitmap bmp, int alpha, int mask, int left, int top, int right, int bottom) {
        if (renderInfo == 0L) {
            return 0L;
        }
        if (bmp == null) {
            return 0L;
        }
        if (right < left || bottom < top) {
            return 0L;
        }
        int bmpWidth = bmp.getWidth();
        int bmpHeight = bmp.getHeight();
        int[] pixels = new int[bmpWidth * bmpHeight];
        bmp.getPixels(pixels, 0, bmpWidth, 0, 0, bmpWidth, bmpHeight);
        return this.addPicImpl(this.mNativeHandle, renderInfo, index, pixels, bmpWidth, bmpHeight, alpha, mask, left, top, right, bottom);
    }

    public long movePic(long renderInfo, int index, long dataHandle, int bmpWidth, int bmpHeight, int alpha, int mask, int left, int top, int right, int bottom) {
        if (renderInfo == 0L) {
            return 0L;
        }
        if (dataHandle <= 0L) {
            return 0L;
        }
        if (right < left || bottom < top) {
            return 0L;
        }
        return this.movePicImpl(this.mNativeHandle, renderInfo, index, dataHandle, bmpWidth, bmpHeight, alpha, mask, left, top, right, bottom);
    }

    public long movePic2(long renderInfo, int index, int left, int top, int right, int bottom) {
        if (renderInfo == 0L) {
            return 0L;
        }
        if (right < left || bottom < top) {
            return 0L;
        }
        return this.movePic2Impl(this.mNativeHandle, renderInfo, index, left, top, right, bottom);
    }

    public boolean removePic(long renderInfo, int index) {
        if (renderInfo == 0L) {
            return false;
        }
        return this.removePicImpl(this.mNativeHandle, renderInfo, index);
    }

    public void glViewSizeChanged(long renderInfo, int width, int height) {
        if (renderInfo == 0L) {
            return;
        }
        this.glViewSizeChangedImpl(this.mNativeHandle, renderInfo, width, height);
    }

    public void destAreaChanged(long renderInfo, int left, int top, int scaleWidth, int scaleHeight) {
        if (renderInfo == 0L) {
            return;
        }
        this.destAreaChangedImpl(this.mNativeHandle, renderInfo, left, top, scaleWidth, scaleHeight);
    }

    public void clearRenderer(long renderInfo) {
        if (renderInfo == 0L) {
            return;
        }
        this.clearRendererImpl(this.mNativeHandle, renderInfo);
    }

    public boolean showShareContent(long renderInfo, long userId, boolean show) {
        return this.showShareContentImpl(this.mNativeHandle, renderInfo, userId, show);
    }

    public boolean stopViewShareContent(long renderInfo, boolean bCloseAnnotation) {
        return this.stopViewShareContentImpl(this.mNativeHandle, renderInfo, bCloseAnnotation);
    }

    public VideoSize getShareDataResolution(long userId) {
        long resolution = this.getShareDataResolutionImpl(this.mNativeHandle, userId);
        VideoSize size = new VideoSize();
        size.height = (int)(resolution >> 16 & 0xFFFFL);
        size.width = (int)(resolution & 0xFFFFL);
        return size;
    }

    public boolean setViewMode(int mode1, int mode2) {
        return this.setViewModeImpl(this.mNativeHandle, mode1, mode2);
    }

    public void setRendererBackgroudColor(long renderInfo, int color2) {
        this.setRendererBackgroudColorImpl(this.mNativeHandle, renderInfo, color2);
    }

    public boolean isVideoSharingInProgress() {
        return this.isVideoSharingInProgressImpl(this.mNativeHandle);
    }

    public void setShareEventSink(long shareEventSinkNativeHandle) {
        this.setShareEventSinkImpl(this.mNativeHandle, shareEventSinkNativeHandle);
    }

    public long getActiveUserID() {
        return this.getActiveUserIDImpl(this.mNativeHandle);
    }

    public boolean senderSupportAnnotation(long nShareSourceUserID) {
        return this.senderSupportAnnotationImpl(this.mNativeHandle, nShareSourceUserID);
    }

    public boolean isAttendeeAnnotationDisabledForMySharedContent() {
        return this.isAttendeeAnnotationDisabledForMySharedContentImpl(this.mNativeHandle);
    }

    public boolean DisableAttendeeAnnotationForMySharedContent(boolean bDisable) {
        return this.disableAttendeeAnnotationForMySharedContentImpl(this.mNativeHandle, bDisable);
    }

    public boolean hasRemoteControlPrivilegeWithUserId(long userID) {
        return this.hasRemoteControlPrivilegeWithUserIdImpl(this.mNativeHandle, userID);
    }

    public boolean isRemoteController(long userID) {
        return this.isRemoteControllerImpl(this.mNativeHandle, userID);
    }

    public boolean startRemoteControl() {
        return this.startRemoteControlImpl(this.mNativeHandle);
    }

    public boolean grabRemoteControl(long myID) {
        return this.grabRemoteControlImpl(this.mNativeHandle, myID);
    }

    public boolean remoteControlSingleTap(float x, float y) {
        return this.remoteControlSingleTapImpl(this.mNativeHandle, x, y);
    }

    public boolean remoteControlDoubleTap(float x, float y) {
        return this.remoteControlDoubleTapImpl(this.mNativeHandle, x, y);
    }

    public boolean remoteControlLongPress(float x, float y) {
        return this.remoteControlLongPressImpl(this.mNativeHandle, x, y);
    }

    public boolean remoteControlDoubleScroll(float x, float y) {
        return this.remoteControlDoubleScrollImpl(this.mNativeHandle, x, y);
    }

    public boolean remoteControlSingleMove(float x, float y) {
        return this.remoteControlSingleMoveImpl(this.mNativeHandle, x, y);
    }

    public boolean remoteControlCharInput(String str) {
        return this.remoteControlCharInputImpl(this.mNativeHandle, str);
    }

    public boolean remoteControlKeyInput(int keyType) {
        return this.remoteControlKeyInputImpl(this.mNativeHandle, keyType);
    }

    public boolean remoteControlMouseValidate(float x, float y) {
        return this.remoteControlMouseValidateImpl(this.mNativeHandle, x, y);
    }

    public boolean requestRemoteControl(long shareSourceUserID) {
        return this.requestRemoteControlImpl(this.mNativeHandle, shareSourceUserID);
    }

    public boolean giveupRemoteControl(long shareSourceUserID) {
        return this.giveupRemoteControlImpl(this.mNativeHandle, shareSourceUserID);
    }

    public void declineRemoteControl(long requestUserID) {
        this.declineRemoteControlImpl(this.mNativeHandle, requestUserID);
    }

    public boolean assignRemoteControlPrivilege(long shareSourceUserID, long assignUserID, boolean allow) {
        return this.assignRemoteControlPrivilegeImpl(this.mNativeHandle, shareSourceUserID, assignUserID, allow);
    }

    public boolean grabRemoteControllingStatus(long shareSourceUserID, long assignUserID, boolean grab) {
        return this.grabRemoteControllingStatusImpl(this.mNativeHandle, shareSourceUserID, assignUserID, grab);
    }

    public boolean checkHasRemoteControlPrivilege(long shareSourceUserID, long targetUserID) {
        return this.checkHasRemoteControlPrivilegeImpl(this.mNativeHandle, shareSourceUserID, targetUserID);
    }

    public boolean isShareSourceInRemoteControllingStatus(long shareSourceUserID) {
        return this.isShareSourceInRemoteControllingStatusImpl(this.mNativeHandle, shareSourceUserID);
    }

    public boolean isShareSourceInRemoteControllingStatusByUser(long shareSourceUserID, long targetUserID) {
        return this.isShareSourceInRemoteControllingStatusByUserImpl(this.mNativeHandle, shareSourceUserID, targetUserID);
    }

    public boolean remoteControlMutiShareSingleTap(long viewHandle, float x, float y) {
        return this.remoteControlMutiShareSingleTapImpl(this.mNativeHandle, viewHandle, x, y);
    }

    public boolean remoteControlMutiShareDoubleTap(long viewHandle, float x, float y) {
        return this.remoteControlMutiShareDoubleTapImpl(this.mNativeHandle, viewHandle, x, y);
    }

    public boolean remoteControlMutiShareLongPress(long viewHandle, float x, float y) {
        return this.remoteControlMutiShareLongPressImpl(this.mNativeHandle, viewHandle, x, y);
    }

    public boolean remoteControlMutiShareDoubleScroll(long viewHandle, float x, float y) {
        return this.remoteControlMutiShareDoubleScrollImpl(this.mNativeHandle, viewHandle, x, y);
    }

    public boolean remoteControlMutiShareSingleMove(long viewHandle, float x, float y) {
        return this.remoteControlMutiShareSingleMoveImpl(this.mNativeHandle, viewHandle, x, y);
    }

    public boolean remoteControlMutiShareCharInput(long viewHandle, String str) {
        return this.remoteControlMutiShareCharInputImpl(this.mNativeHandle, viewHandle, str);
    }

    public boolean remoteControlMutiShareKeyInput(long viewHandle, int keyType) {
        return this.remoteControlMutiShareKeyInputImpl(this.mNativeHandle, viewHandle, keyType);
    }

    public boolean remoteControlMutiShareMouseValidate(long viewHandle, float x, float y) {
        return this.remoteControlMutiShareMouseValidateImpl(this.mNativeHandle, viewHandle, x, y);
    }

    public boolean isViewingPureComputerAudio() {
        return this.isViewingPureComputerAudioImpl(this.mNativeHandle);
    }

    public boolean requestToStopPureComputerAudioShare(long shareAduioUserId) {
        if (shareAduioUserId == 0L) {
            return false;
        }
        return this.requestToStopPureComputerAudioShareImpl(this.mNativeHandle, shareAduioUserId);
    }

    public long getPureComputerAudioSharingUserID() {
        return this.getPureComputerAudioSharingUserIDImpl(this.mNativeHandle);
    }

    private native boolean startShareImpl(long var1);

    private native boolean stopShareImpl(long var1);

    private native boolean setCaptureObjectImpl(long var1);

    private native boolean setCaptureRawDataImpl(long var1, int var3, int var4, int var5, ByteBuffer var6);

    private native boolean setCaptureBitmapDataImpl(long var1, Bitmap var3);

    private native int getShareStatusImpl(long var1);

    private native int getShareSettingTypeImpl(long var1);

    private native boolean presenterIsSharingAudioImpl(long var1);

    private native long createRendererInfo(long var1, boolean var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    private native boolean updateRendererInfo(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10);

    private native boolean destroyRendererInfo(long var1, long var3);

    private native boolean prepareRenderer(long var1, long var3);

    private native boolean destroyRenderer(long var1, long var3);

    private native long addPicImpl(long var1, long var3, int var5, int[] var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14);

    private native long movePicImpl(long var1, long var3, int var5, long var6, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15);

    private native long movePic2Impl(long var1, long var3, int var5, int var6, int var7, int var8, int var9);

    private native boolean removePicImpl(long var1, long var3, int var5);

    private native void glViewSizeChangedImpl(long var1, long var3, int var5, int var6);

    private native void clearRendererImpl(long var1, long var3);

    private native boolean showShareContentImpl(long var1, long var3, long var5, boolean var7);

    private native boolean stopViewShareContentImpl(long var1, long var3, boolean var5);

    private native long getShareDataResolutionImpl(long var1, long var3);

    private native boolean setViewModeImpl(long var1, int var3, int var4);

    private native void destAreaChangedImpl(long var1, long var3, int var5, int var6, int var7, int var8);

    private native void setRendererBackgroudColorImpl(long var1, long var3, int var5);

    private native boolean isVideoSharingInProgressImpl(long var1);

    private native boolean senderSupportAnnotationImpl(long var1, long var3);

    private native boolean isAttendeeAnnotationDisabledForMySharedContentImpl(long var1);

    private native boolean disableAttendeeAnnotationForMySharedContentImpl(long var1, boolean var3);

    private native void setShareEventSinkImpl(long var1, long var3);

    private native long getActiveUserIDImpl(long var1);

    private native boolean hasRemoteControlPrivilegeWithUserIdImpl(long var1, long var3);

    private native boolean isRemoteControllerImpl(long var1, long var3);

    private native boolean startRemoteControlImpl(long var1);

    private native boolean grabRemoteControlImpl(long var1, long var3);

    private native boolean remoteControlSingleTapImpl(long var1, float var3, float var4);

    private native boolean remoteControlDoubleTapImpl(long var1, float var3, float var4);

    private native boolean remoteControlLongPressImpl(long var1, float var3, float var4);

    private native boolean remoteControlDoubleScrollImpl(long var1, float var3, float var4);

    private native boolean remoteControlSingleMoveImpl(long var1, float var3, float var4);

    private native boolean remoteControlCharInputImpl(long var1, String var3);

    private native boolean remoteControlKeyInputImpl(long var1, int var3);

    private native boolean remoteControlMouseValidateImpl(long var1, float var3, float var4);

    private native boolean requestRemoteControlImpl(long var1, long var3);

    private native boolean giveupRemoteControlImpl(long var1, long var3);

    private native void declineRemoteControlImpl(long var1, long var3);

    private native boolean assignRemoteControlPrivilegeImpl(long var1, long var3, long var5, boolean var7);

    private native boolean grabRemoteControllingStatusImpl(long var1, long var3, long var5, boolean var7);

    private native boolean checkHasRemoteControlPrivilegeImpl(long var1, long var3, long var5);

    private native boolean isShareSourceInRemoteControllingStatusImpl(long var1, long var3);

    private native boolean isShareSourceInRemoteControllingStatusByUserImpl(long var1, long var3, long var5);

    private native boolean remoteControlMutiShareSingleTapImpl(long var1, long var3, float var5, float var6);

    private native boolean remoteControlMutiShareDoubleTapImpl(long var1, long var3, float var5, float var6);

    private native boolean remoteControlMutiShareLongPressImpl(long var1, long var3, float var5, float var6);

    private native boolean remoteControlMutiShareDoubleScrollImpl(long var1, long var3, float var5, float var6);

    private native boolean remoteControlMutiShareSingleMoveImpl(long var1, long var3, float var5, float var6);

    private native boolean remoteControlMutiShareCharInputImpl(long var1, long var3, String var5);

    private native boolean remoteControlMutiShareKeyInputImpl(long var1, long var3, int var5);

    private native boolean remoteControlMutiShareMouseValidateImpl(long var1, long var3, float var5, float var6);

    private native boolean isViewingPureComputerAudioImpl(long var1);

    private native boolean requestToStopPureComputerAudioShareImpl(long var1, long var3);

    private native long getPureComputerAudioSharingUserIDImpl(long var1);
}

