/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.confapp;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.IRendererUnit;
import com.zipow.videobox.confapp.RendererUnitInfo;
import com.zipow.videobox.confapp.VideoSessionMgr;
import com.zipow.videobox.confapp.VideoUnit;
import com.zipow.videobox.view.video.AbsVideoScene;
import us.zoom.androidlib.util.StringUtil;

public class GLImage
implements IRendererUnit {
    private static String TAG = GLImage.class.getSimpleName();
    private static final int PIC_BACKGROUND = 4;
    private boolean mIsDestroyed = false;
    private String mUnitName = null;
    private int mLeft;
    private int mTop;
    private int mWidth;
    private int mHeight;
    private long mRenderInfo;
    private boolean mPaused;
    private Drawable mBackground;
    private Bitmap mBackgroundBitmap;
    private boolean mbVisible = true;
    private IRendererUnit.PicInfo mPiBackground;
    private AbsVideoScene mVideoScene;
    private boolean mbPressed = false;
    private OnClickListener mOnClickListener;

    public GLImage(long renderInfo, RendererUnitInfo info) {
        this.mRenderInfo = renderInfo;
        if (info != null) {
            this.mLeft = info.left;
            this.mTop = info.top;
            this.mWidth = info.width;
            this.mHeight = info.height;
        }
    }

    public void setVideoScene(AbsVideoScene scene) {
        this.mVideoScene = scene;
    }

    @Override
    public void setUnitName(String name) {
        this.mUnitName = name;
        TAG = StringUtil.isEmptyOrNull((String)this.mUnitName) ? VideoUnit.class.getSimpleName() : VideoUnit.class.getSimpleName() + ":" + this.mUnitName;
    }

    @Override
    public String getUnitName() {
        return this.mUnitName;
    }

    public void setOnClickListener(OnClickListener l) {
        this.mOnClickListener = l;
    }

    @Override
    public void clearRenderer() {
    }

    @Override
    public void onIdle() {
    }

    @Override
    public void onGLViewSizeChanged(int width, int height) {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        videoMgr.glViewSizeChanged(this.mRenderInfo, width, height);
    }

    @Override
    public void updateUnitInfo(RendererUnitInfo unitInfo) {
        if (unitInfo == null) {
            return;
        }
        if (this.isSameInfo(unitInfo)) {
            return;
        }
        if (this.mVideoScene == null) {
            return;
        }
        this.mLeft = unitInfo.left;
        this.mTop = unitInfo.top;
        this.mWidth = unitInfo.width;
        this.mHeight = unitInfo.height;
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        videoMgr.updateUnitLayout(this.mRenderInfo, unitInfo);
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    @Override
    public int getLeft() {
        return this.mLeft;
    }

    @Override
    public int getTop() {
        return this.mTop;
    }

    @Override
    public int getRight() {
        return this.mLeft + this.mWidth;
    }

    @Override
    public int getBottom() {
        return this.mTop + this.mHeight;
    }

    public boolean contains(float x, float y) {
        return x >= (float)this.getLeft() && x <= (float)(this.getLeft() + this.getWidth()) && y >= (float)this.getTop() && y <= (float)(this.getTop() + this.getHeight());
    }

    @Override
    public void pause() {
        this.mPaused = true;
    }

    @Override
    public void resume() {
        this.mPaused = false;
    }

    @Override
    public boolean isPaused() {
        return this.mPaused;
    }

    @Override
    public void onDestroy() {
        this.removeBackground();
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        videoMgr.destroyGLImage(this);
        this.mIsDestroyed = true;
    }

    @Override
    public void onCreate() {
        this.mIsDestroyed = false;
    }

    @Override
    public long getRendererInfo() {
        return this.mRenderInfo;
    }

    private boolean isSameInfo(RendererUnitInfo unitInfo) {
        if (unitInfo == null) {
            return false;
        }
        return this.mLeft == unitInfo.left && this.mTop == unitInfo.top && this.mWidth == unitInfo.width && this.mHeight == unitInfo.height;
    }

    public void setBackground(Drawable drawable2) {
        if (this.mBackground == drawable2 && drawable2 != null) {
            return;
        }
        this.mBackground = drawable2;
        this.mPiBackground = null;
        this.mBackgroundBitmap = null;
        this.showBackground();
    }

    public Drawable getBackgroundDrawable() {
        return this.mBackground;
    }

    public void setBackground(Bitmap bitmap) {
        if (this.mBackgroundBitmap == bitmap && bitmap != null) {
            return;
        }
        this.mBackgroundBitmap = bitmap;
        this.mPiBackground = null;
        this.mBackground = null;
        this.showBackground();
    }

    public Drawable getBackgrounBitmap() {
        return this.mBackground;
    }

    public void setVisible(boolean visible) {
        this.mbVisible = visible;
        this.showBackground();
    }

    public boolean isVisible() {
        return this.mbVisible;
    }

    private void showBackground() {
        if (this.mVideoScene == null) {
            return;
        }
        if (!this.mbVisible || this.mBackground == null && this.mBackgroundBitmap == null) {
            this.removeBackground();
            return;
        }
        if (this.mIsDestroyed) {
            return;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        Bitmap bmp = null;
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.mPiBackground == null && (bmp = this.createBackgroundBitmap()) == null) {
            return;
        }
        int left = 0;
        int right = width;
        int top = 0;
        int bottom = height;
        long dataHandle = 0L;
        if (this.mPiBackground == null) {
            videoMgr.removePic(this.mRenderInfo, 4);
            dataHandle = videoMgr.addPic(this.mRenderInfo, 4, bmp, 255, 0, left, top, right, bottom);
            if (dataHandle != 0L) {
                this.mPiBackground = new IRendererUnit.PicInfo(dataHandle, bmp.getWidth(), bmp.getHeight());
            }
            if (bmp != this.mBackgroundBitmap) {
                bmp.recycle();
            }
        } else {
            videoMgr.movePic2(this.mRenderInfo, 4, left, top, right, bottom);
        }
    }

    private void removeBackground() {
        if (this.mVideoScene == null) {
            return;
        }
        if (this.mIsDestroyed) {
            return;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        if (videoMgr.removePic(this.mRenderInfo, 4)) {
            this.mPiBackground = null;
        }
    }

    private Bitmap createBackgroundBitmap() {
        Bitmap bitmap;
        if (this.mBackgroundBitmap != null) {
            return this.mBackgroundBitmap;
        }
        if (this.mBackground == null) {
            return null;
        }
        try {
            bitmap = Bitmap.createBitmap((int)this.mWidth, (int)this.mHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        catch (Exception e) {
            return null;
        }
        Canvas canvas = new Canvas(bitmap);
        this.mBackground.setBounds(0, 0, this.mWidth - 1, this.mHeight - 1);
        this.mBackground.draw(canvas);
        return bitmap;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event == null) {
            return false;
        }
        if (!this.mbVisible) {
            return false;
        }
        if (this.mOnClickListener == null) {
            return false;
        }
        if (event.getAction() == 0 && !this.mbPressed && this.isOnButton(event)) {
            this.mbPressed = true;
            return true;
        }
        if (event.getAction() == 1 && this.mbPressed) {
            this.mbPressed = false;
            if (this.isOnButton(event)) {
                this.onClick();
                return true;
            }
        }
        return this.mbPressed;
    }

    private boolean isOnButton(MotionEvent event) {
        if (event == null) {
            return false;
        }
        float x = event.getX();
        float y = event.getY();
        return x >= (float)this.getLeft() && x <= (float)(this.getLeft() + this.getWidth()) && y >= (float)this.getTop() && y <= (float)(this.getTop() + this.getHeight());
    }

    private void onClick() {
        if (this.mOnClickListener != null) {
            this.mOnClickListener.onClick(this);
        }
    }

    public static interface OnClickListener {
        public void onClick(GLImage var1);
    }
}

