/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.confapp;

import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Handler;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.widget.Toast;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.MeetingEndMessageActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.confapp.AudioSessionMgr;
import com.zipow.videobox.confapp.CmmAudioStatus;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.CmmVideoStatus;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.RecordMgr;
import com.zipow.videobox.confapp.SSB_MC_DATA_BLOCK_FECC_TALK_RIGHT_INFO;
import com.zipow.videobox.confapp.SdkConfUIBridge;
import com.zipow.videobox.confapp.VideoSessionMgr;
import com.zipow.videobox.confapp.bo.BOMgr;
import com.zipow.videobox.confapp.bo.BOObject;
import com.zipow.videobox.confapp.qa.ZoomQAComponent;
import com.zipow.videobox.confapp.qa.ZoomQAUI;
import com.zipow.videobox.kubi.KubiServiceManager;
import com.zipow.videobox.sdk.SDKCustomizedMeetingUIHelper;
import com.zipow.videobox.util.ConfLocalHelper;
import com.zipow.videobox.util.IPCHelper;
import com.zipow.videobox.util.NotificationMgr;
import java.util.Locale;
import org.webrtc.voiceengine.VoiceEnginContext;
import org.webrtc.voiceengine.VoiceEngineCompat;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.HardwareUtil;
import us.zoom.androidlib.util.HeadsetUtil;
import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.util.ZMLog;
import us.zoom.videomeetings.R;

public final class ConfUI
implements HeadsetUtil.IHeadsetConnectionListener {
    private static final String TAG = ConfUI.class.getSimpleName();
    private static ConfUI instance = null;
    private ListenerList mListenerList = new ListenerList();
    private ListenerList mVideoFECCCmdListenerList = new ListenerList();
    private ListenerList mRoomCallListenerList = new ListenerList();
    private PhoneStateListener mPhoneStateListener;
    private boolean mIsCallOffHook = false;
    private boolean mIsAudioStoppedByCallOffHook = false;
    private boolean mIsAudioMutedByCallOffHook = false;
    private boolean mIsAudioMutedByPauseAudio = false;
    private boolean mIsAudioStoppedByPauseAudio = false;
    private boolean mIsAudioReady = false;
    private boolean mIsLaunchConfParamReady = false;
    private boolean mIsMeetingInfoReady = false;
    private Handler mHandler = new Handler();
    private int mPTAskToLeave = -1;
    private long mConfFailedReason = 0L;
    private long mActiveVideo = 0L;
    private long mActiveSpeaker = 0L;
    private long mLockedUserId = 0L;
    private int mCurAudioSourceType = 0;
    private int mSwitchableAudioSourceType = 0;
    private boolean mbHasOneStartVideo = false;
    private boolean mIsLeavingConference = false;
    private boolean mIsLeaveComplete = false;
    private boolean mIsMeetingEndMessageDisabled = false;
    private boolean mbCMRNotificationDisplayed = false;
    private boolean mbHasCMR = false;
    private boolean mbOriginalHost = false;
    private boolean mbEndForCallDeclined = false;
    private boolean mbBOStatusChanging = false;
    private boolean mIsSDKCleanUpconfing = false;
    private int mPreferAudioType = -1;

    private ConfUI() {
    }

    public void initialize() {
        this.nativeInit();
        this.startToListenPhoneState();
        HeadsetUtil.getInstance().addListener((HeadsetUtil.IHeadsetConnectionListener)this);
    }

    public static synchronized ConfUI getInstance() {
        if (instance == null) {
            instance = new ConfUI();
        }
        return instance;
    }

    public static synchronized void clearInstance() {
        instance = null;
    }

    public boolean isLaunchConfParamReady() {
        return this.mIsLaunchConfParamReady;
    }

    public boolean isMeetingInfoReady() {
        return this.mIsMeetingInfoReady;
    }

    public long getActiveVideo() {
        return this.mActiveVideo;
    }

    public long getActiveSpeaker() {
        return this.mActiveSpeaker;
    }

    public void setLockedUserId(long id2) {
        this.mLockedUserId = id2;
    }

    public long getLockedUserId() {
        return this.mLockedUserId;
    }

    public boolean isLeaveComplete() {
        return this.mIsLeaveComplete;
    }

    public void setCMRNotifiationDisplayed(boolean displayed) {
        this.mbCMRNotificationDisplayed = displayed;
    }

    public boolean isCMRNotificationDisplayed() {
        return this.mbCMRNotificationDisplayed;
    }

    public void addListener(IConfUIListener l) {
        if (l == null) {
            return;
        }
        IListener[] listeners = this.mListenerList.getAll();
        boolean notifyConfFailed = false;
        if (listeners.length == 0 && this.mConfFailedReason != 0L) {
            notifyConfFailed = true;
        }
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != l) continue;
            this.removeListener((IConfUIListener)listeners[i]);
        }
        this.mListenerList.add((IListener)l);
        if (notifyConfFailed) {
            l.onConfStatusChanged2(2, this.mConfFailedReason);
        }
    }

    public void removeListener(IConfUIListener l) {
        this.mListenerList.remove((IListener)l);
    }

    public void cleanListeners() {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null && listeners.length > 0) {
            for (IListener lTmp : listeners) {
                IConfUIListener l = (IConfUIListener)lTmp;
                this.mListenerList.remove((IListener)l);
            }
        }
    }

    public void addVideoFECCCmdListener(IVideoFECCCmdListener l) {
        this.mVideoFECCCmdListenerList.add((IListener)l);
    }

    public void removeVideoFECCCmdListener(IVideoFECCCmdListener l) {
        this.mVideoFECCCmdListenerList.remove((IListener)l);
    }

    public void addRoomCallStatusListener(IRoomSystemCallEventListener l) {
        if (l == null) {
            return;
        }
        this.mRoomCallListenerList.add((IListener)l);
    }

    public void removeRoomCallStatusListener(IRoomSystemCallEventListener l) {
        this.mRoomCallListenerList.remove((IListener)l);
    }

    protected boolean onConfStatusChanged(int status) {
        try {
            return this.onConfStatusChangedImpl(status);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
            return false;
        }
    }

    private boolean onConfStatusChangedImpl(int status) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null && listeners.length > 0) {
            for (IListener lTmp : listeners) {
                IConfUIListener l = (IConfUIListener)lTmp;
                l.onConfStatusChanged(status);
            }
        }
        if (VideoBoxApplication.getInstance().isSDKMode()) {
            SdkConfUIBridge.getInstance().onConfStatusChanged(status);
        }
        if (!this.mbBOStatusChanging && status == 10) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    ConfUI.this.boStatusChangeComplete();
                }
            }, 2000L);
        }
        if (status == 12) {
            CmmConfContext confContext;
            ZoomQAComponent qacomponent;
            CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
            if (confStatus != null) {
                Locale locale = CompatUtils.getLocalDefault();
                String language = locale.getLanguage();
                String country = locale.getCountry();
                confStatus.setLangcode(language + "-" + country);
            }
            if (!SDKCustomizedMeetingUIHelper.isSdkUsingCustomizedMeetingUI()) {
                NotificationMgr.showConfNotification((Context)VideoBoxApplication.getInstance());
            }
            if ((qacomponent = ConfMgr.getInstance().getQAComponent()) != null) {
                qacomponent.setZoomQAUI(ZoomQAUI.getInstance());
            }
            if ((confContext = ConfMgr.getInstance().getConfContext()) != null) {
                this.mbOriginalHost = confContext.getOrginalHost();
            }
            this.boStatusChangeComplete();
            this.reportOSArchInfo();
        } else if (status == 20) {
            VideoBoxApplication.getInstance().setConfUIPreloaded(false);
            if (listeners == null || listeners.length == 0) {
                VideoBoxApplication.getInstance().killConfProcess();
            }
        } else if (status == 18) {
            this.boStatusChangeStart(true);
        } else if (status == 19) {
            this.boStatusChangeStart(false);
        }
        return true;
    }

    private void boStatusChangeStart(boolean join) {
        CmmConfContext confContext;
        this.mbBOStatusChanging = true;
        int joinReason = 0;
        if (join && (confContext = ConfMgr.getInstance().getConfContext()) != null) {
            joinReason = confContext.getBOJoinReason();
        }
        IPCHelper.getInstance().sendBOStatusChangeStart(join, joinReason, this.getBoMeetingName());
    }

    private String getBoMeetingName() {
        BOMgr boMgr = ConfMgr.getInstance().getBOMgr();
        if (boMgr == null) {
            return "";
        }
        BOObject myBoObject = boMgr.getMyBOObject(1);
        if (myBoObject == null) {
            return "";
        }
        return myBoObject.getMeetingName();
    }

    private void boStatusChangeComplete() {
        this.mbBOStatusChanging = false;
        IPCHelper.getInstance().sendBOStatusChangeComplete();
    }

    public boolean inSilentMode() {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null) {
            return confContext.inSilentMode();
        }
        return false;
    }

    private void runOnGlRunTasksFinished(final Runnable runnable, final long timeout) {
        if (SdkConfUIBridge.getWaitGLRunTaskCount() <= 0) {
            runnable.run();
        } else if (timeout > 0L) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    ConfUI.this.runOnGlRunTasksFinished(runnable, timeout - 20L);
                }
            }, 20L);
        } else {
            SdkConfUIBridge.resetWaitGLRunTaskCount();
            runnable.run();
        }
    }

    protected boolean onConfStatusChanged2(int cmd, long ret) {
        try {
            return this.onConfStatusChanged2Impl(cmd, ret);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
            return false;
        }
    }

    private boolean onConfStatusChanged2Impl(int cmd, long ret) {
        RecordMgr recordMgr;
        IListener[] listeners;
        if (VideoBoxApplication.getInstance().isSDKMode()) {
            SdkConfUIBridge.getInstance().onConfStatusChanged2(cmd, ret);
        }
        if (this.inSilentMode()) {
            switch (cmd) {
                case 0: 
                case 1: 
                case 2: 
                case 8: 
                case 39: 
                case 93: 
                case 124: {
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        if (cmd == 1) {
            this.mIsLeaveComplete = true;
        }
        if ((listeners = this.mListenerList.getAll()) != null) {
            for (IListener lTmp : listeners) {
                IConfUIListener l = (IConfUIListener)lTmp;
                l.onConfStatusChanged2(cmd, ret);
            }
        }
        if (SDKCustomizedMeetingUIHelper.isSdkUsingCustomizedMeetingUI()) {
            if (cmd == 1) {
                this.stopListenPhoneState();
                this.runOnGlRunTasksFinished(new Runnable(){

                    @Override
                    public void run() {
                        ConfUI.this.mIsSDKCleanUpconfing = true;
                        ConfMgr.getInstance().cleanupConf();
                        VideoBoxApplication.getInstance().stopConfService();
                    }
                }, 3000L);
                return true;
            }
            if (cmd == 2) {
                this.mConfFailedReason = ret;
                this.boStatusChangeComplete();
                ConfMgr.getInstance().notifyConfLeaveReason(String.valueOf(ConfLocalHelper.errorCodeToLeaveReason((int)ret)), true, (int)ret == 1);
                ConfMgr.getInstance().leaveConference();
                return true;
            }
            if (cmd == 7) {
                VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
                CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
                if (videoMgr != null && confContext != null && confContext.isVideoOn()) {
                    videoMgr.startMyVideo(0L);
                }
                return true;
            }
        }
        if (cmd == 94) {
            IPCHelper.getInstance().sendCallOutStatus((int)ret);
        }
        if (cmd == 1) {
            this.onConfLeaveComplete(ret);
        } else if (cmd == 5) {
            this.mIsAudioReady = true;
            this.checkOpenLoudSpeaker();
        } else if (cmd == 2) {
            this.mConfFailedReason = ret;
            this.boStatusChangeComplete();
        } else if (cmd == 17) {
            ConfMgr confMgr = ConfMgr.getInstance();
            CmmConfContext confContext = confMgr.getConfContext();
            if (confContext == null) {
                return true;
            }
            if (!this.mbHasOneStartVideo && !ConfMgr.getInstance().noOneIsSendingVideo()) {
                this.mbHasOneStartVideo = true;
                if (confContext.isAudioOnlyMeeting()) {
                    this.mbHasOneStartVideo = true;
                    AudioSessionMgr audioMgr = ConfMgr.getInstance().getAudioObj();
                    if (audioMgr != null) {
                        audioMgr.setPreferedLoudSpeakerStatus(-1);
                        this.checkOpenLoudSpeaker();
                    }
                }
            }
        } else if (cmd == 74) {
            recordMgr = ConfMgr.getInstance().getRecordMgr();
            CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
            if (recordMgr != null && confStatus != null && (recordMgr.isCMRInProgress() && !confStatus.isCMRInConnecting() || recordMgr.recordingMeetingOnCloud())) {
                this.mbHasCMR = true;
            }
        } else if (cmd == 45 && (recordMgr = ConfMgr.getInstance().getRecordMgr()) != null) {
            recordMgr.stopRecord(true);
        }
        return true;
    }

    private void onConfLeaveComplete(long ret) {
        switch ((int)ret) {
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                if (!this.mIsMeetingEndMessageDisabled) {
                    MeetingEndMessageActivity.showMeetingEndedMessage((Context)VideoBoxApplication.getInstance(), (int)ret);
                    break;
                }
                if (!VideoBoxApplication.getInstance().isSDKMode()) break;
                MeetingEndMessageActivity.showLeavingMessage((Context)VideoBoxApplication.getInstance(), null);
                break;
            }
            case 7: {
                if (!this.mIsMeetingEndMessageDisabled) {
                    MeetingEndMessageActivity.showMeetingEndedMessage((Context)VideoBoxApplication.getInstance(), (int)ret, ConfMgr.getInstance().getLastNetworkErrorCode());
                    break;
                }
                if (!VideoBoxApplication.getInstance().isSDKMode()) break;
                MeetingEndMessageActivity.showLeavingMessage((Context)VideoBoxApplication.getInstance(), null);
                break;
            }
            case 2: {
                if (!this.mIsMeetingEndMessageDisabled) {
                    MeetingEndMessageActivity.showMeetingEndedMessage((Context)VideoBoxApplication.getInstance(), (int)ret);
                    break;
                }
                if (!VideoBoxApplication.getInstance().isSDKMode()) break;
                MeetingEndMessageActivity.showLeavingMessage((Context)VideoBoxApplication.getInstance(), null);
                break;
            }
            default: {
                if (this.mbEndForCallDeclined) break;
                MeetingEndMessageActivity.showLeavingMessage((Context)VideoBoxApplication.getInstance(), null);
            }
        }
        this.stopListenPhoneState();
        if (this.mListenerList.size() == 0) {
            ConfMgr.getInstance().cleanupConf();
            VideoBoxApplication.getInstance().stopConfService();
        }
    }

    public boolean isDisplayAsHost(long userId) {
        CmmConfStatus status = ConfMgr.getInstance().getConfStatusObj();
        if (status == null) {
            return false;
        }
        return status.isMasterConfHost(userId);
    }

    public boolean isDisplayAsCohost(long userId) {
        CmmConfStatus status = ConfMgr.getInstance().getConfStatusObj();
        if (status == null || userId == 0L) {
            return false;
        }
        if (status.isMasterConfHost(userId)) {
            return false;
        }
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return false;
        }
        return user.isCoHost() || user.isBOModerator();
    }

    protected boolean onUserStatusChanged(int cmd, long userId, int userAction) {
        try {
            return this.onUserStatusChangedImpl(cmd, userId, userAction);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
            return false;
        }
    }

    private boolean onUserStatusChangedImpl(int cmd, long userId, int userAction) {
        if (this.inSilentMode()) {
            return false;
        }
        switch (cmd) {
            case 10: {
                this.mActiveVideo = userId;
                break;
            }
            case 6: {
                if (ConfMgr.getInstance().noOneIsSendingVideo()) {
                    this.mActiveVideo = userId;
                }
                this.mActiveSpeaker = userId;
                break;
            }
            case 4: {
                this.onUserVideoStatus(userId);
                break;
            }
            case 21: {
                this.onUserAudioTypeChanged(userId);
            }
        }
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IConfUIListener l = (IConfUIListener)lTmp;
                l.onUserStatusChanged(cmd, userId, userAction);
            }
        }
        if (VideoBoxApplication.getInstance().isSDKMode()) {
            SdkConfUIBridge.getInstance().onUserStatusChanged(cmd, userId, userAction);
        }
        return true;
    }

    private void onUserAudioTypeChanged(long userId) {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        AudioSessionMgr audioMgr = ConfMgr.getInstance().getAudioObj();
        if (audioMgr == null) {
            return;
        }
        if (confStatus.isMyself(userId)) {
            CmmUser myself = ConfMgr.getInstance().getMyself();
            if (myself == null) {
                return;
            }
            CmmAudioStatus audioStatus = myself.getAudioStatusObj();
            if (audioStatus == null) {
                return;
            }
            long audioType = audioStatus.getAudiotype();
            if (audioType == 1L && this.mIsAudioMutedByCallOffHook && audioStatus.getIsMuted()) {
                audioMgr.startAudio();
                this.mIsAudioMutedByCallOffHook = false;
            }
            if (audioType == 0L) {
                this.checkOpenLoudSpeaker();
            } else {
                UIUtil.stopProximityScreenOffWakeLock();
            }
        }
    }

    private void onUserVideoStatus(long userId) {
        boolean isMyself;
        CmmConfStatus status = ConfMgr.getInstance().getConfStatusObj();
        boolean bl = isMyself = status != null && status.isMyself(userId);
        if (isMyself) {
            CmmUser user = ConfMgr.getInstance().getMyself();
            if (user == null) {
                return;
            }
            CmmVideoStatus videoStatus = user.getVideoStatusObj();
            if (videoStatus == null) {
                return;
            }
            if (videoStatus.getIsSending()) {
                VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
                if (videoMgr == null) {
                    return;
                }
                videoMgr.onMyVideoStarted();
                CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
                if (confContext != null && confContext.isKubiEnabled()) {
                    videoMgr.turnKubiDeviceOnOFF(true);
                    KubiServiceManager kubiServiceMgr = KubiServiceManager.getInstance((Context)VideoBoxApplication.getInstance());
                    if (kubiServiceMgr != null) {
                        kubiServiceMgr.connectKubiService(true);
                    }
                }
            }
        }
    }

    protected boolean onUserEvent(int eventType, long userId, int flag) {
        try {
            return this.onUserEventImpl(eventType, userId, flag);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
            return false;
        }
    }

    private boolean onUserEventImpl(int eventType, long userId, int flag) {
        if (this.inSilentMode()) {
            return false;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus != null && confStatus.isMyself(userId) && eventType == 0 && !SDKCustomizedMeetingUIHelper.isSdkUsingCustomizedMeetingUI()) {
            return true;
        }
        ConfMgr.getInstance().onUserEvent(eventType, userId, flag);
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IConfUIListener l = (IConfUIListener)lTmp;
                l.onUserEvent(eventType, userId, flag);
            }
        }
        if (VideoBoxApplication.getInstance().isSDKMode()) {
            SdkConfUIBridge.getInstance().onUserEvent(eventType, userId, flag);
        }
        return true;
    }

    protected boolean onClosedCaptionMessageReceived(String msgID, String content, long time) {
        try {
            return this.onClosedCaptionMessageReceivedImpl(msgID, content, time);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
            return false;
        }
    }

    private boolean onClosedCaptionMessageReceivedImpl(String msgID, String content, long time) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IConfUIListener l = (IConfUIListener)lTmp;
                l.onClosedCaptionMessageReceived(msgID, content, time);
            }
        }
        if (VideoBoxApplication.getInstance().isSDKMode()) {
            SdkConfUIBridge.getInstance().onClosedCaptionMessageReceived(msgID, content, time);
        }
        return false;
    }

    protected boolean onRealtimeClosedCaptionMessageReceived(String content) {
        try {
            return this.onRealtimeClosedCaptionMessageReceivedImpl(content);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
            return false;
        }
    }

    private boolean onRealtimeClosedCaptionMessageReceivedImpl(String content) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IConfUIListener l = (IConfUIListener)lTmp;
                l.onRealtimeClosedCaptionMessageReceived(content);
            }
        }
        if (VideoBoxApplication.getInstance().isSDKMode()) {
            SdkConfUIBridge.getInstance().onRealtimeClosedCaptionMessageReceived(content);
        }
        return false;
    }

    protected boolean notifyChatMessageReceived(String msgID, long sender, String senderDisplayName, long receiver, String receiverDisplayName, String content, long time) {
        try {
            return this.notifyChatMessageReceivedImpl(msgID, sender, senderDisplayName, receiver, receiverDisplayName, content, time);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
            return false;
        }
    }

    private boolean notifyChatMessageReceivedImpl(String msgID, long sender, String senderDisplayName, long receiver, String receiverDisplayName, String content, long time) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IConfUIListener l = (IConfUIListener)lTmp;
                l.onChatMessageReceived(msgID, sender, senderDisplayName, receiver, receiverDisplayName, content, time);
            }
        }
        if (VideoBoxApplication.getInstance().isSDKMode()) {
            SdkConfUIBridge.getInstance().onChatMessageReceived(msgID, sender, senderDisplayName, receiver, receiverDisplayName, content, time);
        }
        return true;
    }

    protected void onPTAskToLeave(int reason) {
        try {
            this.onPTAskToLeaveImpl(reason);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onPTAskToLeaveImpl(int reason) {
        ConfMgr confMgr = ConfMgr.getInstance();
        if (reason == 38 && ConfLocalHelper.isGe2NotCallingOut()) {
            return;
        }
        this.mPTAskToLeave = reason;
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IConfUIListener l = (IConfUIListener)lTmp;
                l.onPTAskToLeave(reason);
            }
        }
        switch (reason) {
            case 0: {
                confMgr.notifyConfLeaveReason(String.valueOf(0), true);
                confMgr.leaveConference();
                break;
            }
            case 4: {
                ConfActivity.handleOnPTAskToLeaveForUpdate();
                break;
            }
            case 8: {
                confMgr.notifyConfLeaveReason(String.valueOf(reason), true);
                confMgr.leaveConference();
                break;
            }
            case 38: {
                this.onCallDeclined(confMgr);
                break;
            }
        }
    }

    private void onCallDeclined(ConfMgr confMgr) {
        this.mbEndForCallDeclined = true;
        confMgr.endConference();
    }

    public int getPTAskToLeaveReason() {
        return this.mPTAskToLeave;
    }

    public void clearPTAskToLeaveReason() {
        this.mPTAskToLeave = -1;
    }

    public void setIsLeavingConference(boolean isLeavingConference) {
        this.mIsLeavingConference = true;
    }

    public boolean isLeavingConference() {
        return this.mIsLeavingConference;
    }

    public boolean isSDKCleanUpconfing() {
        return this.mIsSDKCleanUpconfing;
    }

    protected boolean joinConf_ConfirmMeetingInfo(boolean success, boolean hasPassword, boolean hasScreenName) {
        try {
            return this.joinConf_ConfirmMeetingInfoImpl(success, hasPassword, hasScreenName);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
            return false;
        }
    }

    private boolean joinConf_ConfirmMeetingInfoImpl(boolean success, boolean hasPassword, boolean hasScreenName) {
        this.mIsMeetingInfoReady = true;
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IConfUIListener l = (IConfUIListener)lTmp;
                l.onJoinConfConfirmMeetingInfo(success, hasPassword, hasScreenName);
            }
        }
        if (VideoBoxApplication.getInstance().isSDKMode()) {
            SdkConfUIBridge.getInstance().onJoinConfConfirmMeetingInfo(success, hasPassword, hasScreenName);
        }
        return true;
    }

    protected boolean joinConf_ConfirmPasswordValidateResult(boolean success, boolean needWait) {
        try {
            return this.joinConf_ConfirmPasswordValidateResultImpl(success, needWait);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
            return false;
        }
    }

    private boolean joinConf_ConfirmPasswordValidateResultImpl(boolean success, boolean needWait) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IConfUIListener l = (IConfUIListener)lTmp;
                l.onJoinConfConfirmPasswordValidateResult(success, needWait);
            }
        }
        if (VideoBoxApplication.getInstance().isSDKMode()) {
            SdkConfUIBridge.getInstance().onJoinConfConfirmPasswordValidateResult(success, needWait);
        }
        return true;
    }

    protected boolean joinConf_ConfirmMeetingStatus(boolean canJoinNow, boolean hasScreenName) {
        try {
            return this.joinConf_ConfirmMeetingStatusImpl(canJoinNow, hasScreenName);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
            return false;
        }
    }

    private boolean joinConf_ConfirmMeetingStatusImpl(boolean canJoinNow, boolean hasScreenName) {
        this.mIsMeetingInfoReady = true;
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IConfUIListener l = (IConfUIListener)lTmp;
                l.onJoinConfConfirmMeetingStatus(canJoinNow, hasScreenName);
            }
        }
        if (VideoBoxApplication.getInstance().isSDKMode()) {
            SdkConfUIBridge.getInstance().onJoinConfConfirmMeetingStatus(canJoinNow, hasScreenName);
        }
        IPCHelper.getInstance().sendJoinConfConfirmMeetingStatus(canJoinNow, hasScreenName);
        return true;
    }

    protected void notifyCallTimeout() {
        try {
            this.notifyCallTimeoutImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void notifyCallTimeoutImpl() {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IConfUIListener l = (IConfUIListener)lTmp;
                l.onCallTimeOut();
            }
        }
    }

    protected void onLaunchConfParamReady() {
        try {
            this.onLaunchConfParamReadyImpl();
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onLaunchConfParamReadyImpl() {
        this.mIsLaunchConfParamReady = true;
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IConfUIListener l = (IConfUIListener)lTmp;
                l.onLaunchConfParamReady();
            }
        }
    }

    protected boolean onDeviceStatusChanged(int cmd, int ret) {
        try {
            return this.onDeviceStatusChangedImpl(cmd, ret);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
            return false;
        }
    }

    private boolean onDeviceStatusChangedImpl(int cmd, int ret) {
        VideoSessionMgr videoMgr;
        if (this.inSilentMode()) {
            return false;
        }
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IConfUIListener l = (IConfUIListener)lTmp;
                l.onDeviceStatusChanged(cmd, ret);
            }
        }
        if (VideoBoxApplication.getInstance().isSDKMode()) {
            SdkConfUIBridge.getInstance().onDeviceStatusChanged(cmd, ret);
        }
        if (SDKCustomizedMeetingUIHelper.isSdkUsingCustomizedMeetingUI() && cmd == 3 && ret == 2 && (videoMgr = ConfMgr.getInstance().getVideoObj()) != null && videoMgr.isVideoStarted()) {
            videoMgr.stopMyVideo(0L);
        }
        return true;
    }

    protected void onWebinarNeedRegister(boolean bNeedApproval) {
        try {
            this.onWebinarNeedRegisterImpl(bNeedApproval);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onWebinarNeedRegisterImpl(boolean bNeedApproval) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IConfUIListener l = (IConfUIListener)lTmp;
                l.onWebinarNeedRegister(bNeedApproval);
            }
        }
        SdkConfUIBridge.getInstance().onWebinarNeedRegister(bNeedApproval);
    }

    protected void onUpgradeThisFreeMeeting(int ret) {
        try {
            this.onUpgradeThisFreeMeetingImpl(ret);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onUpgradeThisFreeMeetingImpl(int ret) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IConfUIListener l = (IConfUIListener)lTmp;
                l.onUpgradeThisFreeMeeting(ret);
            }
        }
    }

    protected void onCheckCMRPrivilege(int ret, boolean canStartNow) {
        try {
            this.onCheckCMRPrivilegeImpl(ret, canStartNow);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onCheckCMRPrivilegeImpl(int ret, boolean canStartNow) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IConfUIListener l = (IConfUIListener)lTmp;
                l.onCheckCMRPrivilege(ret, canStartNow);
            }
        }
    }

    protected void onVideoFECCCmd(int command, long riCommander, long riExecutive, long riReceiver, long riCameraIndex, int riReason) {
        SSB_MC_DATA_BLOCK_FECC_TALK_RIGHT_INFO info = new SSB_MC_DATA_BLOCK_FECC_TALK_RIGHT_INFO();
        info.commander = riCommander;
        info.executive = riExecutive;
        info.receiver = riReceiver;
        info.camera_index = riCameraIndex;
        info.reason = riReason;
        try {
            this.onVideoFECCCmdImpl(command, info);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    private void onVideoFECCCmdImpl(int command, SSB_MC_DATA_BLOCK_FECC_TALK_RIGHT_INFO info) {
        IListener[] listeners = this.mVideoFECCCmdListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IVideoFECCCmdListener l = (IVideoFECCCmdListener)lTmp;
                l.onVideoFECCCmd(command, info);
            }
        }
    }

    public void onRoomSystemCallStatus(int event, long result, boolean isActiveMeeting) {
        IListener[] listeners = this.mRoomCallListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IRoomSystemCallEventListener l = (IRoomSystemCallEventListener)lTmp;
                l.onRoomSystemCallEvent(event, result, isActiveMeeting);
            }
        }
    }

    public void onHeadsetStatusChanged(boolean wiredHeadsetConnected, boolean bluetoothHeadsetConnected) {
        if (this.mIsCallOffHook) {
            return;
        }
        ConfMgr confMgr = ConfMgr.getInstance();
        if (confMgr == null) {
            return;
        }
        if (!confMgr.isConfConnected()) {
            return;
        }
        AudioSessionMgr audioMgr = confMgr.getAudioObj();
        if (audioMgr == null) {
            return;
        }
        if (wiredHeadsetConnected || bluetoothHeadsetConnected) {
            audioMgr.setPreferedLoudSpeakerStatus(-1);
        }
        this.checkOpenLoudSpeaker();
        audioMgr.notifyHeadsetStatusChanged(bluetoothHeadsetConnected, wiredHeadsetConnected);
    }

    public void onBluetoothScoAudioStatus(boolean on) {
        if (!on) {
            this.checkOpenLoudSpeaker();
        }
        this.updateAudioSourceType();
        ConfMgr confMgr = ConfMgr.getInstance();
        if (confMgr == null) {
            return;
        }
        AudioSessionMgr audioMgr = confMgr.getAudioObj();
        if (audioMgr == null) {
            return;
        }
        audioMgr.notifyBluetoothScoAudioStatus(on, this.mIsCallOffHook);
    }

    private void startToListenPhoneState() {
        TelephonyManager tm = (TelephonyManager)VideoBoxApplication.getInstance().getSystemService("phone");
        if (tm != null) {
            this.mIsCallOffHook = tm.getCallState() == 2;
            this.mPhoneStateListener = new PhoneStateListener(){

                public void onCallStateChanged(int state, String incomingNumber) {
                    super.onCallStateChanged(state, incomingNumber);
                    switch (state) {
                        case 0: {
                            ConfUI.this.onPhoneCallIdle();
                            break;
                        }
                        case 1: 
                        case 2: {
                            ConfUI.this.onPhoneCallOffHook();
                        }
                    }
                }

                public void onDataConnectionStateChanged(int state, int networkType) {
                }
            };
            try {
                tm.listen(this.mPhoneStateListener, 96);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void stopListenPhoneState() {
        if (this.mPhoneStateListener == null) {
            return;
        }
        TelephonyManager tm = (TelephonyManager)VideoBoxApplication.getInstance().getSystemService("phone");
        if (tm != null) {
            try {
                tm.listen(this.mPhoneStateListener, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void onPhoneCallOffHook() {
        this.mIsCallOffHook = true;
        if (this.mIsAudioStoppedByPauseAudio) {
            return;
        }
        ConfMgr confMgr = ConfMgr.getInstance();
        if (confMgr == null) {
            return;
        }
        if (!confMgr.isConfConnected() || !this.mIsAudioReady) {
            return;
        }
        AudioSessionMgr audioMgr = confMgr.getAudioObj();
        if (audioMgr != null) {
            if (this.mIsAudioReady) {
                CmmUser user = confMgr.getMyself();
                if (user == null) {
                    return;
                }
                CmmAudioStatus audioStatus = user.getAudioStatusObj();
                long audioType = audioStatus.getAudiotype();
                if (audioType == 0L && !audioStatus.getIsMuted()) {
                    audioMgr.stopAudio();
                    this.mIsAudioMutedByCallOffHook = true;
                    Toast.makeText((Context)VideoBoxApplication.getInstance(), (int)R.string.zm_msg_audio_stopped_by_call_offhook, (int)1).show();
                }
                audioMgr.setLoudSpeakerStatus(false);
                audioMgr.stopPlayout();
                this.mIsAudioStoppedByCallOffHook = true;
            }
            this.updateAudioSourceType();
        }
    }

    private void onPhoneCallIdle() {
        this.mIsCallOffHook = false;
        if (!this.mIsAudioStoppedByCallOffHook) {
            return;
        }
        ConfMgr confMgr = ConfMgr.getInstance();
        if (confMgr == null) {
            return;
        }
        if (!confMgr.isConfConnected() || !this.mIsAudioReady) {
            return;
        }
        AudioSessionMgr audioMgr = confMgr.getAudioObj();
        if (audioMgr != null) {
            CmmUser user = confMgr.getMyself();
            if (user == null) {
                return;
            }
            audioMgr.startPlayout();
            CmmAudioStatus audioStatus = user.getAudioStatusObj();
            long audioType = audioStatus.getAudiotype();
            if (audioType == 0L && this.mIsAudioMutedByCallOffHook && audioStatus.getIsMuted()) {
                audioMgr.startAudio();
            }
            this.mIsAudioStoppedByCallOffHook = false;
            this.mIsAudioMutedByCallOffHook = false;
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    ConfUI.this.checkOpenLoudSpeaker();
                }
            }, 2000L);
        }
    }

    public void pauseAudio() {
        if (this.mIsAudioStoppedByCallOffHook) {
            return;
        }
        if (this.mIsAudioReady) {
            ConfMgr confMgr = ConfMgr.getInstance();
            if (confMgr == null) {
                return;
            }
            AudioSessionMgr audioMgr = confMgr.getAudioObj();
            if (audioMgr == null) {
                return;
            }
            CmmUser user = confMgr.getMyself();
            if (user == null) {
                return;
            }
            CmmAudioStatus audioStatus = user.getAudioStatusObj();
            long audioType = audioStatus.getAudiotype();
            if (audioType == 0L && !audioStatus.getIsMuted()) {
                audioMgr.stopAudio();
                this.mIsAudioMutedByPauseAudio = true;
            }
            audioMgr.setLoudSpeakerStatus(false);
            audioMgr.stopPlayout();
            this.mIsAudioStoppedByPauseAudio = true;
        }
        this.updateAudioSourceType();
    }

    public void resumeAudio() {
        if (!this.mIsAudioStoppedByPauseAudio) {
            return;
        }
        if (this.mIsAudioReady) {
            ConfMgr confMgr = ConfMgr.getInstance();
            if (confMgr == null) {
                return;
            }
            AudioSessionMgr audioMgr = confMgr.getAudioObj();
            if (audioMgr == null) {
                return;
            }
            CmmUser user = confMgr.getMyself();
            if (user == null) {
                return;
            }
            audioMgr.startPlayout();
            CmmAudioStatus audioStatus = user.getAudioStatusObj();
            long audioType = audioStatus.getAudiotype();
            if (audioType == 0L && this.mIsAudioMutedByPauseAudio && audioStatus.getIsMuted()) {
                audioMgr.startAudio();
            }
            this.mIsAudioStoppedByPauseAudio = false;
            this.mIsAudioMutedByPauseAudio = false;
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    ConfUI.this.checkOpenLoudSpeaker();
                }
            }, 2000L);
        }
    }

    public void checkOpenLoudSpeaker() {
        ConfMgr confMgr = ConfMgr.getInstance();
        if (confMgr == null) {
            return;
        }
        AudioSessionMgr audioMgr = confMgr.getAudioObj();
        if (audioMgr != null) {
            if (this.mIsCallOffHook) {
                if (this.mIsAudioReady && !this.mIsAudioStoppedByCallOffHook) {
                    CmmAudioStatus audioStatus;
                    long audioType;
                    audioMgr.setLoudSpeakerStatus(false);
                    CmmUser user = confMgr.getMyself();
                    if (user != null && (audioType = (audioStatus = user.getAudioStatusObj()).getAudiotype()) == 0L && !audioStatus.getIsMuted()) {
                        audioMgr.stopAudio();
                        this.mIsAudioMutedByCallOffHook = true;
                    }
                    audioMgr.stopPlayout();
                    this.mIsAudioStoppedByCallOffHook = true;
                }
            } else if (audioMgr.getPreferedLoudSpeakerStatus() == 1) {
                audioMgr.stopBluetoothHeadset();
                audioMgr.setLoudSpeakerStatus(true);
            } else {
                if (!(!HeadsetUtil.getInstance().isBluetoothHeadsetOn() || audioMgr.ismIsUseA2dpMode() || this.mPreferAudioType != 3 && this.mPreferAudioType != -1 && HeadsetUtil.getInstance().isWiredHeadsetOn())) {
                    audioMgr.startBluetoothHeadset();
                    this.updateAudioSourceType();
                    return;
                }
                audioMgr.stopBluetoothHeadset();
                if (audioMgr.getPreferedLoudSpeakerStatus() == 0) {
                    audioMgr.setLoudSpeakerStatus(false);
                } else {
                    audioMgr.setLoudSpeakerStatus(!HeadsetUtil.getInstance().isBluetoothHeadsetOn() && !HeadsetUtil.getInstance().isWiredHeadsetOn());
                }
            }
        }
        this.updateAudioSourceType();
    }

    public void changeAudioOutput(int targetAudioType) {
        ConfMgr confMgr = ConfMgr.getInstance();
        if (confMgr == null) {
            return;
        }
        this.mPreferAudioType = targetAudioType;
        AudioSessionMgr audioMgr = confMgr.getAudioObj();
        if (audioMgr != null) {
            if (this.mIsCallOffHook) {
                if (this.mIsAudioReady && !this.mIsAudioStoppedByCallOffHook) {
                    CmmAudioStatus audioStatus;
                    long audioType;
                    audioMgr.setLoudSpeakerStatus(false);
                    CmmUser user = confMgr.getMyself();
                    if (user != null && (audioType = (audioStatus = user.getAudioStatusObj()).getAudiotype()) == 0L && !audioStatus.getIsMuted()) {
                        audioMgr.stopAudio();
                        this.mIsAudioMutedByCallOffHook = true;
                    }
                    audioMgr.stopPlayout();
                    this.mIsAudioStoppedByCallOffHook = true;
                }
            } else if (audioMgr.getPreferedLoudSpeakerStatus() == 1) {
                audioMgr.stopBluetoothHeadset();
                audioMgr.setLoudSpeakerStatus(true);
            } else {
                if (targetAudioType == 3 && HeadsetUtil.getInstance().isBluetoothHeadsetOn()) {
                    audioMgr.startBluetoothHeadset();
                    this.updateAudioSourceType();
                    return;
                }
                audioMgr.stopBluetoothHeadset();
                if (targetAudioType == 2) {
                    audioMgr.startWiredHeadset();
                }
                if (audioMgr.getPreferedLoudSpeakerStatus() == 0) {
                    audioMgr.setLoudSpeakerStatus(false);
                } else {
                    audioMgr.setLoudSpeakerStatus(!HeadsetUtil.getInstance().isBluetoothHeadsetOn() && !HeadsetUtil.getInstance().isWiredHeadsetOn());
                }
            }
        }
        this.updateAudioSourceType();
    }

    private void updateAudioSourceType() {
        ConfMgr confMgr = ConfMgr.getInstance();
        if (confMgr == null) {
            return;
        }
        AudioSessionMgr audioMgr = confMgr.getAudioObj();
        if (audioMgr == null) {
            return;
        }
        boolean isStreamMusic = VoiceEnginContext.getSelectedPlayerStreamType() == 3;
        boolean supportTelephony = VoiceEngineCompat.isFeatureTelephonySupported((Context)VideoBoxApplication.getInstance());
        HeadsetUtil headsetUtil = HeadsetUtil.getInstance();
        boolean headsetOn = headsetUtil.isBluetoothHeadsetOn() || headsetUtil.isWiredHeadsetOn();
        int mOldAudioSourceType = this.mCurAudioSourceType;
        if (!isStreamMusic && (supportTelephony || headsetOn)) {
            if (!(!audioMgr.getLoudSpeakerStatus() || headsetUtil.isBluetoothScoAudioOn() && VoiceEngineCompat.isBluetoothScoSupported())) {
                this.mCurAudioSourceType = 0;
                this.mSwitchableAudioSourceType = headsetUtil.isBluetoothHeadsetOn() ? 0 : (HeadsetUtil.getInstance().isWiredHeadsetOn() ? 2 : 1);
            } else {
                this.mCurAudioSourceType = headsetUtil.isBluetoothScoAudioOn() && VoiceEngineCompat.isBluetoothScoSupported() ? 3 : (headsetUtil.isBluetoothHeadsetOn() && (audioMgr.ismIsUseA2dpMode() || audioMgr.isStarttingSco()) ? 3 : (HeadsetUtil.getInstance().isWiredHeadsetOn() ? 2 : 1));
                this.mSwitchableAudioSourceType = 0;
            }
        } else {
            this.mCurAudioSourceType = 0;
            this.mSwitchableAudioSourceType = -1;
        }
        if (mOldAudioSourceType != this.mCurAudioSourceType) {
            IListener[] listeners = this.mListenerList.getAll();
            if (listeners != null) {
                for (IListener lTmp : listeners) {
                    IConfUIListener l = (IConfUIListener)lTmp;
                    l.onAudioSourceTypeChanged(this.mCurAudioSourceType);
                }
            }
            if (VideoBoxApplication.getInstance().isSDKMode()) {
                SdkConfUIBridge.getInstance().onAudioSourceTypeChanged(this.mCurAudioSourceType);
            }
        }
    }

    public int getCurrentAudioSourceType() {
        return this.mCurAudioSourceType;
    }

    public int getSwitchableAudioSourceType() {
        return this.mSwitchableAudioSourceType;
    }

    public void notifyNetworkType() {
        int networkType = NetworkUtil.getDataNetworkType((Context)VideoBoxApplication.getInstance());
        int typeToSet = 0;
        switch (networkType) {
            case 1: {
                typeToSet = 2;
                break;
            }
            case 2: 
            case 3: {
                typeToSet = 3;
                break;
            }
            case 4: {
                typeToSet = 1;
                break;
            }
            case 0: 
            case 5: {
                typeToSet = 0;
            }
        }
        ConfMgr.getInstance().setAndroidNetworkType(typeToSet, 0);
    }

    public void notifyWifiSignal() {
        VideoBoxApplication context = VideoBoxApplication.getInstance();
        if (context == null) {
            return;
        }
        try {
            WifiManager wifiMgr = (WifiManager)context.getSystemService("wifi");
            if (wifiMgr == null) {
                return;
            }
            WifiInfo wifiInfo = wifiMgr.getConnectionInfo();
            if (wifiInfo != null) {
                int rssi = wifiInfo.getRssi();
                int level = WifiManager.calculateSignalLevel((int)rssi, (int)101);
                ConfMgr.getInstance().setWifiSignalQuality(level);
            }
        }
        catch (Throwable e) {
            ZMLog.w((String)TAG, (Throwable)e, (String)"notifyWifiSignal failure", (Object[])new Object[0]);
        }
    }

    public void setIsMeetingEndMessageDisabled(boolean disabled) {
        this.mIsMeetingEndMessageDisabled = disabled;
    }

    public boolean isCallOffHook() {
        return this.mIsCallOffHook;
    }

    private void reportOSArchInfo() {
        String content = "android," + Build.VERSION.RELEASE + "," + HardwareUtil.getPreferredCpuABI();
        ConfMgr.getInstance().mmrMonitorLog("os_arch_info", content);
    }

    public boolean tryRetrieveMicrophone() {
        ConfMgr confMgr = ConfMgr.getInstance();
        if (confMgr == null) {
            return false;
        }
        if (!confMgr.isConfConnected() || !this.mIsAudioReady) {
            return false;
        }
        AudioSessionMgr audioMgr = confMgr.getAudioObj();
        if (audioMgr == null) {
            return false;
        }
        CmmUser user = confMgr.getMyself();
        if (user == null) {
            return false;
        }
        CmmAudioStatus audioStatus = user.getAudioStatusObj();
        if (audioStatus == null) {
            return false;
        }
        long audioType = audioStatus.getAudiotype();
        if (audioType != 0L) {
            audioMgr.unSelectMicrophone();
            audioMgr.selectDefaultMicrophone(true);
            return true;
        }
        boolean isMuted = audioStatus.getIsMuted();
        if (!isMuted) {
            audioMgr.stopAudio();
        }
        audioMgr.unSelectMicrophone();
        if (!audioMgr.selectDefaultMicrophone(true)) {
            return false;
        }
        if (!isMuted) {
            return audioMgr.startAudio();
        }
        return true;
    }

    private native void nativeInit();

    public static interface IRoomSystemCallEventListener
    extends IListener {
        public void onRoomSystemCallEvent(int var1, long var2, boolean var4);
    }

    public static interface IVideoFECCCmdListener
    extends IListener {
        public void onVideoFECCCmd(int var1, SSB_MC_DATA_BLOCK_FECC_TALK_RIGHT_INFO var2);
    }

    public static abstract class SimpleConfUIListener
    implements IConfUIListener {
        @Override
        public boolean onConfStatusChanged(int status) {
            return false;
        }

        @Override
        public boolean onConfStatusChanged2(int cmd, long ret) {
            return false;
        }

        @Override
        public boolean onUserStatusChanged(int cmd, long userId, int userAction) {
            return false;
        }

        @Override
        public boolean onUserEvent(int eventType, long userId, int flag) {
            return false;
        }

        @Override
        public boolean onChatMessageReceived(String msgID, long sender, String senderDisplayName, long receiver, String receiverDisplayName, String content, long time) {
            return false;
        }

        @Override
        public void onClosedCaptionMessageReceived(String msgID, String content, long time) {
        }

        @Override
        public void onRealtimeClosedCaptionMessageReceived(String content) {
        }

        @Override
        public void onPTAskToLeave(int reason) {
        }

        @Override
        public void onJoinConfConfirmMeetingInfo(boolean success, boolean hasPassword, boolean hasScreenName) {
        }

        @Override
        public void onJoinConfConfirmPasswordValidateResult(boolean success, boolean needWait) {
        }

        @Override
        public void onJoinConfConfirmMeetingStatus(boolean canJoinNow, boolean hasScreenName) {
        }

        @Override
        public void onCallTimeOut() {
        }

        @Override
        public void onLaunchConfParamReady() {
        }

        @Override
        public void onDeviceStatusChanged(int cmd, int ret) {
        }

        @Override
        public void onAudioSourceTypeChanged(int type) {
        }

        @Override
        public void onWebinarNeedRegister(boolean bNeedApproval) {
        }

        @Override
        public void onUpgradeThisFreeMeeting(int ret) {
        }

        @Override
        public void onCheckCMRPrivilege(int ret, boolean canStartNow) {
        }
    }

    public static interface IConfUIListener
    extends IListener {
        public boolean onConfStatusChanged(int var1);

        public boolean onConfStatusChanged2(int var1, long var2);

        public boolean onUserStatusChanged(int var1, long var2, int var4);

        public boolean onUserEvent(int var1, long var2, int var4);

        public boolean onChatMessageReceived(String var1, long var2, String var4, long var5, String var7, String var8, long var9);

        public void onClosedCaptionMessageReceived(String var1, String var2, long var3);

        public void onRealtimeClosedCaptionMessageReceived(String var1);

        public void onPTAskToLeave(int var1);

        public void onJoinConfConfirmMeetingInfo(boolean var1, boolean var2, boolean var3);

        public void onJoinConfConfirmPasswordValidateResult(boolean var1, boolean var2);

        public void onJoinConfConfirmMeetingStatus(boolean var1, boolean var2);

        public void onCallTimeOut();

        public void onLaunchConfParamReady();

        public void onDeviceStatusChanged(int var1, int var2);

        public void onAudioSourceTypeChanged(int var1);

        public void onWebinarNeedRegister(boolean var1);

        public void onUpgradeThisFreeMeeting(int var1);

        public void onCheckCMRPrivilege(int var1, boolean var2);
    }
}

