/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.confapp;

import android.os.Process;
import android.os.RemoteException;
import com.zipow.videobox.IPTService;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.ptapp.ConfProcessMgr;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.NumberUtil;

public class ConfIPCPort {
    private static final String TAG = ConfIPCPort.class.getSimpleName();
    private static ConfIPCPort instance = null;
    private long mNativeHandle = 0L;
    private List<byte[]> mSendMessageBuff = new ArrayList<byte[]>();
    private List<byte[]> mReceiveMessageBuff = new ArrayList<byte[]>();

    private ConfIPCPort() {
    }

    public static synchronized ConfIPCPort getInstance() {
        if (instance == null) {
            instance = new ConfIPCPort();
        }
        return instance;
    }

    public static synchronized void clearInstance() {
        instance = null;
    }

    public void initialize() {
        this.nativeInit();
    }

    public boolean sendMessage(byte[] message) {
        if (message == null) {
            return false;
        }
        IPTService ptService = VideoBoxApplication.getInstance().getPTService();
        if (ptService == null) {
            this.mSendMessageBuff.add(message);
            return false;
        }
        boolean success = true;
        try {
            this.sendBufferedMessages(ptService);
            this.sendMessageImpl(message, ptService);
        }
        catch (Exception e) {
            this.mSendMessageBuff.add(message);
            success = false;
        }
        return success;
    }

    public void sendBufferedMessages() {
        IPTService ptService = VideoBoxApplication.getInstance().getPTService();
        if (ptService == null) {
            return;
        }
        try {
            this.sendBufferedMessages(ptService);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void sendBufferedMessages(IPTService ptService) throws RemoteException {
        if (this.mSendMessageBuff.size() > 0) {
            for (int i = 0; i <= this.mSendMessageBuff.size() - 1; ++i) {
                byte[] msgTmp = this.mSendMessageBuff.get(i);
                this.sendMessageImpl(msgTmp, ptService);
            }
            this.mSendMessageBuff.clear();
        }
    }

    public synchronized void onMessageReceived(byte[] message) {
        if (message == null || message.length <= 4) {
            return;
        }
        int myPid = 0;
        myPid = !VideoBoxApplication.getInstance().isSDKMode() ? Process.myPid() : ConfProcessMgr.getInstance().getCurrentConfProcessId();
        int pid = NumberUtil.byteArrayToInt((byte[])message, (int)0);
        if (pid != myPid) {
            return;
        }
        if (this.mNativeHandle == 0L) {
            this.mReceiveMessageBuff.add(message);
            return;
        }
        try {
            this.onMessageReceivedImpl(this.mNativeHandle, message, 4);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    public synchronized void setNativeHandle(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
        this.receiveBufferedMessages();
    }

    private void receiveBufferedMessages() {
        if (this.mReceiveMessageBuff.size() > 0) {
            for (byte[] message : this.mReceiveMessageBuff) {
                try {
                    this.onMessageReceivedImpl(this.mNativeHandle, message, 4);
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
            }
            this.mReceiveMessageBuff.clear();
        }
    }

    private void sendMessageImpl(byte[] message, IPTService ptService) throws RemoteException {
        try {
            int myPid = 0;
            myPid = !VideoBoxApplication.getInstance().isSDKMode() ? Process.myPid() : ConfProcessMgr.getInstance().getCurrentConfProcessId();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            os.write(NumberUtil.intToByteArray((int)myPid));
            os.write(message);
            byte[] buff = os.toByteArray();
            os.close();
            ptService.sendMessage(buff);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private native void nativeInit();

    private native void onMessageReceivedImpl(long var1, byte[] var3, int var4);
}

