/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.confapp;

import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;

public class AttentionTrackEventSinkUI {
    private static final String TAG = AttentionTrackEventSinkUI.class.getSimpleName();
    private static AttentionTrackEventSinkUI instance = null;
    private ListenerList mListenerList = new ListenerList();
    private long mNativeHandle = 0L;

    private AttentionTrackEventSinkUI() {
        this.init();
    }

    private boolean initialized() {
        return this.mNativeHandle != 0L;
    }

    private void init() {
        try {
            this.mNativeHandle = this.nativeInit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected long getNativeHandle() {
        return this.mNativeHandle;
    }

    protected void finalize() throws Throwable {
        if (this.mNativeHandle != 0L) {
            this.nativeUninit(this.mNativeHandle);
        }
        super.finalize();
    }

    public void addListener(IAttentionTrackEventSinkUIListener l) {
        if (l == null) {
            return;
        }
        IListener[] listeners = this.mListenerList.getAll();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != l) continue;
            this.removeListener((IAttentionTrackEventSinkUIListener)listeners[i]);
        }
        this.mListenerList.add((IListener)l);
    }

    public void removeListener(IAttentionTrackEventSinkUIListener l) {
        this.mListenerList.remove((IListener)l);
    }

    public void initialize() {
        this.nativeInit();
    }

    public static synchronized AttentionTrackEventSinkUI getInstance() {
        if (instance == null) {
            instance = new AttentionTrackEventSinkUI();
        }
        if (!instance.initialized()) {
            instance.init();
        }
        return instance;
    }

    public void OnConfAttentionTrackStatusChanged(boolean bEnabled) {
        try {
            this.OnConfAttentionTrackStatusChangedImpl(bEnabled);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void OnConfAttentionTrackStatusChangedImpl(boolean bEnabled) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IAttentionTrackEventSinkUIListener l = (IAttentionTrackEventSinkUIListener)lTmp;
                l.OnConfAttentionTrackStatusChanged(bEnabled);
            }
        }
    }

    public void OnUserAttentionStatusChanged(int nUserID, boolean bInAttentionMode) {
        try {
            this.OnUserAttentionStatusChangedImpl(nUserID, bInAttentionMode);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void OnUserAttentionStatusChangedImpl(int nUserID, boolean bInAttentionMode) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IAttentionTrackEventSinkUIListener l = (IAttentionTrackEventSinkUIListener)lTmp;
                l.OnUserAttentionStatusChanged(nUserID, bInAttentionMode);
            }
        }
    }

    public void OnWebinarAttendeeAttentionStatusChanged(int nUserID, boolean bInAttentionMode) {
        try {
            this.OnWebinarAttendeeAttentionStatusChangedImpl(nUserID, bInAttentionMode);
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void OnWebinarAttendeeAttentionStatusChangedImpl(int nUserID, boolean bInAttentionMode) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener lTmp : listeners) {
                IAttentionTrackEventSinkUIListener l = (IAttentionTrackEventSinkUIListener)lTmp;
                l.OnWebinarAttendeeAttentionStatusChanged(nUserID, bInAttentionMode);
            }
        }
    }

    private native long nativeInit();

    private native void nativeUninit(long var1);

    public static abstract class SimpleAttentionTrackEventSinkUIListener
    implements IAttentionTrackEventSinkUIListener {
        @Override
        public void OnConfAttentionTrackStatusChanged(boolean bEnabled) {
        }

        @Override
        public void OnUserAttentionStatusChanged(int nUserID, boolean bInAttentionMode) {
        }

        @Override
        public void OnWebinarAttendeeAttentionStatusChanged(int nUserID, boolean bInAttentionMode) {
        }
    }

    public static interface IAttentionTrackEventSinkUIListener
    extends IListener {
        public void OnConfAttentionTrackStatusChanged(boolean var1);

        public void OnUserAttentionStatusChanged(int var1, boolean var2);

        public void OnWebinarAttendeeAttentionStatusChanged(int var1, boolean var2);
    }
}

