/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.box;

import com.box.androidsdk.content.models.BoxFolder;
import com.box.androidsdk.content.models.BoxItem;
import java.io.File;
import java.util.Date;
import us.zoom.androidlib.util.StringUtil;

public class BoxFileObject {
    private BoxItem mOwner;
    private String mPath;
    private String mName;
    private long mSize;
    private boolean isFileObject = false;
    private boolean isFolder = false;

    public BoxFileObject(String parentPath, BoxItem obj) {
        if (obj != null) {
            this.mOwner = obj;
            this.isFileObject = true;
            if (StringUtil.isEmptyOrNull((String)parentPath)) {
                parentPath = File.separator;
            }
            this.mName = this.mOwner.getName();
            this.mPath = parentPath.endsWith(File.separator) ? parentPath + this.mName : parentPath + File.separator + this.mName;
            if (obj instanceof BoxFolder) {
                this.isFolder = true;
                this.mSize = 0L;
            } else {
                Long size = this.mOwner.getSize();
                this.mSize = size != null ? size : 0L;
            }
        }
    }

    public String getPath() {
        if (!this.isFileObject) {
            return "";
        }
        return this.mPath;
    }

    public String getName() {
        if (!this.isFileObject) {
            return "";
        }
        return this.mName;
    }

    public Date getLastModifiedDate() {
        if (!this.isFileObject) {
            return null;
        }
        Date date = this.mOwner.getModifiedAt();
        if (date == null) {
            date = this.mOwner.getCreatedAt();
        }
        return date;
    }

    public long getSize() {
        if (!this.isFileObject) {
            return -1L;
        }
        return this.mSize;
    }

    public String getId() {
        if (this.mOwner == null) {
            return "";
        }
        return this.mOwner.getId();
    }

    public boolean isFileObject() {
        return this.isFileObject;
    }

    public boolean isDir() {
        return this.isFolder;
    }
}

