/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.box;

import com.box.androidsdk.content.BoxApiFolder;
import com.box.androidsdk.content.models.BoxFolder;
import com.box.androidsdk.content.models.BoxItem;
import com.box.androidsdk.content.models.BoxListItems;
import com.box.androidsdk.content.requests.BoxRequestsFolder;
import com.zipow.videobox.box.BoxFileObject;
import com.zipow.videobox.box.IBoxLoadFolderListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.ZMAsyncTask;

public class BoxAsyncLoadFolder
extends ZMAsyncTask<Void, Void, Runnable> {
    private BoxApiFolder mApiFolder;
    private BoxFileObject mFolder;
    private String mFolderPath;
    private boolean isByPath;
    private IBoxLoadFolderListener mListener;
    private List<BoxFileObject> mItems = new ArrayList<BoxFileObject>();
    private Exception mException;

    public BoxAsyncLoadFolder(BoxApiFolder apiFolder, BoxFileObject folder, IBoxLoadFolderListener l) {
        this.mApiFolder = apiFolder;
        this.mFolder = folder;
        this.mListener = l;
        this.isByPath = false;
    }

    public BoxAsyncLoadFolder(BoxApiFolder apiFolder, String path, IBoxLoadFolderListener l) {
        this.mApiFolder = apiFolder;
        this.mFolderPath = path;
        this.mListener = l;
        this.isByPath = true;
    }

    public String getPath() {
        String path = null;
        if (this.isByPath) {
            path = this.mFolderPath;
        } else if (this.mFolder != null) {
            path = this.mFolder.getPath();
        }
        return path;
    }

    protected Runnable doInBackground(Void ... params) {
        if (this.mApiFolder == null || !this.isByPath && (this.mFolder == null || !this.mFolder.isDir()) || this.isByPath && StringUtil.isEmptyOrNull((String)this.mFolderPath)) {
            return new onInvalidParameterRunnable();
        }
        if (this.isCancelled()) {
            return new onCancelRunnable();
        }
        BoxListItems result = null;
        try {
            if (!this.isByPath) {
                this.mFolderPath = this.mFolder.getPath();
                result = (BoxListItems)((BoxRequestsFolder.GetFolderItems)this.mApiFolder.getItemsRequest(this.mFolder.getId()).setFields(new String[]{"size", "name", "id", "modified_at", "created_at"})).send();
            } else {
                String folderId = "0";
                if (this.mFolderPath.equals(File.separator)) {
                    result = (BoxListItems)((BoxRequestsFolder.GetFolderItems)this.mApiFolder.getItemsRequest(folderId).setFields(new String[]{"size", "name", "id", "modified_at", "created_at"})).send();
                } else {
                    String[] parts = this.mFolderPath.split(File.separator);
                    BoxItem obj = null;
                    for (int index = 0; index < parts.length; ++index) {
                        if (obj != null) {
                            folderId = obj.getId();
                        }
                        result = (BoxListItems)((BoxRequestsFolder.GetFolderItems)this.mApiFolder.getItemsRequest(folderId).setFields(new String[]{"size", "name", "id", "modified_at", "created_at"})).send();
                        if (index < parts.length - 1 && (obj = this.findObject(result, parts[index + 1])) == null) {
                            return new onErrorRunnable();
                        }
                        if (!this.isCancelled()) continue;
                        return new onCancelRunnable();
                    }
                }
            }
        }
        catch (Exception e) {
            this.mException = e;
            return new onErrorRunnable();
        }
        if (this.isCancelled()) {
            return new onCancelRunnable();
        }
        this.parseResult(result, this.mFolderPath);
        return new onCompletedRunnable();
    }

    protected void onPostExecute(Runnable result) {
        result.run();
    }

    private void parseResult(BoxListItems result, String dir) {
        if (result == null || StringUtil.isEmptyOrNull((String)dir)) {
            return;
        }
        this.mItems.clear();
        for (BoxItem entry : result) {
            BoxFileObject object = new BoxFileObject(dir, entry);
            this.mItems.add(object);
        }
    }

    private BoxItem findObject(BoxListItems collection, String name) {
        if (collection == null || StringUtil.isEmptyOrNull((String)name)) {
            return null;
        }
        for (BoxItem entry : collection) {
            if (!(entry instanceof BoxFolder) || !name.equals(entry.getName())) continue;
            return entry;
        }
        return null;
    }

    private class onInvalidParameterRunnable
    implements Runnable {
        private onInvalidParameterRunnable() {
        }

        @Override
        public void run() {
            BoxAsyncLoadFolder.this.mListener.onError(BoxAsyncLoadFolder.this, BoxAsyncLoadFolder.this.mFolderPath, null);
        }
    }

    private class onCancelRunnable
    implements Runnable {
        private onCancelRunnable() {
        }

        @Override
        public void run() {
            if (BoxAsyncLoadFolder.this.mListener != null) {
                BoxAsyncLoadFolder.this.mListener.onCancel(BoxAsyncLoadFolder.this, BoxAsyncLoadFolder.this.mFolderPath);
            }
        }
    }

    private class onErrorRunnable
    implements Runnable {
        private onErrorRunnable() {
        }

        @Override
        public void run() {
            if (BoxAsyncLoadFolder.this.mListener != null) {
                BoxAsyncLoadFolder.this.mListener.onError(BoxAsyncLoadFolder.this, BoxAsyncLoadFolder.this.mFolderPath, BoxAsyncLoadFolder.this.mException);
            }
        }
    }

    private class onCompletedRunnable
    implements Runnable {
        private onCompletedRunnable() {
        }

        @Override
        public void run() {
            if (BoxAsyncLoadFolder.this.mListener != null) {
                BoxAsyncLoadFolder.this.mListener.onCompeleted(BoxAsyncLoadFolder.this, BoxAsyncLoadFolder.this.isByPath, BoxAsyncLoadFolder.this.mFolderPath, BoxAsyncLoadFolder.this.mFolder, BoxAsyncLoadFolder.this.mItems);
            }
        }
    }
}

