/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox;

import android.app.Application;
import android.content.Context;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.box.BoxMgr;
import com.zipow.videobox.dropbox.ZMAppKeyPair;
import com.zipow.videobox.dropbox.ZMDropbox;
import com.zipow.videobox.googledrive.GoogleDriveMgr;
import com.zipow.videobox.onedrive.OneDriveConfig;
import java.lang.reflect.Method;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class ZoomApplication
extends Application {
    public void onCreate() {
        super.onCreate();
        VideoBoxApplication.initialize((Context)this, false);
        if (VideoBoxApplication.getInstance().isPTApp() && !"us.zoom.videomeetings".equals(this.getPackageName())) {
            this.checkDropboxAppKeyPair();
            this.checkOneDriveClientID();
            this.checkBoxAppKeyPair();
            this.checkGoogleDriveClientInfo();
        }
    }

    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        try {
            Class<?> classMultiDex = Class.forName("android.support.multidex.MultiDex");
            if (classMultiDex == null) {
                return;
            }
            Method method = classMultiDex.getMethod("install", Context.class);
            if (method == null) {
                return;
            }
            method.invoke(classMultiDex, new Object[]{this});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void checkShareCloudFileClientInfo() {
        this.checkDropboxAppKeyPair();
        this.checkOneDriveClientID();
        this.checkOneDriveBusinessClientID();
        this.checkBoxAppKeyPair();
        this.checkGoogleDriveClientInfo();
    }

    private void checkDropboxAppKeyPair() {
        String key = this.getString(R.string.zm_config_dropbox_app_key);
        String secret = this.getString(R.string.zm_config_dropbox_app_secret);
        ZMAppKeyPair oldKeyPair = ZMDropbox.getAppKeyPair((Context)this);
        if (oldKeyPair == null) {
            if (!StringUtil.isEmptyOrNull((String)key) && !StringUtil.isEmptyOrNull((String)secret)) {
                ZMDropbox.setAppKeyPair((Context)this, key, secret);
            }
        } else if (!StringUtil.isSameString((String)key, (String)oldKeyPair.key) || !StringUtil.isSameString((String)secret, (String)oldKeyPair.secret)) {
            ZMDropbox.setAppKeyPair((Context)this, key, secret);
        }
    }

    private void checkOneDriveClientID() {
        String clientId = this.getString(R.string.zm_config_onedrive_app_client_id);
        String oldId = OneDriveConfig.getClientID((Context)this);
        if (oldId == null) {
            if (!StringUtil.isEmptyOrNull((String)clientId)) {
                OneDriveConfig.setClientID((Context)this, clientId);
            }
        } else if (!StringUtil.isSameString((String)oldId, (String)clientId)) {
            OneDriveConfig.setClientID((Context)this, clientId);
        }
    }

    private void checkOneDriveBusinessClientID() {
        String clientId = this.getString(R.string.zm_config_onedrive_business_app_client_id);
        String oldId = OneDriveConfig.getBusinessClientID((Context)this);
        if (oldId == null) {
            if (!StringUtil.isEmptyOrNull((String)clientId)) {
                OneDriveConfig.setBusinessClientID((Context)this, clientId);
            }
        } else if (!StringUtil.isSameString((String)oldId, (String)clientId)) {
            OneDriveConfig.setBusinessClientID((Context)this, clientId);
        }
    }

    private void checkGoogleDriveClientInfo() {
        String clientId = this.getString(R.string.zm_config_googledrive_app_client_id);
        String redirectUrl = this.getString(R.string.zm_config_googledrive_app_redirect_url);
        String oldId = GoogleDriveMgr.getClientID((Context)this);
        String oldRedirectUrl = GoogleDriveMgr.getRedirectURL((Context)this);
        if (StringUtil.isEmptyOrNull((String)oldId) || StringUtil.isEmptyOrNull((String)oldRedirectUrl)) {
            if (!StringUtil.isEmptyOrNull((String)clientId) && !StringUtil.isEmptyOrNull((String)redirectUrl)) {
                GoogleDriveMgr.setClientID((Context)this, clientId);
                GoogleDriveMgr.setRedirectURL((Context)this, redirectUrl);
            }
        } else if (!StringUtil.isSameString((String)oldId, (String)clientId) || !StringUtil.isSameString((String)oldRedirectUrl, (String)redirectUrl)) {
            GoogleDriveMgr.setClientID((Context)this, clientId);
            GoogleDriveMgr.setRedirectURL((Context)this, redirectUrl);
        }
    }

    private void checkBoxAppKeyPair() {
        String key = this.getString(R.string.zm_config_box_app_key);
        String secret = this.getString(R.string.zm_config_box_app_secret);
        String redirectUrl = this.getString(R.string.zm_config_box_app_redirect_url);
        String oldkey = BoxMgr.getAppKey((Context)this);
        String oldSecret = BoxMgr.getAppSecret((Context)this);
        String oldRedirectUrl = BoxMgr.getAppRedirectUrl((Context)this);
        if (StringUtil.isEmptyOrNull((String)oldkey) || StringUtil.isEmptyOrNull((String)oldSecret) || StringUtil.isEmptyOrNull((String)oldRedirectUrl)) {
            if (!(StringUtil.isEmptyOrNull((String)key) || StringUtil.isEmptyOrNull((String)secret) || StringUtil.isEmptyOrNull((String)redirectUrl))) {
                BoxMgr.setAppKeyPair((Context)this, key, secret, redirectUrl);
            }
        } else if (!(StringUtil.isSameString((String)oldkey, (String)key) && StringUtil.isSameString((String)oldSecret, (String)secret) && StringUtil.isSameString((String)oldRedirectUrl, (String)redirectUrl))) {
            BoxMgr.setAppKeyPair((Context)this, key, secret, redirectUrl);
        }
    }

    public void onTerminate() {
        super.onTerminate();
        VideoBoxApplication context = VideoBoxApplication.getInstance();
        context.onApplicationTerminated();
    }
}

