/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Log;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.zipow.videobox.IntegrationActivity;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.NotificationMgr;
import com.zipow.videobox.util.PreferenceUtil;
import java.util.Map;

public class ZMFirebaseMessagingService
extends FirebaseMessagingService {
    private static final String TAG = ZMFirebaseMessagingService.class.getSimpleName();
    private static final long TIMEOUT = 300000L;

    public void onMessageReceived(RemoteMessage remoteMessage) {
        Map data = remoteMessage.getData();
        if (data != null && data.size() > 0) {
            Log.e((String)TAG, (String)("Message data payload: " + remoteMessage.getData()));
            PreferenceUtil.initialize((Context)this);
            boolean bForceDisableGCM = PreferenceUtil.readBooleanValue("forceDisableGCM", false);
            if (bForceDisableGCM) {
                return;
            }
            try {
                ZoomMessenger messenger;
                PTApp ptApp = PTApp.getInstance();
                if (ptApp != null && (messenger = ptApp.getZoomMessenger()) != null && messenger.isConnectionGood()) {
                    return;
                }
            }
            catch (Throwable ptApp) {
                // empty catch block
            }
            String caption = (String)data.get("caption");
            String callBody = (String)data.get("body");
            String callTime = (String)data.get("time");
            String xmppmt = (String)data.get("xmppmt");
            String msgBody = (String)data.get("mb");
            String senderName = (String)data.get("sendername");
            String sessionID = (String)data.get("senderid");
            String xmppmu = (String)data.get("badge");
            if (TextUtils.isEmpty((CharSequence)senderName) || senderName.equals("[\"\"]")) {
                senderName = "";
            }
            if (senderName.startsWith("[\"") && senderName.endsWith("\"]")) {
                senderName = senderName.substring(2, senderName.length() - 2);
            }
            NotificationMgr.NotificationItem notificationItem = null;
            int countOfUnreadMsg = 1;
            int msgType = 1;
            long time = 0L;
            try {
                msgType = Integer.parseInt(xmppmt);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (TextUtils.isEmpty((CharSequence)callBody)) {
                try {
                    countOfUnreadMsg = Integer.parseInt(xmppmu);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                notificationItem = NotificationMgr.generateNotificationItem((Context)this, msgType, senderName, msgBody, countOfUnreadMsg);
                if (notificationItem != null) {
                    NotificationMgr.showMessageNotificationMMImpl((Context)this, true, 0L, countOfUnreadMsg, sessionID, notificationItem);
                }
            } else {
                try {
                    time = Long.parseLong(callTime);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                long currentTime = System.currentTimeMillis();
                long usedTime = currentTime - time;
                if (usedTime < 300000L) {
                    Intent intent = new Intent((Context)this, IntegrationActivity.class);
                    intent.setFlags(0x10000000);
                    intent.setAction(IntegrationActivity.ACTION_NOS_CALL);
                    intent.putExtra("callCaption", caption);
                    intent.putExtra("callBody", callBody);
                    this.startActivity(intent);
                }
            }
        }
    }
}

