/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.service.notification.StatusBarNotification;
import android.support.annotation.RequiresApi;
import android.support.v4.app.NotificationCompat;
import com.zipow.videobox.IntegrationActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.util.NotificationMgr;
import com.zipow.videobox.util.PreferenceUtil;
import us.zoom.androidlib.app.preference.ZMPreferencesStoreUtils;
import us.zoom.androidlib.util.OsUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public abstract class ZMBaseService
extends Service {
    public void onCreate() {
        super.onCreate();
        this.checkStartService();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.checkStartService();
        return 2;
    }

    protected void checkStartService() {
        boolean isMultiProcess;
        VideoBoxApplication videoBoxApplication = VideoBoxApplication.getInstance();
        boolean bl = isMultiProcess = videoBoxApplication == null ? true : videoBoxApplication.isMultiProcess();
        if (OsUtil.isAtLeastO() && ZMPreferencesStoreUtils.getBoolean((Context)this, (String)"PREFERENCE_PROVIDER_DEFAULT_SP_NAME", (String)((Object)((Object)this)).getClass().getName(), (boolean)true, (boolean)isMultiProcess)) {
            if (this.hasNotification(4)) {
                this.showConfNotification();
            } else {
                this.showDefaultForgroundNotification();
            }
        }
    }

    protected void showConfNotification() {
        Intent clickIntent = new Intent((Context)this, IntegrationActivity.class);
        clickIntent.setAction(IntegrationActivity.ACTION_RETURN_TO_CONF);
        PendingIntent contentIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)clickIntent, (int)0x10000000);
        String contentTitle = this.getString(R.string.zm_app_name);
        String contentText = this.getString(R.string.zm_msg_conf_in_progress);
        int smallIcon = R.drawable.zm_conf_notification;
        if (OsUtil.isAtLeastL()) {
            smallIcon = R.drawable.zm_conf_notification_5_0;
        }
        int color2 = this.getResources().getColor(R.color.zm_notification_icon_bg);
        Bitmap largeIcon = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.zm_launcher);
        NotificationCompat.Builder builder = null;
        if (VideoBoxApplication.getInstance().isSDKMode()) {
            builder = new NotificationCompat.Builder(this.getApplicationContext());
            if (OsUtil.isAtLeastO()) {
                String channelId = PreferenceUtil.readStringValue("sdk_conf_notification_channel_id", "");
                if (!StringUtil.isEmptyOrNull((String)channelId)) {
                    builder.setChannelId(channelId);
                } else {
                    builder = NotificationMgr.getNotificationCompatBuilder(this.getApplicationContext(), false);
                }
            }
        } else {
            builder = NotificationMgr.getNotificationCompatBuilder(this.getApplicationContext(), false);
        }
        builder.setWhen(0L).setSmallIcon(smallIcon).setColor(color2).setContentTitle((CharSequence)contentTitle).setContentText((CharSequence)contentText).setOnlyAlertOnce(true).setContentIntent(contentIntent);
        if (OsUtil.isAtLeastL() && this.getResources().getBoolean(R.bool.zm_config_show_large_icon_in_notification_on_api21_above)) {
            builder.setLargeIcon(largeIcon);
        }
        Notification notification = builder.build();
        this.startForeground(4, notification);
    }

    @RequiresApi(api=26)
    private void showDefaultForgroundNotification() {
        NotificationChannel channel = new NotificationChannel("zoom_service_notification_channel_id", (CharSequence)NotificationMgr.getServiceNotificationChannelName(this.getApplicationContext()), 2);
        if (channel.canShowBadge()) {
            channel.setShowBadge(false);
        }
        NotificationManager manager = (NotificationManager)this.getSystemService("notification");
        manager.createNotificationChannel(channel);
        Notification notification = new Notification.Builder(this.getApplicationContext(), "zoom_service_notification_channel_id").build();
        this.startForeground(9, notification);
    }

    private boolean hasNotification(int notificationId) {
        if (OsUtil.isAtLeastM()) {
            try {
                NotificationManager notificationMgr = (NotificationManager)this.getApplicationContext().getSystemService("notification");
                if (notificationMgr != null) {
                    StatusBarNotification[] statusBarNotifications;
                    for (StatusBarNotification notification : statusBarNotifications = notificationMgr.getActiveNotifications()) {
                        if (notification.getId() != notificationId) continue;
                        return true;
                    }
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }
}

