/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.ComponentCallbacks;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.Signature;
import android.net.Uri;
import android.os.Bundle;
import android.os.Debug;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.PowerManager;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.webkit.CookieSyncManager;
import com.zipow.cmmlib.AppContext;
import com.zipow.cmmlib.AppUtil;
import com.zipow.cmmlib.CmmProxySettings;
import com.zipow.cmmlib.Logger;
import com.zipow.videobox.AutoRecoveryUtil;
import com.zipow.videobox.ConfService;
import com.zipow.videobox.IConfService;
import com.zipow.videobox.IPTService;
import com.zipow.videobox.ISIPService;
import com.zipow.videobox.PTService;
import com.zipow.videobox.SIPService;
import com.zipow.videobox.WakeUpMessagesReceiver;
import com.zipow.videobox.confapp.ConfIPCPort;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.nos.NOSMgr;
import com.zipow.videobox.ptapp.IncomingCallManager;
import com.zipow.videobox.ptapp.PT4SIPIPCPort;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTIPCPort;
import com.zipow.videobox.ptapp.delegate.PTAppDelegation;
import com.zipow.videobox.sip.client.SIPIPCPort;
import com.zipow.videobox.sip.server.SipCallManager;
import com.zipow.videobox.stabilility.JavaCrashHandler;
import com.zipow.videobox.stabilility.StabilityService;
import com.zipow.videobox.util.ImageLoader;
import com.zipow.videobox.util.LogUtil;
import com.zipow.videobox.util.NotificationMgr;
import com.zipow.videobox.util.PreferenceUtil;
import com.zipow.videobox.util.UIMgr;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.webrtc.voiceengine.VoiceEngineCompat;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.HardwareUtil;
import us.zoom.androidlib.util.HeadsetUtil;
import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ImageCache;
import us.zoom.androidlib.util.LanguageUtil;
import us.zoom.androidlib.util.ListenerList;
import us.zoom.androidlib.util.OsUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.util.AndroidContext;
import us.zoom.videomeetings.R;
import us.zoom.videomeetings.ZMBuildConfig;

public class VideoBoxApplication
extends ContextWrapper {
    public static final int START_CONF_SERVICE_ERROR_SUCCESS = 0;
    public static final int START_CONF_SERVICE_ERROR_INTERRUPTED = 1;
    public static final int START_CONF_SERVICE_ERROR_WAITING_PID_TIMEOUT = 2;
    public static final int START_CONF_SERVICE_ERROR_WAITING_INIT_TIMEOUT = 3;
    private static final int MAX_PT_LOG_FILES_COUNT = 15;
    private static final int MAX_CONF_LOG_FILES_COUNT = 15;
    private static final int MAX_UTIL_LOG_FILES_COUNT = 15;
    public static final int PROCESS_TYPE_PT = 0;
    public static final int PROCESS_TYPE_CONF = 1;
    public static final int PROCESS_TYPE_STB = 2;
    public static final int PROCESS_TYPE_SIP = 3;
    private static final long ONE_DAY = 86400000L;
    private static final int MAX_COUNT_CRASH_REPORT_IN_ONE_DAY = 3;
    private static String TAG = null;
    private static VideoBoxApplication gInstance = null;
    private static Context gZoomSdkApplication = null;
    private int mProcessType = -1;
    private Timer mMemMonTimer;
    private Handler mHandler = new Handler();
    private boolean mbMessageLoopStopped = false;
    private ServiceConnection mConfServiceConnection = null;
    private IConfService mConfService = null;
    private ServiceConnection mPTServiceConnection = null;
    private IPTService mPTService = null;
    private ISIPService mSIPService = null;
    private ServiceConnection mSipServiceConnection = null;
    private WakeUpMessagesReceiver mWakeUpMessagesReceiver;
    private boolean mbAppInitialized = false;
    private transient boolean mbSDKMode = false;
    private static final String PT_PROCESS_EXT_NAME = "";
    private static final String STD_PROCESS_EXT_NAME = "stb";
    public static final String SIP_PROCESS_EXT_NAME = "sip";
    private static final String CONF_PROCESS_EXT_NAME = "conf";
    private String mConfProcessExtName = "conf";
    private ListenerList mConfProcessListenerList = new ListenerList();
    private Runnable mPTMessageLoopRunnable = new Runnable(){
        long lastDispatchIdleMessageTime = 0L;

        @Override
        public void run() {
            if (VideoBoxApplication.this.mbMessageLoopStopped) {
                return;
            }
            long timeStart = System.currentTimeMillis();
            if (timeStart - this.lastDispatchIdleMessageTime >= 300L || timeStart < this.lastDispatchIdleMessageTime) {
                this.lastDispatchIdleMessageTime = timeStart;
                PTApp.getInstance().dispatchIdleMessage();
                long timeUsed = System.currentTimeMillis() - timeStart;
                if (timeUsed > 300L) {
                    // empty if block
                }
            }
            VideoBoxApplication.this.startPTMessageLoop();
        }
    };
    private Runnable mConfMessageLoopRunnable = new Runnable(){
        long lastDispatchIdleMessageTime = 0L;

        @Override
        public void run() {
            if (VideoBoxApplication.this.mbMessageLoopStopped) {
                return;
            }
            long timeStart = System.currentTimeMillis();
            if (timeStart - this.lastDispatchIdleMessageTime >= 300L || timeStart < this.lastDispatchIdleMessageTime) {
                this.lastDispatchIdleMessageTime = timeStart;
                ConfMgr.getInstance().dispatchIdleMessage();
                long timeUsed = System.currentTimeMillis() - timeStart;
                if (timeUsed > 300L) {
                    // empty if block
                }
            }
            VideoBoxApplication.this.startConfMessageLoop(50L);
        }
    };
    private static final AtomicInteger sNextGeneratedConfId = new AtomicInteger(1);
    private PowerManager.WakeLock mPartialWakeLock = null;
    private static final String ZOOM_APP_SIGNATURE = "308201e53082014ea00302010202044faa0a6b300d06092a864886f70d01010505003036310b300906035504061302555331273025060355040a131e5a6f6f6d20566964656f20436f6d6d756e69636174696f6e7320496e632e3020170d3132303530393036313035315a180f32303632303432373036313035315a3036310b300906035504061302555331273025060355040a131e5a6f6f6d20566964656f20436f6d6d756e69636174696f6e7320496e632e30819f300d06092a864886f70d010101050003818d00308189028181009b463f2d26827dcd115aecc70e5124b9d68cd78e401489c9eae4cd19bc4ca0576ad28168a81f71e8d8b5a7cdc956d937510df3cfa956c28d55668894c33ce08052946ae4af1455becfd2243897f1731fd17a547260c5a52daaebf8ab8a9aad1ad18f99ff696dcf7d713f6540f102c274fbfbc895045f25af67d0fe8dedc536510203010001300d06092a864886f70d0101050500038181000db7990467b840f362bad88c35874abe4d10d3a872356e57581f06fcbac79ebf6d82bb380d14461eded133d9630d77a6b7bcc9953f1ab02437c6317646218b6a37f3c75e833096fa24a473a9b53b1cca4269f0c753ec33239c9a293ea87c27121f424cb9ec1d7765c7fc0c51b7ee2ec4ab9d15a896eeb150ac06fe67086f1c70";

    private VideoBoxApplication(Context context, int processType, String confProcessExtName) {
        super(LanguageUtil.getUpdateLocaleForContext((Context)context));
        if (confProcessExtName != null) {
            this.mConfProcessExtName = confProcessExtName;
        }
        this.mProcessType = processType;
    }

    public static synchronized VideoBoxApplication getInstance() {
        return gInstance;
    }

    public static synchronized void setZoomSDKApplicationContext(Context context) {
        gZoomSdkApplication = context;
    }

    public static synchronized Context getZoomSDKApplicatonContext() {
        return gZoomSdkApplication;
    }

    public static synchronized Context getGlobalContext() {
        if (gInstance != null) {
            return gInstance;
        }
        if (gZoomSdkApplication != null) {
            return gZoomSdkApplication;
        }
        return null;
    }

    public static synchronized void initialize(Context context, boolean isSDKMode) {
        VideoBoxApplication.initialize(context, isSDKMode, VideoBoxApplication.getProcessType(context), null);
    }

    public static synchronized void initialize(Context context, boolean isSDKMode, int processType) {
        VideoBoxApplication.initialize(context, isSDKMode, processType, null);
    }

    public static synchronized void initialize(Context context, boolean isSDKMode, int processType, String confProcessExtName) {
        if (gInstance != null) {
            return;
        }
        gInstance = new VideoBoxApplication(context, processType, confProcessExtName);
        gInstance.onCreated(isSDKMode);
    }

    public boolean isSDKMode() {
        return this.mbSDKMode;
    }

    public boolean isMultiProcess() {
        return !this.mbSDKMode;
    }

    public void addConfProcessListener(IConfProcessListener l) {
        this.mConfProcessListenerList.add((IListener)l);
    }

    public void removeConfProcessListener(IConfProcessListener l) {
        this.mConfProcessListenerList.remove((IListener)l);
    }

    private void onCreated(boolean isSDKMode) {
        AndroidContext.initialize((Context)this);
        AppContext.initialize((Context)this);
        CmmProxySettings.initialize((Context)this);
        if (!isSDKMode) {
            this.initLog();
        } else {
            this.initLogForSDK();
        }
        PreferenceUtil.initialize((Context)this);
        if (!isSDKMode) {
            this.installJavaCrashHandler();
            this.checkTabletOrTvMode();
        }
        HeadsetUtil.getInstance().initialize((Context)this, VoiceEngineCompat.isBluetoothScoSupported());
        this.initApp(isSDKMode);
        UIMgr.initialize((Context)this);
        this.registerComponentCallbacks((ComponentCallbacks)ImageCache.getInstance());
        if (!isSDKMode) {
            ImageLoader.getInstance().init();
        }
    }

    private void checkTabletOrTvMode() {
        boolean isTableOrTvMode = UIUtil.isTabletOrTV((Context)this);
        String path = AppUtil.getDataPath(true, false);
        if (StringUtil.isEmptyOrNull((String)path)) {
            return;
        }
        File file = new File(path, "isTableOrTvMode");
        if (isTableOrTvMode) {
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException iOException) {}
            }
        } else if (file.exists()) {
            file.delete();
        }
    }

    private void initApp(boolean isSDKMode) {
        this.mbSDKMode = isSDKMode;
        if (isSDKMode) {
            this.initAppForSDK();
            return;
        }
        if (this.isPTApp()) {
            this.mbAppInitialized = true;
            NotificationMgr.removeConfNotification((Context)this);
            IncomingCallManager.getInstance().initialize((Context)this);
            NOSMgr.getInstance().initialize((Context)this);
            this.startStabilityService();
            this.removeTempFiles();
            this.connectConfService();
            try {
                CookieSyncManager.createInstance((Context)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.checkAutoRecovery();
            PreferenceUtil.removeValue("camera_is_freezed");
        } else if (this.isConfApp()) {
            this.mbAppInitialized = true;
            NotificationMgr.removeConfNotification((Context)this);
            if (!this.isConfProcessLegal()) {
                this.killConfProcessAfter(1000L);
                return;
            }
            this.setConfProcessLegal(false);
            this.connectPTService();
            this.startStabilityService();
        } else if (this.isSipApp()) {
            this.mbAppInitialized = true;
            this.connectPTService();
        }
    }

    private void initAppForSDK() {
        NotificationMgr.removeConfNotification((Context)this);
        this.removeTempFiles();
        try {
            CookieSyncManager.createInstance((Context)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        PreferenceUtil.removeValue("camera_is_freezed");
        this.initSDKMainboard();
    }

    public void enableWakeUpMessagesReceiver(boolean enabled) {
        try {
            ComponentName component = new ComponentName((Context)this, WakeUpMessagesReceiver.class);
            this.getPackageManager().setComponentEnabledSetting(component, enabled ? 1 : 2, 1);
            if (OsUtil.isAtLeastN()) {
                if (enabled) {
                    if (this.mWakeUpMessagesReceiver == null) {
                        this.mWakeUpMessagesReceiver = new WakeUpMessagesReceiver();
                        VideoBoxApplication.getInstance().registerReceiver(this.mWakeUpMessagesReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
                    }
                } else if (this.mWakeUpMessagesReceiver != null) {
                    this.unregisterReceiver(this.mWakeUpMessagesReceiver);
                    this.mWakeUpMessagesReceiver = null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isWakeUpMessagesReceiverEnabled() {
        int state = 0;
        try {
            ComponentName component = new ComponentName((Context)this, WakeUpMessagesReceiver.class);
            state = this.getPackageManager().getComponentEnabledSetting(component);
        }
        catch (Exception component) {
            // empty catch block
        }
        boolean enabled = state == 1;
        return enabled;
    }

    private void killConfProcessAfter(long ms) {
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                VideoBoxApplication.this.stopConfService();
            }
        }, ms);
    }

    public void initPTMainboard() {
        this.initPTMainboard(false);
    }

    public void initPTMainboard(boolean isSDKMode) {
        Mainboard mainboard;
        if (!this.isPTApp()) {
            return;
        }
        if (!this.isMainThread()) {
            throw new RuntimeException("called from wrong thread");
        }
        this.setPTProcessId(Process.myPid());
        if (!this.mbAppInitialized) {
            this.initApp(isSDKMode);
        }
        if (!(mainboard = Mainboard.getMainboard()).isInitialized()) {
            this.setConfProcessId(-1);
            this.setSipProcessId(-1);
            long startTime = SystemClock.uptimeMillis();
            mainboard.initialize(null);
            this.startPTMessageLoop();
            this.startDeadLockDetector();
            this.initConfServiceUrl();
            if (Logger.getInstance().isEnabled()) {
                this.startMemMonitor();
            }
        }
        this.startPTService(PTService.ACTION_DEAMON);
    }

    public void initConfMainboard(String commandLine) {
        Mainboard mainboard;
        if (!this.isConfApp()) {
            return;
        }
        if (!this.isMainThread()) {
            throw new RuntimeException("called from wrong thread");
        }
        this.setConfProcessId(Process.myPid());
        if (!this.mbAppInitialized) {
            this.initApp(false);
        }
        if (!(mainboard = Mainboard.getMainboard()).isInitialized()) {
            mainboard.initialize(commandLine);
            Logger.getInstance().startNativeLog(true);
            this.startConfMessageLoop(50L);
            this.setConfProcessReadyFlag(true);
            this.startDeadLockDetector();
            if (Logger.getInstance().isEnabled()) {
                this.startMemMonitor();
            }
        }
    }

    public void initSDKMainboard() {
        if (!this.isMainThread()) {
            throw new RuntimeException("called from wrong thread");
        }
        Mainboard mainboard = Mainboard.getMainboard();
        if (!mainboard.isInitialized()) {
            this.setConfProcessId(-1);
            long startTime = SystemClock.uptimeMillis();
            mainboard.initialize(null);
            this.startPTMessageLoop();
            this.startDeadLockDetector();
            this.initConfServiceUrl();
            if (Logger.getInstance().isEnabled()) {
                this.startMemMonitor();
            }
        }
    }

    public void initConfAppForSDK(String commandLine) {
        if (!this.isMainThread()) {
            throw new RuntimeException("called from wrong thread");
        }
        if (!this.isConfProcessLegal()) {
            this.killConfProcessAfter(1000L);
            return;
        }
        this.setConfProcessLegal(false);
        this.connectPTService();
        long startTime = SystemClock.uptimeMillis();
        Mainboard mainboard = Mainboard.getMainboard();
        if (!mainboard.isSDKConfAppCreated()) {
            mainboard.createConfAppForSdk(commandLine);
        }
        this.startConfMessageLoop(50L);
        this.setConfProcessReadyFlag(true);
    }

    private void setConfProcessReadyFlag(boolean ready) {
        File dir = this.getFilesDir();
        if (dir == null) {
            return;
        }
        dir.mkdir();
        if (dir.exists() && dir.isDirectory()) {
            String path = dir.getAbsolutePath();
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            File file = new File(path + "conf_process_ready");
            if (ready) {
                try {
                    file.createNewFile();
                }
                catch (IOException iOException) {}
            } else {
                file.delete();
            }
        }
    }

    public boolean isConfProcessReady() {
        File dir = this.getFilesDir();
        if (dir == null) {
            return true;
        }
        String path = dir.getAbsolutePath();
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        File file = new File(path + "conf_process_ready");
        return file.exists();
    }

    public void setConfUIPreloaded(boolean preloaded) {
        File dir = this.getFilesDir();
        if (dir == null) {
            return;
        }
        dir.mkdir();
        if (dir.exists() && dir.isDirectory()) {
            String path = dir.getAbsolutePath();
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            File file = new File(path + "conf_ui_preloaded");
            if (preloaded) {
                try {
                    file.createNewFile();
                }
                catch (IOException iOException) {}
            } else {
                file.delete();
            }
        }
    }

    public boolean isConfUIPreloaded() {
        File dir = this.getFilesDir();
        if (dir == null) {
            return true;
        }
        String path = dir.getAbsolutePath();
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        File file = new File(path + "conf_ui_preloaded");
        return file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setConfProcessId(int pid) {
        File dir = this.getFilesDir();
        if (dir == null) {
            return;
        }
        dir.mkdir();
        if (dir.exists() && dir.isDirectory()) {
            String path = dir.getAbsolutePath();
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            File file = new File(path + "conf_process_id");
            if (pid > 0) {
                OutputStream os = null;
                try {
                    file.createNewFile();
                    os = new FileOutputStream(file);
                    String pidStr = String.valueOf(pid);
                    ((FileOutputStream)os).write(pidStr.getBytes());
                    ((FileOutputStream)os).close();
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        if (os != null) {
                            os.flush();
                            ((FileOutputStream)os).close();
                        }
                    }
                    catch (Exception exception) {}
                }
            } else {
                file.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConfProcessId() {
        File file;
        File dir = this.getFilesDir();
        if (dir == null) {
            return -1;
        }
        String path = dir.getAbsolutePath();
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        if ((file = new File(path + "conf_process_id")).exists()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(file);
                byte[] b = new byte[is.available()];
                is.read(b);
                String pidStr = new String(b);
                int n = Integer.parseInt(pidStr);
                return n;
            }
            catch (Exception e) {
                int n = -1;
                return n;
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPTProcessId(int pid) {
        File dir = this.getFilesDir();
        if (dir == null) {
            return;
        }
        dir.mkdir();
        if (dir.exists() && dir.isDirectory()) {
            String path = dir.getAbsolutePath();
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            File file = new File(path + "pt_process_id");
            if (pid > 0) {
                FileOutputStream os = null;
                try {
                    os = new FileOutputStream(file);
                    file.createNewFile();
                    String pidStr = String.valueOf(pid);
                    os.write(pidStr.getBytes());
                    os.close();
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        if (os != null) {
                            os.flush();
                            os.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            } else {
                file.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPTProcessId() {
        File file;
        File dir = this.getFilesDir();
        if (dir == null) {
            return -1;
        }
        String path = dir.getAbsolutePath();
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        if ((file = new File(path + "pt_process_id")).exists()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(file);
                byte[] b = new byte[is.available()];
                is.read(b);
                String pidStr = new String(b);
                int n = Integer.parseInt(pidStr);
                return n;
            }
            catch (Exception e) {
                int n = -1;
                return n;
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSipProcessId(int pid) {
        File dir = this.getFilesDir();
        if (dir == null) {
            return;
        }
        dir.mkdir();
        if (dir.exists() && dir.isDirectory()) {
            String path = dir.getAbsolutePath();
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            File file = new File(path + "sip_process_id");
            if (pid > 0) {
                OutputStream os = null;
                try {
                    file.createNewFile();
                    os = new FileOutputStream(file);
                    String pidStr = String.valueOf(pid);
                    ((FileOutputStream)os).write(pidStr.getBytes());
                    ((FileOutputStream)os).close();
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        if (os != null) {
                            os.flush();
                            ((FileOutputStream)os).close();
                        }
                    }
                    catch (Exception exception) {}
                }
            } else {
                file.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSipProcessId() {
        File file;
        File dir = this.getFilesDir();
        if (dir == null) {
            return -1;
        }
        String path = dir.getAbsolutePath();
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        if ((file = new File(path + "sip_process_id")).exists()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(file);
                byte[] b = new byte[is.available()];
                is.read(b);
                String pidStr = new String(b);
                int n = Integer.parseInt(pidStr);
                return n;
            }
            catch (Exception e) {
                int n = -1;
                return n;
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return -1;
    }

    private boolean isMainThread() {
        return Looper.getMainLooper().getThread().getId() == Thread.currentThread().getId();
    }

    private boolean isC2DMUsed() {
        String cachedRegistrationId = PreferenceUtil.readStringValue("gcm_registration_id", null);
        return !StringUtil.isEmptyOrNull((String)cachedRegistrationId);
    }

    private void startStabilityService() {
        if (this.isC2DMUsed()) {
            return;
        }
        if (OsUtil.isAtLeastO()) {
            return;
        }
        Intent i = new Intent();
        i.setClassName(this.getPackageName(), StabilityService.class.getName());
        i.setAction(StabilityService.ACTION_LOG_CRASH);
        try {
            CompatUtils.startService((Context)this, (Intent)i, (!this.isAtFront() ? 1 : 0) != 0, (boolean)this.isMultiProcess());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void notifyStabilityServiceCrashInfo() {
    }

    public void notifyStabilityServiceToProtectPT() {
        if (OsUtil.isAtLeastO()) {
            return;
        }
        Intent i = new Intent();
        i.setClassName(this.getPackageName(), StabilityService.class.getName());
        i.setAction(StabilityService.ACTION_PROTECT_PT);
        try {
            CompatUtils.startService((Context)this, (Intent)i, (!this.isAtFront() ? 1 : 0) != 0, (boolean)this.isMultiProcess());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopStabilityService() {
        Intent i = new Intent();
        i.setClassName(this.getPackageName(), StabilityService.class.getName());
        try {
            this.stopService(i);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initConfServiceUrl() {
        AppContext appContext = new AppContext("config");
        String webServer = appContext.queryWithKey("conf.webserver", AppContext.APP_NAME_CHAT);
        if (webServer != null && webServer.indexOf("www.zoom.us") > 0) {
            appContext.setKeyValue("conf.webserver", null, AppContext.APP_NAME_CHAT);
        }
    }

    public void runOnMainThread(Runnable runnable) {
        if (runnable != null) {
            this.mHandler.post(runnable);
        }
    }

    public void runOnMainThreadDelayed(Runnable runnable, long delayMs) {
        if (runnable != null) {
            this.mHandler.postDelayed(runnable, delayMs);
        }
    }

    public void exit() {
        ZMActivity activity;
        if (Thread.currentThread().getId() == Looper.getMainLooper().getThread().getId() && (activity = ZMActivity.getFrontActivity()) != null) {
            activity.finish();
        }
        this.stopConfService();
        this.stopPTService();
        this.stopStabilityService();
        this.killProcess((Context)this, 0);
    }

    public void restart() {
        ZMActivity activity;
        if (Thread.currentThread().getId() == Looper.getMainLooper().getThread().getId() && (activity = ZMActivity.getFrontActivity()) != null) {
            activity.finish();
        }
        this.stopConfService();
        this.killProcess((Context)this, 0);
    }

    private void onPTServiceConnected(IPTService service) {
        this.mPTService = service;
        if (this.isConfApp() || this.isSDKMode()) {
            ConfIPCPort.getInstance().sendBufferedMessages();
        }
        PTAppDelegation.getInstance().initDelegations();
    }

    private void onPTServiceDisconnected() {
        this.mPTService = null;
        this.mPTServiceConnection = null;
        this.setPTProcessId(-1);
        if (this.isConfApp()) {
            ConfMgr.getInstance().leaveConference();
        }
    }

    private void onConfServiceConnected(IConfService service) {
        this.mConfService = service;
        if (this.isPTApp() || this.isSDKMode()) {
            PTIPCPort.getInstance().sendBufferedMessages();
        }
        this.notifyConfProcessStarted();
    }

    private void onConfServiceDisconnected() {
        this.mConfService = null;
        this.setConfProcessId(-1);
        this.setConfProcessReadyFlag(false);
        NotificationMgr.removeConfNotification((Context)this);
        this.keepPartialWake(false);
        this.notifyConfProcessStopped();
    }

    private void notifyConfProcessStarted() {
        if (this.isConfProcessReady()) {
            IListener[] listeners = this.mConfProcessListenerList.getAll();
            if (listeners != null && listeners.length > 0) {
                for (IListener l : listeners) {
                    IConfProcessListener listener = (IConfProcessListener)l;
                    listener.onConfProcessStarted();
                }
            }
        } else if (this.mConfService != null) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    VideoBoxApplication.this.notifyConfProcessStopped();
                }
            }, 10L);
        }
    }

    private void notifyConfProcessStopped() {
        if (!this.isConfProcessRunning()) {
            IListener[] listeners = this.mConfProcessListenerList.getAll();
            if (listeners != null && listeners.length > 0) {
                for (IListener l : listeners) {
                    IConfProcessListener listener = (IConfProcessListener)l;
                    listener.onConfProcessStopped();
                }
            }
        } else if (this.mConfService == null) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    VideoBoxApplication.this.notifyConfProcessStopped();
                }
            }, 10L);
        }
    }

    private boolean isConfProcessLegal() {
        File dir = this.getFilesDir();
        if (dir == null) {
            return true;
        }
        String path = dir.getAbsolutePath();
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        File file = new File(path + "conf_process_legal");
        return file.exists();
    }

    private void setConfProcessLegal(boolean legal) {
        File dir = this.getFilesDir();
        if (dir == null) {
            return;
        }
        dir.mkdir();
        if (dir.exists() && dir.isDirectory()) {
            String path = dir.getAbsolutePath();
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            File file = new File(path + "conf_process_legal");
            if (legal) {
                try {
                    file.createNewFile();
                }
                catch (IOException iOException) {}
            } else {
                file.delete();
            }
        }
    }

    private void initLogTag() {
        TAG = VideoBoxApplication.class.getSimpleName() + "[";
        TAG = this.isPTApp() ? TAG + "PT" : (this.isConfApp() ? TAG + "Conf" : (this.isStbProcess() ? TAG + "STB" : (this.isSipApp() ? TAG + "SIP" : TAG + "Unknown")));
        TAG = TAG + "]";
    }

    private void startPTMessageLoop() {
        this.mHandler.postDelayed(this.mPTMessageLoopRunnable, 50L);
    }

    private void startConfMessageLoop(long delayed) {
        this.mHandler.postDelayed(this.mConfMessageLoopRunnable, delayed);
    }

    private void stopConfMessageLoop() {
        this.mHandler.removeCallbacks(this.mConfMessageLoopRunnable);
    }

    private void stopMessageLoop() {
        this.mbMessageLoopStopped = true;
    }

    private static int getProcessType(Context context) {
        int myPid = Process.myPid();
        String processName = PT_PROCESS_EXT_NAME;
        ActivityManager activityMgr = (ActivityManager)context.getSystemService("activity");
        List processes = activityMgr.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo process : processes) {
            if (process.pid != myPid) continue;
            processName = process.processName;
        }
        String packageName = context.getPackageName();
        if (PT_PROCESS_EXT_NAME.equals(PT_PROCESS_EXT_NAME) && packageName.equals(processName) || (packageName + ":" + PT_PROCESS_EXT_NAME).equals(processName)) {
            return 0;
        }
        if ((packageName + ":" + CONF_PROCESS_EXT_NAME).equals(processName)) {
            return 1;
        }
        if ((packageName + ":" + STD_PROCESS_EXT_NAME).equals(processName)) {
            return 2;
        }
        if ((packageName + ":" + SIP_PROCESS_EXT_NAME).equals(processName)) {
            return 3;
        }
        return 0;
    }

    public boolean isPTApp() {
        return this.mProcessType == 0;
    }

    public boolean isConfApp() {
        return this.mProcessType == 1;
    }

    public boolean isStbProcess() {
        return this.mProcessType == 2;
    }

    public void onApplicationTerminated() {
        this.stopMessageLoop();
        this.stopMemMonitor();
    }

    public void startPTService(String action) {
        Intent i = new Intent();
        i.setClassName(this.getPackageName(), PTService.class.getName());
        i.setAction(action);
        CompatUtils.startService((Context)this, (Intent)i, (!this.isAtFront() ? 1 : 0) != 0, (boolean)this.isMultiProcess());
    }

    public void stopPTService() {
        Intent i = new Intent();
        i.setClassName(this.getPackageName(), PTService.class.getName());
        try {
            this.stopService(i);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int startConfService(Bundle args) {
        int count;
        if (this.isSDKMode()) {
            return this.startConfServiceForSDK(args);
        }
        if (this.isConfApp()) {
            Intent i = new Intent();
            i.setClassName(this.getPackageName(), ConfService.class.getName());
            if (args != null) {
                i.putExtra("args", args);
            }
            CompatUtils.startService((Context)this, (Intent)i, (!this.isAtFront() ? 1 : 0) != 0, (boolean)this.isMultiProcess());
            return 0;
        }
        if (this.mConfServiceConnection != null) {
            try {
                this.unbindService(this.mConfServiceConnection);
            }
            catch (Exception i) {
                // empty catch block
            }
            this.mConfServiceConnection = null;
            this.mConfService = null;
            this.setConfProcessId(-1);
            this.setConfProcessReadyFlag(false);
        }
        Intent intentStop = new Intent();
        intentStop.setClassName(this.getPackageName(), ConfService.class.getName());
        try {
            this.stopService(intentStop);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setConfProcessLegal(true);
        Intent i = new Intent();
        i.setClassName(this.getPackageName(), ConfService.class.getName());
        if (args != null) {
            i.putExtra("args", args);
        }
        CompatUtils.startService((Context)this, (Intent)i, (!this.isAtFront() ? 1 : 0) != 0, (boolean)this.isMultiProcess());
        this.connectConfService();
        for (count = 0; !this.isConfProcessRunning() && count < 200; ++count) {
            try {
                Thread.sleep(20L);
                continue;
            }
            catch (InterruptedException e) {
                return 1;
            }
        }
        for (count = 0; !this.isConfProcessReady() && count < 100; ++count) {
            try {
                Thread.sleep(20L);
                continue;
            }
            catch (InterruptedException e) {
                return 1;
            }
        }
        if (!this.isConfProcessRunning()) {
            return 2;
        }
        if (!this.isConfProcessReady()) {
            return 3;
        }
        this.keepPartialWake(true);
        return 0;
    }

    public int startConfServiceForSDK(Bundle args) {
        if (this.mPTServiceConnection != null) {
            try {
                this.unbindService(this.mPTServiceConnection);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mPTServiceConnection = null;
            this.mPTService = null;
        }
        Intent intentStopPT = new Intent();
        intentStopPT.setClassName(this.getPackageName(), PTService.class.getName());
        try {
            this.stopService(intentStopPT);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.startPTService(PTService.ACTION_DEAMON);
        this.connectPTService();
        if (this.mConfServiceConnection != null) {
            try {
                this.unbindService(this.mConfServiceConnection);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mConfServiceConnection = null;
            this.mConfService = null;
            this.setConfProcessId(-1);
            this.setConfProcessReadyFlag(false);
        }
        Intent intentStop = new Intent();
        intentStop.setClassName(this.getPackageName(), ConfService.class.getName());
        try {
            this.stopService(intentStop);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setConfProcessLegal(true);
        Intent i = new Intent();
        i.setClassName(this.getPackageName(), ConfService.class.getName());
        if (args != null) {
            i.putExtra("args", args);
        }
        this.startService(i);
        this.connectConfService();
        this.setConfProcessId(VideoBoxApplication.generateConfProcessId());
        return 0;
    }

    private static int generateConfProcessId() {
        int newValue;
        int result;
        do {
            if ((newValue = (result = sNextGeneratedConfId.get()) + 1) <= 0xFFFFFF) continue;
            newValue = 1;
        } while (!sNextGeneratedConfId.compareAndSet(result, newValue));
        return result;
    }

    public boolean hasPTProcess() {
        return this.getPidByProcessType(0) > 0;
    }

    public boolean isConfProcessRunning() {
        if (this.isSDKMode()) {
            return this.getConfProcessId() > 0;
        }
        return VideoBoxApplication.getPidByName((Context)this, this.getPackageName() + ":" + this.mConfProcessExtName) > 0;
    }

    public boolean isProcessRunning(int pid) {
        if (pid <= 0) {
            return false;
        }
        ActivityManager activityMgr = (ActivityManager)this.getSystemService("activity");
        List processes = activityMgr.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo process : processes) {
            if (process.pid != pid) continue;
            return true;
        }
        return false;
    }

    public void stopConfService() {
        Mainboard mainboard;
        if (this.isSDKMode()) {
            this.stopConfServiceForSDK();
            return;
        }
        NotificationMgr.removeConfNotification((Context)this);
        PTIPCPort.getInstance().setNativeHandle(0L);
        this.clearConfAppContext();
        if (this.mConfServiceConnection != null) {
            try {
                this.unbindService(this.mConfServiceConnection);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mConfServiceConnection = null;
            this.mConfService = null;
            this.setConfProcessReadyFlag(false);
        }
        if ((mainboard = Mainboard.getMainboard()) != null && mainboard.isInitialized()) {
            mainboard.notifyConfProcessExitCorrectly();
        }
        Intent i = new Intent();
        i.setClassName(this.getPackageName(), ConfService.class.getName());
        try {
            this.stopService(i);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.killConfProcess();
    }

    public void stopConfServiceForSDK() {
        NotificationMgr.removeConfNotification((Context)this);
        PTIPCPort.getInstance().setNativeHandle(0L);
        this.clearConfAppContext();
        if (this.mConfServiceConnection != null) {
            try {
                this.unbindService(this.mConfServiceConnection);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mConfServiceConnection = null;
            this.mConfService = null;
            this.setConfProcessReadyFlag(false);
        }
        this.stopConfMessageLoop();
        Intent i = new Intent();
        i.setClassName(this.getPackageName(), ConfService.class.getName());
        try {
            this.stopService(i);
        }
        catch (Exception exception) {
            // empty catch block
        }
        final Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard != null && mainboard.isInitialized()) {
            mainboard.notifyConfProcessExitCorrectly();
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mainboard.termConfAppForSDK();
                    VideoBoxApplication.this.setConfProcessId(-1);
                    VideoBoxApplication.this.notifyConfProcessStopped();
                    if (VideoBoxApplication.this.mPTServiceConnection != null) {
                        try {
                            VideoBoxApplication.this.unbindService(VideoBoxApplication.this.mPTServiceConnection);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        VideoBoxApplication.this.mPTServiceConnection = null;
                        VideoBoxApplication.this.mPTService = null;
                    }
                    VideoBoxApplication.this.stopPTService();
                }
            });
        }
    }

    public void clearConfAppContext() {
        this.setConfProcessReadyFlag(false);
    }

    public void killConfProcess() {
        if (this.isConfApp()) {
            this.setConfProcessId(-1);
            Runtime.getRuntime().exit(0);
            return;
        }
        int confPid = this.getConfProcessId();
        this.killProcess((Context)this, 1);
        while (this.isProcessRunning(confPid)) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void killCurrentProcess() {
        if (this.isPTApp()) {
            if (!PTApp.getInstance().isPhoneNumberRegistered()) {
                NotificationMgr.removeMessageNotificationMM((Context)this);
            }
            this.setPTProcessId(-1);
        } else if (this.isConfApp()) {
            NotificationMgr.removeConfNotification((Context)this);
            this.setConfProcessId(-1);
        } else if (this.isSipApp()) {
            this.setSipProcessId(-1);
        }
        int myPid = Process.myPid();
        Process.killProcess((int)myPid);
    }

    private void connectConfService() {
        if (this.mConfService != null) {
            return;
        }
        if (this.mConfServiceConnection == null) {
            this.mConfServiceConnection = new ServiceConnection(){

                public void onServiceConnected(ComponentName componentName, IBinder serviceBounder) {
                    IConfService service = IConfService.Stub.asInterface(serviceBounder);
                    VideoBoxApplication.this.onConfServiceConnected(service);
                }

                public void onServiceDisconnected(ComponentName name) {
                    VideoBoxApplication.this.onConfServiceDisconnected();
                }
            };
        }
        Intent i = new Intent();
        i.setClassName(this.getPackageName(), ConfService.class.getName());
        boolean ret = this.bindService(i, this.mConfServiceConnection, 64);
    }

    public IConfService getConfService() {
        return this.mConfService;
    }

    private void connectPTService() {
        if (this.mPTService != null) {
            return;
        }
        if (this.mPTServiceConnection == null) {
            this.mPTServiceConnection = new ServiceConnection(){

                public void onServiceConnected(ComponentName componentName, IBinder serviceBounder) {
                    IPTService service = IPTService.Stub.asInterface(serviceBounder);
                    VideoBoxApplication.this.onPTServiceConnected(service);
                }

                public void onServiceDisconnected(ComponentName name) {
                    VideoBoxApplication.this.onPTServiceDisconnected();
                }
            };
        }
        Intent i = new Intent();
        i.setClassName(this.getPackageName(), PTService.class.getName());
        boolean ret = this.bindService(i, this.mPTServiceConnection, 64);
    }

    public IPTService getPTService() {
        return this.mPTService;
    }

    public boolean isAtFront() {
        ZMActivity frontActivity = ZMActivity.getFrontActivity();
        if (frontActivity != null && frontActivity.isActive()) {
            return true;
        }
        if (this.isConfApp()) {
            IPTService ptService = this.getPTService();
            if (ptService != null) {
                try {
                    if (ptService.isPTAppAtFront()) {
                        return true;
                    }
                }
                catch (RemoteException remoteException) {}
            }
        } else {
            IConfService confService = this.getConfService();
            if (confService != null) {
                try {
                    if (confService.isConfAppAtFront()) {
                        return true;
                    }
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    private void printMemoryCPU() {
        if (!Logger.getInstance().isEnabled() || Logger.getInstance().getLevel() > 1) {
            return;
        }
        String info = VideoBoxApplication.getMemoryCPUStatistics();
    }

    public static String getMemoryCPUStatistics() {
        VideoBoxApplication context = VideoBoxApplication.getInstance();
        if (context == null) {
            return PT_PROCESS_EXT_NAME;
        }
        ActivityManager activityMgr = (ActivityManager)context.getSystemService("activity");
        if (activityMgr == null) {
            return PT_PROCESS_EXT_NAME;
        }
        int pid = Process.myPid();
        Debug.MemoryInfo[] infos = activityMgr.getProcessMemoryInfo(new int[]{pid});
        if (infos == null || infos.length != 1) {
            return PT_PROCESS_EXT_NAME;
        }
        Debug.MemoryInfo memInfo = infos[0];
        if (memInfo == null) {
            return PT_PROCESS_EXT_NAME;
        }
        ActivityManager.MemoryInfo actMemInfo = new ActivityManager.MemoryInfo();
        activityMgr.getMemoryInfo(actMemInfo);
        long free = Runtime.getRuntime().freeMemory();
        long heap = Runtime.getRuntime().totalMemory();
        long max = Runtime.getRuntime().maxMemory();
        long allocated = heap - free;
        long nativeFree = Debug.getNativeHeapFreeSize();
        long nativeHeap = Debug.getNativeHeapSize();
        long nativeAlloc = Debug.getNativeHeapAllocatedSize();
        int cpuFreq = HardwareUtil.getCPUKernelFrequency((int)0, (int)0);
        String info = String.format(Locale.US, "Mem: PSS=%d, SharedDirty=%d, PrivateDirty=%d (Dalvik:[%d, %d, %d]; Native:[%d, %d, %d]; Other:[%d, %d, %d])\nHeap: dalvik[Max=%.2fM, Free=%.2fM, Heap=%.2fM, Allocated=%.2fM], native[Free=%.2fM, Heap=%.2fM, Allocated=%.2fM]\nActMem: availMem=%d, lowMemory=%b, threshold=%d\nCPU Freq: %d", memInfo.getTotalPss(), memInfo.getTotalSharedDirty(), memInfo.getTotalPrivateDirty(), memInfo.dalvikPss, memInfo.dalvikSharedDirty, memInfo.dalvikPrivateDirty, memInfo.nativePss, memInfo.nativeSharedDirty, memInfo.nativePrivateDirty, memInfo.otherPss, memInfo.otherSharedDirty, memInfo.otherPrivateDirty, Float.valueOf((float)max / 1024.0f / 1024.0f), Float.valueOf((float)free / 1024.0f / 1024.0f), Float.valueOf((float)heap / 1024.0f / 1024.0f), Float.valueOf((float)allocated / 1024.0f / 1024.0f), Float.valueOf((float)nativeFree / 1024.0f / 1024.0f), Float.valueOf((float)nativeHeap / 1024.0f / 1024.0f), Float.valueOf((float)nativeAlloc / 1024.0f / 1024.0f), actMemInfo.availMem, actMemInfo.lowMemory, actMemInfo.threshold, cpuFreq);
        return info;
    }

    private void startMemMonitor() {
        try {
            this.mMemMonTimer = new Timer();
            this.mMemMonTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    VideoBoxApplication.this.printMemoryCPU();
                }
            }, 0L, 10000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stopMemMonitor() {
        if (this.mMemMonTimer != null) {
            this.mMemMonTimer.cancel();
        }
    }

    private static int getPidByName(Context context, String processName) {
        int id2 = -1;
        ActivityManager activityMgr = (ActivityManager)context.getSystemService("activity");
        List processes = activityMgr.getRunningAppProcesses();
        if (processes == null) {
            return 0;
        }
        for (ActivityManager.RunningAppProcessInfo process : processes) {
            if (process == null || !processName.equals(process.processName)) continue;
            id2 = process.pid;
        }
        return id2;
    }

    private int getPidByProcessType(int processType) {
        int id2 = -1;
        if (processType == 0) {
            return this.getPTProcessId();
        }
        if (processType == 1) {
            return this.getConfProcessId();
        }
        if (processType == 3) {
            return this.getSipProcessId();
        }
        return id2;
    }

    public void killProcess(Context context, int processType) {
        int pid = this.getPidByProcessType(processType);
        if (pid > 0) {
            Process.killProcess((int)pid);
            if (processType == 0) {
                this.setPTProcessId(-1);
            } else if (processType == 1) {
                this.setConfProcessId(-1);
            } else if (processType == 3) {
                this.setSipProcessId(-1);
            }
        }
    }

    private void removeTempFiles() {
        if (!this.isConfProcessRunning()) {
            File fDir = new File(AppUtil.getDataPath());
            this.removeTmpFiles(fDir);
        }
    }

    private void removeTmpFiles(File fDir) {
        if (!fDir.exists()) {
            return;
        }
        File[] files = fDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String fileName = pathname.getName();
                return fileName.endsWith(".tmp") || fileName.startsWith("tmp-");
            }
        });
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                files[i].delete();
            }
        }
    }

    private void removeOldestPTLogs() {
        this.removeOldestLogs("zChatApp", ".log", 15);
    }

    private void removeOldestConfLogs() {
        this.removeOldestLogs("zVideoApp", ".log", 15);
    }

    private void removeOldestUtilLogs() {
        this.removeOldestLogs("util", ".log", 15);
    }

    private void removeOldestCrashLogs() {
        this.removeOldestLogs("crash-java-", ".log.sent", 4);
        this.removeOldestLogs("crash-native-", ".log.sent", 4);
        this.removeOldestLogs("crash-", ".log", 4);
        this.removeOldestLogs("freeze-", ".log", 4);
        this.removeOldestLogs("freeze-", ".log.sent", 4);
        this.removeOldestLogs("crash-", ".gz", 4);
        this.removeOldestLogs("crash-", ".gz.sent", 4);
    }

    private void removeOldestASLogs() {
        this.removeOldestLogs("cptshare-", ".log", 15);
    }

    private void removeOldestLogs(final String prefix, final String sufix, int maxCount) {
        String dir = AppUtil.getLogParentPath() + "/logs";
        File fDir = new File(dir);
        if (!fDir.exists()) {
            return;
        }
        LogUtil.removeOldestLogFiles(maxCount, fDir, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String fileName = pathname.getName();
                return fileName.startsWith(prefix) && fileName.endsWith(sufix);
            }
        });
    }

    private void restrictCrashReportFrequency() {
        String dir = AppUtil.getLogParentPath() + "/logs";
        File fDir = new File(dir);
        if (!fDir.exists()) {
            return;
        }
        File[] files = fDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file == null || !file.isFile()) {
                    return false;
                }
                String fileName = file.getName();
                long time = file.lastModified();
                return fileName.startsWith("crash-") && System.currentTimeMillis() - time < 86400000L;
            }
        });
        if (files != null && files.length > 3) {
            int countSent = 0;
            for (File file : files) {
                if (file == null || !file.getName().endsWith(".sent")) continue;
                ++countSent;
            }
            int countNoneSent = files.length - countSent;
            int allowSent = 3 - countSent;
            if (allowSent < 0) {
                allowSent = 0;
            }
            if (countNoneSent > allowSent) {
                for (File file : files) {
                    if (file == null || file.getName().endsWith(".sent")) continue;
                    file.renameTo(new File(file.getAbsolutePath() + ".sent"));
                    if (--countNoneSent <= allowSent) break;
                }
            }
        }
    }

    private void initLog() {
        this.initLogTag();
        Logger logger = Logger.getInstance();
        if (this.isPTApp()) {
            this.removeOldestCrashLogs();
            this.removeOldestPTLogs();
            this.removeOldestConfLogs();
            this.removeOldestUtilLogs();
            this.removeOldestASLogs();
            this.removeOldestSIPLogs();
            this.restrictCrashReportFrequency();
        }
    }

    private void initLogForSDK() {
        TAG = VideoBoxApplication.class.getSimpleName() + "[SDK]";
        Logger logger = Logger.getInstance();
        this.removeOldestCrashLogs();
        this.removeOldestPTLogs();
        this.removeOldestConfLogs();
        this.removeOldestUtilLogs();
        this.removeOldestASLogs();
        this.removeOldestSIPLogs();
        this.restrictCrashReportFrequency();
    }

    private void installJavaCrashHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new JavaCrashHandler(Thread.getDefaultUncaughtExceptionHandler()));
    }

    public String getVersionName() {
        return this.getString(R.string.zm_display_version);
    }

    public String getKernelVersion() {
        return this.getString(R.string.zm_version_name);
    }

    private void startDeadLockDetector() {
        AppContext appContext = new AppContext("config");
        String disableDeadlockDetect = appContext.queryWithKey("com.zoom.test.disable_deadlock_detect", AppContext.APP_NAME_CHAT);
        if ("yes".equals(disableDeadlockDetect) || HardwareUtil.getCPUKernalNumbers() <= 1 || HardwareUtil.getCPUKernelFrequency((int)0, (int)2) > 1000000) {
            // empty if block
        }
    }

    public void keepPartialWake(boolean keep) {
        try {
            PowerManager pm = (PowerManager)this.getSystemService("power");
            if (pm == null) {
                return;
            }
            if (this.mPartialWakeLock == null) {
                if (!keep) {
                    return;
                }
                this.mPartialWakeLock = pm.newWakeLock(1, ((Object)((Object)this)).getClass().getName());
                if (this.mPartialWakeLock == null) {
                    return;
                }
            }
            if (keep) {
                if (!this.mPartialWakeLock.isHeld()) {
                    this.mPartialWakeLock.acquire();
                }
            } else {
                if (this.mPartialWakeLock.isHeld()) {
                    this.mPartialWakeLock.release();
                }
                this.mPartialWakeLock = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void checkAutoRecovery() {
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (ZMActivity.hasActivityCreated()) {
                    return;
                }
                if (WakeUpMessagesReceiver.hasMessageReceived()) {
                    return;
                }
                if (VideoBoxApplication.this.isC2DMUsed()) {
                    VideoBoxApplication.this.exit();
                    return;
                }
                AutoRecoveryUtil.getInstance().autoRecovery((Context)VideoBoxApplication.this);
            }
        }, 3000L);
    }

    private Signature[] getSignatures() {
        try {
            PackageInfo packageInfo = this.getPackageManager().getPackageInfo(this.getPackageName(), 64);
            if (packageInfo != null) {
                return packageInfo.signatures;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public boolean isValidSignature() {
        if (ZMBuildConfig.BUILD_TARGET != 0) {
            return true;
        }
        Signature[] signatures = this.getSignatures();
        if (signatures == null) {
            return false;
        }
        for (Signature signature : signatures) {
            if (!signature.toCharsString().equals(ZOOM_APP_SIGNATURE)) continue;
            return true;
        }
        return false;
    }

    private void removeOldestSIPLogs() {
        this.removeOldestLogs("zSipApp", ".log", 15);
    }

    public void initSipMainborad() {
        this.initSipMainborad(false);
    }

    public void initSipMainborad(boolean isSDKMode) {
        Mainboard mainboard;
        if (!this.isSipApp()) {
            return;
        }
        if (!this.isMainThread()) {
            throw new RuntimeException("called from wrong thread");
        }
        this.setSipProcessId(Process.myPid());
        if (!this.mbAppInitialized) {
            this.initApp(isSDKMode);
        }
        if (!(mainboard = Mainboard.getMainboard()).isInitialized()) {
            long startTime = SystemClock.uptimeMillis();
            mainboard.initialize(null);
            this.startDeadLockDetector();
            if (Logger.getInstance().isEnabled()) {
                this.startMemMonitor();
            }
            this.setSipProcessReadyFlag(true);
        }
    }

    private void setSipProcessReadyFlag(boolean ready) {
        File dir = this.getFilesDir();
        if (dir == null) {
            return;
        }
        dir.mkdir();
        if (dir.exists() && dir.isDirectory()) {
            String path = dir.getAbsolutePath();
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            File file = new File(path + "sip_process_ready");
            if (ready) {
                try {
                    file.createNewFile();
                }
                catch (IOException iOException) {}
            } else {
                file.delete();
            }
        }
    }

    public boolean isSipProcessReady() {
        File dir = this.getFilesDir();
        if (dir == null) {
            return true;
        }
        String path = dir.getAbsolutePath();
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        File file = new File(path + "sip_process_ready");
        return file.exists();
    }

    public void startSIPService(final String action) {
        if (this.mSipServiceConnection != null) {
            try {
                this.unbindService(this.mSipServiceConnection);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mSipServiceConnection = null;
            this.mSIPService = null;
            this.setSipProcessReadyFlag(false);
        }
        Intent intentStop = new Intent();
        intentStop.setClassName(this.getPackageName(), SIPService.class.getName());
        boolean ret = false;
        try {
            ret = this.stopService(intentStop);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setSipProcessReadyFlag(true);
        if (ret) {
            this.runOnMainThreadDelayed(new Runnable(){

                @Override
                public void run() {
                    VideoBoxApplication.this.doStartSIPService(action);
                }
            }, 10L);
        } else {
            this.doStartSIPService(action);
        }
    }

    private void doStartSIPService(String action) {
        Intent i = new Intent();
        i.setClassName(this.getPackageName(), SIPService.class.getName());
        i.setAction(action);
        CompatUtils.startService((Context)this, (Intent)i, (!this.isAtFront() ? 1 : 0) != 0, (boolean)this.isMultiProcess());
        this.connectSIPService();
    }

    public void stopSIPService() {
        if (this.mSipServiceConnection != null) {
            try {
                this.unbindService(this.mSipServiceConnection);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mSipServiceConnection = null;
            this.setSipProcessReadyFlag(false);
        }
        this.mSIPService = null;
        Intent i = new Intent();
        i.setClassName(this.getPackageName(), SIPService.class.getName());
        try {
            this.stopService(i);
        }
        catch (Exception exception) {
            // empty catch block
        }
        PT4SIPIPCPort.getInstance().setNativeHandle(0L);
    }

    private void onSIPServiceConnected(ISIPService service) {
        this.mSIPService = service;
        if (this.isPTApp()) {
            SipCallManager.getInstance().onSipCallServiceStarted();
            SIPIPCPort.getInstance().sendBufferedMessages();
        }
    }

    private void onSIPServiceDisconnected() {
        this.mSIPService = null;
        this.mPTServiceConnection = null;
        this.setSipProcessId(-1);
        this.setSipProcessReadyFlag(false);
        SipCallManager.getInstance().onSipCallServiceStoped();
        if (this.isPTApp()) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    SipCallManager.getInstance().initSIPCall();
                }
            }, 10L);
        }
    }

    public boolean isSipApp() {
        return this.mProcessType == 3;
    }

    public boolean isSipProcessRunning() {
        return this.getSipProcessId() > 0;
    }

    public void killSipProcess() {
        if (this.isSipApp()) {
            this.setSipProcessId(-1);
            Runtime.getRuntime().exit(0);
            return;
        }
        this.killProcess((Context)this, 3);
        while (this.isProcessRunning(this.getSipProcessId())) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void connectSIPService() {
        if (this.mSIPService != null) {
            return;
        }
        if (this.mSipServiceConnection == null) {
            this.mSipServiceConnection = new ServiceConnection(){

                public void onServiceConnected(ComponentName componentName, IBinder serviceBounder) {
                    ISIPService service = ISIPService.Stub.asInterface(serviceBounder);
                    VideoBoxApplication.this.onSIPServiceConnected(service);
                }

                public void onServiceDisconnected(ComponentName name) {
                    VideoBoxApplication.this.onSIPServiceDisconnected();
                }
            };
        }
        Intent i = new Intent();
        i.setClassName(this.getPackageName(), SIPService.class.getName());
        boolean ret = this.bindService(i, this.mSipServiceConnection, 64);
    }

    public ISIPService getSIPService() {
        return this.mSIPService;
    }

    @TargetApi(value=23)
    @SuppressLint(value={"InlinedApi"})
    public void requestIgnoreBatteryOptimization() {
        PowerManager powerMgr;
        if (OsUtil.isAtLeastM() && (powerMgr = (PowerManager)this.getSystemService("power")) != null && !powerMgr.isIgnoringBatteryOptimizations(this.getPackageName())) {
            try {
                Intent intent = new Intent("android.settings.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS");
                intent.setData(Uri.parse((String)("package:" + this.getPackageName())));
                intent.addFlags(0x10000000);
                this.startActivity(intent);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static interface IConfProcessListener
    extends IListener {
        public void onConfProcessStarted();

        public void onConfProcessStopped();
    }
}

