/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.view.MotionEvent;
import android.view.View;
import com.zipow.videobox.SimpleInMeetingActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.mainboard.Mainboard;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.ZMLog;
import us.zoom.androidlib.widget.ZMIgnoreKeyboardLayout;
import us.zoom.androidlib.widget.ZMKeyboardDetector;
import us.zoom.androidlib.widget.ZMTipLayer;
import us.zoom.videomeetings.R;

public class SimpleActivity
extends ZMActivity
implements ZMKeyboardDetector.KeyboardListener {
    public static final int PROCESS_AUTO = 0;
    public static final int PROCESS_PT = 1;
    public static final int PROCESS_CONF = 2;
    private static final String TAG = SimpleActivity.class.getSimpleName();
    private static final String ARG_FRAGMENT_CLASS = "fragmentClass";
    private static final String ARG_FRAGMENT_ARGUMENTS = "fragmentArguments";
    private static final String ARG_FRAGMENT_ANIMA_TYPE = "animType";
    private static final String ARG_LAYOUT_IGNORE_KEYBORAD = "layoutIgnoreKeyboard";
    public static final int LEFT_RIGHT_ANIMA = 0;
    public static final int BOTTOM_TOP_ANIMA = 1;
    public static final int ALPHA_ANIMA = 2;
    private int animType;
    private String mFragmentTag = null;
    private ZMKeyboardDetector mKeyboardDetector;
    private ZMTipLayer mTipLayer;
    private ZMIgnoreKeyboardLayout mFragmentContent;

    private static Class<?> getSimpleActivityClass(int processType) {
        if (processType == 1) {
            return SimpleActivity.class;
        }
        if (processType == 2) {
            return SimpleInMeetingActivity.class;
        }
        if (VideoBoxApplication.getInstance().isConfApp()) {
            return SimpleInMeetingActivity.class;
        }
        return SimpleActivity.class;
    }

    public static void show(ZMActivity activity, String fragmentClass, Bundle args, int requestCode) {
        SimpleActivity.show(activity, fragmentClass, args, requestCode, 0);
    }

    public static void show(ZMActivity activity, String fragmentClass, Bundle args, int requestCode, int processType) {
        Intent intent = new Intent((Context)activity, SimpleActivity.getSimpleActivityClass(processType));
        intent.putExtra(ARG_FRAGMENT_CLASS, fragmentClass);
        intent.putExtra(ARG_FRAGMENT_ARGUMENTS, args);
        activity.startActivityForResult(intent, requestCode);
        activity.overridePendingTransition(R.anim.zm_slide_in_right, R.anim.zm_slide_out_left);
    }

    public static void show(ZMActivity activity, String fragmentClass, Bundle args, int requestCode, boolean animBottomTop) {
        SimpleActivity.show(activity, fragmentClass, args, requestCode, animBottomTop, 0);
    }

    public static void show(ZMActivity activity, String fragmentClass, Bundle args, int requestCode, boolean animBottomTop, int processType) {
        SimpleActivity.show(activity, fragmentClass, args, requestCode, animBottomTop, false, processType);
    }

    public static void show(ZMActivity activity, String fragmentClass, Bundle args, int requestCode, boolean animBottomTop, boolean layoutIgnoreKeyboard) {
        SimpleActivity.show(activity, fragmentClass, args, requestCode, animBottomTop, layoutIgnoreKeyboard, 0);
    }

    public static void show(ZMActivity activity, String fragmentClass, Bundle args, int requestCode, boolean animBottomTop, boolean layoutIgnoreKeyboard, int processType) {
        Intent intent = new Intent((Context)activity, SimpleActivity.getSimpleActivityClass(processType));
        intent.putExtra(ARG_FRAGMENT_CLASS, fragmentClass);
        intent.putExtra(ARG_FRAGMENT_ARGUMENTS, args);
        intent.putExtra(ARG_LAYOUT_IGNORE_KEYBORAD, layoutIgnoreKeyboard);
        if (animBottomTop) {
            intent.putExtra(ARG_FRAGMENT_ANIMA_TYPE, 1);
        } else {
            intent.putExtra(ARG_FRAGMENT_ANIMA_TYPE, 0);
        }
        activity.startActivityForResult(intent, requestCode);
        if (animBottomTop) {
            activity.overridePendingTransition(R.anim.zm_slide_in_bottom, R.anim.zm_fade_out);
        } else {
            activity.overridePendingTransition(R.anim.zm_slide_in_right, R.anim.zm_slide_out_left);
        }
    }

    public static void show(Fragment fragment, String fragmentClass, Bundle args, int requestCode, boolean animBottomTop) {
        SimpleActivity.show(fragment, fragmentClass, args, requestCode, animBottomTop, 0);
    }

    public static void show(Fragment fragment, String fragmentClass, Bundle args, int requestCode, boolean animBottomTop, int processType) {
        SimpleActivity.show(fragment, fragmentClass, args, requestCode, animBottomTop, false, processType);
    }

    public static void show(Fragment fragment, String fragmentClass, Bundle args, int requestCode, boolean animBottomTop, boolean layoutIgnoreKeyboard) {
        SimpleActivity.show(fragment, fragmentClass, args, requestCode, animBottomTop, layoutIgnoreKeyboard, 0);
    }

    public static void show(Fragment fragment, String fragmentClass, Bundle args, int requestCode, boolean animBottomTop, boolean layoutIgnoreKeyboard, int processType) {
        if (fragment == null) {
            return;
        }
        ZMActivity activity = (ZMActivity)fragment.getActivity();
        if (activity == null) {
            return;
        }
        Intent intent = new Intent((Context)activity, SimpleActivity.getSimpleActivityClass(processType));
        intent.putExtra(ARG_FRAGMENT_CLASS, fragmentClass);
        intent.putExtra(ARG_FRAGMENT_ARGUMENTS, args);
        intent.putExtra(ARG_LAYOUT_IGNORE_KEYBORAD, layoutIgnoreKeyboard);
        if (animBottomTop) {
            intent.putExtra(ARG_FRAGMENT_ANIMA_TYPE, 1);
        } else {
            intent.putExtra(ARG_FRAGMENT_ANIMA_TYPE, 0);
        }
        fragment.startActivityForResult(intent, requestCode);
        if (animBottomTop) {
            activity.overridePendingTransition(R.anim.zm_slide_in_bottom, R.anim.zm_fade_out);
        } else {
            activity.overridePendingTransition(R.anim.zm_slide_in_right, R.anim.zm_slide_out_left);
        }
    }

    public static void show(Fragment fragment, String fragmentClass, Bundle args, int requestCode, int animType) {
        SimpleActivity.show(fragment, fragmentClass, args, requestCode, animType, 0);
    }

    public static void show(Fragment fragment, String fragmentClass, Bundle args, int requestCode) {
        SimpleActivity.show(fragment, fragmentClass, args, requestCode, 0);
    }

    public static void show(Fragment fragment, String fragmentClass, Bundle args, int requestCode, int animType, int processType) {
        if (fragment == null) {
            return;
        }
        ZMActivity activity = (ZMActivity)fragment.getActivity();
        if (activity == null) {
            return;
        }
        Intent intent = new Intent((Context)activity, SimpleActivity.getSimpleActivityClass(processType));
        intent.putExtra(ARG_FRAGMENT_CLASS, fragmentClass);
        intent.putExtra(ARG_FRAGMENT_ARGUMENTS, args);
        intent.putExtra(ARG_FRAGMENT_ANIMA_TYPE, animType);
        fragment.startActivityForResult(intent, requestCode);
        switch (animType) {
            case 1: {
                activity.overridePendingTransition(R.anim.zm_slide_in_bottom, R.anim.zm_slide_out_left);
                break;
            }
            case 2: {
                activity.overridePendingTransition(R.anim.zm_fade_in, R.anim.zm_fade_out);
                break;
            }
            default: {
                activity.overridePendingTransition(R.anim.zm_slide_in_right, R.anim.zm_slide_out_left);
            }
        }
    }

    public void finish() {
        super.finish();
        if (this.animType == 0) {
            this.overridePendingTransition(R.anim.zm_slide_in_left, R.anim.zm_slide_out_right);
        } else if (this.animType == 2) {
            this.overridePendingTransition(R.anim.zm_fade_in, R.anim.zm_fade_out);
        } else {
            this.overridePendingTransition(0, R.anim.zm_slide_out_bottom);
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null || !mainboard.isInitialized()) {
            this.finish();
            return;
        }
        this.setContentView(R.layout.zm_simple_activity);
        this.mTipLayer = (ZMTipLayer)this.findViewById(R.id.tipLayer);
        this.mKeyboardDetector = (ZMKeyboardDetector)this.findViewById(R.id.keyboardDetector);
        this.mFragmentContent = (ZMIgnoreKeyboardLayout)this.findViewById(R.id.fragmentContent);
        this.mKeyboardDetector.setKeyboardListener((ZMKeyboardDetector.KeyboardListener)this);
        this.initTipLayer();
        Intent intent = this.getIntent();
        if (intent == null) {
            return;
        }
        this.animType = intent.getIntExtra(ARG_FRAGMENT_ANIMA_TYPE, 0);
        if (savedInstanceState == null) {
            String fragmentClass = intent.getStringExtra(ARG_FRAGMENT_CLASS);
            Bundle args = intent.getBundleExtra(ARG_FRAGMENT_ARGUMENTS);
            try {
                Class<?> clazz = Class.forName(fragmentClass);
                Fragment f = (Fragment)clazz.newInstance();
                if (args != null) {
                    f.setArguments(args);
                }
                this.mFragmentTag = clazz.getName();
                this.getSupportFragmentManager().beginTransaction().add(R.id.fragmentContent, f, this.mFragmentTag).commit();
            }
            catch (Exception e) {
                ZMLog.e((String)TAG, (Throwable)e, (String)"create SimpleActivity failed. fragmentClass=%s", (Object[])new Object[]{fragmentClass});
            }
        }
        if (this.animType == 1) {
            this.disableFinishActivityByGesture(true);
        }
        boolean layoutIgnoreKeyboard = intent.getBooleanExtra(ARG_LAYOUT_IGNORE_KEYBORAD, false);
        this.mFragmentContent.setIgnoreKeyboardOpen(layoutIgnoreKeyboard);
    }

    private void initTipLayer() {
        if (this.mTipLayer != null) {
            this.mTipLayer.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    return SimpleActivity.this.onTipLayerTouched();
                }
            });
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (outState != null) {
            outState.putString(SimpleActivity.class.getName() + ".mFragmentTag", this.mFragmentTag);
        }
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        if (savedInstanceState != null) {
            this.mFragmentTag = savedInstanceState.getString(SimpleActivity.class.getName() + ".mFragmentTag");
        }
    }

    public boolean onSearchRequested() {
        Fragment f = this.findMainFragment();
        if (f instanceof ExtListener && ((ExtListener)f).onSearchRequested()) {
            return true;
        }
        return super.onSearchRequested();
    }

    public void onBackPressed() {
        Fragment f = this.findMainFragment();
        if (f instanceof ExtListener && ((ExtListener)f).onBackPressed()) {
            return;
        }
        super.onBackPressed();
    }

    private Fragment findMainFragment() {
        if (this.mFragmentTag == null) {
            return null;
        }
        FragmentManager fm = this.getSupportFragmentManager();
        if (fm == null) {
            return null;
        }
        return fm.findFragmentByTag(this.mFragmentTag);
    }

    public boolean isKeyboardOpen() {
        if (this.mKeyboardDetector == null) {
            return false;
        }
        return this.mKeyboardDetector.isKeyboardOpen();
    }

    public ZMKeyboardDetector getKeyboardDetector() {
        return this.mKeyboardDetector;
    }

    public void onKeyboardOpen() {
        Fragment f = this.findMainFragment();
        if (f instanceof ExtListener) {
            ((ExtListener)f).onKeyboardOpen();
        }
    }

    public void onKeyboardClosed() {
        Fragment f = this.findMainFragment();
        if (f instanceof ExtListener) {
            ((ExtListener)f).onKeyboardClosed();
        }
    }

    protected boolean onTipLayerTouched() {
        Fragment f = this.findMainFragment();
        if (f instanceof ExtListener) {
            return ((ExtListener)f).onTipLayerTouched();
        }
        return false;
    }

    public String toString() {
        return super.toString() + "<" + this.mFragmentTag + ">";
    }

    public static interface ExtListener {
        public boolean onSearchRequested();

        public boolean onTipLayerTouched();

        public void onKeyboardOpen();

        public void onKeyboardClosed();

        public boolean onBackPressed();
    }
}

