/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.v4.app.NotificationCompat;
import com.zipow.videobox.IConfService;
import com.zipow.videobox.IMActivity;
import com.zipow.videobox.IPTService;
import com.zipow.videobox.IntegrationActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.ZMBaseService;
import com.zipow.videobox.confapp.bo.BOStatusChangeMgrOnPT;
import com.zipow.videobox.fragment.ForceUpdateDialogFragment;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.ptapp.ABContactsHelper;
import com.zipow.videobox.ptapp.FavoriteMgr;
import com.zipow.videobox.ptapp.IMHelper;
import com.zipow.videobox.ptapp.MeetingHelper;
import com.zipow.videobox.ptapp.PT4SIPIPCPort;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTBuddyHelper;
import com.zipow.videobox.ptapp.PTIPCPort;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.ZoomContact;
import com.zipow.videobox.util.AppStateMonitor;
import com.zipow.videobox.util.NotificationMgr;
import com.zipow.videobox.util.PreferenceUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import us.zoom.androidlib.app.ForegroundTaskManager;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.ZMLog;
import us.zoom.videomeetings.R;

public class PTService
extends ZMBaseService {
    private static final String TAG = PTService.class.getSimpleName();
    public static final String ACTION_DEAMON = PTService.class.getName() + ".ACTION_DEAMON";
    public static final String ACTION_START_FOREGROUND = PTService.class.getName() + ".ACTION_START_FOREGROUND";
    public static final String ACTION_STOP_FOREGROUND = PTService.class.getName() + ".ACTION_STOP_FOREGROUND";
    public static final String ACTION_SHOW_CONF_NOTIFICATION = PTService.class.getName() + ".ACTION_SHOW_CONF_NOTIFICATION";
    public static final String ACTION_REMOVE_CONF_NOTIFICATION = PTService.class.getName() + ".ACTION_REMOVE_CONF_NOTIFICATION";
    public static final String ACTION_SHOW_SIP_NOTIFICATION = PTService.class.getName() + ".ACTION_SHOW_SIP_NOTIFICATION";
    public static final String ACTION_REMOVE_SIP_NOTIFICATION = PTService.class.getName() + ".ACTION_REMOVE_SIP_NOTIFICATION";
    private boolean mIsInForeground = false;
    private boolean mIsInMeeting = false;
    private boolean mIsInSIP = false;

    public IBinder onBind(Intent intent) {
        return new ServiceBinder();
    }

    @TargetApi(value=14)
    public void onTaskRemoved(Intent rootIntent) {
        super.onTaskRemoved(rootIntent);
        if (VideoBoxApplication.getInstance() == null) {
            this.stopSelf();
            return;
        }
        String cachedRegistrationId = PreferenceUtil.readStringValue("gcm_registration_id", null);
        Mainboard mainboard = Mainboard.getMainboard();
        if ((!StringUtil.isEmptyOrNull((String)cachedRegistrationId) || mainboard != null && !PTApp.getInstance().isDirectCallAvailable()) && PTApp.getInstance().getCallStatus() != 2) {
            this.stopSelf();
        }
    }

    @Override
    public void onCreate() {
        super.onCreate();
    }

    public void onDestroy() {
        super.onDestroy();
    }

    public void onStart(Intent intent, int startId) {
        super.onStart(intent, startId);
    }

    public void onRebind(Intent intent) {
        super.onRebind(intent);
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        int ret = super.onStartCommand(intent, flags, startId);
        if (intent == null) {
            return ret;
        }
        String action = intent.getAction();
        if (ACTION_DEAMON.equalsIgnoreCase(action)) {
            ret = VideoBoxApplication.getInstance() != null && VideoBoxApplication.getInstance().isSDKMode() ? 2 : 1;
        } else if (!ACTION_START_FOREGROUND.equalsIgnoreCase(action) && !ACTION_STOP_FOREGROUND.equalsIgnoreCase(action)) {
            if (ACTION_SHOW_CONF_NOTIFICATION.equalsIgnoreCase(action)) {
                this.showConfNotification();
                this.mIsInMeeting = true;
            } else if (ACTION_REMOVE_CONF_NOTIFICATION.equalsIgnoreCase(action)) {
                this.removeConfNotification();
            } else if (ACTION_SHOW_SIP_NOTIFICATION.equalsIgnoreCase(action)) {
                this.showSipNotification();
            } else if (ACTION_REMOVE_SIP_NOTIFICATION.equalsIgnoreCase(action)) {
                this.removeSipNotification();
            }
        }
        return ret;
    }

    public boolean onUnbind(Intent intent) {
        return super.onUnbind(intent);
    }

    protected void startForeground() {
        if (this.mIsInMeeting) {
            this.mIsInForeground = true;
            return;
        }
    }

    protected void stopForeground() {
        if (!this.mIsInMeeting && !this.mIsInSIP) {
            super.stopForeground(true);
        } else if (this.mIsInMeeting) {
            this.showConfNotification();
        } else {
            this.showSipNotification();
        }
        this.mIsInForeground = false;
    }

    private void removeConfNotification() {
        this.mIsInMeeting = false;
        if (this.mIsInForeground) {
            this.startForeground();
        } else {
            this.stopForeground();
        }
    }

    private void removeSipNotification() {
        this.mIsInSIP = false;
        if (this.mIsInForeground) {
            this.startForeground();
        } else {
            this.stopForeground();
        }
    }

    private void showSipNotification() {
        Intent clickIntent = new Intent((Context)this, IntegrationActivity.class);
        clickIntent.setAction(IntegrationActivity.ACTION_RETURN_TO_SIP);
        PendingIntent contentIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)clickIntent, (int)0x10000000);
        String contentTitle = this.getString(R.string.zm_app_name);
        String contentText = this.getString(R.string.zm_msg_sip_in_progress_14480);
        int smallIcon = R.drawable.zm_conf_notification;
        if (Build.VERSION.SDK_INT >= 21) {
            smallIcon = R.drawable.zm_sip_notification_5_0;
        }
        int color2 = this.getResources().getColor(R.color.zm_notification_icon_bg);
        Bitmap largeIcon = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.zm_launcher);
        NotificationCompat.Builder builder = NotificationMgr.getNotificationCompatBuilder(this.getApplicationContext(), false).setWhen(0L).setSmallIcon(smallIcon).setColor(color2).setContentTitle((CharSequence)contentTitle).setContentText((CharSequence)contentText).setContentIntent(contentIntent);
        if (Build.VERSION.SDK_INT >= 21 && this.getResources().getBoolean(R.bool.zm_config_show_large_icon_in_notification_on_api21_above)) {
            builder.setLargeIcon(largeIcon);
        }
        Notification notification = builder.build();
        this.startForeground(6, notification);
        this.mIsInSIP = true;
    }

    private static class ServiceBinder
    extends IPTService.Stub {
        private Handler mHandler = new Handler();

        @Override
        public void sendMessage(byte[] message) throws RemoteException {
            PTIPCPort.getInstance().onMessageReceived(message);
        }

        @Override
        public boolean isSignedIn() throws RemoteException {
            FutureTask<Boolean> task = new FutureTask<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return PTApp.getInstance().isWebSignedOn();
                }
            });
            this.mHandler.post(task);
            try {
                return task.get();
            }
            catch (Exception e) {
                ZMLog.e((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                return false;
            }
        }

        @Override
        public boolean isIMSignedIn() throws RemoteException {
            FutureTask<Boolean> task = new FutureTask<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    IMHelper imHelper = PTApp.getInstance().getIMHelper();
                    return imHelper != null && imHelper.isIMSignedOn();
                }
            });
            this.mHandler.post(task);
            try {
                return task.get();
            }
            catch (Exception e) {
                ZMLog.e((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                return false;
            }
        }

        @Override
        public boolean isPTAppAtFront() throws RemoteException {
            FutureTask<Boolean> task = new FutureTask<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    ZMActivity activity = ZMActivity.getFrontActivity();
                    return activity != null && activity.isActive();
                }
            });
            this.mHandler.post(task);
            try {
                return task.get();
            }
            catch (Exception e) {
                ZMLog.e((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                return false;
            }
        }

        @Override
        public int inviteBuddiesToConf(final String[] buddyJids, final String[] emails, final String meetingId, final long meetingNum, final String invitationMsgTemplate) throws RemoteException {
            FutureTask<Integer> task = new FutureTask<Integer>(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return PTApp.getInstance().inviteBuddiesToConf(buddyJids, emails, meetingId, meetingNum, invitationMsgTemplate);
                }
            });
            this.mHandler.post(task);
            try {
                return task.get();
            }
            catch (Exception e) {
                ZMLog.e((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                return -1;
            }
        }

        @Override
        public int getBuddyItemCount() throws RemoteException {
            FutureTask<Integer> task = new FutureTask<Integer>(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    PTBuddyHelper buddyHelper = PTApp.getInstance().getBuddyHelper();
                    if (buddyHelper == null) {
                        return 0;
                    }
                    return buddyHelper.getBuddyItemCount();
                }
            });
            this.mHandler.post(task);
            try {
                return task.get();
            }
            catch (Exception e) {
                ZMLog.e((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                return 0;
            }
        }

        @Override
        public void reloadAllBuddyItems() throws RemoteException {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    IConfService confService = VideoBoxApplication.getInstance().getConfService();
                    if (confService == null) {
                        return;
                    }
                    try {
                        PTBuddyHelper buddyHelper = PTApp.getInstance().getBuddyHelper();
                        if (buddyHelper == null) {
                            return;
                        }
                        int count = buddyHelper.getBuddyItemCount();
                        for (int i = 0; i < count; ++i) {
                            byte[] data = buddyHelper.getBuddyItemData(i);
                            confService.sinkIMBuddyPresence(data);
                        }
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            });
        }

        @Override
        public String[] filterBuddyWithInput(final String input) throws RemoteException {
            FutureTask<String[]> task = new FutureTask<String[]>(new Callable<String[]>(){

                @Override
                public String[] call() throws Exception {
                    PTBuddyHelper buddyHelper = PTApp.getInstance().getBuddyHelper();
                    if (buddyHelper == null) {
                        return null;
                    }
                    return buddyHelper.filterBuddyWithInput(input);
                }
            });
            this.mHandler.post(task);
            try {
                return task.get();
            }
            catch (Exception e) {
                ZMLog.e((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                return null;
            }
        }

        @Override
        public void showNeedUpdate() throws RemoteException {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ZMActivity frontActivity = ZMActivity.getFrontActivity();
                    if (frontActivity instanceof IMActivity && frontActivity.isActive()) {
                        ForceUpdateDialogFragment.show(frontActivity.getSupportFragmentManager());
                    } else {
                        IMActivity.showStartCallFailedNeedUpdateOnResume();
                        if (frontActivity != null) {
                            IMActivity.show((Context)frontActivity);
                        } else {
                            Intent i = new Intent((Context)VideoBoxApplication.getInstance(), IMActivity.class);
                            i.addFlags(0x10020000);
                            VideoBoxApplication.getInstance().startActivity(i);
                        }
                    }
                }
            });
        }

        @Override
        public int getPTLoginType() throws RemoteException {
            FutureTask<Integer> task = new FutureTask<Integer>(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return PTApp.getInstance().getPTLoginType();
                }
            });
            this.mHandler.post(task);
            try {
                return task.get();
            }
            catch (Exception e) {
                ZMLog.e((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                return 102;
            }
        }

        @Override
        public String FavoriteMgr_getLocalPicturePath(final String email) throws RemoteException {
            FutureTask<String> task = new FutureTask<String>(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    FavoriteMgr favMgr = PTApp.getInstance().getFavoriteMgr();
                    if (favMgr == null) {
                        return null;
                    }
                    return favMgr.getLocalPicturePath(email);
                }
            });
            this.mHandler.post(task);
            try {
                return task.get();
            }
            catch (Exception e) {
                ZMLog.e((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                return null;
            }
        }

        @Override
        public byte[] FavoriteMgr_getFavoriteListWithFilter(final String filter) throws RemoteException {
            FutureTask<byte[]> task = new FutureTask<byte[]>(new Callable<byte[]>(){

                @Override
                public byte[] call() throws Exception {
                    FavoriteMgr favMgr = PTApp.getInstance().getFavoriteMgr();
                    if (favMgr == null) {
                        return null;
                    }
                    ArrayList<ZoomContact> contacts = new ArrayList<ZoomContact>();
                    boolean res = favMgr.getFavoriteListWithFilter(filter, contacts);
                    if (!res) {
                        return null;
                    }
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    try {
                        ObjectOutputStream os = new ObjectOutputStream(bos);
                        os.writeObject(contacts);
                    }
                    catch (IOException e) {
                        return null;
                    }
                    byte[] buff = bos.toByteArray();
                    return buff;
                }
            });
            this.mHandler.post(task);
            try {
                return task.get();
            }
            catch (Exception e) {
                ZMLog.e((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                return null;
            }
        }

        @Override
        public String[] ABContactsHelper_getMatchedPhoneNumbers() throws RemoteException {
            FutureTask<String[]> task = new FutureTask<String[]>(new Callable<String[]>(){

                @Override
                public String[] call() throws Exception {
                    ABContactsHelper contactsHelper = PTApp.getInstance().getABContactsHelper();
                    if (contactsHelper == null) {
                        return null;
                    }
                    ArrayList<String> phoneNumbers = new ArrayList<String>();
                    contactsHelper.getMatchedPhoneNumbers(phoneNumbers);
                    String[] arrNumbers = new String[phoneNumbers.size()];
                    return phoneNumbers.toArray(arrNumbers);
                }
            });
            this.mHandler.post(task);
            try {
                return task.get();
            }
            catch (Exception e) {
                ZMLog.e((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                return null;
            }
        }

        @Override
        public int ABContactsHelper_inviteABContacts(final String[] phoneNumbers, final String invitationMsgTemplate) throws RemoteException {
            if (phoneNumbers == null || invitationMsgTemplate == null) {
                return 1;
            }
            FutureTask<Integer> task = new FutureTask<Integer>(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    ABContactsHelper contactsHelper = PTApp.getInstance().getABContactsHelper();
                    if (contactsHelper == null) {
                        return 1;
                    }
                    ArrayList<String> listPhoneNumbers = new ArrayList<String>();
                    for (int i = 0; i < phoneNumbers.length; ++i) {
                        listPhoneNumbers.add(phoneNumbers[i]);
                    }
                    return contactsHelper.inviteABContacts(listPhoneNumbers, invitationMsgTemplate);
                }
            });
            this.mHandler.post(task);
            try {
                return task.get();
            }
            catch (Exception e) {
                ZMLog.e((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                return 11;
            }
        }

        @Override
        public String[] getLatestMeetingInfo() throws RemoteException {
            FutureTask<String[]> task = new FutureTask<String[]>(new Callable<String[]>(){

                @Override
                public String[] call() throws Exception {
                    String id2 = PTUI.getInstance().getLatestMeetingId();
                    String number = String.valueOf(PTUI.getInstance().getLatestMeetingNumber());
                    return new String[]{id2, number};
                }
            });
            this.mHandler.post(task);
            try {
                return task.get();
            }
            catch (Exception e) {
                ZMLog.e((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                return null;
            }
        }

        @Override
        public boolean inviteCallOutUser(final String callOutNumber, final String userName) throws RemoteException {
            FutureTask<Boolean> task = new FutureTask<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return PTApp.getInstance().inviteCallOutUser(callOutNumber, userName);
                }
            });
            this.mHandler.post(task);
            try {
                return task.get();
            }
            catch (Exception e) {
                ZMLog.e((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                return false;
            }
        }

        @Override
        public boolean cancelCallOut() throws RemoteException {
            FutureTask<Boolean> task = new FutureTask<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return PTApp.getInstance().cancelCallOut();
                }
            });
            this.mHandler.post(task);
            try {
                return task.get();
            }
            catch (Exception e) {
                ZMLog.e((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                return false;
            }
        }

        @Override
        public boolean isCallOutInProgress() throws RemoteException {
            FutureTask<Boolean> task = new FutureTask<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return PTApp.getInstance().isCallOutInProgress(null);
                }
            });
            this.mHandler.post(task);
            try {
                return task.get();
            }
            catch (Exception e) {
                ZMLog.e((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                return false;
            }
        }

        @Override
        public int getCallOutStatus() throws RemoteException {
            FutureTask<Integer> task = new FutureTask<Integer>(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return PTApp.getInstance().getCallOutStatus();
                }
            });
            this.mHandler.post(task);
            try {
                return task.get();
            }
            catch (Exception e) {
                ZMLog.e((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                return 0;
            }
        }

        @Override
        public String[] getH323Gateway() throws RemoteException {
            FutureTask<String[]> task = new FutureTask<String[]>(new Callable<String[]>(){

                @Override
                public String[] call() throws Exception {
                    String addressInfo = PTApp.getInstance().getH323Gateway();
                    return addressInfo.split(";");
                }
            });
            this.mHandler.post(task);
            try {
                return task.get();
            }
            catch (Exception e) {
                ZMLog.e((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                return null;
            }
        }

        @Override
        public String getH323Password() throws RemoteException {
            FutureTask<String> task = new FutureTask<String>(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return PTApp.getInstance().getH323Password();
                }
            });
            this.mHandler.post(task);
            try {
                return task.get();
            }
            catch (Exception e) {
                ZMLog.e((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                return null;
            }
        }

        @Override
        public boolean sendMeetingParingCode(final long meetingId, final String paringCode) throws RemoteException {
            FutureTask<Boolean> task = new FutureTask<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    MeetingHelper meetingHelper = PTApp.getInstance().getMeetingHelper();
                    if (meetingHelper == null) {
                        return false;
                    }
                    return meetingHelper.sendMeetingParingCode(meetingId, paringCode);
                }
            });
            this.mHandler.post(task);
            try {
                return task.get();
            }
            catch (Exception e) {
                ZMLog.e((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                return false;
            }
        }

        @Override
        public boolean callOutRoomSystem(final String address, final int deviceType) throws RemoteException {
            FutureTask<Boolean> task = new FutureTask<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    MeetingHelper meetingHelper = PTApp.getInstance().getMeetingHelper();
                    if (meetingHelper == null) {
                        return false;
                    }
                    return meetingHelper.callOutRoomSystem(address, deviceType, 2);
                }
            });
            this.mHandler.post(task);
            try {
                return task.get();
            }
            catch (Exception e) {
                ZMLog.e((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                return false;
            }
        }

        @Override
        public boolean cancelCallOutRoomSystem() throws RemoteException {
            FutureTask<Boolean> task = new FutureTask<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    MeetingHelper meetingHelper = PTApp.getInstance().getMeetingHelper();
                    if (meetingHelper == null) {
                        return false;
                    }
                    return meetingHelper.cancelRoomDevice();
                }
            });
            this.mHandler.post(task);
            try {
                return task.get();
            }
            catch (Exception e) {
                ZMLog.e((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                return false;
            }
        }

        @Override
        public void onConfUIMoveToFront(final String activityClass) throws RemoteException {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ForegroundTaskManager.getInstance().onAnotherProcessMoveToFront(activityClass);
                    AppStateMonitor.getInstance().onConfUIMoveToFront();
                }
            });
        }

        @Override
        public void onConfUIMoveToBackground() throws RemoteException {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    AppStateMonitor.getInstance().onConfUIMoveToBackground();
                }
            });
        }

        @Override
        public void onBOStatusChangeStart(final boolean join, final int joinReason, final String boMeetingName) throws RemoteException {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    BOStatusChangeMgrOnPT.getInstance().handleStatusChangeStart(join, joinReason, boMeetingName);
                }
            });
        }

        @Override
        public void onBOStatusChangeComplete() throws RemoteException {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    BOStatusChangeMgrOnPT.getInstance().handleStatusChangeCompeleted();
                }
            });
        }

        @Override
        public void onJoinConfMeetingStatus(final boolean canJoinNow, final boolean hasScreenName) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    PTUI.getInstance().onJoinConfMeetingStatus(canJoinNow, hasScreenName);
                }
            });
        }

        @Override
        public void onCallOutStatus(final int status) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    PTUI.getInstance().dispatchCallMeStatusChanged(status);
                }
            });
        }

        @Override
        public boolean isSdkNeedWaterMark() throws RemoteException {
            FutureTask<Boolean> task = new FutureTask<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return PTApp.getInstance().isSdkNeedWaterMark();
                }
            });
            this.mHandler.post(task);
            try {
                return task.get();
            }
            catch (Exception e) {
                ZMLog.e((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                return false;
            }
        }

        @Override
        public void sendMessageFromSip(byte[] message) throws RemoteException {
            PT4SIPIPCPort.getInstance().onMessageReceived(message);
        }
    }
}

