/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.zipow.videobox.fragment.MeetingInfoFragment;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.view.ScheduledMeetingItem;
import java.io.Serializable;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.videomeetings.R;

public class MeetingInfoActivity
extends ZMActivity {
    private static final String ARG_MEETING_ITEM = "meetingItem";
    private static final String ARG_PARENT_SCREEN_TITLE = "parentScreenTitle";
    private static final String ARG_AUTO_ADD_INVITEE = "autoAddInvitee";
    public static final int REQUEST_EDIT = 103;

    public static void show(ZMActivity activity, ScheduledMeetingItem mi, int parentScreenTitle, boolean autoAddInvitee, int requestCode) {
        Intent intent = new Intent((Context)activity, MeetingInfoActivity.class);
        intent.putExtra(ARG_MEETING_ITEM, (Serializable)mi);
        intent.putExtra(ARG_PARENT_SCREEN_TITLE, parentScreenTitle);
        intent.putExtra(ARG_AUTO_ADD_INVITEE, autoAddInvitee);
        activity.startActivityForResult(intent, requestCode);
        activity.overridePendingTransition(R.anim.zm_slide_in_right, R.anim.zm_slide_out_left);
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(R.anim.zm_slide_in_left, R.anim.zm_slide_out_right);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null || !mainboard.isInitialized()) {
            this.finish();
            return;
        }
        if (savedInstanceState == null) {
            Intent intent = this.getIntent();
            ScheduledMeetingItem item = (ScheduledMeetingItem)intent.getSerializableExtra(ARG_MEETING_ITEM);
            int parentScreenTitle = intent.getIntExtra(ARG_PARENT_SCREEN_TITLE, 0);
            boolean autoAddInvitee = intent.getBooleanExtra(ARG_AUTO_ADD_INVITEE, false);
            MeetingInfoFragment.showInActivity(this, item, parentScreenTitle, autoAddInvitee);
        }
    }

    private void finishSubActivities() {
        this.finishActivity(103);
    }

    public void onResume() {
        super.onResume();
        this.finishSubActivities();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 103 && resultCode == -1) {
            if (data == null) {
                return;
            }
            ScheduledMeetingItem item = (ScheduledMeetingItem)data.getSerializableExtra(ARG_MEETING_ITEM);
            MeetingInfoFragment f = MeetingInfoFragment.getMeetingInfoFragment(this.getSupportFragmentManager());
            if (f != null) {
                f.onEditSuccess(item);
            }
        }
    }
}

