/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.widget.Button;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.WaitingDialog;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class MeetingEndMessageActivity
extends ZMActivity
implements VideoBoxApplication.IConfProcessListener {
    private static final String TAG = MeetingEndMessageActivity.class.getSimpleName();
    public static final String ACTION_SHOW_MEETING_ENDED_MESSAGE = MeetingEndMessageActivity.class.getName() + ".action.ACTION_SHOW_MEETING_ENDED_MESSAGE";
    public static final String ACTION_SHOW_LEAVING_MESSAGE = MeetingEndMessageActivity.class.getName() + ".action.ACTION_SHOW_LEAVING_MESSAGE";
    public static final String ACTION_SHOW_CMR_NOTIFICATION = MeetingEndMessageActivity.class.getName() + ".action.ACTION_SHOW_CMR_NOTIFICATION";
    public static final String ARG_ENDMEETING_REASON = "endMeetingReason";
    public static final String ARG_ENDMEETING_REASON_CODE = "endMeetingCode";
    public static final String ARG_LEAVING_MESSAGE = "leavingMessage";
    private WaitingDialog mWaitingDialog;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    protected void onDestroy() {
        super.onDestroy();
        VideoBoxApplication app = VideoBoxApplication.getInstance();
        if (app != null) {
            app.removeConfProcessListener(this);
        }
    }

    public void onResume() {
        super.onResume();
        if (VideoBoxApplication.getInstance() == null) {
            this.finish();
            return;
        }
        Intent intent = this.getIntent();
        String action = intent.getAction();
        boolean needFinish = true;
        if (ACTION_SHOW_MEETING_ENDED_MESSAGE.equals(action)) {
            needFinish = this.handleActionShowMeetingEndMessage(intent);
        } else if (ACTION_SHOW_LEAVING_MESSAGE.equalsIgnoreCase(action)) {
            needFinish = this.handleActionShowLeavingMessage(intent);
        } else if (ACTION_SHOW_CMR_NOTIFICATION.equalsIgnoreCase(action)) {
            needFinish = this.handleActionShowCMRNotification(intent);
        }
        intent.setAction(null);
        this.setIntent(intent);
        if (needFinish) {
            this.finish();
        }
    }

    private boolean handleActionShowMeetingEndMessage(Intent intent) {
        int reason = intent.getIntExtra(ARG_ENDMEETING_REASON, 0);
        int code = intent.getIntExtra(ARG_ENDMEETING_REASON_CODE, 0);
        switch (reason) {
            case 1: {
                this.showExpeledDialog();
                break;
            }
            case 2: {
                this.showMeetingEndDialog();
                break;
            }
            case 4: {
                this.showFreeMeetingTimeoutDialog();
                break;
            }
            case 3: {
                this.showJBHTimeoutDialog();
                break;
            }
            case 6: {
                this.showEndByHostStartAnotherMeetingDialog();
                break;
            }
            case 7: {
                this.showEndBySDKConnectionBrokenDialog(code);
            }
        }
        return false;
    }

    public static void showMeetingEndedMessage(Context context, int endMeetingReason) {
        MeetingEndMessageActivity.showMeetingEndedMessage(context, endMeetingReason, 0);
    }

    public static void showMeetingEndedMessage(Context context, int endMeetingReason, int endCode) {
        if (VideoBoxApplication.getInstance().isPTApp() && !VideoBoxApplication.getInstance().isSDKMode()) {
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            if (!messenger.isConnectionGood() && messenger.isForceSignout()) {
                return;
            }
        }
        Intent intent = new Intent(context, MeetingEndMessageActivity.class);
        intent.setFlags(0x58800000);
        intent.setAction(ACTION_SHOW_MEETING_ENDED_MESSAGE);
        intent.putExtra(ARG_ENDMEETING_REASON, endMeetingReason);
        intent.putExtra(ARG_ENDMEETING_REASON_CODE, endCode);
        try {
            context.startActivity(intent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void showExpeledDialog() {
        ExpeledDialog dialog = new ExpeledDialog();
        dialog.show(this.getSupportFragmentManager(), ExpeledDialog.class.getSimpleName());
    }

    private void showMeetingEndDialog() {
        MeetingEndDialog dialog = MeetingEndDialog.newMeetingEndDialog(0);
        dialog.show(this.getSupportFragmentManager(), MeetingEndDialog.class.getSimpleName());
    }

    private void showFreeMeetingTimeoutDialog() {
        MeetingEndDialog dialog = MeetingEndDialog.newMeetingEndDialog(R.string.zm_msg_free_meeting_timeout);
        dialog.show(this.getSupportFragmentManager(), MeetingEndDialog.class.getSimpleName());
    }

    private void showJBHTimeoutDialog() {
        MeetingEndDialog dialog = MeetingEndDialog.newMeetingEndDialog(R.string.zm_msg_jbh_meeting_timeout);
        dialog.show(this.getSupportFragmentManager(), MeetingEndDialog.class.getSimpleName());
    }

    private void showEndByHostStartAnotherMeetingDialog() {
        MeetingEndDialog dialog = MeetingEndDialog.newMeetingEndDialog(R.string.zm_msg_meeting_end_by_host_start_another_meeting);
        dialog.show(this.getSupportFragmentManager(), MeetingEndDialog.class.getSimpleName());
    }

    private void showEndBySDKConnectionBrokenDialog(int errCode) {
        MeetingEndDialog dialog = MeetingEndDialog.newMeetingEndDialog(this.getString(R.string.zm_msg_conffail_neterror_confirm, new Object[]{errCode}));
        dialog.show(this.getSupportFragmentManager(), MeetingEndDialog.class.getSimpleName());
    }

    private boolean handleActionShowLeavingMessage(Intent intent) {
        FragmentManager fm;
        String message = intent.getStringExtra(ARG_LEAVING_MESSAGE);
        if (StringUtil.isEmptyOrNull((String)message)) {
            message = this.getString(R.string.zm_msg_waiting);
        }
        if ((fm = this.getSupportFragmentManager()) == null) {
            return false;
        }
        if (!VideoBoxApplication.getInstance().isConfProcessRunning()) {
            return true;
        }
        this.showWaitingDialog(message, fm);
        VideoBoxApplication.getInstance().addConfProcessListener(this);
        return false;
    }

    @Override
    public void onConfProcessStarted() {
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction(){

            public void run(IUIElement ui) {
                ((MeetingEndMessageActivity)ui).doFinish();
            }
        });
    }

    @Override
    public void onConfProcessStopped() {
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction(){

            public void run(IUIElement ui) {
                ((MeetingEndMessageActivity)ui).doFinish();
            }
        });
    }

    private void doFinish() {
        this.dismissWaitingDialog();
        this.finish();
    }

    private void showWaitingDialog(String message, FragmentManager fm) {
        if (this.mWaitingDialog != null) {
            return;
        }
        this.mWaitingDialog = new WaitingDialog(message);
        this.mWaitingDialog.setCancelable(true);
        this.mWaitingDialog.show(fm, "WaitingDialog");
    }

    private void dismissWaitingDialog() {
        if (this.mWaitingDialog == null) {
            FragmentManager fm = this.getSupportFragmentManager();
            if (fm == null) {
                return;
            }
            this.mWaitingDialog = (WaitingDialog)fm.findFragmentByTag("WaitingDialog");
        }
        if (this.mWaitingDialog != null && this.mWaitingDialog.isVisible()) {
            this.mWaitingDialog.dismissAllowingStateLoss();
        }
        this.mWaitingDialog = null;
    }

    public static void showLeavingMessage(Context context, String message) {
        if (VideoBoxApplication.getInstance().isPTApp() && !VideoBoxApplication.getInstance().isSDKMode()) {
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            if (!messenger.isConnectionGood() && messenger.isForceSignout()) {
                return;
            }
        }
        Intent intent = new Intent(context, MeetingEndMessageActivity.class);
        intent.setFlags(0x58800000);
        intent.setAction(ACTION_SHOW_LEAVING_MESSAGE);
        intent.putExtra(ARG_LEAVING_MESSAGE, message);
        try {
            context.startActivity(intent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void showCMRNotification(Context context) {
        Intent intent = new Intent(context, MeetingEndMessageActivity.class);
        intent.setFlags(0x58800000);
        intent.setAction(ACTION_SHOW_CMR_NOTIFICATION);
        try {
            context.startActivity(intent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean handleActionShowCMRNotification(Intent intent) {
        return false;
    }

    public static class MeetingEndDialog
    extends ZMDialogFragment {
        private Button mBtnOK;
        private Handler mHandler;
        private String mButtonOkString;
        private int mTimeOutSeconds = 0;
        private Runnable timeOutRunnalbe = new Runnable(){

            @Override
            public void run() {
                ZMAlertDialog dialog = (ZMAlertDialog)MeetingEndDialog.this.getDialog();
                if (dialog == null) {
                    return;
                }
                if (MeetingEndDialog.this.mTimeOutSeconds > 0) {
                    MeetingEndDialog.this.mBtnOK = dialog.getButton(-1);
                    String timeOut = Integer.toString(MeetingEndDialog.this.mTimeOutSeconds);
                    MeetingEndDialog.this.mBtnOK.setText((CharSequence)(MeetingEndDialog.this.mButtonOkString + " ( " + timeOut + " ) "));
                    MeetingEndDialog.this.mTimeOutSeconds--;
                    MeetingEndDialog.this.mHandler.postDelayed((Runnable)this, 1000L);
                } else {
                    FragmentActivity activity = MeetingEndDialog.this.getActivity();
                    if (activity != null) {
                        activity.finish();
                    }
                }
            }
        };

        public static MeetingEndDialog newMeetingEndDialog(int msgId) {
            MeetingEndDialog dialog = new MeetingEndDialog();
            Bundle args = new Bundle();
            args.putInt("msgId", msgId);
            dialog.setArguments(args);
            return dialog;
        }

        public static MeetingEndDialog newMeetingEndDialog(String message) {
            MeetingEndDialog dialog = new MeetingEndDialog();
            Bundle args = new Bundle();
            args.putString("message", message);
            dialog.setArguments(args);
            return dialog;
        }

        public MeetingEndDialog() {
            this.setCancelable(false);
        }

        public void onStart() {
            super.onStart();
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            Bundle args = this.getArguments();
            int msgId = args != null ? args.getInt("msgId", 0) : 0;
            String message = args != null ? args.getString("message") : "";
            this.mTimeOutSeconds = 5;
            if (msgId == 0) {
                msgId = R.string.zm_msg_meeting_end;
            }
            this.mButtonOkString = this.getString(R.string.zm_btn_ok);
            this.mHandler = new Handler();
            this.mHandler.postDelayed(this.timeOutRunnalbe, 1000L);
            ZMAlertDialog.Builder builder = new ZMAlertDialog.Builder((Context)this.getActivity());
            if (!StringUtil.isEmptyOrNull((String)message)) {
                builder.setTitle(message);
            } else {
                builder.setTitle(msgId);
            }
            builder.setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    FragmentActivity activity;
                    MeetingEndDialog.this.mTimeOutSeconds = 0;
                    if (MeetingEndDialog.this.mHandler != null) {
                        MeetingEndDialog.this.mHandler.removeCallbacks(MeetingEndDialog.this.timeOutRunnalbe);
                    }
                    if ((activity = MeetingEndDialog.this.getActivity()) != null) {
                        activity.finish();
                    }
                }
            });
            return builder.create();
        }

        public void onDestroy() {
            this.mTimeOutSeconds = 0;
            if (this.mHandler != null) {
                this.mHandler.removeCallbacks(this.timeOutRunnalbe);
            }
            super.onDestroy();
        }
    }

    public static class ExpeledDialog
    extends ZMDialogFragment {
        private Button mBtnOK;
        private Handler mHandler;
        private String mButtonOkString;
        private int mTimeOutSeconds = 0;
        private Runnable timeOutRunnalbe = new Runnable(){

            @Override
            public void run() {
                ZMAlertDialog dialog = (ZMAlertDialog)ExpeledDialog.this.getDialog();
                if (dialog == null) {
                    return;
                }
                if (ExpeledDialog.this.mTimeOutSeconds > 0) {
                    ExpeledDialog.this.mBtnOK = dialog.getButton(-1);
                    String timeOut = Integer.toString(ExpeledDialog.this.mTimeOutSeconds);
                    ExpeledDialog.this.mBtnOK.setText((CharSequence)(ExpeledDialog.this.mButtonOkString + " ( " + timeOut + " ) "));
                    ExpeledDialog.this.mTimeOutSeconds--;
                    ExpeledDialog.this.mHandler.postDelayed((Runnable)this, 1000L);
                } else {
                    FragmentActivity activity = ExpeledDialog.this.getActivity();
                    if (activity != null) {
                        activity.finish();
                    }
                }
            }
        };

        public ExpeledDialog() {
            this.setCancelable(false);
        }

        public void onStart() {
            super.onStart();
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            this.mTimeOutSeconds = 5;
            this.mButtonOkString = this.getString(R.string.zm_btn_ok);
            this.mHandler = new Handler();
            this.mHandler.postDelayed(this.timeOutRunnalbe, 1000L);
            return new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.zm_msg_expeled_by_host_44379).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    FragmentActivity activity;
                    ExpeledDialog.this.mTimeOutSeconds = 0;
                    if (ExpeledDialog.this.mHandler != null) {
                        ExpeledDialog.this.mHandler.removeCallbacks(ExpeledDialog.this.timeOutRunnalbe);
                    }
                    if ((activity = ExpeledDialog.this.getActivity()) != null) {
                        activity.finish();
                    }
                }
            }).create();
        }

        public void onDestroy() {
            this.mTimeOutSeconds = 0;
            if (this.mHandler != null) {
                this.mHandler.removeCallbacks(this.timeOutRunnalbe);
            }
            super.onDestroy();
        }
    }
}

