/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.hardware.fingerprint.FingerprintManager;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.view.View;
import com.zipow.videobox.IMActivity;
import com.zipow.videobox.LauncherActivity;
import com.zipow.videobox.PTService;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.WelcomeActivity;
import com.zipow.videobox.dialog.DialogActionCallBack;
import com.zipow.videobox.dialog.FbConfirmCreateAccountDialog;
import com.zipow.videobox.dialog.FingerprintAuthenticationDialog;
import com.zipow.videobox.dialog.ZMGDPRConfirmDialog;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.ptapp.AutoLogoffChecker;
import com.zipow.videobox.ptapp.IMHelper;
import com.zipow.videobox.ptapp.LogoutHandler;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.RevokeTokenAutoLogoffChecker;
import com.zipow.videobox.thirdparty.AuthResult;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.util.ZMServiceHelper;
import com.zipow.videobox.util.ZmPtUtils;
import com.zipow.videobox.view.LoginView;
import java.io.Serializable;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.thirdparty.login.LoginType;
import us.zoom.thirdparty.login.ThirdPartyLoginFactory;
import us.zoom.thirdparty.login.facebook.AuthToken;
import us.zoom.thirdparty.login.facebook.FBAppAuthCallBack;
import us.zoom.thirdparty.login.facebook.FBAuthUtil;
import us.zoom.thirdparty.login.facebook.FBSessionStore;
import us.zoom.thirdparty.login.facebook.FacebookError;
import us.zoom.thirdparty.login.sso.SsoUtil;
import us.zoom.videomeetings.R;

public class LoginActivity
extends ZMActivity
implements PTUI.IPTUIListener,
PTUI.IIMListener,
PTUI.IAuthHandlerListener,
DialogActionCallBack,
PTUI.IGDPRListener,
FingerprintAuthenticationDialog.FingerprintAuthCallBack {
    private static final String TAG = LoginActivity.class.getSimpleName();
    public static final String ACTION_LOGIN_ZOOM = LoginActivity.class.getName() + ".action.ACTION_LOGIN_ZOOM";
    public static final String ACTION_THIRD_LOGIN = LoginActivity.class.getName() + ".action.ACTION_THIRD_LOGIN";
    private static final String ARG_EMAIL = "email";
    private static final String ARG_PSW = "password";
    private static final String ARG_KEEP_LOGIN = "keepLogin";
    private static final String ARG_LOGIN_TYPE = "loginType";
    private static final String ARG_SHOW_FOR_TOKEN_EXPIRED = "showForTokenExpired";
    private static final String ARG_PRODUCT_VENDOR = "productVendor";
    private static final String ARG_AUTO_LOGOFF_INFO = "autoLogoffInfo";
    private static final String ARG_REVOKE_TOKEN = "ARG_REVOKE_TOKEN";
    private static final String ARG_THIRD_LOGIN = "ARG_THIRD_LOGIN";
    private static final String ARG_AUTH_LAST_TIME = "googleAuthLastTime";
    public static final int REQUEST_FACEBOOK_AUTH = 100;
    private static final int REQUEST_DIALOG_GDPR = 1000;
    private LoginView mLoginView;
    private AuthToken mFacebookAuthToken;
    public static long mLastAuthTime = -1L;

    public static boolean show(Context context) {
        return LoginActivity.show(context, false, -999);
    }

    public static boolean show(Context context, boolean autoLogin) {
        return LoginActivity.show(context, autoLogin, -999);
    }

    public static boolean show(Context context, boolean autoLogin, boolean isShowRevokeToken) {
        return LoginActivity.show(context, autoLogin, -999, null, isShowRevokeToken);
    }

    public static boolean show(Context context, boolean autoLogin, int productVendor) {
        return LoginActivity.show(context, autoLogin, productVendor, null);
    }

    public static boolean show(Context context, boolean autoLogin, int productVendor, AutoLogoffChecker.AutoLogoffInfo autoLogoffInfo) {
        return LoginActivity.show(context, autoLogin, productVendor, autoLogoffInfo, false);
    }

    public static boolean show(Context context, boolean autoLogin, int productVendor, AutoLogoffChecker.AutoLogoffInfo autoLogoffInfo, boolean isRevokenToken) {
        if (context == null) {
            return false;
        }
        if (!NetworkUtil.hasDataNetwork((Context)VideoBoxApplication.getInstance()) && context instanceof ZMActivity) {
            String message = context.getResources().getString(R.string.zm_alert_network_disconnected);
            LoginView.AuthFailedDialog.show((ZMActivity)context, message);
            return false;
        }
        Intent i = new Intent(context, LoginActivity.class);
        if (!(context instanceof Activity)) {
            i.addFlags(0x10000000);
        }
        i.putExtra(ARG_PRODUCT_VENDOR, productVendor);
        i.putExtra(ARG_AUTO_LOGOFF_INFO, (Serializable)autoLogoffInfo);
        if (autoLogin) {
            i.putExtra(ARG_LOGIN_TYPE, PTApp.getInstance().getPTLoginType());
        }
        if (PTApp.getInstance().isTokenExpired()) {
            i.putExtra(ARG_SHOW_FOR_TOKEN_EXPIRED, true);
        }
        i.putExtra(ARG_REVOKE_TOKEN, isRevokenToken);
        context.startActivity(i);
        if (context instanceof Activity) {
            ((Activity)context).overridePendingTransition(R.anim.zm_slide_in_right, R.anim.zm_slide_out_left);
        }
        return true;
    }

    public static boolean showForAuthUI(Context context, @NonNull AuthResult authResult) {
        if (context == null) {
            return false;
        }
        Intent i = new Intent(context, LoginActivity.class);
        if (!(context instanceof Activity)) {
            i.addFlags(0x10000000);
        }
        i.setAction(ACTION_THIRD_LOGIN);
        i.putExtra(ARG_THIRD_LOGIN, (Parcelable)authResult);
        i.putExtra(ARG_AUTH_LAST_TIME, System.currentTimeMillis());
        context.startActivity(i);
        return true;
    }

    public LoginView getmLoginView() {
        return this.mLoginView;
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(R.anim.zm_slide_in_left, R.anim.zm_slide_out_right);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.mFacebookAuthToken == null) {
            this.mFacebookAuthToken = FBSessionStore.getSession((Context)this, (String)"facebook-session");
        }
        if (UIMgr.isLargeMode((Context)this) && !UIMgr.isDualPaneSupportedInPortraitMode((Context)this)) {
            this.setRequestedOrientation(0);
        } else if (!UIMgr.isLargeMode((Context)this) && UIUtil.getDisplayMinWidthInDip((Context)this) < 500.0f) {
            this.setRequestedOrientation(1);
        }
        if (PTApp.getInstance().isWebSignedOn()) {
            IMActivity.show((Context)this);
            this.finish();
            this.overridePendingTransition(R.anim.zm_slide_in_right, R.anim.zm_slide_out_left);
            return;
        }
        int productVendor = -999;
        AutoLogoffChecker.AutoLogoffInfo autologoffInfo = null;
        Intent intent = this.getIntent();
        if (intent != null) {
            productVendor = intent.getIntExtra(ARG_PRODUCT_VENDOR, productVendor);
            autologoffInfo = (AutoLogoffChecker.AutoLogoffInfo)intent.getSerializableExtra(ARG_AUTO_LOGOFF_INFO);
            intent.putExtra(ARG_LOGIN_TYPE, -1);
        }
        this.mLoginView = new LoginView((Context)this);
        this.mLoginView.setId(R.id.viewLogin);
        this.mLoginView.setSelectedProductVendor(productVendor);
        if (intent != null) {
            this.mLoginView.setSelectedLoginType(intent.getIntExtra(ARG_LOGIN_TYPE, -1));
        }
        if (autologoffInfo != null) {
            this.mLoginView.setAutologoffInfo(autologoffInfo);
        }
        this.setContentView((View)this.mLoginView);
        this.mLoginView.restoreInstanceState(savedInstanceState);
        PTUI.getInstance().addPTUIListener(this);
        PTUI.getInstance().addIMListener(this);
        PTUI.getInstance().addGDPRListener(this);
        if (ZmPtUtils.isSupportFingerprintAndEnableFingerprintWithUserInfo(this)) {
            FingerprintAuthenticationDialog.show(this);
        }
        if (intent.getBooleanExtra(ARG_REVOKE_TOKEN, false)) {
            RevokeTokenAutoLogoffChecker.RovokeTokenDialog.show(this);
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        if (this.mLoginView != null) {
            this.mLoginView.saveInstanceState(outState);
        }
        super.onSaveInstanceState(outState);
    }

    public void onResume() {
        super.onResume();
        IMHelper imHelper = PTApp.getInstance().getIMHelper();
        if (PTApp.getInstance().isWebSignedOn() || imHelper != null && imHelper.isIMSignedOn()) {
            IMActivity.show((Context)this);
            this.finish();
            return;
        }
        this.removePTNotification();
        Intent intent = this.getIntent();
        if (ACTION_LOGIN_ZOOM.equals(intent.getAction())) {
            intent.setAction(null);
            this.setIntent(intent);
            String email = intent.getStringExtra(ARG_EMAIL);
            String password = intent.getStringExtra(ARG_PSW);
            boolean keepLogin = intent.getBooleanExtra(ARG_KEEP_LOGIN, true);
            this.loginZoom(email, password, keepLogin, false, false);
            return;
        }
        if (ACTION_THIRD_LOGIN.equals(intent.getAction())) {
            long time = intent.getLongExtra(ARG_AUTH_LAST_TIME, 0L);
            if (mLastAuthTime == time) {
                return;
            }
            mLastAuthTime = time;
            intent.setAction(null);
            this.setIntent(intent);
            AuthResult authResult = (AuthResult)intent.getParcelableExtra(ARG_THIRD_LOGIN);
            this.onAuthResult(authResult);
            return;
        }
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null) {
            return;
        }
        if (!mainboard.isInitialized()) {
            this.showLauncherActivity();
        }
    }

    public boolean isShownForTokenExpired() {
        Intent intent = this.getIntent();
        return intent != null && intent.getBooleanExtra(ARG_SHOW_FOR_TOKEN_EXPIRED, false);
    }

    private void showLauncherActivity() {
        LauncherActivity.showLauncherActivity(this);
        this.finish();
    }

    private void removePTNotification() {
        ZMServiceHelper.doServiceAction(PTService.ACTION_STOP_FOREGROUND, PTService.class);
    }

    public String querySSODomainByEmail(String email) {
        return this.mLoginView.querySSODomainByEmail(email);
    }

    public void onBackPressed() {
        if (this.isShownForTokenExpired()) {
            PTApp.getInstance().logout(0);
        }
        WelcomeActivity.show((Context)this, true, false);
        this.finish();
    }

    public void onDestroy() {
        super.onDestroy();
        PTUI.getInstance().removeAuthHandler(this);
        PTUI.getInstance().removePTUIListener(this);
        PTUI.getInstance().removeIMListener(this);
        PTUI.getInstance().removeGDPRListener(this);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 100: {
                if (this.mFacebookAuthToken == null) break;
                FBAuthUtil.authorizeCallback((AuthToken)this.mFacebookAuthToken, (int)resultCode, (Intent)data, (FBAppAuthCallBack)new FBAppAuthCallBack(){

                    public void forceAuthByBrowser() {
                    }

                    public void onCancelAuth() {
                        LoginActivity.this.mLoginView.onFBAuthCancel();
                    }

                    public void onFaceBookError(FacebookError facebookError) {
                        LoginActivity.this.mLoginView.onFBAuthFailed(facebookError);
                    }

                    public void onError(String error) {
                        LoginActivity.this.mLoginView.onFBAuthFailed(error);
                    }

                    public void onComplete(Bundle data) {
                        LoginActivity.this.onFBAppAuthSuccess(LoginActivity.this.mFacebookAuthToken);
                    }
                });
            }
        }
    }

    protected void onNewIntent(Intent intent) {
        this.setIntent(intent);
    }

    public void loginSSOSite(String siteUrl) {
        this.mLoginView.loginSSOSite(siteUrl);
    }

    public void loginZoom(String account, String password, boolean keepLogin, boolean useCachedAccount, boolean returnToLoginWithIfFailed) {
        this.mLoginView.loginZoom(account, password, keepLogin, useCachedAccount, returnToLoginWithIfFailed);
    }

    private void onAuthResult(AuthResult authResult) {
        int action = authResult.getAction();
        if (action == 8 || action == 10) {
            PTUI.getInstance().addAuthHandler(this);
            Mainboard.getMainboard().notifyUrlAction(authResult.getUrl());
        } else if (authResult.isValid()) {
            if (action == 11) {
                this.mLoginView.startLoginSSOWithToken(authResult.getCode());
            }
        } else {
            this.mLoginView.onSSOAuthFailed(authResult.getErrorCode());
        }
    }

    private void onFBAppAuthSuccess(final AuthToken authToken) {
        this.getNonNullEventTaskManagerOrThrowException().push("onFBAuthSuccess", new EventAction(){

            public void run(IUIElement ui) {
                ((LoginActivity)ui).handleOnFBAppAuthSuccess(authToken);
            }
        });
    }

    private void handleOnFBAppAuthSuccess(AuthToken authToken) {
        FBSessionStore.save((String)"facebook-session", (AuthToken)authToken, (Context)this);
        this.mLoginView.startFBAppIMAuth(authToken);
    }

    public void showSSOAuthUI(String siteUrl) {
        ThirdPartyLoginFactory.build((LoginType)LoginType.Sso, (Bundle)ThirdPartyLoginFactory.buildSsoBundle((String)SsoUtil.formatUrl((String)siteUrl))).login((Activity)this);
    }

    private void onSSOAuthSuccess(final String siteUrl, final String token) {
        this.getNonNullEventTaskManagerOrThrowException().push("onSSOAuthSuccess", new EventAction(){

            public void run(IUIElement ui) {
                ((LoginActivity)ui).handleOnSSOAuthSuccess(siteUrl, token);
            }
        });
    }

    private void handleOnSSOAuthSuccess(String siteUrl, String token) {
        this.mLoginView.onSSOAuthSuccess(siteUrl, token);
    }

    @Override
    public void onPTAppEvent(int event, long result) {
        switch (event) {
            case 8: {
                this.sinkIMLogin(result);
                break;
            }
            case 22: {
                this.sinkCallStatusChanged(result);
                break;
            }
            case 35: {
                this.sinkWebAccessFail();
                break;
            }
            case 0: {
                this.sinkWebLogin(result);
            }
        }
    }

    @Override
    public void onDataNetworkStatusChanged(boolean connected) {
    }

    public void sinkIMLogin(final long result) {
        this.getNonNullEventTaskManagerOrThrowException().push("sinkIMLogin", new EventAction("sinkIMLogin"){

            public void run(IUIElement ui) {
                ((LoginActivity)ui).handleOnIMLogin(result);
            }
        });
    }

    private void handleOnIMLogin(long result) {
        this.mLoginView.onIMLogin(result);
    }

    public void sinkWebLogin(final long result) {
        this.getNonNullEventTaskManagerOrThrowException().push("sinkWebLogin", new EventAction("sinkWebLogin"){

            public void run(IUIElement ui) {
                ((LoginActivity)ui).handleOnWebLogin(result);
            }
        });
    }

    private void handleOnWebLogin(long result) {
        this.mLoginView.onWebLogin(result);
    }

    private void sinkCallStatusChanged(final long result) {
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("handleOnCallStatusChanged"){

            public void run(IUIElement ui) {
                ((LoginActivity)ui).handleOnCallStatusChanged(result);
            }
        });
    }

    private void handleOnCallStatusChanged(long result) {
        this.mLoginView.onCallStatusChanged(result);
    }

    private void sinkWebAccessFail() {
        this.getNonNullEventTaskManagerOrThrowException().push("sinkWebAccessFail", new EventAction("sinkWebAccessFail"){

            public void run(IUIElement ui) {
                ((LoginActivity)ui).handleOnWebAccessFail();
            }
        });
    }

    private void handleOnWebAccessFail() {
        this.mLoginView.onWebAccessFail();
    }

    @Override
    public void onIMLocalStatusChanged(final int status) {
        this.getNonNullEventTaskManagerOrThrowException().push(new EventAction("onIMLocalStatusChanged"){

            public void run(IUIElement ui) {
                ((LoginActivity)ui).handleOnIMLocalStatusChanged(status);
            }
        });
    }

    private void handleOnIMLocalStatusChanged(int status) {
        this.mLoginView.onIMLocalStatusChanged(status);
    }

    @Override
    public void onIMReceived(PTAppProtos.IMMessage message) {
    }

    @Override
    public void onIMBuddyPresence(PTAppProtos.BuddyItem item) {
    }

    @Override
    public void onIMBuddyPic(PTAppProtos.BuddyItem item) {
    }

    @Override
    public void onIMBuddySort() {
    }

    @Override
    public void onSubscriptionRequest() {
    }

    @Override
    public void onSubscriptionUpdate() {
    }

    @Override
    public void onQuerySSOVanityURL(String reqId, int result, String url) {
        this.mLoginView.onQuerySSOVanityURL(reqId, result, url);
    }

    @Override
    public void onQueryIPLocation(int result, PTAppProtos.IPLocationInfo ipInfo) {
    }

    @Override
    public void onGoogleAuthReturn(String accessToken, String refreshToken, long error, String errorStr) {
        PTUI.getInstance().removeAuthHandler(this);
        if (error == 0L) {
            this.mLoginView.startGoogleIMAuth(accessToken, refreshToken);
        } else {
            String message = this.getResources().getString(R.string.zm_alert_web_auth_failed_33814);
            LoginView.AuthFailedDialog.show(this, message);
        }
    }

    @Override
    public void onFacebookAuthReturn(String accessToken, long expiresIn, long error, String errorStr) {
        PTUI.getInstance().removeAuthHandler(this);
        if (error == 0L) {
            this.mLoginView.startFBIMAuth(accessToken, expiresIn);
        } else {
            String message = this.getResources().getString(R.string.zm_alert_web_auth_failed_33814);
            LoginView.AuthFailedDialog.show(this, message);
        }
    }

    @Override
    public void performDialogAction(int request, int action, Bundle args) {
        if (request == 1000) {
            if (action == -1) {
                PTUI.getInstance().ClearGDPRConfirmFlag();
                PTApp.getInstance().confirmGDPR(true);
            } else if (action == -2) {
                PTApp.getInstance().confirmGDPR(false);
            } else if (action == 1) {
                PTApp.getInstance().confirmGDPR(false);
            }
        } else if (action == FbConfirmCreateAccountDialog.ACTION_LOGIN_FB_FIRST) {
            this.mLoginView.loginFacebookWithAcceptedTos();
        }
    }

    @Override
    public void OnShowPrivacyDialog(String privacyUrl, String tosUrl) {
        this.showGDPRConfirmDialog(privacyUrl, tosUrl);
    }

    @Override
    public void NotifyUIToLogOut() {
        LogoutHandler.getInstance().startLogout();
        WelcomeActivity.show((Context)this, false, false);
        this.finish();
    }

    private void showGDPRConfirmDialog(String privacyUrl, String tosUrl) {
        if (StringUtil.isEmptyOrNull((String)privacyUrl) || StringUtil.isEmptyOrNull((String)tosUrl)) {
            return;
        }
        ZMGDPRConfirmDialog f = ZMGDPRConfirmDialog.findFragment(this.getSupportFragmentManager());
        if (f != null) {
            f.dismiss();
        }
        ZMGDPRConfirmDialog.showDialog(this, 1000, 1, tosUrl, privacyUrl);
    }

    @Override
    public void onAuthenticateSucceeded(FingerprintManager.AuthenticationResult result) {
        this.mLoginView.loginZoomWithFingerprint();
    }

    @Override
    public void onEnterPasswd() {
        this.mLoginView.requestFocusPasswd();
    }
}

