/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import com.zipow.videobox.fragment.JoinConfFragment;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.ptapp.PTApp;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.videomeetings.R;

public class JoinConfActivity
extends ZMActivity {
    public static final String ARG_CONF_NUMBER = "hangoutNumber";
    public static final String ARG_SCREEN_NAME = "screenName";
    public static final String ARG_URL_ACTION = "urlAction";

    public static void showJoinByNumber(Context context, String confNumber, String screenName) {
        if (context == null) {
            return;
        }
        Intent intent = new Intent(context, JoinConfActivity.class);
        intent.addFlags(131072);
        intent.putExtra(ARG_CONF_NUMBER, confNumber);
        intent.putExtra(ARG_SCREEN_NAME, screenName);
        context.startActivity(intent);
        if (context instanceof Activity) {
            ((Activity)context).overridePendingTransition(R.anim.zm_slide_in_bottom, R.anim.zm_fade_out);
        }
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(R.anim.zm_fade_in, R.anim.zm_slide_out_bottom);
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.overridePendingTransition(R.anim.zm_fade_in, R.anim.zm_slide_out_bottom);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null || !mainboard.isInitialized()) {
            this.finish();
            return;
        }
        if (savedInstanceState == null) {
            JoinConfFragment f = new JoinConfFragment();
            Intent intent = this.getIntent();
            if (intent != null) {
                String hangoutNumber = intent.getStringExtra(ARG_CONF_NUMBER);
                String screenName = intent.getStringExtra(ARG_SCREEN_NAME);
                String urlAction = intent.getStringExtra(ARG_URL_ACTION);
                Bundle bundle = new Bundle();
                bundle.putString(ARG_CONF_NUMBER, hangoutNumber);
                bundle.putString(ARG_SCREEN_NAME, screenName);
                bundle.putString(ARG_URL_ACTION, urlAction);
                f.setArguments(bundle);
            }
            this.getSupportFragmentManager().beginTransaction().add(0x1020002, (Fragment)f, JoinConfFragment.class.getName()).commit();
        }
    }

    public void onResume() {
        super.onResume();
        if (PTApp.getInstance().hasActiveCall()) {
            this.finish();
        }
    }
}

