/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ConfigurationInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.ForgetPasswordActivity;
import com.zipow.videobox.IMActivity;
import com.zipow.videobox.LauncherActivity;
import com.zipow.videobox.SetPasswordActivity;
import com.zipow.videobox.SignupActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.WelcomeActivity;
import com.zipow.videobox.fragment.CreateProfileFragment;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.UrlActionData;
import com.zipow.videobox.sdk.SDKCustomizedMeetingUIHelper;
import com.zipow.videobox.thirdparty.ThirdPartyHandler;
import com.zipow.videobox.util.IClientUriHandler;
import com.zipow.videobox.util.ZmPtUtils;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.ResourcesUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.thirdparty.login.facebook.AuthToken;
import us.zoom.thirdparty.login.facebook.FBSessionStore;
import us.zoom.videomeetings.R;

public class JoinByURLActivity
extends ZMActivity {
    public static final String ACTION_SWITCH_CALL = JoinByURLActivity.class.getName() + ".action.SWITCH_CALL";
    public static final String ARG_SCREEN_NAME = "screenName";
    public static final String ARG_URL_ACTION = "urlAction";
    private static final String TAG = JoinByURLActivity.class.getSimpleName();

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ZMActivity frontActivity = JoinByURLActivity.getFrontActivity();
        if (frontActivity instanceof SignupActivity || frontActivity instanceof ForgetPasswordActivity) {
            frontActivity.finish();
        }
    }

    public void onResume() {
        super.onResume();
        Intent intent = this.getIntent();
        if (intent == null) {
            this.finish();
            return;
        }
        if (!this.checkSupported()) {
            return;
        }
        Uri uri = intent.getData();
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null || !mainboard.isInitialized()) {
            this.finish();
            if (uri != null) {
                LauncherActivity.showLauncherActivityForUri(this, uri.toString());
            } else {
                LauncherActivity.showLauncherActivity(this, null, null);
            }
            return;
        }
        if (ACTION_SWITCH_CALL.equals(intent.getAction())) {
            PTApp.getInstance().forceLeaveCurrentCall();
            PTApp.getInstance().dispatchIdleMessage();
            String urlAction = intent.getStringExtra(ARG_URL_ACTION);
            String screenName = intent.getStringExtra(ARG_SCREEN_NAME);
            UrlActionData actionData = PTApp.getInstance().parseURLActionData(urlAction);
            String numberFromUrl = actionData != null ? actionData.getConfno() : null;
            String confIdFromUrl = actionData != null ? actionData.getConfid() : null;
            ZmPtUtils.switchToVendor(ZmPtUtils.parseVendorFromUrl(urlAction));
            if (actionData != null && actionData.getAction() == 1) {
                VideoBoxApplication.getInstance().setConfUIPreloaded(false);
                mainboard.notifyUrlAction(urlAction);
            } else if (StringUtil.isEmptyOrNull((String)numberFromUrl) && StringUtil.isEmptyOrNull((String)confIdFromUrl)) {
                mainboard.notifyUrlAction(urlAction);
            } else {
                ConfActivity.joinByUrl((Context)this, urlAction, screenName);
            }
            this.finish();
            return;
        }
        if (uri == null) {
            this.finish();
            return;
        }
        List pathSegments = uri.getPathSegments();
        if (pathSegments == null) {
            this.finish();
            return;
        }
        if (this.handleClientURI(uri)) {
            return;
        }
        if (this.handleSetPwdURI(uri)) {
            return;
        }
        ZmPtUtils.switchToVendor(ZmPtUtils.parseVendorFromUrl(uri.toString()));
        this.parseURLActionData(uri);
    }

    private void parseURLActionData(Uri uri) {
        String token;
        UrlActionData actionData = PTApp.getInstance().parseURLActionData(uri.toString());
        if (!PTApp.getInstance().isWebSignedOn() && actionData != null && actionData.getAction() == 1 && "0".equals(actionData.getSnsType()) && !StringUtil.isEmptyOrNull((String)(token = actionData.getSnsToken()))) {
            AuthToken authToken = new AuthToken();
            authToken.setAccessToken(token);
            authToken.setExpires(Integer.MAX_VALUE);
            FBSessionStore.save((String)"facebook-session", (AuthToken)authToken, (Context)this);
        }
        boolean canFinish = false;
        if (actionData != null) {
            int action = actionData.getAction();
            if (action == 2) {
                canFinish = this.joinByUrl(uri);
            } else if (action == 1) {
                canFinish = this.webStart(uri);
            } else if (action == 3) {
                Mainboard.getMainboard().notifyUrlAction(uri.toString());
                if (PTApp.getInstance().isWebSignedOn()) {
                    IMActivity.show((Context)this);
                } else {
                    this.showWelcomeUI();
                }
                canFinish = true;
            } else if (ThirdPartyHandler.parseAuthResult(this, action, uri)) {
                canFinish = true;
            } else {
                VideoBoxApplication.getInstance().setConfUIPreloaded(false);
                Mainboard.getMainboard().notifyUrlAction(uri.toString());
                canFinish = true;
            }
        } else {
            VideoBoxApplication.getInstance().setConfUIPreloaded(false);
            Mainboard.getMainboard().notifyUrlAction(uri.toString());
            canFinish = true;
        }
        if (canFinish) {
            this.finish();
        }
    }

    private boolean checkSupported() {
        boolean glversionSupported;
        ActivityManager activityManager = (ActivityManager)this.getSystemService("activity");
        if (activityManager == null) {
            return false;
        }
        ConfigurationInfo configurationInfo = activityManager.getDeviceConfigurationInfo();
        boolean bl = glversionSupported = configurationInfo.reqGlEsVersion >= 131072;
        if (!glversionSupported || Build.CPU_ABI.equals("armeabi") || Build.CPU_ABI.startsWith("armeabi-v6")) {
            new ZMAlertDialog.Builder((Context)this).setTitle(R.string.zm_app_name).setMessage(R.string.zm_msg_devices_not_supported).setCancelable(false).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.cancel();
                    JoinByURLActivity.this.finish();
                }
            }).show();
            return false;
        }
        return true;
    }

    private boolean joinByUrl(Uri uri) {
        if (!SDKCustomizedMeetingUIHelper.isSdkUsingCustomizedMeetingUI()) {
            return ConfActivity.joinByUrl((Context)this, uri.toString());
        }
        return SDKCustomizedMeetingUIHelper.handleSdkStartOrJoin((Context)this, uri.toString());
    }

    private boolean webStart(Uri uri) {
        if (!SDKCustomizedMeetingUIHelper.isSdkUsingCustomizedMeetingUI()) {
            return ConfActivity.webStart((Context)this, uri.toString());
        }
        return SDKCustomizedMeetingUIHelper.handleSdkStartOrJoin((Context)this, uri.toString());
    }

    public static void switchCallTo(Context context, String urlAction, String screenName) {
        Intent intent = new Intent(context, JoinByURLActivity.class);
        intent.setFlags(0x10000000);
        intent.setAction(ACTION_SWITCH_CALL);
        intent.putExtra(ARG_URL_ACTION, urlAction);
        intent.putExtra(ARG_SCREEN_NAME, screenName);
        context.startActivity(intent);
    }

    private boolean handleClientURI(Uri uri) {
        String zoomScheme = this.getZoomScheme();
        if (!zoomScheme.equals(uri.getScheme())) {
            return false;
        }
        if (!this.handleClientURIWithExtHandler(uri)) {
            if ("client".equals(uri.getHost())) {
                String path = uri.getPath();
                if ("/signup".equals(path)) {
                    this.showSignup();
                } else if ("/forgetpwd".equals(path)) {
                    this.showForgetPassowrd();
                }
            } else if ("open".equals(uri.getHost()) || "".equals(uri.getHost())) {
                this.showMainUI();
            } else {
                return false;
            }
        }
        this.finish();
        return true;
    }

    private boolean handleClientURIWithExtHandler(Uri uri) {
        String handlerClass = ResourcesUtil.getString((Context)this, (int)R.string.zm_config_ext_client_uri_handler);
        if (!StringUtil.isEmptyOrNull((String)handlerClass)) {
            try {
                Class<?> clazz = Class.forName(handlerClass);
                IClientUriHandler handler = (IClientUriHandler)clazz.newInstance();
                return handler.handleUri((Activity)this, uri);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private void showMainUI() {
        if (PTApp.getInstance().hasActiveCall()) {
            ConfActivity.returnToConf((Context)this);
        } else {
            this.showWelcomeUI();
        }
    }

    public void showWelcomeUI() {
        WelcomeActivity.show((Context)this, false, true, null, null);
        this.overridePendingTransition(0, 0);
    }

    private String getZoomScheme() {
        String zoomScheme = this.getString(R.string.zm_zoom_scheme);
        if (StringUtil.isEmptyOrNull((String)zoomScheme)) {
            zoomScheme = "zoomus";
        }
        return zoomScheme;
    }

    private void showSignup() {
        SignupActivity.show(this);
    }

    private void showForgetPassowrd() {
        ForgetPasswordActivity.show(this);
    }

    private boolean handleSetPwdURI(Uri uri) {
        String zoomScheme = this.getZoomScheme();
        if (!zoomScheme.equals(uri.getScheme())) {
            return false;
        }
        String path = uri.getPath();
        if (!"/setpwd".equals(path)) {
            return false;
        }
        String type = uri.getQueryParameter("type");
        String email = uri.getQueryParameter("email");
        String uname = uri.getQueryParameter("uname");
        String code = uri.getQueryParameter("code");
        String firstName = uri.getQueryParameter("fname");
        String lastName = uri.getQueryParameter("lname");
        if ("set".equals(type)) {
            this.showSetPassword(email, firstName, lastName, code);
        } else if ("reset".equals(type)) {
            this.showResetPassword(email, uname, code);
        }
        this.finish();
        return true;
    }

    private void showSetPassword(String email, String firstName, String lastName, String code) {
        CreateProfileFragment.showAsActivity(this, firstName, lastName, email, code);
    }

    private void showResetPassword(String email, String uname, String code) {
        SetPasswordActivity.show(this, uname, email, code);
    }
}

