/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentManager;
import android.view.Menu;
import android.view.MotionEvent;
import android.view.View;
import com.zipow.videobox.BuddyInviteActivity;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.IMChatActivity;
import com.zipow.videobox.JoinConfActivity;
import com.zipow.videobox.LauncherActivity;
import com.zipow.videobox.LoginActivity;
import com.zipow.videobox.MMChatActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.WelcomeActivity;
import com.zipow.videobox.fragment.BuddyInviteFragment;
import com.zipow.videobox.fragment.ForceUpdateDialogFragment;
import com.zipow.videobox.fragment.JoinConfFragment;
import com.zipow.videobox.fragment.MyProfileFragment;
import com.zipow.videobox.fragment.NewVersionDialog;
import com.zipow.videobox.fragment.SettingFragment;
import com.zipow.videobox.fragment.SimpleMessageDialog;
import com.zipow.videobox.fragment.SystemNotificationFragment;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.ptapp.IMHelper;
import com.zipow.videobox.ptapp.IMSession;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTBuddyHelper;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomChatSession;
import com.zipow.videobox.ptapp.mm.ZoomGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.sip.server.SipCallManager;
import com.zipow.videobox.util.DialogUtils;
import com.zipow.videobox.util.LoginUtil;
import com.zipow.videobox.util.NotificationMgr;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.util.UpgradeUtil;
import com.zipow.videobox.util.ZmPtUtils;
import com.zipow.videobox.view.IMBuddyItem;
import com.zipow.videobox.view.IMView;
import com.zipow.videobox.view.ScheduledMeetingItem;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMKeyboardDetector;
import us.zoom.androidlib.widget.ZMTipLayer;
import us.zoom.thirdparty.login.facebook.AuthToken;
import us.zoom.thirdparty.login.facebook.FBSessionStore;
import us.zoom.thirdparty.login.facebook.FacebookError;
import us.zoom.thirdparty.login.facebook.ServiceListener;
import us.zoom.videomeetings.R;

public class IMActivity
extends ZMActivity
implements PTUI.IPTUIListener,
PTUI.IIMListener,
PTUI.IConfInvitationListener,
PTUI.IPhoneABListener {
    private static final String TAG = IMActivity.class.getSimpleName();
    public static final String ACTION_SHOW_UNREAD_MESSAGE = IMActivity.class.getName() + ".action.SHOW_UNREAD_MESSAGE";
    public static final String ACTION_SHOW_UNREAD_MESSAGE_MM = IMActivity.class.getName() + ".action.SHOW_UNREAD_MESSAGE_MM";
    public static final String ACTION_SHOW_JOIN_BY_NO = IMActivity.class.getName() + ".action.ACTION_SHOW_JOIN_BY_NO";
    public static final String ACTION_SHOW_LOGIN_TO_USE = IMActivity.class.getName() + ".action.ACTION_SHOW_LOGIN_TO_USE";
    public static final String ACTION_LOGIN_AS_HOST = IMActivity.class.getName() + ".action.ACTION_LOGIN_AS_HOST";
    public static final String ACTION_SHOW_AND_UPGRADE = IMActivity.class.getName() + ".action.ACTION_SHOW_AND_UPGRADE";
    public static final String ARG_JOIN_MEETING_URL = IMActivity.class.getName() + ".arg.join.meeting.url";
    public static final String ARG_NEW_VERSIONS = "ARG_NEW_VERSIONS";
    public static final String ARG_USE_PASSWD = "ARG_USE_PASSWD";
    public static final int REQUEST_CHAT = 100;
    public static final int REQUEST_SETTINGS = 101;
    public static final int REQUEST_INVITE_BUDDY = 102;
    public static final int REQUEST_SCHEDULE = 103;
    public static final int REQUEST_MEETINGINFO = 104;
    public static final int REQUEST_HISTORYINFO = 105;
    public static final int REQUEST_AB_DETAILS = 106;
    public static final int REQUEST_STORAGE_NEW_VERSION = 107;
    private static final String ARG_CLEAR_OTHER_ACTIVITIES = "clearOtherActivities";
    private IMView mIMView;
    private ZMKeyboardDetector mKeyboardDetector;
    private ZMTipLayer mTipLayer;
    private static boolean gbShowStartCallFailedNeedUpdate = false;
    private AuthToken mFacebookAuthToken;
    private Boolean mIsAddressBookEnalbed = null;
    private ZoomMessengerUI.IZoomMessengerUIListener mZoomMessengerUIListener;
    private SipCallManager.OnSipCallEventListener mOnSipCallEventListener = new SipCallManager.OnSipCallEventListener(){

        @Override
        public void onSipCallEvent(int event, String callId) {
            IMActivity.this.onSipCallEvent(event, callId);
        }
    };
    private boolean mbReturnToMeetingOnResume = false;

    public static void show(Context context) {
        IMActivity.show(context, false, null, null);
    }

    public static void showWithPasswd(Context context) {
        Bundle extras = new Bundle();
        extras.putBoolean(ARG_USE_PASSWD, true);
        IMActivity.show(context, false, null, extras);
    }

    public static void show(Context context, boolean clearOthers) {
        IMActivity.show(context, clearOthers, null, null);
    }

    public static void show(Context context, boolean clearOthers, String action) {
        IMActivity.show(context, clearOthers, action, null);
    }

    public static void show(Context context, boolean clearOthers, String action, Bundle extras) {
        Intent i = new Intent(context, IMActivity.class);
        i.addFlags(131072);
        if (!(context instanceof Activity)) {
            i.addFlags(0x10000000);
        }
        if (action != null) {
            i.setAction(action);
        }
        i.putExtra(ARG_CLEAR_OTHER_ACTIVITIES, clearOthers);
        if (extras != null) {
            i.putExtras(extras);
        }
        context.startActivity(i);
    }

    public static void showJoinByNumber(Context context) {
        Intent i = new Intent(context, IMActivity.class);
        i.setAction(ACTION_SHOW_JOIN_BY_NO);
        i.addFlags(131072);
        ZMActivity curActivity = ZMActivity.getFrontActivity();
        if (curActivity == null) {
            i.addFlags(0x10000000);
        } else {
            context = curActivity;
        }
        context.startActivity(i);
    }

    public static void showLoginToUse(Context context) {
        Intent i = new Intent(context, IMActivity.class);
        i.setAction(ACTION_SHOW_LOGIN_TO_USE);
        i.addFlags(131072);
        if (!(context instanceof Activity)) {
            i.addFlags(0x10000000);
        }
        context.startActivity(i);
    }

    public static void showStartCallFailedNeedUpdateOnResume() {
        gbShowStartCallFailedNeedUpdate = true;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.disableFinishActivityByGesture(true);
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null || !mainboard.isInitialized()) {
            this.showLauncherActivity();
            this.finish();
            return;
        }
        if (UIMgr.isLargeMode((Context)this) && !UIMgr.isDualPaneSupportedInPortraitMode((Context)this)) {
            this.setRequestedOrientation(0);
        } else if (UIUtil.isTablet((Context)this)) {
            this.setRequestedOrientation(4);
        } else if (PTApp.getInstance().hasMessenger()) {
            this.setRequestedOrientation(1);
        }
        this.setContentView(R.layout.zm_im_main_screen);
        this.mIMView = (IMView)this.findViewById(R.id.imView);
        this.mTipLayer = (ZMTipLayer)this.findViewById(R.id.tipLayer);
        this.mKeyboardDetector = (ZMKeyboardDetector)this.findViewById(R.id.keyboardDetector);
        this.mKeyboardDetector.setKeyboardListener((ZMKeyboardDetector.KeyboardListener)this.mIMView);
        this.initTipLayer();
        PTUI.getInstance().addPTUIListener(this);
        PTUI.getInstance().addIMListener(this);
        PTUI.getInstance().addConfInvitationListener(this);
        PTUI.getInstance().addPhoneABListener(this);
        PTApp.getInstance().setLanguageIdAsSystemConfiguration();
        this.checkFingerPrint();
    }

    private void checkFingerPrint() {
        Intent intent = this.getIntent();
        if (intent == null) {
            return;
        }
        Bundle bundle = intent.getExtras();
        if (bundle == null) {
            return;
        }
        if (bundle.getBoolean(ARG_USE_PASSWD, false) && PTApp.getInstance().getPTLoginType() == 100 && ZmPtUtils.isSupportFingerprintAndDisableFingerprintWithUserInfo(this)) {
            DialogUtils.showAlertDialog(this, R.string.zm_title_confirm_sign_in_fingerprint_22438, R.string.zm_btn_ok, R.string.zm_btn_cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int i) {
                    MyProfileFragment.FingerprintOption fingerprintOption = MyProfileFragment.FingerprintOption.readFromPreference();
                    if (fingerprintOption != null && !fingerprintOption.ismEnableFingerprint()) {
                        fingerprintOption.setmEnableFingerprint(true);
                        fingerprintOption.savePreference();
                    }
                }
            });
        }
    }

    private void showLauncherActivity() {
        String action;
        Intent intent = this.getIntent();
        String string2 = action = intent != null ? intent.getAction() : null;
        if (intent != null) {
            Bundle extras = intent.getExtras();
            LauncherActivity.showLauncherActivity(this, action, extras);
        }
        this.finish();
    }

    private void initTipLayer() {
        if (this.mTipLayer != null) {
            this.mTipLayer.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    return IMActivity.this.closeTips();
                }
            });
        }
    }

    public boolean isKeyboardOpen() {
        if (this.mKeyboardDetector == null) {
            return false;
        }
        return this.mKeyboardDetector.isKeyboardOpen();
    }

    protected void onNewIntent(Intent intent) {
        this.setIntent(intent);
    }

    private void showUnreadMessageThirdPartyIM() {
        PTAppProtos.BuddyItem proto;
        IMHelper imHelper = PTApp.getInstance().getIMHelper();
        if (imHelper == null) {
            return;
        }
        PTBuddyHelper buddyHelper = PTApp.getInstance().getBuddyHelper();
        if (buddyHelper == null) {
            return;
        }
        int cntBuddy = buddyHelper.getBuddyItemCount();
        String buddyHasMsg = null;
        for (int i = 0; i < cntBuddy; ++i) {
            String jid = buddyHelper.getBuddyItemJid(i);
            IMSession session = imHelper.getSessionBySessionName(jid);
            if (session == null || session.getUnreadMessageCount() <= 0) continue;
            if (buddyHasMsg != null) {
                this.mIMView.showBuddyList();
                return;
            }
            buddyHasMsg = jid;
        }
        if (buddyHasMsg != null && (proto = buddyHelper.getBuddyItemByJid(buddyHasMsg)) != null) {
            IMBuddyItem item = new IMBuddyItem().parseFromProtoItem(proto);
            this.showChatUI(item);
        }
    }

    private void showUnreadMessageMM() {
        IMHelper imHelper;
        NotificationMgr.removeMessageNotificationMM((Context)this);
        int countOfZoomMessenger = 0;
        int countOfThirdPartyIM = 0;
        int countOfSystemNotification = 0;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null) {
            String sessionId;
            countOfZoomMessenger = messenger.getTotalUnreadMessageCount();
            countOfSystemNotification = messenger.getUnreadRequestCount();
            Intent intent = this.getIntent();
            if (intent != null && !StringUtil.isEmptyOrNull((String)(sessionId = intent.getStringExtra("unreadMsgSession")))) {
                if ("######SYSTEM_NOTIFICATION_SESSION".equals(sessionId)) {
                    this.showSystemNotification();
                } else {
                    ZoomChatSession session = messenger.getSessionById(sessionId);
                    if (session != null) {
                        if (session.isGroup()) {
                            ZoomGroup group = session.getSessionGroup();
                            if (group == null) {
                                return;
                            }
                            String groupId = group.getGroupID();
                            if (StringUtil.isEmptyOrNull((String)groupId)) {
                                return;
                            }
                            this.startGroupChat(groupId);
                        } else {
                            ZoomBuddy buddy = session.getSessionBuddy();
                            if (buddy == null) {
                                return;
                            }
                            this.startOneToOneChat(buddy);
                        }
                        return;
                    }
                }
            }
        }
        if ((imHelper = PTApp.getInstance().getIMHelper()) != null) {
            countOfThirdPartyIM = imHelper.getUnreadMsgCount();
        }
        if (countOfSystemNotification == 0 && countOfZoomMessenger == 0 && countOfThirdPartyIM > 0) {
            this.showUnreadMessageThirdPartyIM();
        }
        if (countOfSystemNotification == 0 && countOfZoomMessenger > 0 && countOfThirdPartyIM == 0) {
            this.mIMView.showChatsList();
        } else if (countOfSystemNotification > 0 && countOfZoomMessenger == 0 && countOfThirdPartyIM == 0) {
            this.showSystemNotification();
        } else {
            this.mIMView.showChatsList();
        }
    }

    private void showSystemNotification() {
        SystemNotificationFragment.showAsActivity(this, 0);
    }

    private void startOneToOneChat(ZoomBuddy buddy) {
        MMChatActivity.showAsOneToOneChat(this, buddy);
    }

    private void startGroupChat(String groupId) {
        MMChatActivity.showAsGroupChat(this, groupId);
    }

    private void showJoinByNo() {
        if (UIMgr.isLargeMode((Context)this)) {
            JoinConfFragment.showJoinByNumber(this.getSupportFragmentManager(), null, null);
        } else {
            JoinConfActivity.showJoinByNumber((Context)this, null, null);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.isFinishing() && !PTApp.getInstance().isPhoneNumberRegistered()) {
            NotificationMgr.removeMessageNotificationMM((Context)this);
        }
        if (this.mIMView != null) {
            this.mIMView.onActivityDestroy();
        }
        if (this.isFinishing()) {
            PTUI.getInstance().removePTUIListener(this);
            PTUI.getInstance().removeIMListener(this);
            PTUI.getInstance().removeConfInvitationListener(this);
            PTUI.getInstance().removePhoneABListener(this);
        }
    }

    protected void onStart() {
        super.onStart();
        SipCallManager.getInstance().addListener(this.mOnSipCallEventListener);
    }

    protected void onStop() {
        SipCallManager.getInstance().removeListener(this.mOnSipCallEventListener);
        super.onStop();
    }

    public void onResume() {
        Intent intent;
        NotificationMgr.removeLoginExpiredNotificaiton((Context)this);
        this.finishSubActivities();
        super.onResume();
        if (this.mbReturnToMeetingOnResume) {
            this.mbReturnToMeetingOnResume = false;
            if (PTApp.getInstance().hasActiveCall()) {
                ConfActivity.returnToConf((Context)this);
            }
        }
        if (this.mIMView == null) {
            return;
        }
        if (this.mFacebookAuthToken == null) {
            this.mFacebookAuthToken = FBSessionStore.getSession((Context)this, (String)"facebook-session");
        }
        if ((intent = this.getIntent()) == null) {
            return;
        }
        boolean bNeedCheckAutoLogin = true;
        if (ACTION_SHOW_UNREAD_MESSAGE.equals(intent.getAction())) {
            this.showUnreadMessageThirdPartyIM();
        } else if (ACTION_SHOW_UNREAD_MESSAGE_MM.equals(intent.getAction())) {
            this.showUnreadMessageMM();
        } else if (ACTION_SHOW_JOIN_BY_NO.equals(intent.getAction())) {
            this.showJoinByNo();
        } else if (ACTION_SHOW_LOGIN_TO_USE.equals(intent.getAction())) {
            this.loginToUse();
            bNeedCheckAutoLogin = false;
        } else if (ACTION_LOGIN_AS_HOST.equals(intent.getAction())) {
            String joinMeetingUrl = intent.getStringExtra(ARG_JOIN_MEETING_URL);
            int vendor = -999;
            if (joinMeetingUrl != null) {
                vendor = ZmPtUtils.parseVendorFromUrl(joinMeetingUrl);
                ZmPtUtils.switchToVendor(vendor);
            }
            this.loginToUse(vendor);
            this.mbReturnToMeetingOnResume = true;
            bNeedCheckAutoLogin = false;
        } else if (ACTION_SHOW_AND_UPGRADE.equals(intent.getAction())) {
            UpgradeUtil.upgrade(this);
        }
        if (bNeedCheckAutoLogin) {
            this.checkAutoLogin();
        }
        intent.setAction(null);
        boolean clearOtherActivities = intent.getBooleanExtra(ARG_CLEAR_OTHER_ACTIVITIES, false);
        if (clearOtherActivities) {
            int activityCount = ZMActivity.getInProcessActivityCountInStack();
            if (activityCount > 0) {
                for (int i = activityCount - 1; i >= 0; --i) {
                    ZMActivity activity = ZMActivity.getInProcessActivityInStackAt((int)i);
                    if (activity instanceof IMActivity || activity == null) continue;
                    activity.finish();
                }
            }
            intent.putExtra(ARG_CLEAR_OTHER_ACTIVITIES, false);
        }
        this.setIntent(intent);
        if (gbShowStartCallFailedNeedUpdate) {
            ForceUpdateDialogFragment.show(this.getSupportFragmentManager());
            gbShowStartCallFailedNeedUpdate = false;
        }
        if (this.mZoomMessengerUIListener == null) {
            this.mZoomMessengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

                @Override
                public boolean onIndicateMessageReceived(String sessionId, String senderJid, String messageId) {
                    IMActivity.this.onZoomMessengerMessageReceived();
                    return false;
                }

                @Override
                public void onIndicateBuddyListUpdated() {
                    IMActivity.this.onIndicateZoomMessengerBuddyListUpdated();
                }

                @Override
                public boolean onNotifySubscribeRequest(String jid, String msg) {
                    return IMActivity.this.onZoomMessengerNotifySubscribeRequest();
                }

                @Override
                public boolean onNotifySubscriptionAccepted(String jid) {
                    return IMActivity.this.onZoomMessengerNotifySubscribeRequest();
                }

                @Override
                public boolean onNotifySubscriptionDenied(String jid) {
                    return IMActivity.this.onZoomMessengerNotifySubscribeRequest();
                }

                @Override
                public void onReceivedCall(String groupId, String senderJid, PTAppProtos.InvitationItem item) {
                    IMActivity.this.onZoomMessengerMessageReceived();
                }

                @Override
                public void onNotify_ChatSessionListUpdate() {
                    IMActivity.this.onZoomMessengerChatSessionListUpdate();
                }

                @Override
                public void onNotifySubscribeRequestUpdated(String jid) {
                    IMActivity.this.onZoomMessengerNotifySubscribeRequestUpdated(jid);
                }

                @Override
                public void Indicate_RevokeMessageResult(String actionOwner, String sessionId, String guid, String recallMsgId, boolean result) {
                    IMActivity.this.onZoomMessengerIndicateRevokeMessageResult(actionOwner, sessionId, guid, recallMsgId, result);
                }

                @Override
                public void onNotify_ChatSessionUnreadUpdate() {
                    IMActivity.this.onZoomMessengerNotifyChatSessionUnreadUpdate();
                }
            };
        }
        ZoomMessengerUI.getInstance().addListener(this.mZoomMessengerUIListener);
        Boolean oldIsAddressBookEnalbed = this.mIsAddressBookEnalbed;
        this.mIsAddressBookEnalbed = PTApp.getInstance().isPhoneNumberRegistered();
        if (oldIsAddressBookEnalbed != null && !this.mIsAddressBookEnalbed.equals(oldIsAddressBookEnalbed)) {
            this.onAddressBookEnabled(this.mIsAddressBookEnalbed);
        }
        PTUI.getInstance().checkStartKubiService();
        this.mIMView.onResume();
        this.checkNewVersionReadyBeforeShowIM();
    }

    protected void onSaveInstanceState(Bundle outState) {
        if (outState != null) {
            outState.putBoolean("mbReturnToMeetingOnResume", this.mbReturnToMeetingOnResume);
        }
        super.onSaveInstanceState(outState);
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            this.mbReturnToMeetingOnResume = savedInstanceState.getBoolean("mbReturnToMeetingOnResume");
        }
        super.onRestoreInstanceState(savedInstanceState);
    }

    private void checkNewVersionReadyBeforeShowIM() {
        Intent intent = this.getIntent();
        if (intent == null) {
            return;
        }
        Bundle extras = intent.getExtras();
        if (extras == null || !extras.getBoolean(ARG_NEW_VERSIONS, false)) {
            return;
        }
        this.handleOnNewVersionReady();
        extras.putBoolean(ARG_NEW_VERSIONS, false);
        intent.putExtras(extras);
    }

    private void checkAutoLogin() {
        this.checkAutoLogin(true);
    }

    public void onSipCallEvent(int event, String callId) {
        if (this.isActive()) {
            this.mIMView.onSipCallEvent(event, callId);
        }
    }

    public void onIndicateZoomMessengerBuddyListUpdated() {
        if (this.isActive()) {
            this.mIMView.onIndicateZoomMessengerBuddyListUpdated();
        }
    }

    public boolean onZoomMessengerNotifySubscribeRequest() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null || messenger.imChatGetOption() == 2) {
            return false;
        }
        if (this.isActive()) {
            this.mIMView.onZoomMessengerNotifySubscribeRequest();
        }
        return false;
    }

    private void checkAutoLogin(boolean checkIM) {
        IMHelper imHelper = PTApp.getInstance().getIMHelper();
        if (!(PTApp.getInstance().isWebSignedOn() || PTApp.getInstance().isAuthenticating() || imHelper != null && (imHelper.isIMSignedOn() || imHelper.isIMLoggingIn()))) {
            this.autoLogin();
        } else if (checkIM && imHelper != null && PTApp.getInstance().isCurrentLoginTypeSupportIM() && !imHelper.isIMSignedOn() && !imHelper.isIMLoggingIn()) {
            PTUI.getInstance().reconnectIM();
        }
        if (this.isActive()) {
            this.mIMView.updateUI();
        }
    }

    public void onPause() {
        super.onPause();
        ZoomMessengerUI.getInstance().removeListener(this.mZoomMessengerUIListener);
    }

    private void switchAccount() {
        PTApp.getInstance().logout(1);
        this.showLoginUI(false);
    }

    public void loginToUse() {
        this.switchAccount();
    }

    public void loginToUse(int vendor) {
        PTApp.getInstance().logout(1, vendor != 1);
        LoginUtil.showLoginUI((Context)this, false, vendor);
    }

    public void autoLoginByDeviceAfterLogout() {
        this.checkAutoLogin();
    }

    private void autoLogin() {
        if (!NetworkUtil.hasDataNetwork((Context)VideoBoxApplication.getInstance())) {
            if (!PTApp.getInstance().isWebSignedOn()) {
                this.finishAndShowWelcome();
            }
            return;
        }
        if (PTApp.getInstance().isTokenExpired()) {
            return;
        }
        if (PTApp.getInstance().getPTLoginType() == 2) {
            if (!PTApp.getInstance().autoSignin()) {
                this.showLoginUIForTokenExpired(true);
            }
        } else if (PTApp.getInstance().getPTLoginType() == 0) {
            if (this.mFacebookAuthToken.isSessionValid()) {
                boolean shouldAutoSignIn;
                block29: {
                    shouldAutoSignIn = false;
                    if (this.mFacebookAuthToken.shouldExtendAccessToken()) {
                        try {
                            if (this.mFacebookAuthToken.extendAccessToken(this.getApplicationContext(), (ServiceListener)new ExtendTokenServiceListener())) {
                                shouldAutoSignIn = false;
                                break block29;
                            }
                            shouldAutoSignIn = true;
                        }
                        catch (Exception exception) {}
                    } else {
                        shouldAutoSignIn = true;
                    }
                }
                if (shouldAutoSignIn && !PTApp.getInstance().autoSignin()) {
                    this.showLoginUIForTokenExpired(true);
                }
            } else {
                this.showLoginUIForTokenExpired(true);
            }
        } else if (PTApp.getInstance().getPTLoginType() == 100) {
            PTAppProtos.ZoomAccount account = PTApp.getInstance().getSavedZoomAccount();
            if (account != null && !StringUtil.isEmptyOrNull((String)account.getUserName())) {
                if (!PTApp.getInstance().autoSignin()) {
                    this.showLoginUIForTokenExpired(true);
                }
            } else {
                this.finishAndShowWelcome();
            }
        } else if (PTApp.getInstance().getPTLoginType() == 101) {
            if (!PTApp.getInstance().autoSignin()) {
                this.showLoginUIForTokenExpired(true);
            }
        } else if (PTApp.getInstance().getPTLoginType() == 98) {
            String[] phoneNumber = new String[1];
            String[] ext = new String[1];
            PTApp.getInstance().getSavedRingCentralPhoneNumberAndExt(phoneNumber, ext);
            if (phoneNumber[0] != null && !StringUtil.isEmptyOrNull((String)phoneNumber[0])) {
                if (!PTApp.getInstance().autoSignin()) {
                    this.showLoginUIForTokenExpired(true);
                }
            } else {
                this.finishAndShowWelcome();
            }
        } else {
            this.finishAndShowWelcome();
        }
    }

    private void finishAndShowWelcome() {
        WelcomeActivity.show((Context)this, false, false);
        this.finish();
    }

    private void showLoginUIForTokenExpired(final boolean autoLogin) {
        PTApp.getInstance().setTokenExpired(true);
        this.getNonNullEventTaskManagerOrThrowException().push("showLoginUIForTokenExpired", new EventAction(){

            public void run(IUIElement ui) {
                LoginUtil.showLoginUI((Context)IMActivity.this, autoLogin, -999);
            }
        });
    }

    private void onFBTokenExtended(String token) {
        FBSessionStore.save((String)"facebook-session", (AuthToken)this.mFacebookAuthToken, (Context)this);
        if (StringUtil.isEmptyOrNull((String)token)) {
            return;
        }
        long expiresInSeconds = (this.mFacebookAuthToken.expires - System.currentTimeMillis()) / 1000L;
        PTApp ptApp = PTApp.getInstance();
        ptApp.loginXmppServer(token);
        ptApp.loginWithFacebook(token, expiresInSeconds);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.mIMView == null) {
            return;
        }
        this.mIMView.onConfigurationChanged(newConfig);
    }

    private void finishSubActivities() {
        this.finishActivity(100);
        this.finishActivity(101);
        this.finishActivity(102);
        this.finishActivity(103);
        this.finishActivity(104);
        this.finishActivity(105);
        this.finishActivity(106);
    }

    public void onBackPressed() {
        if (this.closeTips()) {
            return;
        }
        if (this.mIMView.onBackPressed()) {
            return;
        }
        this.moveTaskToBack(true);
    }

    public boolean onSearchRequested() {
        return this.mIMView.onSearchRequested();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 103 && resultCode == -1) {
            if (data == null) {
                return;
            }
            ScheduledMeetingItem item = (ScheduledMeetingItem)data.getSerializableExtra("meetingItem");
            this.onScheduleSuccess(item);
        }
    }

    public void onScheduleSuccess(ScheduledMeetingItem item) {
        this.mIMView.onScheduleSuccess(item);
    }

    public void onAddressBookEnabled(boolean enabled) {
        this.mIMView.onAddressBookEnabled(enabled);
    }

    private boolean closeTips() {
        return this.mIMView.closeTips();
    }

    public void onClickJoinConf() {
        JoinConfActivity.showJoinByNumber((Context)this, null, null);
    }

    public void showChatUI(IMBuddyItem buddyItem) {
        this.mIMView.showChatUI(buddyItem);
    }

    public void showLoginUI(boolean autoLogin) {
        LoginUtil.showLoginUI((Context)this, autoLogin, -999);
    }

    public void showBuddyInviteUI(IMBuddyItem buddyItem) {
        if (UIMgr.isLargeMode((Context)this)) {
            FragmentManager fm = this.getSupportFragmentManager();
            BuddyInviteFragment.showDialog(fm, buddyItem.userId);
        } else {
            BuddyInviteActivity.show(this, 102, buddyItem.userId);
        }
    }

    @Override
    public void onPTAppEvent(int event, long result) {
        switch (event) {
            case 9: {
                this.sinkMyInfoReady(result);
                break;
            }
            case 12: {
                this.sinkMyPictureReady(result);
                break;
            }
            case 8: {
                this.sinkIMLogin(result);
                break;
            }
            case 1: {
                this.sinkWebLogout(result);
                break;
            }
            case 14: {
                this.sinkIMLogout(result);
                break;
            }
            case 0: {
                this.sinkWebLogin(result);
                break;
            }
            case 22: {
                this.sinkCallStatusChanged(result);
                break;
            }
            case 21: {
                this.sinkOnIMReconnecting();
                break;
            }
            case 23: {
                this.sinkCallPlistChanged();
                break;
            }
            case 35: {
                this.sinkGoogleWebAccessFail();
                break;
            }
            case 25: {
                this.onNewVersionReady(result);
            }
        }
    }

    @Override
    public void onDataNetworkStatusChanged(boolean connected) {
        IMHelper imHelper;
        if (this.isActive() && PTApp.getInstance().isWebSignedOn() && (imHelper = PTApp.getInstance().getIMHelper()) != null) {
            this.mIMView.onIMLocalStatusChanged(imHelper.getIMLocalStatus());
        }
        if (connected) {
            this.checkAutoLogin(false);
        }
    }

    private void sinkMyInfoReady(long result) {
        if (this.isActive()) {
            this.mIMView.onMyInfoReady();
        }
    }

    private void sinkMyPictureReady(long result) {
        if (this.isActive()) {
            this.mIMView.onMyPictureReady();
        }
    }

    private void sinkIMLogout(long result) {
    }

    private void sinkWebLogout(long result) {
        if (this.isActive()) {
            this.handleOnWebLogout(result);
        }
    }

    private void handleOnWebLogout(long result) {
    }

    private void sinkIMLogin(long result) {
        if (this.isActive()) {
            this.mIMView.onIMLogin(result);
        }
    }

    private void sinkWebLogin(long result) {
        if (this.isActive()) {
            this.mIMView.onWebLogin(result);
        }
    }

    private void sinkCallStatusChanged(long result) {
        if (this.isActive()) {
            this.mIMView.onCallStatusChanged(result);
        }
    }

    private void sinkCallPlistChanged() {
        if (this.isActive()) {
            this.mIMView.onCallPlistChanged();
        }
    }

    private void sinkGoogleWebAccessFail() {
        if (this.isActive()) {
            this.mIMView.onGoogleWebAccessFail();
        }
    }

    @Override
    public void onIMLocalStatusChanged(int status) {
        if (this.isActive()) {
            this.mIMView.onIMLocalStatusChanged(status);
        }
    }

    private void sinkOnIMReconnecting() {
        if (this.isActive()) {
            IMHelper imHelper = PTApp.getInstance().getIMHelper();
            if (imHelper == null) {
                return;
            }
            this.mIMView.onIMLocalStatusChanged(imHelper.getIMLocalStatus());
        }
    }

    @Override
    public void onIMReceived(PTAppProtos.IMMessage message) {
        if (this.isActive()) {
            this.mIMView.onIMReceived(message);
        }
        if (message.getMessageType() == 0) {
            IMHelper imHelper = PTApp.getInstance().getIMHelper();
            if (imHelper == null) {
                return;
            }
            String jid = imHelper.getJIDMyself();
            if (jid != null && jid.equals(message.getFromScreenName())) {
                imHelper.setIMMessageUnread(message, false);
                return;
            }
            ZMActivity frontActivity = ZMActivity.getFrontActivity();
            if (!(frontActivity instanceof IMChatActivity) || !frontActivity.isActive()) {
                NotificationMgr.showMessageNotificationMM((Context)this, true);
            }
        }
    }

    @Override
    public void onIMBuddyPresence(PTAppProtos.BuddyItem item) {
        if (this.isActive()) {
            this.mIMView.onIMBuddyPresence(item);
        }
    }

    @Override
    public void onIMBuddyPic(PTAppProtos.BuddyItem item) {
        if (this.isActive()) {
            this.mIMView.onIMBuddyPic(item);
        }
    }

    @Override
    public void onIMBuddySort() {
        if (this.isActive()) {
            this.mIMView.onIMBuddySort();
        }
    }

    @Override
    public void onSubscriptionRequest() {
        if (this.isActive()) {
            this.mIMView.onSubscriptionRequest();
        }
    }

    @Override
    public void onSubscriptionUpdate() {
        if (this.isActive()) {
            this.mIMView.onSubscriptionUpdate();
        }
    }

    @Override
    public void onConfInvitation(PTAppProtos.InvitationItem invitation) {
    }

    @Override
    public void onCallAccepted(PTAppProtos.InvitationItem item) {
    }

    @Override
    public void onCallDeclined(PTAppProtos.InvitationItem item) {
    }

    @Override
    public void onPhoneABEvent(int event, long result, Object content) {
        if (event == 3) {
            if (result == 1104L) {
                this.getNonNullEventTaskManagerOrThrowException().push("onPhoneBindByOther", new EventAction("onPhoneBindByOther"){

                    public void run(IUIElement ui) {
                        ((IMActivity)ui).onPhoneBindByOther();
                    }
                });
            } else if (result == 1102L) {
                this.getNonNullEventTaskManagerOrThrowException().push("onPhoneNotExist", new EventAction("onPhoneNotExist"){

                    public void run(IUIElement ui) {
                        ((IMActivity)ui).onPhoneNotExist();
                    }
                });
            }
        }
    }

    private void onPhoneBindByOther() {
        this.mIMView.reloadView();
        this.showPhoneBindByOtherDialog();
    }

    private void onPhoneNotExist() {
        this.mIMView.reloadView();
    }

    private void showPhoneBindByOtherDialog() {
        SimpleMessageDialog dialog = SimpleMessageDialog.newInstance(R.string.zm_msg_phone_bind_by_other);
        dialog.show(this.getSupportFragmentManager(), "BindByOtherMessageDialog");
    }

    private void onZoomMessengerMessageReceived() {
        this.mIMView.post(new Runnable(){

            @Override
            public void run() {
                if (IMActivity.this.isActive()) {
                    IMActivity.this.mIMView.onZoomMessengerMessageReceived();
                }
            }
        });
    }

    private void onZoomMessengerNotifySubscribeRequestUpdated(String jid) {
        if (this.isActive()) {
            this.mIMView.onZoomMessengerChatSessionListUpdate();
        }
    }

    private void onZoomMessengerNotifyChatSessionUnreadUpdate() {
        if (this.isActive()) {
            this.mIMView.onZoomMessengerNotifyChatSessionUnreadUpdate();
        }
    }

    private void onZoomMessengerChatSessionListUpdate() {
        if (this.isActive()) {
            this.mIMView.onZoomMessengerChatSessionListUpdate();
        }
    }

    private void onZoomMessengerIndicateRevokeMessageResult(String actionOwner, String sessionId, String guid, String recallMsgId, boolean result) {
        if (this.isActive()) {
            this.mIMView.onZoomMessengerIndicateRevokeMessageResult(actionOwner, sessionId, guid, recallMsgId, result);
        }
    }

    public void onMMSessionDeleted(String sessionId) {
        int countAll;
        IMHelper imHelper;
        this.mIMView.onMMSessionDeleted(sessionId);
        int countOfZoomMessenger = 0;
        int countOfThirdPartyIM = 0;
        int countOfSystemNotification = 0;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null) {
            countOfZoomMessenger = messenger.getTotalUnreadMessageCount();
            countOfSystemNotification = messenger.getUnreadRequestCount();
        }
        if ((imHelper = PTApp.getInstance().getIMHelper()) != null) {
            countOfThirdPartyIM = imHelper.getUnreadMsgCount();
        }
        if ((countAll = countOfZoomMessenger + countOfThirdPartyIM + countOfSystemNotification) == 0) {
            NotificationMgr.removeMessageNotificationMM((Context)this);
        }
        NotificationMgr.removeMessageNotificationMM((Context)this, sessionId);
    }

    private void onNewVersionReady(long result) {
        SettingFragment.saveNewVersionReadyTime();
        if (this.isActive()) {
            this.handleOnNewVersionReady();
        }
    }

    private void handleOnNewVersionReady() {
        if (this.mIMView != null) {
            this.mIMView.onNewVersionReady();
        }
        String version = PTApp.getInstance().getLatestVersionString();
        String note = PTApp.getInstance().getLatestVersionReleaseNote();
        NewVersionDialog oldDlg = (NewVersionDialog)this.getSupportFragmentManager().findFragmentByTag(NewVersionDialog.class.getName());
        if (oldDlg != null) {
            oldDlg.setArguments(version, note);
            return;
        }
        NewVersionDialog oldNewVersionDialog = NewVersionDialog.getLastInstance();
        if (oldNewVersionDialog != null) {
            oldNewVersionDialog.setArguments(version, note);
            return;
        }
        long time = PTApp.getInstance().getLastUpdateNotesDisplayTime();
        if (System.currentTimeMillis() - time < 43200000L) {
            return;
        }
        PTApp.getInstance().setLastUpdateNotesDisplayTime(System.currentTimeMillis());
        NewVersionDialog dlg = NewVersionDialog.newInstance(version, note, new NewVersionDialog.RequestPermissionListener(){

            @Override
            public void requestPermission() {
                IMActivity.this.zm_requestPermissions(new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, 107);
            }
        });
        dlg.show(this.getSupportFragmentManager(), NewVersionDialog.class.getName());
        oldNewVersionDialog = dlg;
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == 107) {
            if (this.checkStoragePermission()) {
                UpgradeUtil.upgrade(this);
            }
        } else {
            super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    private boolean checkStoragePermission() {
        return Build.VERSION.SDK_INT < 23 || this.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") == 0;
    }

    public void updateSettingsNoteBubble() {
        if (this.mIMView != null) {
            this.mIMView.updateSettingsNoteBubble();
        }
    }

    @Override
    public void onQuerySSOVanityURL(String reqId, int result, String url) {
    }

    @Override
    public void onQueryIPLocation(int result, PTAppProtos.IPLocationInfo ipInfo) {
    }

    public boolean onCreatePanelMenu(int featureId, Menu menu) {
        return super.onCreatePanelMenu(featureId, menu);
    }

    class ExtendTokenServiceListener
    implements ServiceListener {
        ExtendTokenServiceListener() {
        }

        public void onComplete(Bundle values) {
            IMActivity.this.onFBTokenExtended(((IMActivity)IMActivity.this).mFacebookAuthToken.token);
        }

        public void onFacebookError(FacebookError e) {
            LoginActivity.show((Context)IMActivity.this, true);
        }

        public void onError(Error e) {
            LoginActivity.show((Context)IMActivity.this, true);
        }
    }
}

