/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.view.View;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.RecordMgr;
import com.zipow.videobox.util.ConfLocalHelper;
import com.zipow.videobox.view.ConfChatItem;
import java.util.Locale;
import us.zoom.androidlib.app.ZMFragment;
import us.zoom.androidlib.util.AccessibilityUtil;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

class ConfAccessibilityActivity
extends ConfActivity {
    private static final String TAG = ConfAccessibilityActivity.class.getName();
    private String mLastRecordStatusDescription;
    private AccessibilityRetainedFragment mAccessibilityRetainedFragment;

    ConfAccessibilityActivity() {
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initAccessibilityRetainedFragment();
        this.restoreAccessibilityRetainedFragment();
    }

    public static String getConfChatAccessibilityDescription(Context context, ConfChatItem confChatItem) {
        if (confChatItem == null || context == null) {
            return "";
        }
        String receiveName = confChatItem.receiverName;
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus != null && confStatus.isMyself(confChatItem.receiver)) {
            receiveName = context.getString(R.string.zm_webinar_txt_me);
        }
        boolean isWebinar = ConfLocalHelper.isWebinar();
        if (confChatItem.msgType == 0) {
            receiveName = context.getString(isWebinar ? R.string.zm_mi_panelists_and_attendees_11380 : R.string.zm_webinar_txt_everyone);
        } else if (confChatItem.msgType == 2) {
            receiveName = context.getString(R.string.zm_webinar_txt_label_ccPanelist, new Object[]{receiveName, context.getString(R.string.zm_webinar_txt_all_panelists)});
        } else if (confChatItem.msgType == 1) {
            receiveName = context.getString(R.string.zm_webinar_txt_all_panelists);
        }
        return context.getString(R.string.zm_accessibility_receive_message_19147, new Object[]{confChatItem.senderName, receiveName, confChatItem.content});
    }

    protected void processSpokenAccessibilityForConfCmd(View focusView, int cmd, long ret) {
        if (AccessibilityUtil.isSpokenFeedbackEnabled((Context)this)) {
            switch (cmd) {
                case 74: {
                    this.processRecord(focusView);
                }
            }
        }
    }

    protected void processSpokenAccessibilityForUserCmd(View focusView, int cmd, long userId, int userAction) {
        if (AccessibilityUtil.isSpokenFeedbackEnabled((Context)this)) {
            switch (cmd) {
                case 35: {
                    this.processRaisedHand(focusView, userId, true);
                    break;
                }
                case 36: {
                    this.processRaisedHand(focusView, userId, false);
                }
            }
        }
    }

    protected void doAccessiblityForViewAudioSharingStatus(View focusView, long userId, boolean start) {
        if (!AccessibilityUtil.isSpokenFeedbackEnabled((Context)this)) {
            return;
        }
        ConfMgr confMgr = ConfMgr.getInstance();
        if (confMgr == null) {
            return;
        }
        CmmUser shareUser = confMgr.getUserById(userId);
        if (shareUser == null) {
            return;
        }
        String content = start ? this.getString(R.string.zm_accessibility_start_view_audio_sharing_41468, new Object[]{shareUser.getScreenName()}) : this.getString(R.string.zm_accessibility_stop_view_audio_sharing_41468, new Object[]{shareUser.getScreenName()});
        AccessibilityUtil.announceForAccessibilityCompat((View)focusView, (CharSequence)content);
    }

    private void restoreAccessibilityRetainedFragment() {
        AccessibilityRetainedFragment f = this.getAccessibilityRetainedFragment();
        this.mLastRecordStatusDescription = f.restoremLastRecordStatusDescription();
    }

    private void initAccessibilityRetainedFragment() {
        this.mAccessibilityRetainedFragment = this.getAccessibilityRetainedFragment();
        if (this.mAccessibilityRetainedFragment == null) {
            this.mAccessibilityRetainedFragment = new AccessibilityRetainedFragment();
            this.getSupportFragmentManager().beginTransaction().add((Fragment)this.mAccessibilityRetainedFragment, AccessibilityRetainedFragment.class.getName()).commit();
        }
    }

    private AccessibilityRetainedFragment getAccessibilityRetainedFragment() {
        if (this.mAccessibilityRetainedFragment != null) {
            return this.mAccessibilityRetainedFragment;
        }
        FragmentManager fm = this.getSupportFragmentManager();
        AccessibilityRetainedFragment retainedFragment = (AccessibilityRetainedFragment)fm.findFragmentByTag(AccessibilityRetainedFragment.class.getName());
        return retainedFragment;
    }

    private void processRecord(View focusView) {
        RecordMgr recordMgr = ConfMgr.getInstance().getRecordMgr();
        if (recordMgr == null) {
            return;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        boolean isOthersRecording = recordMgr.theMeetingisBeingRecording();
        boolean isCurUserRecording = recordMgr.isRecordingInProgress();
        String contentDescription = isCurUserRecording ? (confStatus.isCMRInConnecting() ? this.getString(R.string.zm_record_status_preparing) : this.getString(recordMgr.isCMRPaused() ? R.string.zm_record_status_paused : R.string.zm_record_status_recording)) : this.getString(isOthersRecording ? R.string.zm_accessibility_record_started_23040 : R.string.zm_accessibility_record_stoped_23040);
        if (StringUtil.isEmptyOrNull((String)this.mLastRecordStatusDescription)) {
            this.mLastRecordStatusDescription = this.getString(R.string.zm_accessibility_record_stoped_23040);
        }
        if (!StringUtil.isSameString((String)this.mLastRecordStatusDescription, (String)contentDescription)) {
            this.mLastRecordStatusDescription = contentDescription;
            AccessibilityRetainedFragment f = this.getAccessibilityRetainedFragment();
            f.savemLastRecordStatusDescription(this.mLastRecordStatusDescription);
            if (!isCurUserRecording && this.isEnglishLanguage()) {
                AccessibilityUtil.announceForAccessibilityCompat((View)focusView, (CharSequence)"", (boolean)false);
            } else {
                AccessibilityUtil.announceForAccessibilityCompat((View)focusView, (CharSequence)contentDescription, (boolean)false);
            }
        }
    }

    private boolean isEnglishLanguage() {
        Locale locale = CompatUtils.getLocalDefault();
        if (locale == null) {
            return true;
        }
        String language = locale.getLanguage();
        return !StringUtil.isEmptyOrNull((String)language) && language.trim().toLowerCase().equals("en");
    }

    private void processRaisedHand(View focusView, long userId, boolean isRaisedHand) {
        String name;
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user != null && !StringUtil.isEmptyOrNull((String)(name = user.getScreenName()))) {
            AccessibilityUtil.announceForAccessibilityCompat((View)focusView, (CharSequence)this.getString(isRaisedHand ? R.string.zm_accessibility_someone_raised_hand_23051 : R.string.zm_description_msg_xxx_lower_hand, new Object[]{name}), (boolean)false);
        }
    }

    public static class AccessibilityRetainedFragment
    extends ZMFragment {
        private String mLastRecordStatusDescription;

        public AccessibilityRetainedFragment() {
            this.setRetainInstance(true);
        }

        public void savemLastRecordStatusDescription(String lastRecordStatusDescription) {
            this.mLastRecordStatusDescription = lastRecordStatusDescription;
        }

        public String restoremLastRecordStatusDescription() {
            return this.mLastRecordStatusDescription;
        }
    }
}

