/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import com.zipow.videobox.fragment.AddrBookItemDetailsFragment;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.view.IMAddrBookItem;
import java.io.Serializable;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class AddrBookItemDetailsActivity
extends ZMActivity {
    private static final String ARG_CONTACT = "contact";
    private static final String ARG_IS_FROM_ONE_TO_ONE_CHAT = "isFromOneToOneChat";

    public static void show(ZMActivity activity, IMAddrBookItem contact, int requestId) {
        AddrBookItemDetailsActivity.show(activity, contact, false, requestId);
    }

    public static void show(ZMActivity activity, IMAddrBookItem contact, boolean isFromOneToOneChat, int requestId) {
        Intent intent = new Intent((Context)activity, AddrBookItemDetailsActivity.class);
        intent.putExtra(ARG_CONTACT, (Serializable)contact);
        intent.putExtra(ARG_IS_FROM_ONE_TO_ONE_CHAT, isFromOneToOneChat);
        activity.startActivityForResult(intent, requestId);
        activity.overridePendingTransition(R.anim.zm_slide_in_right, R.anim.zm_slide_out_left);
    }

    public static void show(Fragment f, IMAddrBookItem contact, int requestId) {
        AddrBookItemDetailsActivity.show(f, contact, false, requestId);
    }

    public static void show(Fragment f, IMAddrBookItem contact, boolean isFromOneToOneChat, int requestId) {
        FragmentActivity activity = f.getActivity();
        if (activity == null) {
            return;
        }
        Intent intent = new Intent((Context)activity, AddrBookItemDetailsActivity.class);
        intent.putExtra(ARG_CONTACT, (Serializable)contact);
        intent.putExtra(ARG_IS_FROM_ONE_TO_ONE_CHAT, isFromOneToOneChat);
        f.startActivityForResult(intent, requestId);
        activity.overridePendingTransition(R.anim.zm_slide_in_right, R.anim.zm_slide_out_left);
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(R.anim.zm_slide_in_left, R.anim.zm_slide_out_right);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (UIMgr.isLargeMode((Context)this) && !UIMgr.isDualPaneSupportedInPortraitMode((Context)this)) {
            this.setRequestedOrientation(0);
        } else if (UIUtil.isTablet((Context)this)) {
            this.setRequestedOrientation(4);
        } else if (PTApp.getInstance().hasMessenger()) {
            this.setRequestedOrientation(1);
        }
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard == null || !mainboard.isInitialized()) {
            this.finish();
            return;
        }
        if (savedInstanceState == null) {
            Intent intent = this.getIntent();
            IMAddrBookItem contact = (IMAddrBookItem)intent.getSerializableExtra(ARG_CONTACT);
            boolean isFromOneToOneChat = intent.getBooleanExtra(ARG_IS_FROM_ONE_TO_ONE_CHAT, false);
            AddrBookItemDetailsFragment.showInActivity(this, contact, isFromOneToOneChat);
        }
    }
}

