/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.nydus;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import android.os.Build;
import com.zipow.nydus.DeviceFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;

@SuppressLint(value={"NewApi"})
public class UVCUtil {
    private static final String TAG = UVCUtil.class.getSimpleName();
    private static final String ACTION_USB_PERMISSION = "us.zoom.videomeetings.USB_PERMISSION_REQUEST_RESULT";
    private static UVCUtil instance;
    private Context mContext;
    private UsbManager mUsbManager;
    private ListenerList mListeners = new ListenerList();
    private DeviceFilter mFilter;
    private PendingIntent mPermissionIntent;
    private final BroadcastReceiver mUsbReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            UsbDevice device;
            String action = intent.getAction();
            if (UVCUtil.ACTION_USB_PERMISSION.equals(action)) {
                UsbDevice device2 = (UsbDevice)intent.getParcelableExtra("device");
                boolean granted = intent.getBooleanExtra("permission", false);
                if (device2 != null) {
                    UVCUtil.this.processPermissionGranted(device2, granted);
                }
            } else if ("android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(action)) {
                UsbDevice device3 = (UsbDevice)intent.getParcelableExtra("device");
                if (device3 != null) {
                    UVCUtil.this.processDeviceAttached(device3);
                }
            } else if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action) && (device = (UsbDevice)intent.getParcelableExtra("device")) != null) {
                UVCUtil.this.processDeviceDettached(device);
            }
        }
    };

    public static int getMinimumSupportedSdkInt() {
        return 17;
    }

    public static synchronized UVCUtil getInstance(Context context) {
        if (Build.VERSION.SDK_INT < UVCUtil.getMinimumSupportedSdkInt()) {
            return null;
        }
        if (instance == null && context != null) {
            instance = new UVCUtil(context);
        }
        return instance;
    }

    private UVCUtil(Context context) {
        this.mContext = context.getApplicationContext();
        this.mUsbManager = this.getUsbManager(context);
        this.mPermissionIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
        this.mFilter = DeviceFilter.buildUVCDeviceFilter();
        this.registerReceiver();
    }

    public void addUVCListener(IUVCListener l) {
        this.mListeners.add((IListener)l);
    }

    public void removeUVCListener(IUVCListener l) {
        this.mListeners.remove((IListener)l);
    }

    public List<UsbDevice> getUVCDevices() {
        ArrayList<UsbDevice> resultList = new ArrayList<UsbDevice>();
        if (this.mUsbManager == null) {
            return resultList;
        }
        HashMap deviceList = null;
        try {
            deviceList = this.mUsbManager.getDeviceList();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (deviceList != null) {
            for (UsbDevice device : deviceList.values()) {
                if (device == null || !this.mFilter.matches(this.mContext, device)) continue;
                resultList.add(device);
            }
        }
        return resultList;
    }

    public boolean hasPermission(UsbDevice device) {
        if (this.mUsbManager == null) {
            return false;
        }
        try {
            return this.mUsbManager.hasPermission(device);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean requestPermission(UsbDevice device) {
        if (this.mUsbManager == null) {
            return false;
        }
        try {
            this.mUsbManager.requestPermission(device, this.mPermissionIntent);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void registerReceiver() {
        IntentFilter filter = new IntentFilter(ACTION_USB_PERMISSION);
        filter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        this.mContext.registerReceiver(this.mUsbReceiver, filter);
    }

    private void processDeviceDettached(UsbDevice device) {
        if (this.mFilter.matches(this.mContext, device)) {
            IListener[] listeners;
            for (IListener l : listeners = this.mListeners.getAll()) {
                IUVCListener uvcListener = (IUVCListener)l;
                uvcListener.onDeviceDetatched(device);
            }
        }
    }

    private void processDeviceAttached(UsbDevice device) {
        if (this.mFilter.matches(this.mContext, device)) {
            IListener[] listeners;
            for (IListener l : listeners = this.mListeners.getAll()) {
                IUVCListener uvcListener = (IUVCListener)l;
                uvcListener.onDeviceAttached(device);
            }
        }
    }

    private void processPermissionGranted(UsbDevice device, boolean granted) {
        if (this.mFilter.matches(this.mContext, device)) {
            IListener[] listeners;
            for (IListener l : listeners = this.mListeners.getAll()) {
                IUVCListener uvcListener = (IUVCListener)l;
                uvcListener.onPermissionGranted(device, granted);
            }
        }
    }

    private UsbManager getUsbManager(Context context) {
        if (context == null) {
            return null;
        }
        UsbManager usbManager = null;
        try {
            usbManager = (UsbManager)context.getSystemService("usb");
        }
        catch (Exception e) {
            return null;
        }
        return usbManager;
    }

    public static class SimpleUVCListener
    implements IUVCListener {
        @Override
        public void onPermissionGranted(UsbDevice device, boolean granted) {
        }

        @Override
        public void onDeviceAttached(UsbDevice device) {
        }

        @Override
        public void onDeviceDetatched(UsbDevice device) {
        }
    }

    public static interface IUVCListener
    extends IListener {
        public void onPermissionGranted(UsbDevice var1, boolean var2);

        public void onDeviceAttached(UsbDevice var1);

        public void onDeviceDetatched(UsbDevice var1);
    }
}

