/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.nydus;

class SysBusUsbConstantsResolver {
    private static final int USB_CLASS_PER_INTERFACE = 0;
    private static final int USB_CLASS_AUDIO = 1;
    private static final int USB_CLASS_COMM = 2;
    private static final int USB_CLASS_HID = 3;
    private static final int USB_CLASS_PHYSICAL = 5;
    private static final int USB_CLASS_STILL_IMAGE = 6;
    private static final int USB_CLASS_PRINTER = 7;
    private static final int USB_CLASS_MASS_STORAGE = 8;
    private static final int USB_CLASS_HUB = 9;
    private static final int USB_CLASS_CDC_DATA = 10;
    private static final int USB_CLASS_CSCID = 11;
    private static final int USB_CLASS_CONTENT_SEC = 13;
    private static final int USB_CLASS_VIDEO = 14;
    private static final int USB_CLASS_PERSONAL_HEALTH = 15;
    private static final int USB_CLASS_DIAGNOSTICS = 220;
    private static final int USB_CLASS_WIRELESS_CONTROLLER = 224;
    private static final int USB_CLASS_MISC = 239;
    private static final int USB_CLASS_APP_SPEC = 254;
    private static final int USB_CLASS_VENDOR_SPEC = 255;
    private static final int USB_DIR_OUT = 0;
    private static final int USB_DIR_IN = 128;
    private static final int USB_ENDPOINT_XFER_CONTROL = 0;
    private static final int USB_ENDPOINT_XFER_ISOC = 1;
    private static final int USB_ENDPOINT_XFER_BULK = 2;
    private static final int USB_ENDPOINT_XFER_INT = 3;

    SysBusUsbConstantsResolver() {
    }

    protected static String resolveUsbClass(int usbClass) {
        switch (usbClass) {
            case 0: {
                return "Use class information in the Interface Descriptors (0x" + Integer.toHexString(usbClass) + ")";
            }
            case 1: {
                return "Audio Device (0x" + Integer.toHexString(usbClass) + ")";
            }
            case 2: {
                return "Communication Device (0x" + Integer.toHexString(usbClass) + ")";
            }
            case 3: {
                return "Human Interaction Device (0x" + Integer.toHexString(usbClass) + ")";
            }
            case 5: {
                return "Physical Device (0x" + Integer.toHexString(usbClass) + ")";
            }
            case 6: {
                return "Still Image Device (0x" + Integer.toHexString(usbClass) + ")";
            }
            case 7: {
                return "Printer (0x" + Integer.toHexString(usbClass) + ")";
            }
            case 8: {
                return "Mass Storage Device (0x" + Integer.toHexString(usbClass) + ")";
            }
            case 9: {
                return "USB Hub (0x" + Integer.toHexString(usbClass) + ")";
            }
            case 10: {
                return "Communication Device Class (CDC) (0x" + Integer.toHexString(usbClass) + ")";
            }
            case 11: {
                return "Content SmartCard Device (0x" + Integer.toHexString(usbClass) + ")";
            }
            case 13: {
                return "Content Security Device (0x" + Integer.toHexString(usbClass) + ")";
            }
            case 254: {
                return "Application Specific (0x" + Integer.toHexString(usbClass) + ")";
            }
            case 255: {
                return "Vendor Specific (0x" + Integer.toHexString(usbClass) + ")";
            }
            case 14: {
                return "Video Device (0x" + Integer.toHexString(usbClass) + ")";
            }
            case 15: {
                return "Personal Healthcare Device (0x" + Integer.toHexString(usbClass) + ")";
            }
            case 220: {
                return "Diagnostics Device (0x" + Integer.toHexString(usbClass) + ")";
            }
            case 224: {
                return "Wireless Controller (0x" + Integer.toHexString(usbClass) + ")";
            }
            case 239: {
                return "Miscellaneous (0x" + Integer.toHexString(usbClass) + ")";
            }
        }
        return "Unknown (0x" + Integer.toHexString(usbClass) + ")";
    }

    protected static String resolveUsbEndpointDirection(int usbEndpointDirection) {
        switch (usbEndpointDirection) {
            case 0: {
                return "Outbound (0x" + Integer.toHexString(usbEndpointDirection) + ")";
            }
            case 128: {
                return "Inbound (0x" + Integer.toHexString(usbEndpointDirection) + ")";
            }
        }
        return "Unknown (0x" + Integer.toHexString(usbEndpointDirection) + ")";
    }

    protected static String resolveUsbEndpointType(int usbEndpointType) {
        switch (usbEndpointType) {
            case 0: {
                return "Control (0x" + Integer.toHexString(usbEndpointType) + ")";
            }
            case 1: {
                return "Isochronous (0x" + Integer.toHexString(usbEndpointType) + ")";
            }
            case 2: {
                return "Bulk (0x" + Integer.toHexString(usbEndpointType) + ")";
            }
            case 3: {
                return "Intrrupt (0x" + Integer.toHexString(usbEndpointType) + ")";
            }
        }
        return "Unknown (0x" + Integer.toHexString(usbEndpointType) + ")";
    }
}

