/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.cmmlib;

import us.zoom.androidlib.util.ILogger;

public class Logger
implements ILogger {
    private static Logger instance = new Logger();
    private int mLevel = 2;
    private boolean mIsEnabled = false;
    private boolean mUseNativeLog = false;

    private Logger() {
    }

    public static Logger getInstance() {
        return instance;
    }

    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.mIsEnabled = enabled;
    }

    public void setLevel(int level) {
        this.mLevel = level;
    }

    public int getLevel() {
        return this.mLevel;
    }

    public boolean needLogThreadId() {
        return !this.useNativeLog();
    }

    private boolean useNativeLog() {
        return this.mUseNativeLog;
    }

    public void startNativeLog(boolean start) {
        this.mUseNativeLog = start;
    }

    public void log(int level, String tag, String msg, Throwable t) {
        if (!this.useNativeLog()) {
            this.logWithAndroidJavaLogger(level, tag, msg, t);
            return;
        }
        try {
            this.logWithNativeLogger(level, tag, msg, t);
        }
        catch (UnsatisfiedLinkError e) {
            this.logWithAndroidJavaLogger(level, tag, msg, t);
        }
    }

    private void logWithNativeLogger(int level, String tag, String msg, Throwable t) {
        StackTraceElement[] stack;
        if (t == null) {
            Logger.writeLogImpl(level, tag, msg);
            return;
        }
        Logger.writeLogImpl(level, tag, msg);
        if (t.getMessage() != null) {
            Logger.writeLogImpl(level, tag, t.getMessage());
        }
        for (StackTraceElement elem : stack = t.getStackTrace()) {
            Logger.writeLogImpl(level, tag, elem.toString());
        }
    }

    private void logWithAndroidJavaLogger(int level, String tag, String msg, Throwable t) {
    }

    private static native void writeLogImpl(int var0, String var1, String var2);
}

