/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.cmmlib;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.zipow.cmmlib.ZoomAppPropData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.ZMBuildConfig;

public class AppContext {
    public static final String PREFER_NAME_CHAT = "config";
    public static final String PREFER_NAME_VIDEO = "confparams";
    public static final String PREFER_NAME_AVATAR_CACHE_INDEX = "SSBAvatarCacheIndex";
    public static final String PREFER_NAME_UCINDEX = "SSBSUCIndex";
    public static final String APP_NAME_CHAT;
    public static final String APP_NAME_VIDEO;
    private static final String TAG;
    private String mPreferenceName;
    private static Context s_context;
    private static HashMap<String, AppContextImpl> s_contextImplMap;
    private static Handler s_handler;

    public static void initialize(Context context) {
        assert (context != null);
        s_context = context;
        s_handler = new Handler();
    }

    public AppContext(String preferenceName) {
        this.mPreferenceName = preferenceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppContextImpl getContextImpl() {
        AppContextImpl contextImpl = null;
        HashMap<String, AppContextImpl> hashMap = s_contextImplMap;
        synchronized (hashMap) {
            contextImpl = s_contextImplMap.get(this.mPreferenceName);
            if (contextImpl == null) {
                contextImpl = new AppContextImpl(this.mPreferenceName);
                s_contextImplMap.put(this.mPreferenceName, contextImpl);
            }
        }
        return contextImpl;
    }

    public boolean beginTransaction() {
        AppContextImpl contextImpl = this.getContextImpl();
        return contextImpl.beginTransaction();
    }

    public boolean endTransaction() {
        AppContextImpl contextImpl = this.getContextImpl();
        return contextImpl.endTransaction();
    }

    public String queryWithKey(String key, String appName) {
        AppContextImpl contextImpl = this.getContextImpl();
        String value = contextImpl.queryWithKey(key, appName);
        return value;
    }

    public boolean setKeyValue(String key, String value, String appName) {
        AppContextImpl contextImpl = this.getContextImpl();
        return contextImpl.setKeyValue(key, value, appName);
    }

    public boolean setKeyValueDelayCommit(String key, String value, String appName, long minDelayMs) {
        AppContextImpl contextImpl = this.getContextImpl();
        return contextImpl.setKeyValueDelayCommit(key, value, appName, minDelayMs);
    }

    public boolean eraseAll() {
        AppContextImpl contextImpl = this.getContextImpl();
        return contextImpl.eraseAll();
    }

    public static boolean BAASecurity_IsEnabled() {
        return AppContext.BAASecurityIsEnabledImpl();
    }

    private static native boolean BAASecurityIsEnabledImpl();

    static {
        System.loadLibrary("zoom_stlport");
        System.loadLibrary("crypto_sb");
        System.loadLibrary("ssl_sb");
        System.loadLibrary("cmmlib");
        switch (ZMBuildConfig.BUILD_TARGET) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                APP_NAME_CHAT = "ZoomChat";
                APP_NAME_VIDEO = "ZoomVideo";
                break;
            }
            default: {
                APP_NAME_CHAT = "PT";
                APP_NAME_VIDEO = "Meet";
            }
        }
        TAG = AppContext.class.getSimpleName();
        s_contextImplMap = new HashMap();
    }

    static class AppContextImpl {
        private String mPreferenceName;
        private ReentrantLock lock = new ReentrantLock();
        private Properties cachedProps = null;
        private long propsFileTimestamp = 0L;
        private boolean isChanged = false;
        private Properties transactionProps = null;
        private Runnable taskDelayCommit = new Runnable(){

            @Override
            public void run() {
                AppContextImpl.this.endTransaction();
            }
        };

        public AppContextImpl(String preferenceName) {
            this.mPreferenceName = preferenceName;
        }

        private File getProperptyFile() {
            File filesDir = s_context.getFilesDir();
            if (filesDir == null) {
                return null;
            }
            File dir = new File(filesDir + "/data");
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File file = new File(dir.getAbsolutePath() + "/" + this.mPreferenceName + ".ini");
            return file;
        }

        public boolean beginTransaction() {
            if (!this.lock.isHeldByCurrentThread()) {
                this.lock.lock();
            }
            if (this.transactionProps != null) {
                return true;
            }
            this.transactionProps = this.loadProperties();
            return true;
        }

        public boolean endTransaction() {
            if (!this.lock.isHeldByCurrentThread()) {
                this.lock.lock();
            }
            if (this.transactionProps == null) {
                this.lock.unlock();
                return false;
            }
            try {
                if (this.isChanged) {
                    if (this.transactionProps.isEmpty()) {
                        File file = this.getProperptyFile();
                        if (file != null && file.exists()) {
                            file.delete();
                        }
                    } else {
                        this.saveProperties(this.transactionProps);
                    }
                }
            }
            finally {
                this.transactionProps = null;
                this.isChanged = false;
                this.lock.unlock();
            }
            return true;
        }

        public String queryWithKey(String key, String appName) {
            if (s_context == null) {
                return "";
            }
            Properties props = null;
            this.lock.lock();
            if (this.transactionProps != null) {
                props = this.transactionProps;
            }
            if (props == null) {
                props = this.loadProperties();
            }
            this.lock.unlock();
            String value = props.getProperty(appName + "." + key);
            if (value == null) {
                value = "";
            }
            return value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Properties loadProperties() {
            Properties props = new Properties();
            this.isChanged = false;
            File file = null;
            InputStream is = null;
            try {
                file = this.getProperptyFile();
                if (file == null || !file.exists()) {
                    Properties properties = props;
                    return properties;
                }
                long timestamp = this.getTimestamp();
                if (this.cachedProps != null && this.propsFileTimestamp == timestamp) {
                    Properties properties = this.cachedProps;
                    return properties;
                }
                is = new FileInputStream(file);
                props.load(is);
                this.propsFileTimestamp = timestamp;
                this.cachedProps = props;
            }
            catch (Exception e) {
                if (file != null) {
                    file.delete();
                }
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception exception) {}
            }
            return props;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean saveProperties(Properties props) {
            boolean ret = false;
            OutputStream os = null;
            try {
                File file = this.getProperptyFile();
                if (file == null) {
                    boolean bl = false;
                    return bl;
                }
                os = new FileOutputStream(file);
                props.store(os, null);
                ret = true;
                long oldTimestamp = this.getTimestamp();
                this.propsFileTimestamp = this.newTimestamp(oldTimestamp);
                this.cachedProps = props;
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    if (os != null) {
                        os.flush();
                        os.close();
                    }
                }
                catch (Exception exception) {}
            }
            return ret;
        }

        public boolean setKeyValue(String key, String value, String appName) {
            if (s_context == null) {
                return false;
            }
            Properties props = null;
            boolean isInTransaction = false;
            this.lock.lock();
            if (this.transactionProps != null) {
                isInTransaction = true;
                props = this.transactionProps;
            }
            if (props == null) {
                props = this.loadProperties();
            }
            String realKey = appName + "." + key;
            if (value == null) {
                if (props.containsKey(realKey)) {
                    props.remove(realKey);
                    this.isChanged = true;
                }
            } else {
                String oldVal = props.getProperty(realKey);
                if (!StringUtil.isSameString((String)oldVal, (String)value)) {
                    props.setProperty(realKey, value);
                    this.isChanged = true;
                }
            }
            if (!isInTransaction && this.isChanged) {
                this.saveProperties(props);
                this.isChanged = false;
            }
            this.lock.unlock();
            return true;
        }

        public boolean setKeyValueDelayCommit(final String key, final String value, final String appName, long minDelayMs) {
            boolean ret = true;
            if (minDelayMs <= 0L || Looper.getMainLooper().getThread().getId() == Thread.currentThread().getId()) {
                if (minDelayMs > 0L) {
                    this.beginTransaction();
                }
                ret = this.setKeyValue(key, value, appName);
            } else {
                s_handler.post(new Runnable(){

                    @Override
                    public void run() {
                        AppContextImpl.this.beginTransaction();
                        AppContextImpl.this.setKeyValue(key, value, appName);
                    }
                });
            }
            if (minDelayMs > 0L) {
                s_handler.removeCallbacks(this.taskDelayCommit);
                s_handler.postDelayed(this.taskDelayCommit, minDelayMs);
            }
            return ret;
        }

        public boolean eraseAll() {
            if (s_context == null) {
                return false;
            }
            Properties props = null;
            boolean isInTransaction = false;
            this.lock.lock();
            if (this.transactionProps != null) {
                isInTransaction = true;
                props = this.transactionProps;
            }
            if (isInTransaction) {
                if (!props.isEmpty()) {
                    props.clear();
                    this.isChanged = true;
                }
            } else {
                File file = this.getProperptyFile();
                if (file != null && file.exists()) {
                    file.delete();
                }
                long oldTimestamp = this.getTimestamp();
                this.propsFileTimestamp = this.newTimestamp(oldTimestamp);
                this.cachedProps = null;
                this.isChanged = false;
            }
            this.lock.unlock();
            return true;
        }

        private long newTimestamp(long oldTimestamp) {
            ZoomAppPropData propData = ZoomAppPropData.getInstance();
            if (propData == null) {
                return 0L;
            }
            long timestamp = System.currentTimeMillis();
            if (timestamp == oldTimestamp) {
                ++timestamp;
            }
            propData.setInt64("timestamp-" + this.mPreferenceName, timestamp);
            return timestamp;
        }

        private long getTimestamp() {
            ZoomAppPropData propData = ZoomAppPropData.getInstance();
            if (propData == null) {
                return 0L;
            }
            long timestamp = propData.queryInt64("timestamp-" + this.mPreferenceName, 1L);
            return timestamp;
        }
    }
}

