/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.annotate;

import com.zipow.videobox.confapp.IRendererUnit;
import com.zipow.videobox.confapp.ShareUnit;
import com.zipow.videobox.sdk.SDKShareUnit;
import us.zoom.androidlib.util.IListener;

public class ZoomShareData {
    private static final String TAG = ZoomShareData.class.getSimpleName();
    private static ZoomShareData m_instance = null;
    private IZoomShareDataListener mListener;
    private IRendererUnit m_shareUnit;
    private boolean m_hdpi = false;
    private boolean m_bAttendeeAnnotateDisable = false;
    private boolean m_bPresenter = false;

    public static ZoomShareData getInstance() {
        if (null == m_instance) {
            m_instance = new ZoomShareData();
        }
        return m_instance;
    }

    public void addListener(IZoomShareDataListener l) {
        if (l == null) {
            return;
        }
        this.mListener = l;
    }

    public void setIsPresenter(boolean bPresenter) {
        this.m_bPresenter = bPresenter;
    }

    public long getViewHandle() {
        long renderInfo = 0L;
        if (!this.m_bPresenter && null != this.m_shareUnit) {
            renderInfo = this.m_shareUnit.getRendererInfo();
        }
        return renderInfo;
    }

    public void onShareSourceDataSizeChanged(int width, int height) {
        try {
            if (null != this.mListener) {
                this.mListener.onShareSourceDataSizeChanged(width, height);
            }
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void onDestAreaChangedChanged(float x, float y, float width, float height) {
        try {
            if (null != this.mListener) {
                this.mListener.onDestAreaChangedChanged(x, y, width, height);
            }
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void onUpdateUnitShare(ShareUnit unit, int videoGalleryWidth, int videoGalleryHeight) {
        this.m_shareUnit = unit;
        try {
            if (null != this.mListener) {
                this.mListener.onUpdateUnitShare(unit, videoGalleryWidth, videoGalleryHeight);
            }
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public void onUpdateSDKUnitShare(SDKShareUnit unit) {
        this.m_shareUnit = unit;
    }

    public void setIsHDPI(boolean bHdpi) {
        this.m_hdpi = bHdpi;
    }

    public boolean getIsHDPI() {
        return this.m_hdpi;
    }

    public void setAttendeeAnnotateDisable(boolean disable) {
        this.m_bAttendeeAnnotateDisable = disable;
    }

    public boolean getAttendeeAnnotateDisable() {
        return this.m_bAttendeeAnnotateDisable;
    }

    public static interface IZoomShareDataListener
    extends IListener {
        public void onShareSourceDataSizeChanged(int var1, int var2);

        public void onDestAreaChangedChanged(float var1, float var2, float var3, float var4);

        public void onUpdateUnitShare(ShareUnit var1, int var2, int var3);
    }
}

