/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.annotate;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.zipow.annotate.ISAnnotateDraw;

public class TextCtl
extends ISAnnotateDraw {
    private Paint mPaint = new Paint();
    private float x = 0.0f;
    private float y = 0.0f;
    private String text = "";
    private float textSize = 0.0f;

    public TextCtl(float penSize, int penColor, int alpha) {
        this.mPaint.setAntiAlias(true);
        this.mPaint.setDither(true);
        this.mPaint.setColor(penColor);
        this.mPaint.setAlpha(alpha);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public void draw(Canvas canvas) {
        Paint.FontMetrics metrics = this.mPaint.getFontMetrics();
        if (null != canvas && null != this.text && null != this.mPaint) {
            String[] textList = this.text.split("\n");
            for (int i = 0; i < textList.length; ++i) {
                float baseLine = Math.abs(metrics.top * (float)(i + 1)) + this.y + 4.0f;
                canvas.drawText(textList[i], this.x, baseLine, this.mPaint);
            }
        }
    }

    @Override
    public void setTextData(String text, int x, int y, boolean isBold, boolean isItalic, int fontSize) {
        this.textSize = fontSize;
        this.mPaint.setFakeBoldText(isBold);
        this.mPaint.setTextSkewX(isItalic ? -0.25f : 0.0f);
        this.mPaint.setTextSize((float)fontSize);
        this.x = x;
        this.y = y;
        this.text = text;
    }
}

