/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.annotate;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import com.zipow.annotate.AnnoPoint;
import com.zipow.annotate.ISAnnotateDraw;
import java.util.List;

public class PenCtl
extends ISAnnotateDraw {
    private Path m_path = new Path();
    private Paint mPaint = new Paint();
    private boolean m_hasDrawn = false;
    private float mX = 0.0f;
    private float mY = 0.0f;
    private static final float TOUCH_TOLERANCE = 4.0f;

    public PenCtl(float penSize, int penColor, int alpha) {
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setStrokeWidth(penSize);
        this.mPaint.setColor(penColor);
        this.mPaint.setAlpha(alpha);
    }

    @Override
    public void cleanAll() {
        this.m_path.reset();
    }

    @Override
    public void draw(Canvas canvas) {
        if (null != canvas) {
            canvas.drawPath(this.m_path, this.mPaint);
        }
    }

    public boolean hasDraw() {
        return this.m_hasDrawn;
    }

    @Override
    public void touchDown(float x, float y) {
        this.m_path.moveTo(x, y);
        this.m_path.lineTo(x, y);
        this.mX = x;
        this.mY = y;
    }

    @Override
    public void touchMove(float x, float y) {
        float dx = Math.abs(x - this.mX);
        float dy = Math.abs(y - this.mY);
        if (dx >= 4.0f || dy >= 4.0f) {
            this.m_path.quadTo(this.mX, this.mY, (x + this.mX) / 2.0f, (y + this.mY) / 2.0f);
            this.m_hasDrawn = true;
            this.mX = x;
            this.mY = y;
        }
    }

    @Override
    public void touchUp(float x, float y) {
        this.m_path.lineTo(this.mX, this.mY);
        this.mX = x;
        this.mY = y;
    }

    @Override
    public void setAnnoPoints(List<AnnoPoint> annoPoints) {
    }
}

