/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.annotate;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import com.zipow.annotate.AnnoToolType;
import com.zipow.annotate.ISAnnotateDraw;

public class AutoShapeCtl
extends ISAnnotateDraw {
    private AnnoToolType m_toolType = AnnoToolType.ANNO_TOOL_NONE_DRAWING;
    private Paint m_paint = new Paint();
    private float m_startx = 0.0f;
    private float m_starty = 0.0f;
    private float m_endx = 0.0f;
    private float m_endy = 0.0f;
    private float m_radius = 0.0f;

    public AutoShapeCtl(float penSize, int penColor, int alpha) {
        this.m_paint.setAntiAlias(true);
        this.m_paint.setDither(true);
        this.m_paint.setColor(penColor);
        this.m_paint.setAlpha(alpha);
        this.m_paint.setStyle(Paint.Style.STROKE);
        this.m_paint.setStrokeJoin(Paint.Join.ROUND);
        this.m_paint.setStrokeCap(Paint.Cap.ROUND);
        this.m_paint.setStrokeWidth(penSize);
    }

    @Override
    public void setToolType(AnnoToolType type) {
        this.m_toolType = type;
        if (AnnoToolType.ANNO_TOOL_TYPE_AUTO_RECTANGLE == this.m_toolType || AnnoToolType.ANNO_TOOL_TYPE_AUTO_ELLIPSE == this.m_toolType || AnnoToolType.ANNO_TOOL_TYPE_AUTO_LINE == this.m_toolType) {
            this.m_paint.setStyle(Paint.Style.STROKE);
        } else {
            this.m_paint.setStyle(Paint.Style.FILL);
        }
    }

    @Override
    public void draw(Canvas canvas) {
        if (null != canvas) {
            if (AnnoToolType.ANNO_TOOL_TYPE_AUTO_LINE == this.m_toolType) {
                canvas.drawLine(this.m_startx, this.m_starty, this.m_endx, this.m_endy, this.m_paint);
            } else if (AnnoToolType.ANNO_TOOL_TYPE_AUTO_ELLIPSE == this.m_toolType || AnnoToolType.ANNO_TOOL_TYPE_AUTO_ELLIPSE_SEMI_FILL == this.m_toolType || AnnoToolType.ANNO_TOOL_TYPE_AUTO_ELLIPSE_FILL == this.m_toolType) {
                RectF oval = new RectF();
                oval.left = this.m_startx;
                oval.top = this.m_starty;
                oval.right = this.m_endx;
                oval.bottom = this.m_endy;
                canvas.drawOval(oval, this.m_paint);
            } else {
                canvas.drawRect(this.m_startx, this.m_starty, this.m_endx, this.m_endy, this.m_paint);
            }
        }
    }

    @Override
    public void touchDown(float x, float y) {
        this.m_startx = x;
        this.m_starty = y;
        this.m_endx = x;
        this.m_endy = y;
    }

    @Override
    public void touchMove(float x, float y) {
        this.m_endx = x;
        this.m_endy = y;
        if (AnnoToolType.ANNO_TOOL_TYPE_AUTO_ELLIPSE == this.m_toolType) {
            this.m_radius = (float)(Math.sqrt((x - this.m_startx) * (x - this.m_startx) + (y - this.m_starty) * (y - this.m_starty)) / 2.0);
        }
    }

    @Override
    public void touchUp(float x, float y) {
        this.m_endx = x;
        this.m_endy = y;
    }
}

